/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.persistent.IPersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSHeaders;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@TestOnly
public final class PersistentFSRecordsOverInMemoryStorage
implements PersistentFSRecordsStorage,
IPersistentFSRecordsStorage {
    private static final int HEADER_SIZE = 40;
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.nativeOrder());
    private final int maxRecords;
    private final ByteBuffer records;
    private final AtomicInteger allocatedRecordsCount = new AtomicInteger(0);
    private final AtomicInteger globalModCount = new AtomicInteger(0);
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private final transient HeaderAccessor headerAccessor = new HeaderAccessor(this);
    private final Path storagePath;

    public PersistentFSRecordsOverInMemoryStorage(Path path, int maxRecords) throws IOException {
        this.storagePath = Objects.requireNonNull(path, "path");
        if (maxRecords <= 0) {
            throw new IllegalArgumentException("maxRecords(=" + maxRecords + ") should be >0");
        }
        this.maxRecords = maxRecords;
        this.records = ByteBuffer.allocateDirect(maxRecords * 40 + 40).order(ByteOrder.nativeOrder());
        if (Files.exists(path, new LinkOption[0])) {
            long fileSize = Files.size(path);
            if (fileSize > (long)this.records.capacity()) {
                long recordsInFile = (fileSize - 40L) / 40L;
                throw new IllegalArgumentException("[" + String.valueOf(path) + "](=" + fileSize + "b) contains " + recordsInFile + " records > maxRecords(=" + maxRecords + ") => can't load all the records from file!");
            }
            try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
                int actualBytesRead = channel.read(this.records);
                if (actualBytesRead <= 0) {
                    this.allocatedRecordsCount.set(0);
                } else {
                    int recordsRead = (actualBytesRead - 40) / 40;
                    int recordExcess = (actualBytesRead - 40) % 40;
                    if (recordExcess > 0) {
                        throw new IOException("[" + String.valueOf(path) + "] likely truncated: (" + actualBytesRead + "b)  = (" + recordsRead + " whole records) + " + recordExcess + "b excess");
                    }
                    this.allocatedRecordsCount.set(recordsRead);
                }
            }
        }
        this.globalModCount.set(this.getIntHeaderField(8));
    }

    @Override
    public int allocateRecord() throws IOException {
        int recordId = this.allocatedRecordsCount.incrementAndGet();
        if (recordId > this.maxRecords) {
            throw new IndexOutOfBoundsException("maxRecords(=" + this.maxRecords + ") limit exceeded");
        }
        this.markRecordAsModified(recordId);
        this.markDirty();
        return recordId;
    }

    @Override
    public void setAttributeRecordId(int recordId, int recordRef) throws IOException {
        PersistentFSRecordsOverInMemoryStorage.checkValidIdField(recordId, recordRef, "attributeRecordId");
        this.setIntField(recordId, 12, recordRef);
    }

    @Override
    public int getAttributeRecordId(int recordId) throws IOException {
        return this.getIntField(recordId, 12);
    }

    @Override
    public int getParent(int recordId) throws IOException {
        return this.getIntField(recordId, 0);
    }

    @Override
    public void setParent(int recordId, int parentId) throws IOException {
        this.checkParentIdIsValid(parentId);
        this.setIntField(recordId, 0, parentId);
    }

    @Override
    public int getNameId(int recordId) throws IOException {
        return this.getIntField(recordId, 4);
    }

    @Override
    public int updateNameId(int recordId, int nameId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(nameId);
        return this.setIntField(recordId, 4, nameId);
    }

    @Override
    public boolean setFlags(int recordId, @PersistentFS.Attributes int newFlags) throws IOException {
        boolean reallyChanged;
        int oldFlags = this.getIntField(recordId, 8);
        boolean bl = reallyChanged = oldFlags != newFlags;
        if (reallyChanged) {
            this.setIntField(recordId, 8, newFlags);
        }
        return reallyChanged;
    }

    @Override
    public @PersistentFS.Attributes int getFlags(int recordId) throws IOException {
        return this.getIntField(recordId, 8);
    }

    @Override
    public long getLength(int recordId) throws IOException {
        return this.getLongField(recordId, 32);
    }

    @Override
    public boolean setLength(int recordId, long newLength) throws IOException {
        boolean reallyChanged;
        boolean bl = reallyChanged = this.getLongField(recordId, 32) != newLength;
        if (reallyChanged) {
            this.setLongField(recordId, 32, newLength);
        }
        return reallyChanged;
    }

    @Override
    public long getTimestamp(int recordId) throws IOException {
        return this.getLongField(recordId, 24);
    }

    @Override
    public boolean setTimestamp(int recordId, long newTimestamp) throws IOException {
        boolean reallyChanged;
        boolean bl = reallyChanged = this.getLongField(recordId, 24) != newTimestamp;
        if (reallyChanged) {
            this.setLongField(recordId, 24, newTimestamp);
        }
        return reallyChanged;
    }

    @Override
    public int getModCount(int recordId) throws IOException {
        return this.getIntField(recordId, 20);
    }

    @Override
    public void markRecordAsModified(int recordId) throws IOException {
        this.setIntField(recordId, 20, this.globalModCount.incrementAndGet());
    }

    @Override
    public int getContentRecordId(int recordId) throws IOException {
        return this.getIntField(recordId, 16);
    }

    @Override
    public boolean setContentRecordId(int recordId, int contentRef) throws IOException {
        boolean reallyChanged;
        PersistentFSRecordsOverInMemoryStorage.checkValidIdField(recordId, contentRef, "contentRecordId");
        boolean bl = reallyChanged = this.getIntField(recordId, 16) != contentRef;
        if (reallyChanged) {
            this.setIntField(recordId, 16, contentRef);
        }
        return reallyChanged;
    }

    @Override
    public void cleanRecord(int recordId) throws IOException {
        this.checkRecordId(recordId);
        int recordStartAtBytes = this.recordOffsetInBytes(recordId, 0);
        int recordSizeInInts = 10;
        for (int wordNo = 0; wordNo < recordSizeInInts; ++wordNo) {
            int offset = recordStartAtBytes + wordNo * 4;
            INT_HANDLE.setVolatile(this.records, offset, 0);
        }
        this.markDirty();
    }

    @Override
    public <R> R readRecord(int recordId, @NotNull IPersistentFSRecordsStorage.RecordReader<R> reader) throws IOException {
        if (reader == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(0);
        }
        RecordAccessor recordAccessor = new RecordAccessor(recordId, this);
        return reader.readRecord(recordAccessor);
    }

    @Override
    public int updateRecord(int recordId, @NotNull IPersistentFSRecordsStorage.RecordUpdater updater) throws IOException {
        if (updater == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(1);
        }
        int trueRecordId = recordId <= 0 ? this.allocateRecord() : recordId;
        RecordAccessor recordAccessor = new RecordAccessor(recordId, this);
        boolean updated = updater.updateRecord(recordAccessor);
        if (updated) {
            // empty if block
        }
        return trueRecordId;
    }

    @Override
    public <R> R readHeader(@NotNull IPersistentFSRecordsStorage.HeaderReader<R> reader) throws IOException {
        if (reader == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(2);
        }
        return reader.readHeader(this.headerAccessor);
    }

    @Override
    public void updateHeader(@NotNull IPersistentFSRecordsStorage.HeaderUpdater updater) throws IOException {
        if (updater == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(3);
        }
        if (updater.updateHeader(this.headerAccessor)) {
            this.globalModCount.incrementAndGet();
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty.get();
    }

    @Override
    public long getTimestamp() throws IOException {
        return this.getLongHeaderField(16);
    }

    @Override
    public boolean wasClosedProperly() throws IOException {
        return true;
    }

    @Override
    public int getErrorsAccumulated() throws IOException {
        return this.getIntHeaderField(24);
    }

    @Override
    public void setErrorsAccumulated(int errors) throws IOException {
        this.setIntHeaderField(24, errors);
        this.globalModCount.incrementAndGet();
        this.dirty.compareAndSet(false, true);
    }

    @Override
    public void setVersion(int version) throws IOException {
        this.setIntHeaderField(0, version);
        this.setLongHeaderField(16, System.currentTimeMillis());
        this.globalModCount.incrementAndGet();
        this.dirty.compareAndSet(false, true);
    }

    @Override
    public int getVersion() throws IOException {
        return this.getIntHeaderField(0);
    }

    @Override
    public int getFlags() throws IOException {
        return this.getIntHeaderField(28);
    }

    @Override
    public boolean updateFlags(int flagsToAdd, int flagsToRemove) throws IOException {
        int currentFlags = INT_HANDLE.getVolatile(this.records, 28);
        int newFlags = currentFlags & ~flagsToRemove | flagsToAdd;
        if (newFlags == currentFlags) {
            return false;
        }
        INT_HANDLE.setVolatile(this.records, 28, newFlags);
        this.markDirty();
        return true;
    }

    @Override
    public int getGlobalModCount() {
        return this.globalModCount.get();
    }

    @Override
    public int recordsCount() {
        return this.allocatedRecordsCount.get();
    }

    @Override
    public int maxAllocatedID() {
        return this.allocatedRecordsCount.get();
    }

    @Override
    public boolean isValidFileId(int recordId) {
        int allocatedSoFar = this.allocatedRecordsCount.get();
        return 0 < recordId && recordId <= allocatedSoFar;
    }

    public long actualDataLength() {
        int recordsCount = this.recordsCount();
        return 40L * (long)recordsCount + 40L;
    }

    @Override
    public boolean processAllRecords(@NotNull PersistentFSRecordsStorage.FsRecordProcessor processor2) throws IOException {
        if (processor2 == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(4);
        }
        int recordsCount = this.allocatedRecordsCount.get();
        for (int recordId = 1; recordId <= recordsCount; ++recordId) {
            processor2.process(recordId, this.getNameId(recordId), this.getFlags(recordId), this.getParent(recordId), this.getAttributeRecordId(recordId), this.getContentRecordId(recordId), false);
        }
        return true;
    }

    @Override
    public void force() throws IOException {
        if (this.dirty.get()) {
            this.setIntHeaderField(8, this.globalModCount.get());
            long actualDataLength = this.actualDataLength();
            ByteBuffer actualRecordsToStore = this.records.duplicate();
            actualRecordsToStore.position(0).limit((int)actualDataLength).order(this.records.order());
            try (SeekableByteChannel channel = Files.newByteChannel(this.storagePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                channel.write(actualRecordsToStore);
            }
            this.markNotDirty();
        }
    }

    @Override
    public void close() throws IOException {
        this.force();
    }

    @Override
    public void closeAndClean() throws IOException {
        this.close();
    }

    private void checkParentIdIsValid(int parentId) throws IndexOutOfBoundsException {
        if (parentId == 0) {
            return;
        }
        if (!this.isValidFileId(parentId)) {
            throw new IndexOutOfBoundsException("parentId(=" + parentId + ") is outside of allocated IDs range [0, " + this.maxAllocatedID() + "]");
        }
    }

    private static void checkValidIdField(int recordId, int idFieldValue, @NotNull String fieldName) {
        if (fieldName == null) {
            PersistentFSRecordsOverInMemoryStorage.$$$reportNull$$$0(5);
        }
        if (idFieldValue < 0) {
            throw new IllegalArgumentException("file[id: " + recordId + "]." + fieldName + "(=" + idFieldValue + ") must be >=0");
        }
    }

    private void setLongField(int recordId, int fieldRelativeOffset, long fieldValue) {
        int offset = this.recordOffsetInBytes(recordId, fieldRelativeOffset);
        LONG_HANDLE.setVolatile(this.records, offset, fieldValue);
        this.markDirty();
    }

    private long getLongField(int recordId, int fieldRelativeOffset) {
        int offset = this.recordOffsetInBytes(recordId, fieldRelativeOffset);
        return LONG_HANDLE.getVolatile(this.records, offset);
    }

    private int setIntField(int recordId, int fieldRelativeOffset, int fieldValue) {
        int offset = this.recordOffsetInBytes(recordId, fieldRelativeOffset);
        int previousValue = INT_HANDLE.getAndSet(this.records, offset, fieldValue);
        this.markDirty();
        return previousValue;
    }

    private int getIntField(int recordId, int fieldRelativeOffset) {
        int offset = this.recordOffsetInBytes(recordId, fieldRelativeOffset);
        return INT_HANDLE.getVolatile(this.records, offset);
    }

    private int recordOffsetInBytes(int recordId, int fieldRelativeOffset) throws IndexOutOfBoundsException {
        this.checkRecordId(recordId);
        return 40 * (recordId - 1) + fieldRelativeOffset + 40;
    }

    private void checkRecordId(int recordId) throws IndexOutOfBoundsException {
        if (!this.isValidFileId(recordId)) {
            int allocatedSoFar = this.allocatedRecordsCount.get();
            throw new IndexOutOfBoundsException("recordId(=" + recordId + ") is outside of allocated IDs range (0, " + allocatedSoFar + "]");
        }
    }

    private void setLongHeaderField(@PersistentFSHeaders.HeaderOffset int headerRelativeOffsetBytes, long headerValue) {
        PersistentFSRecordsOverInMemoryStorage.checkHeaderOffset(headerRelativeOffsetBytes);
        LONG_HANDLE.setVolatile(this.records, headerRelativeOffsetBytes, headerValue);
        this.markDirty();
    }

    private long getLongHeaderField(@PersistentFSHeaders.HeaderOffset int headerRelativeOffsetBytes) {
        PersistentFSRecordsOverInMemoryStorage.checkHeaderOffset(headerRelativeOffsetBytes);
        return LONG_HANDLE.getVolatile(this.records, headerRelativeOffsetBytes);
    }

    private void setIntHeaderField(@PersistentFSHeaders.HeaderOffset int headerRelativeOffsetBytes, int headerValue) {
        PersistentFSRecordsOverInMemoryStorage.checkHeaderOffset(headerRelativeOffsetBytes);
        INT_HANDLE.setVolatile(this.records, headerRelativeOffsetBytes, headerValue);
        this.markDirty();
    }

    private int getIntHeaderField(@PersistentFSHeaders.HeaderOffset int headerRelativeOffsetBytes) {
        PersistentFSRecordsOverInMemoryStorage.checkHeaderOffset(headerRelativeOffsetBytes);
        return INT_HANDLE.getVolatile(this.records, headerRelativeOffsetBytes);
    }

    private static void checkHeaderOffset(int headerRelativeOffset) {
        if (0 > headerRelativeOffset || headerRelativeOffset >= 40) {
            throw new IndexOutOfBoundsException("headerFieldOffset(=" + headerRelativeOffset + ") is outside of header [0, 40) ");
        }
    }

    private void markDirty() {
        this.dirty.set(true);
    }

    private void markNotDirty() {
        this.dirty.set(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsOverInMemoryStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readRecord";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRecord";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readHeader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllRecords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidIdField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HeaderAccessor
    implements IPersistentFSRecordsStorage.HeaderForUpdate {
        @NotNull
        private final PersistentFSRecordsOverInMemoryStorage records;

        private HeaderAccessor(@NotNull PersistentFSRecordsOverInMemoryStorage records) {
            if (records == null) {
                HeaderAccessor.$$$reportNull$$$0(0);
            }
            this.records = records;
        }

        @Override
        public long getTimestamp() throws IOException {
            return this.records.getTimestamp();
        }

        @Override
        public int getVersion() throws IOException {
            return this.records.getVersion();
        }

        @Override
        public int getGlobalModCount() {
            return this.records.getGlobalModCount();
        }

        @Override
        public void setVersion(int version) throws IOException {
            this.records.setVersion(version);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsOverInMemoryStorage$HeaderAccessor", "<init>"));
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class RecordLayout {
        static final int PARENT_REF_OFFSET = 0;
        static final int NAME_REF_OFFSET = 4;
        static final int FLAGS_OFFSET = 8;
        static final int ATTR_REF_OFFSET = 12;
        static final int CONTENT_REF_OFFSET = 16;
        static final int MOD_COUNT_OFFSET = 20;
        static final int TIMESTAMP_OFFSET = 24;
        static final int LENGTH_OFFSET = 32;
        public static final int RECORD_SIZE_IN_BYTES = 40;
    }

    private static class RecordAccessor
    implements IPersistentFSRecordsStorage.RecordForUpdate {
        private final int recordId;
        @NotNull
        private final PersistentFSRecordsOverInMemoryStorage records;

        private RecordAccessor(int recordId, @NotNull PersistentFSRecordsOverInMemoryStorage records) {
            if (records == null) {
                RecordAccessor.$$$reportNull$$$0(0);
            }
            this.recordId = recordId;
            this.records = records;
        }

        @Override
        public int recordId() {
            return this.recordId;
        }

        @Override
        public int getAttributeRecordId() throws IOException {
            return this.records.getAttributeRecordId(this.recordId);
        }

        @Override
        public int getParent() throws IOException {
            return this.records.getParent(this.recordId);
        }

        @Override
        public int getNameId() throws IOException {
            return this.records.getNameId(this.recordId);
        }

        @Override
        public long getLength() throws IOException {
            return this.records.getLength(this.recordId);
        }

        @Override
        public long getTimestamp() throws IOException {
            return this.records.getTimestamp();
        }

        @Override
        public int getModCount() throws IOException {
            return this.records.getModCount(this.recordId);
        }

        @Override
        public int getContentRecordId() throws IOException {
            return this.records.getContentRecordId(this.recordId);
        }

        @Override
        public @PersistentFS.Attributes int getFlags() throws IOException {
            return this.records.getFlags(this.recordId);
        }

        @Override
        public void setAttributeRecordId(int attributeRecordId) throws IOException {
            this.records.setAttributeRecordId(this.recordId, attributeRecordId);
        }

        @Override
        public void setParent(int parentId) throws IOException {
            this.records.setParent(this.recordId, parentId);
        }

        @Override
        public void setNameId(int nameId) throws IOException {
            this.records.updateNameId(this.recordId, nameId);
        }

        @Override
        public boolean setFlags(@PersistentFS.Attributes int flags) throws IOException {
            return this.records.setFlags(this.recordId, flags);
        }

        @Override
        public boolean setLength(long length) throws IOException {
            return this.records.setLength(this.recordId, length);
        }

        @Override
        public boolean setTimestamp(long timestamp) throws IOException {
            return this.records.setTimestamp(this.recordId, timestamp);
        }

        @Override
        public boolean setContentRecordId(int contentRecordId) throws IOException {
            return this.records.setContentRecordId(this.recordId, contentRecordId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsOverInMemoryStorage$RecordAccessor", "<init>"));
        }
    }
}

