/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorageFactory;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.Unmappable;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class MappedFileStorageHelper
implements Closeable,
CleanableStorage,
Unmappable {
    private static final Map<Path, MappedFileStorageHelper> storagesRegistry = new HashMap<Path, MappedFileStorageHelper>();
    public static final int DEFAULT_PAGE_SIZE = 0x400000;
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteBufferViewVarHandle(short[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final VarHandle LONG_HANDLE = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private final int bytesPerRow;
    private final transient byte[] rowOfZeroes;
    @NotNull
    private final MMappedFileStorage storage;
    @NotNull
    private final IntSupplier maxAllocatedFileIdSupplier;
    private final boolean checkFileIdsBelowMax;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static MappedFileStorageHelper openHelper(@NotNull FSRecordsImpl vfs, @NotNull Path absoluteStoragePath, int bytesPerRow, boolean checkFileIdsBelowMax) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(0);
        }
        if (absoluteStoragePath == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(1);
        }
        if (!absoluteStoragePath.isAbsolute()) {
            throw new IllegalArgumentException("absoluteStoragePath(=" + String.valueOf(absoluteStoragePath) + ") is not absolute");
        }
        if (bytesPerRow <= 0) {
            throw new IllegalArgumentException("bytesPerRow(=" + bytesPerRow + ") must be >0");
        }
        Path storageDir = absoluteStoragePath.getParent().normalize();
        Files.createDirectories(storageDir, new FileAttribute[0]);
        PersistentFSConnection connection = vfs.connection();
        PersistentFSRecordsStorage recordsStorage = connection.records();
        Map<Path, MappedFileStorageHelper> map2 = storagesRegistry;
        // MONITORENTER : map2
        MappedFileStorageHelper alreadyExistingHelper = storagesRegistry.get(absoluteStoragePath);
        if (alreadyExistingHelper != null && alreadyExistingHelper.storage.isOpen()) {
            if (alreadyExistingHelper.bytesPerRow != bytesPerRow) {
                throw new IllegalStateException("StorageHelper[" + String.valueOf(absoluteStoragePath) + "] is already registered, but with .bytesPerRow(=" + bytesPerRow + ") != storage.bytesPerRow(=" + alreadyExistingHelper.bytesPerRow + ")");
            }
            MappedFileStorageHelper mappedFileStorageHelper = alreadyExistingHelper;
            // MONITOREXIT : map2
            if (mappedFileStorageHelper != null) return mappedFileStorageHelper;
            MappedFileStorageHelper.$$$reportNull$$$0(2);
            return mappedFileStorageHelper;
        }
        MappedFileStorageHelper mappedFileStorageHelper = (MappedFileStorageHelper)MMappedFileStorageFactory.withDefaults().pageSize(0x400000).ifFileIsNotPageAligned(MMappedFileStorageFactory.IfNotPageAligned.CLEAN).wrapStorageSafely(absoluteStoragePath, mappedFileStorage -> {
            MappedFileStorageHelper storageHelper = new MappedFileStorageHelper((MMappedFileStorage)mappedFileStorage, bytesPerRow, recordsStorage::maxAllocatedID, checkFileIdsBelowMax);
            storagesRegistry.put(absoluteStoragePath, storageHelper);
            return storageHelper;
        });
        // MONITOREXIT : map2
        if (mappedFileStorageHelper != null) return mappedFileStorageHelper;
        MappedFileStorageHelper.$$$reportNull$$$0(3);
        return mappedFileStorageHelper;
    }

    @NotNull
    public static MappedFileStorageHelper openHelper(@NotNull FSRecordsImpl vfs, @NotNull String storageName, int bytesPerRow) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(4);
        }
        if (storageName == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(5);
        }
        return MappedFileStorageHelper.openHelper(vfs, storageName, bytesPerRow, true);
    }

    @NotNull
    public static MappedFileStorageHelper openHelper(@NotNull FSRecordsImpl vfs, @NotNull String storageName, int bytesPerRow, boolean checkFileIdsBelowMax) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(6);
        }
        if (storageName == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(7);
        }
        PersistentFSConnection connection = vfs.connection();
        Path fastAttributesDir = connection.paths().storagesSubDir("extended-attributes");
        Path storagePath = fastAttributesDir.resolve(storageName).toAbsolutePath();
        return MappedFileStorageHelper.openHelper(vfs, storagePath, bytesPerRow, checkFileIdsBelowMax);
    }

    @NotNull
    public static MappedFileStorageHelper openHelperAndVerifyVersions(@NotNull FSRecordsImpl vfs, @NotNull String storageName, int storageFormatVersion, int bytesPerRow) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(8);
        }
        if (storageName == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(9);
        }
        return MappedFileStorageHelper.openHelperAndVerifyVersions(vfs, storageName, storageFormatVersion, bytesPerRow, true);
    }

    @NotNull
    public static MappedFileStorageHelper openHelperAndVerifyVersions(@NotNull FSRecordsImpl vfs, @NotNull String storageName, int storageFormatVersion, int bytesPerRow, boolean checkFileIdBelowMax) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(10);
        }
        if (storageName == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(11);
        }
        MappedFileStorageHelper helper = MappedFileStorageHelper.openHelper(vfs, storageName, bytesPerRow, checkFileIdBelowMax);
        MappedFileStorageHelper.verifyTagsAndVersions(helper, vfs.getCreationTimestamp(), storageFormatVersion);
        MappedFileStorageHelper mappedFileStorageHelper = helper;
        if (mappedFileStorageHelper == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(12);
        }
        return mappedFileStorageHelper;
    }

    @NotNull
    public static MappedFileStorageHelper openHelperAndVerifyVersions(@NotNull FSRecordsImpl vfs, @NotNull Path absoluteStoragePath, int storageFormatVersion, int bytesPerRow, boolean checkFileIdBelowMax) throws IOException {
        if (vfs == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(13);
        }
        if (absoluteStoragePath == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(14);
        }
        MappedFileStorageHelper helper = MappedFileStorageHelper.openHelper(vfs, absoluteStoragePath, bytesPerRow, checkFileIdBelowMax);
        MappedFileStorageHelper.verifyTagsAndVersions(helper, vfs.getCreationTimestamp(), storageFormatVersion);
        MappedFileStorageHelper mappedFileStorageHelper = helper;
        if (mappedFileStorageHelper == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(15);
        }
        return mappedFileStorageHelper;
    }

    /*
     * WARNING - void declaration
     */
    public static void verifyTagsAndVersions(@NotNull MappedFileStorageHelper helper, long vfsCreationTag, int n) throws IOException {
        void storageFormatVersion;
        if (helper == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(16);
        }
        if (helper.getVFSCreationTag() != vfsCreationTag) {
            helper.clear();
        }
        if (helper.getVersion() != storageFormatVersion) {
            helper.clear();
        }
        helper.setVFSCreationTag(vfsCreationTag);
        helper.setVersion((int)storageFormatVersion);
    }

    @VisibleForTesting
    public static Map<Path, MappedFileStorageHelper> registeredStorages() {
        return storagesRegistry;
    }

    private MappedFileStorageHelper(@NotNull MMappedFileStorage storage, int bytesPerRow, @NotNull IntSupplier maxRowsSupplier, boolean checkFileIdsBelowMax) {
        if (storage == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(17);
        }
        if (maxRowsSupplier == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(18);
        }
        if (storage.pageSize() % bytesPerRow != 0) {
            throw new IllegalArgumentException("bytesPerRow(=" + bytesPerRow + ") is not aligned with pageSize(=" + storage.pageSize() + "): rows must be page-aligned");
        }
        this.storage = storage;
        this.bytesPerRow = bytesPerRow;
        this.maxAllocatedFileIdSupplier = maxRowsSupplier;
        this.checkFileIdsBelowMax = checkFileIdsBelowMax;
        this.rowOfZeroes = new byte[bytesPerRow];
    }

    public int getVersion() throws IOException {
        return this.readIntHeaderField(0);
    }

    public void setVersion(int version) throws IOException {
        this.writeIntHeaderField(0, version);
    }

    public long getVFSCreationTag() throws IOException {
        return this.readLongHeaderField(8);
    }

    public void setVFSCreationTag(long vfsCreationTag) throws IOException {
        this.writeLongHeaderField(8, vfsCreationTag);
    }

    public int bytesPerRow() {
        return this.bytesPerRow;
    }

    public int readIntField(@NotNull VirtualFile vFile, int fieldOffset) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(19);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        return this.readIntField(fileId, fieldOffset);
    }

    public void writeIntField(@NotNull VirtualFile vFile, int fieldOffset, int value) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(20);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        this.writeIntField(fileId, fieldOffset, value);
    }

    public int updateIntField(@NotNull VirtualFile vFile, int fieldOffset, @NotNull IntUnaryOperator updateOperator) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(21);
        }
        if (updateOperator == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(22);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        return this.updateIntField(fileId, fieldOffset, updateOperator);
    }

    public long readLongField(@NotNull VirtualFile vFile, int fieldOffset) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(23);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        return this.readLongField(fileId, fieldOffset);
    }

    public void writeLongField(@NotNull VirtualFile vFile, int fieldOffset, long value) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(24);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        this.writeLongField(fileId, fieldOffset, value);
    }

    public long updateLongField(@NotNull VirtualFile vFile, int fieldOffset, @NotNull LongUnaryOperator updateOperator) throws IOException {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(25);
        }
        if (updateOperator == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(26);
        }
        int fileId = MappedFileStorageHelper.extractFileId(vFile);
        return this.updateLongField(fileId, fieldOffset, updateOperator);
    }

    public void clear() throws IOException {
        this.clearImpl(true);
    }

    public void clearRecords() throws IOException {
        this.clearImpl(false);
    }

    private void clearImpl(boolean clearHeaders) throws IOException {
        int startOffsetInFile = clearHeaders ? 0 : 64;
        this.storage.zeroizeTillEOF((long)startOffsetInFile);
    }

    public void fsync() throws IOException {
        this.storage.fsync();
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
        storagesRegistry.remove(this.storage.storagePath());
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.storage.closeAndUnsafelyUnmap();
        storagesRegistry.remove(this.storage.storagePath());
    }

    public void closeAndClean() throws IOException {
        this.closeAndUnsafelyUnmap();
        this.storage.closeAndClean();
    }

    public String toString() {
        return "MappedFileStorageHelper[" + String.valueOf(this.storage.storagePath()) + "]";
    }

    private void clearRow(int fileId) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId);
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        rawPageBuffer.put(offsetInPage, this.rowOfZeroes);
    }

    public short readShortField(int fileId, int fieldOffsetInRow) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        return SHORT_HANDLE.getVolatile(rawPageBuffer, offsetInPage);
    }

    public void writeShortField(int fileId, int fieldOffsetInRow, short attributeValue) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        SHORT_HANDLE.setVolatile(rawPageBuffer, offsetInPage, attributeValue);
    }

    public int readIntField(int fileId, int fieldOffsetInRow) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        return INT_HANDLE.getVolatile(rawPageBuffer, offsetInPage);
    }

    public void writeIntField(int fileId, int fieldOffsetInRow, int attributeValue) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        INT_HANDLE.setVolatile(rawPageBuffer, offsetInPage, attributeValue);
    }

    public int updateIntField(int fileId, int fieldOffsetInRow, @NotNull IntUnaryOperator updateOperator) throws IOException {
        int newValue;
        int currentValue;
        if (updateOperator == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(27);
        }
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        while (!INT_HANDLE.compareAndSet(rawPageBuffer, offsetInPage, currentValue = INT_HANDLE.getVolatile(rawPageBuffer, offsetInPage), newValue = updateOperator.applyAsInt(currentValue))) {
        }
        return currentValue;
    }

    public long readLongField(int fileId, int fieldOffsetInRow) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        return LONG_HANDLE.getVolatile(rawPageBuffer, offsetInPage);
    }

    public void writeLongField(int fileId, int fieldOffsetInRow, long attributeValue) throws IOException {
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        LONG_HANDLE.setVolatile(rawPageBuffer, offsetInPage, attributeValue);
    }

    public long updateLongField(int fileId, int fieldOffsetInRow, @NotNull LongUnaryOperator updateOperator) throws IOException {
        long newValue;
        long currentValue;
        if (updateOperator == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(28);
        }
        long offsetInFile = this.toOffsetInFile(fileId) + (long)fieldOffsetInRow;
        int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
        MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
        ByteBuffer rawPageBuffer = page.rawPageBuffer();
        while (!LONG_HANDLE.compareAndSet(rawPageBuffer, offsetInPage, currentValue = LONG_HANDLE.getVolatile(rawPageBuffer, offsetInPage), newValue = updateOperator.applyAsLong(currentValue))) {
        }
        return currentValue;
    }

    public int readIntHeaderField(int headerRelativeOffset) throws IOException {
        MappedFileStorageHelper.checkHeaderFieldOffset(headerRelativeOffset);
        MMappedFileStorage.Page page = this.storage.pageByOffset((long)headerRelativeOffset);
        return INT_HANDLE.getVolatile(page.rawPageBuffer(), headerRelativeOffset);
    }

    public long readLongHeaderField(int headerRelativeOffset) throws IOException {
        MappedFileStorageHelper.checkHeaderFieldOffset(headerRelativeOffset);
        MMappedFileStorage.Page page = this.storage.pageByOffset((long)headerRelativeOffset);
        return LONG_HANDLE.getVolatile(page.rawPageBuffer(), headerRelativeOffset);
    }

    public void writeIntHeaderField(int headerRelativeOffset, int headerFieldValue) throws IOException {
        MappedFileStorageHelper.checkHeaderFieldOffset(headerRelativeOffset);
        MMappedFileStorage.Page page = this.storage.pageByOffset((long)headerRelativeOffset);
        INT_HANDLE.setVolatile(page.rawPageBuffer(), headerRelativeOffset, headerFieldValue);
    }

    public void writeLongHeaderField(int headerRelativeOffset, long headerFieldValue) throws IOException {
        MappedFileStorageHelper.checkHeaderFieldOffset(headerRelativeOffset);
        MMappedFileStorage.Page page = this.storage.pageByOffset((long)headerRelativeOffset);
        LONG_HANDLE.setVolatile(page.rawPageBuffer(), headerRelativeOffset, headerFieldValue);
    }

    private long toOffsetInFile(int fileId) {
        this.checkFileIdValid(fileId);
        long offsetInFile = (long)(fileId - 1) * (long)this.bytesPerRow + 64L;
        if (offsetInFile < 0L) {
            throw new AssertionError((Object)("fileId(=" + fileId + ") x bytesPerRow(=" + this.bytesPerRow + ") is too big: offsetInFile(=" + offsetInFile + ") must be positive"));
        }
        return offsetInFile;
    }

    private void checkFileIdValid(int fileId) {
        if (this.checkFileIdsBelowMax) {
            int maxAllocatedID = this.maxAllocatedFileID();
            if (fileId < 1 || fileId > maxAllocatedID) {
                throw new IllegalArgumentException("fileId[#" + fileId + "] is outside of allocated range [1.." + maxAllocatedID + "]");
            }
        } else if (fileId < 1) {
            throw new IllegalArgumentException("fileId[#" + fileId + "] is invalid, must be >=1");
        }
    }

    private int maxAllocatedFileID() {
        return this.maxAllocatedFileIdSupplier.getAsInt();
    }

    private static void checkHeaderFieldOffset(int headerRelativeOffset) {
        if (headerRelativeOffset >= 64) {
            throw new IllegalArgumentException("Header offset(=" + headerRelativeOffset + ") is outside of header[0..64)");
        }
    }

    private static int extractFileId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            MappedFileStorageHelper.$$$reportNull$$$0(29);
        }
        if (!(vFile instanceof VirtualFileWithId)) {
            throw new IllegalArgumentException(String.valueOf(vFile) + " must be VirtualFileWithId");
        }
        VirtualFileWithId fileWithId = (VirtualFileWithId)vFile;
        return fileWithId.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteStoragePath";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/MappedFileStorageHelper";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxRowsSupplier";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/MappedFileStorageHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openHelper";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "openHelperAndVerifyVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openHelper";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 15: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openHelperAndVerifyVersions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "verifyTagsAndVersions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readIntField";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeIntField";
                break;
            }
            case 21: 
            case 22: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateIntField";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readLongField";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeLongField";
                break;
            }
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateLongField";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractFileId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 12, 15 -> new IllegalStateException(string);
        };
    }

    public static final class HeaderLayout {
        public static final int VERSION_OFFSET = 0;
        public static final int RESERVED_OFFSET = 4;
        public static final int VFS_CREATION_TIMESTAMP_OFFSET = 8;
        public static final int FIRST_FREE_FIELD = 16;
        public static final int HEADER_SIZE = 64;
    }
}

