/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.SquareStripeButtonKt;
import com.intellij.toolWindow.ResizeStripeManager;
import com.intellij.ui.icons.StrokeKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u000fH\u0014J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J$\u0010\u0019\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButtonLook;", "Lcom/intellij/openapi/actionSystem/impl/IdeaActionButtonLook;", "button", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ActionButton;)V", "paintBackground", "", "g", "Ljava/awt/Graphics;", "component", "Ljavax/swing/JComponent;", "state", "", "getState", "Lcom/intellij/openapi/actionSystem/ActionButtonComponent;", "paintBorder", "getBackgroundColor", "Ljava/awt/Color;", "color", "getIconPosition", "Ljava/awt/Point;", "actionButton", "icon", "Ljavax/swing/Icon;", "paintIcon", "getButtonArc", "Lcom/intellij/util/ui/JBValue$UIInteger;", "Companion", "intellij.platform.ide.impl"})
public class SquareStripeButtonLook
extends IdeaActionButtonLook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionButton button;

    public SquareStripeButtonLook(@NotNull ActionButton button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
        this.button = button2;
    }

    @Override
    public void paintBackground(@NotNull Graphics g, @NotNull JComponent component2, int state2) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Color color = this.getStateBackground(component2, state2);
        if (color == null) {
            return;
        }
        Color initialColor = color;
        Rectangle it = rectangle = new Rectangle(component2.getSize());
        boolean bl = false;
        JBInsets.removeFrom((Rectangle)it, (Insets)component2.getInsets());
        JBInsets.removeFrom((Rectangle)it, (Insets)Companion.getIconPadding(SquareStripeButtonKt.isOnTheLeftStripe(component2)));
        Rectangle rect = rectangle;
        Color color2 = this.getBackgroundColor(initialColor);
        this.paintLookBackground(g, rect, color2);
    }

    @Override
    protected int getState(@Nullable ActionButtonComponent button2) {
        if (button2 instanceof SquareStripeButton) {
            if (((SquareStripeButton)button2).isFocused()) {
                return 2;
            }
            if (((SquareStripeButton)button2).getToolWindow().isVisible()) {
                return -1;
            }
            if (!((SquareStripeButton)button2).isHovered()) {
                return 0;
            }
        }
        return super.getState(button2);
    }

    @Override
    public void paintBorder(@NotNull Graphics g, @NotNull JComponent component2, int state2) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        if (this.button instanceof SquareStripeButton && ((SquareStripeButton)this.button).isFocused() || state2 == 0 && !component2.isBackgroundSet()) {
            return;
        }
        Rectangle it = rectangle = new Rectangle(component2.getSize());
        boolean bl = false;
        JBInsets.removeFrom((Rectangle)it, (Insets)component2.getInsets());
        JBInsets.removeFrom((Rectangle)it, (Insets)Companion.getIconPadding(SquareStripeButtonKt.isOnTheLeftStripe(component2)));
        Rectangle rect = rectangle;
        Color color = state2 == -1 ? JBUI.CurrentTheme.ActionButton.pressedBorder() : JBUI.CurrentTheme.ActionButton.hoverBorder();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        this.paintLookBorder(g, rect, color2);
    }

    private final Color getBackgroundColor(Color color) {
        if (this.button instanceof SquareStripeButton && ((SquareStripeButton)this.button).isFocused()) {
            Color color2 = UIManager.getColor("ToolWindow.Button.selectedBackground");
            if (color2 == null) {
                color2 = color;
            }
            return color2;
        }
        return color;
    }

    @Override
    @NotNull
    protected Point getIconPosition(@NotNull ActionButtonComponent actionButton, @NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)actionButton, (String)"actionButton");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Rectangle rect = new Rectangle(actionButton.getWidth(), actionButton.getHeight());
        JBInsets.removeFrom((Rectangle)rect, (Insets)actionButton.getInsets());
        JBInsets.removeFrom((Rectangle)rect, (Insets)Companion.getIconPadding(SquareStripeButtonKt.isOnTheLeftStripe(this.button)));
        int x = rect.x + (rect.width - icon2.getIconWidth()) / 2;
        int y = rect.y + (rect.height - icon2.getIconHeight()) / 2;
        return new Point(x, y);
    }

    @Override
    public void paintIcon(@Nullable Graphics g, @Nullable ActionButtonComponent actionButton, @NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Color color = UIManager.getColor("ToolWindow.Button.selectedForeground");
        if (!(actionButton instanceof SquareStripeButton) || !((SquareStripeButton)actionButton).isFocused() || color == null) {
            super.paintIcon(g, actionButton, icon2);
            return;
        }
        Color color2 = UIManager.getColor("ToolWindow.Button.selectedForeground");
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(...)");
        super.paintIcon(g, actionButton, StrokeKt.toStrokeIcon((Icon)icon2, (Color)color2));
    }

    @NotNull
    protected JBValue.UIInteger getButtonArc() {
        return new JBValue.UIInteger("Button.ToolWindow.arc", UISettings.Companion.getInstance().getCompactMode() ? 8 : 12);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButtonLook$Companion;", "", "<init>", "()V", "getIconPadding", "Ljava/awt/Insets;", "isLeft", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Insets getIconPadding(boolean isLeft) {
            Insets insets = JBUI.CurrentTheme.Toolbar.stripeToolbarButtonIconPadding((boolean)isLeft, (boolean)ResizeStripeManager.Companion.isShowNames());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"stripeToolbarButtonIconPadding(...)");
            return insets;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

