/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.ex.WindowManagerListener;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.FrameStateListener;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WindowManager", storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED, usePathMacroManager=false)}, category=SettingsCategory.UI, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001lB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010#H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0014H\u0016J \u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/H\u0016J\b\u00102\u001a\u00020\u0007H\u0016J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u001a\u00109\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0018\u0010<\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010@\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0016J\u0018\u0010A\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u0010B\u001a\u00020\u0007H\u0016J\u0010\u0010C\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010D\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010E\u001a\u0002042\u0006\u0010F\u001a\u00020GH\u0016J\u0014\u0010H\u001a\u0004\u0018\u0001062\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010,\u001a\u00020\u0014H\u0016J\u001c\u0010I\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020M2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010N\u001a\u0004\u0018\u00010O2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010P\u001a\u0004\u0018\u00010\u00192\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010Q\u001a\u0004\u0018\u00010#2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0017J\u0014\u0010R\u001a\u0004\u0018\u00010#2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0014\u0010S\u001a\u0004\u0018\u00010O2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010T\u001a\u0004\u0018\u00010\u0019H\u0007J\u001e\u0010U\u001a\u0002042\u0006\u0010V\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010WJ(\u0010U\u001a\u0002042\u0006\u0010V\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00142\u0006\u0010X\u001a\u00020\u0007H\u0080@\u00a2\u0006\u0004\bY\u0010ZJ\u0010\u0010[\u001a\u0002042\u0006\u0010\\\u001a\u00020#H\u0017J\u0010\u0010]\u001a\u00020\u00072\u0006\u0010^\u001a\u00020#H\u0016J\r\u0010_\u001a\u000204H\u0000\u00a2\u0006\u0002\b`J\f\u0010a\u001a\u00060bj\u0002`cH\u0016J\n\u0010d\u001a\u0004\u0018\u000106H\u0016J\u0012\u0010e\u001a\u0004\u0018\u00010M2\u0006\u00105\u001a\u000206H\u0016J\u0014\u0010e\u001a\u0004\u0018\u00010M2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010f\u001a\u0002042\u0006\u0010B\u001a\u00020\u0003H\u0016J\b\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020\u0003H\u0016J\b\u0010j\u001a\u00020\u0007H\u0016J\u0010\u0010k\u001a\u0002042\u0006\u0010,\u001a\u00020\u0014H\u0016R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006m"}, d2={"Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "Lcom/intellij/openapi/wm/ex/WindowManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jdom/Element;", "<init>", "()V", "alphaModeSupported", "", "Ljava/lang/Boolean;", "windowWatcher", "Lcom/intellij/openapi/wm/impl/WindowWatcher;", "getWindowWatcher$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/WindowWatcher;", "value", "Lcom/intellij/openapi/wm/impl/DesktopLayout;", "oldLayout", "getOldLayout$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/DesktopLayout;", "projectToFrame", "Ljava/util/HashMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl$ProjectItem;", "Lkotlin/collections/HashMap;", "frameToReuse", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "defaultFrameInfoHelper", "Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "getDefaultFrameInfoHelper$intellij_platform_ide_impl", "()Lcom/intellij/openapi/wm/impl/FrameInfoHelper;", "frameReuseEnabled", "getFrameReuseEnabled", "()Z", "getAllProjectFrames", "", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "()[Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "getProjectFrameHelpers", "", "findVisibleFrame", "Ljavax/swing/JFrame;", "findFirstVisibleFrameHelper", "getScreenBounds", "Ljava/awt/Rectangle;", "project", "isInsideScreenBounds", "x", "", "y", "width", "isAlphaModeSupported", "setAlphaModeRatio", "", "window", "Ljava/awt/Window;", "ratio", "", "setWindowMask", "mask", "Ljava/awt/Shape;", "setWindowShadow", "mode", "Lcom/intellij/openapi/wm/ex/WindowManagerEx$WindowShadowMode;", "resetWindow", "isAlphaModeEnabled", "setAlphaModeEnabled", "state", "isNotSuggestAsParent", "doNotSuggestAsParent", "dispatchComponentEvent", "e", "Ljava/awt/event/ComponentEvent;", "suggestParentWindow", "getStatusBar", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;", "Lcom/intellij/openapi/wm/StatusBar;", "component", "Ljava/awt/Component;", "findFrameFor", "Lcom/intellij/openapi/wm/IdeFrame;", "getFrame", "getFrameHelper", "findFrameHelper", "getIdeFrame", "removeAndGetRootFrame", "assignFrame", "frameHelper", "(Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "withListener", "assignFrame$intellij_platform_ide_impl", "(Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "releaseFrame", "releasedFrameHelper", "isFrameReused", "helper", "disposeRootFrame", "disposeRootFrame$intellij_platform_ide_impl", "withFrameReuseEnabled", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "getMostRecentFocusedWindow", "getFocusedComponent", "loadState", "getStateModificationCount", "", "getState", "isFullScreenSupportedInCurrentOS", "updateDefaultFrameInfoOnProjectClose", "ProjectItem", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/WindowManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1563#2:550\n1634#2,3:551\n1563#2:556\n1634#2,3:557\n37#3,2:554\n1#4:560\n*S KotlinDebug\n*F\n+ 1 WindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/WindowManagerImpl\n*L\n117#1:550\n117#1:551,3\n119#1:556\n119#1:557,3\n117#1:554,2\n*E\n"})
public final class WindowManagerImpl
extends WindowManagerEx
implements PersistentStateComponentWithModificationTracker<Element> {
    @Nullable
    private Boolean alphaModeSupported;
    @NotNull
    private final WindowWatcher windowWatcher = new WindowWatcher();
    @Nullable
    private DesktopLayout oldLayout;
    @NotNull
    private final HashMap<Project, ProjectItem> projectToFrame = new HashMap();
    @NotNull
    private final AtomicReference<IdeFrameImpl> frameToReuse = new AtomicReference();
    @NotNull
    private final FrameInfoHelper defaultFrameInfoHelper = new FrameInfoHelper();
    private boolean frameReuseEnabled;

    public WindowManagerImpl() {
        Application app = ApplicationManager.getApplication();
        SimpleMessageBusConnection connection = app.getMessageBus().simpleConnect();
        if (!app.isUnitTestMode()) {
            Disposer.register((Disposable)((Disposable)app), () -> WindowManagerImpl._init_$lambda$0(this));
            connection.subscribe(TitleInfoProvider.TOPIC, (Object)new TitleInfoProvider.TitleInfoProviderListener(){

                @Override
                public void configurationChanged() {
                    for (Map.Entry entry : ((Map)projectToFrame).entrySet()) {
                        Project project2 = (Project)entry.getKey();
                        ProjectItem item = (ProjectItem)entry.getValue();
                        item.frameHelper.updateTitle$intellij_platform_ide_impl(project2);
                    }
                }
            });
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", this.windowWatcher);
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(Project project2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    ProjectFrameHelper helper = this.getFrameHelper(project2);
                    WindowManagerImplKt.access$getLOG$p().info("=== Release(" + (helper != null) + ") frame on closed project ===");
                    ProjectFrameHelper projectFrameHelper = helper;
                    if (projectFrameHelper == null) break block0;
                    ProjectFrameHelper projectFrameHelper2 = projectFrameHelper;
                    WindowManagerImpl windowManagerImpl = this;
                    ProjectFrameHelper it = projectFrameHelper2;
                    boolean bl = false;
                    windowManagerImpl.releaseFrame(it);
                }
            }
        });
    }

    @NotNull
    public final WindowWatcher getWindowWatcher$intellij_platform_ide_impl() {
        return this.windowWatcher;
    }

    @Nullable
    public final DesktopLayout getOldLayout$intellij_platform_ide_impl() {
        return this.oldLayout;
    }

    @NotNull
    public final FrameInfoHelper getDefaultFrameInfoHelper$intellij_platform_ide_impl() {
        return this.defaultFrameInfoHelper;
    }

    @ApiStatus.Internal
    public final boolean getFrameReuseEnabled() {
        return this.frameReuseEnabled;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProjectFrameHelper[] getAllProjectFrames() {
        void $this$mapTo$iv$iv;
        Collection<ProjectItem> collection = this.projectToFrame.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectItem projectItem = (ProjectItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.frameHelper);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ProjectFrameHelper[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProjectFrameHelper> getProjectFrameHelpers() {
        void $this$mapTo$iv$iv;
        Collection<ProjectItem> collection = this.projectToFrame.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectItem projectItem = (ProjectItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.frameHelper);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public JFrame findVisibleFrame() {
        IdeFrame ideFrame;
        Collection<ProjectItem> collection = this.projectToFrame.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Object object = (ProjectItem)CollectionsKt.firstOrNull((Iterable)collection);
        return object != null && (object = ((ProjectItem)object).frameHelper) != null && (object = ((ProjectFrameHelper)object).getFrame()) != null ? (JFrame)object : ((ideFrame = WelcomeFrame.Companion.getInstance()) instanceof JFrame ? (JFrame)ideFrame : null);
    }

    @Override
    @Nullable
    public ProjectFrameHelper findFirstVisibleFrameHelper() {
        Collection<ProjectItem> collection = this.projectToFrame.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return (ProjectFrameHelper)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), WindowManagerImpl::findFirstVisibleFrameHelper$lambda$0));
    }

    @Override
    @NotNull
    public Rectangle getScreenBounds() {
        Rectangle rectangle = ScreenUtil.getAllScreensRectangle();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getAllScreensRectangle(...)");
        return rectangle;
    }

    @Override
    @Nullable
    public Rectangle getScreenBounds(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        IdeFrameImpl ideFrameImpl = this.getFrame(project2);
        Intrinsics.checkNotNull((Object)ideFrameImpl);
        Point onScreen = ideFrameImpl.getLocationOnScreen();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Intrinsics.checkNotNull((Object)devices);
        for (GraphicsDevice device : devices) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(onScreen)) continue;
            return bounds;
        }
        return null;
    }

    public boolean isInsideScreenBounds(int x, int y, int width) {
        return ScreenUtil.getAllScreensShape().contains(x, y, width, 1.0);
    }

    public boolean isAlphaModeSupported() {
        Boolean result2 = this.alphaModeSupported;
        if (result2 == null) {
            this.alphaModeSupported = result2 = Boolean.valueOf(WindowManagerImplKt.access$calcAlphaModelSupported());
        }
        return result2;
    }

    public void setAlphaModeRatio(@NotNull Window window, float ratio) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (!(window.isDisplayable() && window.isShowing())) {
            boolean $i$a$-require-WindowManagerImpl$setAlphaModeRatio$32 = false;
            String $i$a$-require-WindowManagerImpl$setAlphaModeRatio$32 = "window must be displayable and showing. window=" + window;
            throw new IllegalArgumentException($i$a$-require-WindowManagerImpl$setAlphaModeRatio$32.toString());
        }
        if (!(0.0f <= ratio ? ratio <= 1.0f : false)) {
            boolean bl = false;
            String string = "ratio must be in [0..1] range. ratio=" + ratio;
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.isAlphaModeSupported() || !this.isAlphaModeEnabled(window)) {
            return;
        }
        WindowManagerImplKt.access$setAlphaMode(window, ratio);
    }

    @Override
    public void setWindowMask(@NotNull Window window, @Nullable Shape mask) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT)) {
                window.setShape(mask);
            } else {
                WindowUtils.setWindowMask((Window)window, (Shape)mask);
            }
        }
        catch (Throwable e) {
            WindowManagerImplKt.access$getLOG$p().debug(e);
        }
    }

    @Override
    public void setWindowShadow(@NotNull Window window, @NotNull WindowManagerEx.WindowShadowMode mode) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (window instanceof JWindow) {
            JRootPane root = ((JWindow)window).getRootPane();
            root.putClientProperty("Window.shadow", mode != WindowManagerEx.WindowShadowMode.DISABLED);
            root.putClientProperty("Window.style", mode == WindowManagerEx.WindowShadowMode.SMALL ? "small" : null);
        }
    }

    @Override
    public void resetWindow(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        try {
            if (!this.isAlphaModeSupported()) {
                return;
            }
            this.setWindowMask(window, null);
            WindowManagerImplKt.access$setAlphaMode(window, 0.0f);
            this.setWindowShadow(window, WindowManagerEx.WindowShadowMode.NORMAL);
        }
        catch (Throwable e) {
            WindowManagerImplKt.access$getLOG$p().debug(e);
        }
    }

    public boolean isAlphaModeEnabled(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (!(window.isDisplayable() && window.isShowing())) {
            boolean bl = false;
            String string = "window must be displayable and showing. window=" + window;
            throw new IllegalArgumentException(string.toString());
        }
        return this.isAlphaModeSupported();
    }

    public void setAlphaModeEnabled(@NotNull Window window, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (!(window.isDisplayable() && window.isShowing())) {
            boolean bl = false;
            String string = "window must be displayable and showing. window=" + window;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public boolean isNotSuggestAsParent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.windowWatcher.isNotSuggestAsParent(window);
    }

    public void doNotSuggestAsParent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.windowWatcher.doNotSuggestAsParent(window);
    }

    @Override
    public void dispatchComponentEvent(@NotNull ComponentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.windowWatcher.dispatchComponentEvent(e);
    }

    @Nullable
    public Window suggestParentWindow(@Nullable Project project2) {
        return this.windowWatcher.suggestParentWindow(project2, this);
    }

    @Nullable
    public IdeStatusBarImpl getStatusBar(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project2);
        return projectFrameHelper != null ? projectFrameHelper.getStatusBar() : null;
    }

    @Nullable
    public StatusBar getStatusBar(@NotNull Component component2, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        for (Component parent = component2; parent != null; parent = (Component)parent.getParent()) {
            if (!(parent instanceof IdeFrame)) continue;
            return ((IdeFrame)parent).getStatusBar();
        }
        return null;
    }

    @Override
    @Nullable
    public IdeFrame findFrameFor(@Nullable Project project2) {
        IdeFrame ideFrame;
        if (project2 == null) {
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(this.getMostRecentFocusedWindow());
            ideFrame = projectFrameHelper != null ? (IdeFrame)projectFrameHelper : WindowManagerImplKt.access$tryToFindTheOnlyFrame();
        } else if (project2.isDefault()) {
            ideFrame = WelcomeFrame.Companion.getInstance();
        } else {
            ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project2);
            if (projectFrameHelper == null) {
                projectFrameHelper = this.getFrameHelper(null);
            }
            ideFrame = projectFrameHelper;
        }
        return ideFrame;
    }

    @Override
    @Nullable
    public IdeFrameImpl getFrame(@Nullable Project project2) {
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project2);
        return projectFrameHelper != null ? projectFrameHelper.getFrame() : null;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ProjectFrameHelper getFrameHelper(@Nullable Project project2) {
        ProjectItem projectItem = (ProjectItem)((Map)this.projectToFrame).get(project2);
        return projectItem != null ? projectItem.frameHelper : null;
    }

    @Override
    @Nullable
    public ProjectFrameHelper findFrameHelper(@Nullable Project project2) {
        Object object = project2;
        if (object == null) {
            IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            object = ideFrame != null ? ideFrame.getProject() : null;
            if (object == null) {
                return null;
            }
        }
        return this.getFrameHelper((Project)object);
    }

    @Nullable
    public IdeFrame getIdeFrame(@Nullable Project project2) {
        if (project2 != null) {
            return this.getFrameHelper(project2);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            Component component2 = ComponentUtil.findUltimateParent((Component)window);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"findUltimateParent(...)");
            IdeFrame ideFrame = WindowManagerImplKt.access$getIdeFrame(component2);
            if (ideFrame != null) {
                IdeFrame it = ideFrame;
                boolean bl = false;
                return it;
            }
        }
        IdeFrame ideFrame = Frame.getFrames();
        Intrinsics.checkNotNullExpressionValue((Object)ideFrame, (String)"getFrames(...)");
        for (IdeFrame each : ideFrame) {
            Intrinsics.checkNotNull((Object)each);
            IdeFrame ideFrame2 = WindowManagerImplKt.access$getIdeFrame((Component)each);
            if (ideFrame2 == null) continue;
            IdeFrame it = ideFrame2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public final IdeFrameImpl removeAndGetRootFrame() {
        return this.frameToReuse.getAndSet(null);
    }

    @Nullable
    public final Object assignFrame(@NotNull ProjectFrameHelper frameHelper, @NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.assignFrame$intellij_platform_ide_impl(frameHelper, project2, true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object assignFrame$intellij_platform_ide_impl(@NotNull ProjectFrameHelper frameHelper, @NotNull Project project2, boolean withListener, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project2, withListener, frameHelper, null){
            int label;
            final /* synthetic */ WindowManagerImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $withListener;
            final /* synthetic */ ProjectFrameHelper $frameHelper;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$withListener = $withListener;
                this.$frameHelper = $frameHelper;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WindowManagerImplKt.access$getLOG$p().assertTrue(!WindowManagerImpl.access$getProjectToFrame$p(this.this$0).containsKey(this.$project));
                        if (this.$withListener) {
                            FrameStateListener listener2 = new FrameStateListener(this.this$0.getDefaultFrameInfoHelper$intellij_platform_ide_impl());
                            this.$frameHelper.getFrame().addComponentListener(listener2);
                            v0 = WindowManagerImpl.access$getProjectToFrame$p(this.this$0).put(this.$project, new ProjectItem(this.$frameHelper, listener2));
                        } else {
                            v0 = WindowManagerImpl.access$getProjectToFrame$p(this.this$0).put(this.$project, new ProjectItem(this.$frameHelper, null));
                        }
                        ((WindowManagerListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(WindowManagerListener.Companion.getTOPIC())).onFramesChanged();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @RequiresEdt
    public void releaseFrame(@NotNull ProjectFrameHelper releasedFrameHelper) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)releasedFrameHelper, (String)"releasedFrameHelper");
        Project project2 = releasedFrameHelper.getProject();
        if (project2 != null) {
            ProjectItem projectItem = this.projectToFrame.remove(project2);
            if (projectItem != null) {
                projectItem.release();
            }
            if (this.frameReuseEnabled && this.frameToReuse.get() == null && !(project2 instanceof LightEditCompatible)) {
                releasedFrameHelper.storeStateForReuse();
                IdeFrameImpl frame = releasedFrameHelper.getFrame();
                this.frameToReuse.set(frame);
                frame.doSetRootPane$intellij_platform_ide_impl(null);
                frame.setFrameHelper(null);
                if (JOptionPane.getRootFrame() == frame) {
                    JOptionPane.setRootFrame(null);
                }
            }
            ((WindowManagerListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(WindowManagerListener.Companion.getTOPIC())).onFramesChanged();
        }
        WindowManagerImpl windowManagerImpl = this;
        try {
            WindowManagerImpl $this$releaseFrame_u24lambda_u240 = windowManagerImpl;
            boolean bl = false;
            releasedFrameHelper.dispose();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)WindowManagerImplKt.access$getLOG$p());
    }

    @Override
    public boolean isFrameReused(@NotNull ProjectFrameHelper helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        return helper.getFrame() == this.frameToReuse.get();
    }

    public final void disposeRootFrame$intellij_platform_ide_impl() {
        block0: {
            IdeFrameImpl ideFrameImpl = this.frameToReuse.getAndSet(null);
            if (ideFrameImpl == null) break block0;
            ideFrameImpl.doDispose();
        }
    }

    @Override
    @NotNull
    public AutoCloseable withFrameReuseEnabled() {
        boolean oldValue = this.frameReuseEnabled;
        this.frameReuseEnabled = true;
        return () -> WindowManagerImpl.withFrameReuseEnabled$lambda$0(this, oldValue);
    }

    @Nullable
    public Window getMostRecentFocusedWindow() {
        return this.windowWatcher.getFocusedWindow();
    }

    @Nullable
    public Component getFocusedComponent(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.windowWatcher.getFocusedComponent(window);
    }

    @Nullable
    public Component getFocusedComponent(@Nullable Project project2) {
        return this.windowWatcher.getFocusedComponent(project2);
    }

    public void loadState(@NotNull Element state2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            Element frameElement = state2.getChild("frame");
            if (frameElement != null) {
                FrameInfo info = new FrameInfo();
                XmlSerializer.deserializeInto((Element)frameElement, (Object)((Object)info));
                if ((info.getExtendedState() & 1) > 0) {
                    info.setExtendedState(0);
                }
                this.defaultFrameInfoHelper.copyFrom(info);
            }
            Element element = state2.getChild("layout");
            if (element == null) break block2;
            Element it = element;
            boolean bl = false;
            DesktopLayout layout2 = new DesktopLayout(null, null, 3, null);
            DesktopLayout.readExternal$default(layout2, it, false, 2, null);
            this.oldLayout = layout2;
        }
    }

    public long getStateModificationCount() {
        return this.defaultFrameInfoHelper.getModificationCount();
    }

    @NotNull
    public Element getState() {
        Element state2;
        block1: {
            state2 = new Element("state");
            FrameInfo frameInfo = this.defaultFrameInfoHelper.getInfo();
            if (frameInfo == null) break block1;
            FrameInfo it = frameInfo;
            boolean bl = false;
            Element element = XmlSerializer.serialize$default((Object)((Object)it), null, (boolean)false, (int)6, null);
            frameInfo = element;
            if (element != null) {
                it = frameInfo;
                boolean bl2 = false;
                state2.addContent((Element)it);
            }
        }
        return state2;
    }

    public boolean isFullScreenSupportedInCurrentOS() {
        return FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs();
    }

    public void updateDefaultFrameInfoOnProjectClose(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ProjectFrameHelper projectFrameHelper = this.getFrameHelper(project2);
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper = projectFrameHelper;
        this.defaultFrameInfoHelper.copyFrom(WindowManagerImplKt.getFrameInfoByFrameHelper(frameHelper));
    }

    private static final void _init_$lambda$0(WindowManagerImpl this$0) {
        this$0.disposeRootFrame$intellij_platform_ide_impl();
    }

    private static final ProjectFrameHelper findFirstVisibleFrameHelper$lambda$0(ProjectItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.frameHelper;
    }

    private static final void withFrameReuseEnabled$lambda$0(WindowManagerImpl this$0, boolean $oldValue) {
        this$0.frameReuseEnabled = $oldValue;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/WindowManagerImpl$ProjectItem;", "", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "listener", "Ljava/awt/event/ComponentListener;", "<init>", "(Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;Ljava/awt/event/ComponentListener;)V", "release", "", "intellij.platform.ide.impl"})
    private static final class ProjectItem {
        @JvmField
        @NotNull
        public final ProjectFrameHelper frameHelper;
        @Nullable
        private final ComponentListener listener;

        public ProjectItem(@NotNull ProjectFrameHelper frameHelper, @Nullable ComponentListener listener2) {
            Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
            this.frameHelper = frameHelper;
            this.listener = listener2;
        }

        public final void release() {
            block0: {
                ComponentListener componentListener2 = this.listener;
                if (componentListener2 == null) break block0;
                ComponentListener it = componentListener2;
                boolean bl = false;
                this.frameHelper.getFrame().removeComponentListener(it);
            }
        }
    }
}

