/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/wm/impl/status/CounterLabel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ide/ui/UISettingsListener;", "<init>", "()V", "textPanel", "Lcom/intellij/openapi/wm/impl/status/TextPanel;", "numberOfProgresses", "", "isProgressVisible", "", "lastDigitNumber", "textsForMinimumSize", "Lkotlin/ranges/IntRange;", "minimumSize", "Ljava/awt/Dimension;", "createTextPanel", "setNumber", "", "isPopupShowing", "refreshTextForMinimumSizeIfNeeded", "numberToShow", "getPreferredSize", "getMinimumSize", "uiSettingsChanged", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "intellij.platform.ide.impl"})
final class CounterLabel
extends JPanel
implements UISettingsListener {
    @NotNull
    private final TextPanel textPanel = this.createTextPanel();
    private int numberOfProgresses;
    private boolean isProgressVisible;
    private int lastDigitNumber;
    @Nullable
    private IntRange textsForMinimumSize;
    @Nullable
    private Dimension minimumSize;

    public CounterLabel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.textPanel, "Center");
        this.setOpaque(false);
        this.setNumber(0, false, false);
    }

    private final TextPanel createTextPanel() {
        TextPanel panel2 = new TextPanel(null, 1, null);
        panel2.setForeground(JBUI.CurrentTheme.StatusBar.Widget.FOREGROUND);
        return panel2;
    }

    public final void setNumber(int numberOfProgresses, boolean isProgressVisible, boolean isPopupShowing) {
        this.numberOfProgresses = numberOfProgresses;
        this.isProgressVisible = isProgressVisible;
        int numberToShow = isProgressVisible ? numberOfProgresses - 1 : numberOfProgresses;
        this.refreshTextForMinimumSizeIfNeeded(numberToShow);
        String panelText = isPopupShowing ? "" : (numberToShow <= 0 ? "" : (!isProgressVisible && numberToShow == 1 ? "" : (isProgressVisible ? "+" + numberToShow : String.valueOf(numberToShow))));
        this.textPanel.setText(panelText);
    }

    private final void refreshTextForMinimumSizeIfNeeded(int numberToShow) {
        String numberToShowString = String.valueOf(numberToShow);
        if (numberToShowString.length() != this.lastDigitNumber) {
            this.lastDigitNumber = numberToShowString.length();
            this.textsForMinimumSize = switch (this.lastDigitNumber) {
                case 1 -> new IntRange(0, 9);
                case 2 -> new IntRange(10, 99);
                case 3 -> new IntRange(100, 999);
                default -> null;
            };
            this.minimumSize = null;
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension precalculated;
        Dimension dimension = precalculated = this.minimumSize;
        if (dimension != null) {
            return dimension;
        }
        IntRange texts = this.textsForMinimumSize;
        if (texts == null || texts.isEmpty()) {
            Dimension dimension2 = super.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
            return dimension2;
        }
        TextPanel probe = this.createTextPanel();
        Dimension minSize = new Dimension(0, 0);
        IntRange intRange = texts;
        int text2 = intRange.getFirst();
        int n = intRange.getLast();
        int n2 = intRange.getStep();
        if (n2 > 0 && text2 <= n || n2 < 0 && n <= text2) {
            while (true) {
                probe.setText("+" + text2);
                Dimension size2 = probe.getPreferredSize();
                minSize = new Dimension(Math.max(minSize.width, size2.width), Math.max(minSize.height, size2.height));
                if (text2 == n) break;
                text2 += n2;
            }
        }
        this.minimumSize = minSize;
        return minSize;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        this.minimumSize = null;
    }
}

