/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.HelpTooltipManager;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.StatusBarWidgetWrapper;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/wm/impl/status/MultipleTextValues;", "Lcom/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows;", "Lcom/intellij/openapi/wm/impl/status/StatusBarWidgetWrapper;", "presentation", "Lcom/intellij/openapi/wm/StatusBarWidget$MultipleTextValuesPresentation;", "<init>", "(Lcom/intellij/openapi/wm/StatusBarWidget$MultipleTextValuesPresentation;)V", "beforeUpdate", "", "intellij.platform.ide.impl"})
final class MultipleTextValues
extends TextPanel.WithIconAndArrows
implements StatusBarWidgetWrapper {
    @NotNull
    private final StatusBarWidget.MultipleTextValuesPresentation presentation;

    public MultipleTextValues(@NotNull StatusBarWidget.MultipleTextValuesPresentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        super((Function0<String>)((Function0)new Function0<String>((Object)presentation2){

            public final String invoke() {
                return ((StatusBarWidget.MultipleTextValuesPresentation)this.receiver).getTooltipText();
            }
        }));
        this.presentation = presentation2;
        CharSequence charSequence = this.presentation.getSelectedValue();
        this.setVisible(!(charSequence == null || charSequence.length() == 0));
        this.setTextAlignment(0.5f);
        this.setBorder(JBUI.CurrentTheme.StatusBar.Widget.border());
        new ClickListener(){

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JBPopup jBPopup = presentation.getPopup();
                if (jBPopup == null) {
                    return false;
                }
                JBPopup popup2 = jBPopup;
                UIEventLogger.StatusBarPopupShown.log(presentation.getClass());
                Dimension dimension = this.getSizeFor(popup2);
                Point at = new Point(0, -dimension.height);
                popup2.show(new RelativePoint(event.getComponent(), at));
                return true;
            }

            private final Dimension getSizeFor(JBPopup popup2) {
                Dimension dimension;
                if (popup2 instanceof AbstractPopup) {
                    Dimension dimension2 = ((AbstractPopup)popup2).getSizeForPositioning();
                    dimension = dimension2;
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getSizeForPositioning(...)");
                } else {
                    Dimension dimension3 = popup2.getContent().getPreferredSize();
                    dimension = dimension3;
                    Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getPreferredSize(...)");
                }
                return dimension;
            }
        }.installOn((Component)this, true);
        ClientProperty.put((JComponent)this, (Key)HelpTooltipManager.SHORTCUT_PROPERTY, () -> ((StatusBarWidget.MultipleTextValuesPresentation)this.presentation).getShortcutText());
    }

    @Override
    public void beforeUpdate() {
        String value = this.presentation.getSelectedValue();
        this.setText(value);
        this.setIcon(this.presentation.getIcon());
        this.setVisible(!Strings.isEmpty((String)value));
    }
}

