/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessorKt;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/AttachProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "validateDirectory", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "chooseAndAttachToProject", "Companion", "intellij.platform.ide.impl"})
public class AttachProjectAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Path> TO_SELECT_KEY;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(ProjectAttachProcessor.Companion.canAttachToProject() && GeneralSettings.Companion.getInstance().getConfirmOpenNewProject() != -1);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        this.chooseAndAttachToProject(project3);
    }

    public boolean validateDirectory(@NotNull Project project2, @NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return true;
    }

    public final void chooseAndAttachToProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Companion.chooseAndAttachToProject(project2, (Function2<? super Project, ? super VirtualFile, Boolean>)((Function2)new Function2<Project, VirtualFile, Boolean>((Object)this){

            public final Boolean invoke(Project p0, VirtualFile p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((AttachProjectAction)((Object)this.receiver)).validateDirectory(p0, p1);
            }
        }));
    }

    @NotNull
    public static final Key<Path> getTO_SELECT_KEY() {
        return Companion.getTO_SELECT_KEY();
    }

    static {
        Key key = Key.create((String)"attach_to_select_key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TO_SELECT_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/AttachProjectAction$Companion;", "", "<init>", "()V", "chooseAndAttachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "validateDirectory", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "TO_SELECT_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "getTO_SELECT_KEY$annotations", "getTO_SELECT_KEY", "()Lcom/intellij/openapi/util/Key;", "attachProject", "virtualFile", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nAttachProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachProjectAction.kt\ncom/intellij/platform/AttachProjectAction$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,122:1\n42#2,3:123\n*S KotlinDebug\n*F\n+ 1 AttachProjectAction.kt\ncom/intellij/platform/AttachProjectAction$Companion\n*L\n98#1:123,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        public final void chooseAndAttachToProject(@NotNull Project project2, @NotNull Function2<? super Project, ? super VirtualFile, Boolean> validateDirectory) {
            VirtualFile preselectedDirectory;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(validateDirectory, (String)"validateDirectory");
            OpenProjectFileChooserDescriptor descriptor = new OpenProjectFileChooserDescriptor(true);
            Path path = (Path)project2.getUserData(this.getTO_SELECT_KEY());
            if (path != null) {
                Path it = path;
                boolean bl = false;
                project2.putUserData(Companion.getTO_SELECT_KEY(), null);
                v1 = LocalFileSystem.getInstance().findFileByNioFile(it);
            } else {
                v1 = preselectedDirectory = null;
            }
            if (preselectedDirectory == null) {
                String defaultProjectDirectory = GeneralLocalSettings.Companion.getInstance().getDefaultProjectDirectory();
                preselectedDirectory = ((CharSequence)defaultProjectDirectory).length() == 0 ? VfsUtil.findFileByIoFile((File)new File(SystemProperties.getUserHome()), (boolean)true) : VfsUtil.findFileByIoFile((File)new File(defaultProjectDirectory), (boolean)true);
            }
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)preselectedDirectory, arg_0 -> Companion.chooseAndAttachToProject$lambda$2(arg_0 -> Companion.chooseAndAttachToProject$lambda$1(validateDirectory, project2, arg_0), arg_0));
        }

        @NotNull
        public final Key<Path> getTO_SELECT_KEY() {
            return TO_SELECT_KEY;
        }

        @JvmStatic
        public static /* synthetic */ void getTO_SELECT_KEY$annotations() {
        }

        @RequiresEdt
        public final void attachProject(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Ref.ObjectRef baseDir = new Ref.ObjectRef();
            baseDir.element = virtualFile;
            if (!virtualFile.isDirectory()) {
                baseDir.element = virtualFile.getParent();
                while (baseDir.element != null) {
                    boolean bl;
                    try {
                        boolean $i$f$service = false;
                        Class<ProjectStorePathManager> serviceClass$iv = ProjectStorePathManager.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        ProjectStorePathManager projectStorePathManager = (ProjectStorePathManager)object;
                        Path path = ((VirtualFile)baseDir.element).toNioPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                        bl = projectStorePathManager.testStoreDirectoryExistsForProjectRoot(path);
                    }
                    catch (InvalidPathException e) {
                        bl = false;
                    }
                    boolean isProjectDirectory = bl;
                    if (isProjectDirectory) break;
                    baseDir.element = ((VirtualFile)baseDir.element).getParent();
                }
            }
            if (baseDir.element == null) {
                Object[] objectArray = new Object[]{virtualFile.getPath()};
                Messages.showErrorDialog((String)IdeBundle.message((String)"dialog.message.attach.project.not.found", (Object[])objectArray), (String)IdeBundle.message((String)"dialog.title.attach.project.error", (Object[])new Object[0]));
            } else {
                String string = ActionsBundle.message((String)"action.AttachProject.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                TasksKt.runWithModalProgressBlocking((Project)project2, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project2, (Ref.ObjectRef<VirtualFile>)baseDir, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Ref.ObjectRef<VirtualFile> $baseDir;
                    {
                        this.$project = $project;
                        this.$baseDir = $baseDir;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Path path = Path.of(FileUtil.toSystemDependentName((String)((VirtualFile)this.$baseDir.element).getPath()), new String[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                                this.label = 1;
                                Object object2 = PlatformProjectOpenProcessorKt.attachToProjectAsync$default(this.$project, path, null, null, null, (Continuation)this, 28, null);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        }

        private static final Unit chooseAndAttachToProject$lambda$1(Function2 $validateDirectory, Project $project, List it) {
            VirtualFile directory = (VirtualFile)it.get(0);
            Intrinsics.checkNotNull((Object)directory);
            if (((Boolean)$validateDirectory.invoke((Object)$project, (Object)directory)).booleanValue()) {
                Companion.attachProject(directory, $project);
            }
            return Unit.INSTANCE;
        }

        private static final void chooseAndAttachToProject$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

