/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.platform.ide.IdeFingerprint;
import com.intellij.util.indexing.FileBasedIndexExtension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0017\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"fingerprint", "Lkotlin/Lazy;", "Lcom/intellij/platform/ide/IdeFingerprint;", "ideFingerprint", "debugHelperToken", "", "(I)J", "computeIdeFingerprint", "addPluginFingerprint", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "hasher", "Lcom/dynatrace/hash4j/hashing/HashStream64;", "hashByFileContent", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "hashFile", "file", "Ljava/nio/file/Path;", "path", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeFingerprint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeFingerprint.kt\ncom/intellij/platform/ide/IdeFingerprintKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,151:1\n1869#2,2:152\n1321#3,2:154\n*S KotlinDebug\n*F\n+ 1 IdeFingerprint.kt\ncom/intellij/platform/ide/IdeFingerprintKt\n*L\n93#1:152,2\n133#1:154,2\n*E\n"})
public final class IdeFingerprintKt {
    @NotNull
    private static final Lazy<IdeFingerprint> fingerprint = LazyKt.lazy(IdeFingerprintKt::fingerprint$lambda$0);

    @ApiStatus.Internal
    public static final long ideFingerprint(int debugHelperToken) {
        return debugHelperToken == 0 ? ((IdeFingerprint)fingerprint.getValue()).unbox-impl() : IdeFingerprintKt.computeIdeFingerprint(debugHelperToken);
    }

    public static /* synthetic */ long ideFingerprint$default(int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return IdeFingerprintKt.ideFingerprint(n);
    }

    @ApiStatus.Internal
    private static final long computeIdeFingerprint(int debugHelperToken) {
        long startTime = System.currentTimeMillis();
        HashStream64 hasher = Hashing.xxh3_64().hashStream();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
        ApplicationInfoEx appInfo = applicationInfoEx;
        HashStream64 hashStream64 = AppMode.isRunningFromDevBuild() ? hasher.putBytes(Files.readAllBytes(PathManager.getHomeDir().resolve("fingerprint.txt"))) : hasher.putLong(appInfo.getBuildTime().toEpochSecond());
        hasher.putString(appInfo.getBuild().asString());
        String string = System.getProperty("idea.kotlin.plugin.use.k1");
        if (string == null) {
            string = "k2";
        }
        hasher.putString(string);
        List loadedPlugins = PluginManagerCore.getLoadedPlugins();
        hasher.putInt(loadedPlugins.size());
        if (PluginManagerCore.isRunningFromSources()) {
            hasher.putLong(System.currentTimeMillis());
        } else {
            for (IdeaPluginDescriptor plugin : loadedPlugins) {
                if (plugin.isBundled()) continue;
                Intrinsics.checkNotNull((Object)hasher);
                IdeFingerprintKt.addPluginFingerprint(plugin, hasher);
            }
        }
        Iterable $this$forEach$iv = FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBasedIndexExtension it = (FileBasedIndexExtension)element$iv;
            boolean bl = false;
            hasher.putInt(it.getVersion());
        }
        hasher.putInt(debugHelperToken);
        hasher.putInt(FileSizeLimit.Companion.getFingerprint());
        long fingerprint = IdeFingerprint.constructor-impl(hasher.getAsLong());
        long durationMs = System.currentTimeMillis() - startTime;
        Logger.getInstance((String)"com.intellij.platform.ide.IdeFingerprint").info("Calculated dependencies fingerprint in " + durationMs + " ms (hash=" + IdeFingerprint.asString-impl(fingerprint) + ", buildTime=" + appInfo.getBuildTime().toEpochSecond() + ", appVersion=" + appInfo.getBuild().asString() + ")");
        return fingerprint;
    }

    private static final void addPluginFingerprint(IdeaPluginDescriptor plugin, HashStream64 hasher) {
        hasher.putString(plugin.getPluginId().getIdString());
        hasher.putString(plugin.getVersion());
        String string = plugin.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        if (StringsKt.contains((CharSequence)string, (CharSequence)"SNAPSHOT", (boolean)true)) {
            Intrinsics.checkNotNull((Object)plugin, (String)"null cannot be cast to non-null type com.intellij.ide.plugins.IdeaPluginDescriptorImpl");
            IdeFingerprintKt.hashByFileContent((IdeaPluginDescriptorImpl)plugin, hasher);
        }
    }

    private static final void hashByFileContent(IdeaPluginDescriptorImpl descriptor, HashStream64 hasher) {
        if (descriptor.getUseCoreClassLoader()) {
            hasher.putLong(0L);
            return;
        }
        ProgressManager.checkCanceled();
        List list2 = descriptor.getJarFiles();
        Intrinsics.checkNotNull((Object)list2);
        List files2 = list2;
        hasher.putInt(files2.size());
        for (Path file2 : files2) {
            Sequence $this$forEach$iv = SequencesKt.sorted((Sequence)PathsKt.walk((Path)file2, (PathWalkOption[])new PathWalkOption[0]));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path f = (Path)element$iv;
                boolean bl = false;
                String absolutePathString = ((Object)f.toAbsolutePath()).toString();
                if (StringsKt.startsWith$default((String)absolutePathString, (String)"/tmp/byteBuddyAgent", (boolean)false, (int)2, null)) continue;
                IdeFingerprintKt.hashFile(f, hasher, absolutePathString);
            }
        }
    }

    private static final void hashFile(Path file2, HashStream64 hasher, String path) {
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        BasicFileAttributes attributes = Files.readAttributes(file2, BasicFileAttributes.class, linkOptionArray);
        hasher.putString(path);
        hasher.putLong(attributes.size());
        hasher.putLong(attributes.lastModifiedTime().toMillis());
    }

    private static final IdeFingerprint fingerprint$lambda$0() {
        return IdeFingerprint.box-impl(IdeFingerprintKt.computeIdeFingerprint(0));
    }
}

