/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SingleContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.openapi.wm.impl.content.ToolWindowInEditorSupport;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowDragHelper;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.ui.drag.DialogDragImageView;
import com.intellij.ui.drag.DragImageView;
import com.intellij.ui.drag.GlassPaneDragImageView;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002MNB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001aH\u0014J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010-\u001a\u00020%2\b\u0010.\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020\u001cH\u0014J \u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002J \u00105\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u001cH\u0016J\b\u00109\u001a\u00020%H\u0016J \u0010:\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001aH\u0014J\b\u0010=\u001a\u00020%H\u0002J\b\u0010>\u001a\u00020%H\u0002J\u0010\u0010?\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010@\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010\u000b2\u0006\u0010B\u001a\u00020!H\u0002J\u0012\u0010C\u001a\u0004\u0018\u0001072\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010D\u001a\u00020%2\u0006\u0010E\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u000207H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020IH\u0002J\f\u0010J\u001a\u00020\u001c*\u00020\u000bH\u0002J\u0014\u0010K\u001a\u0004\u0018\u00010L2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/toolWindow/ToolWindowInnerDragHelper;", "Lcom/intellij/ui/MouseDragHelper;", "Ljavax/swing/JComponent;", "parent", "Lcom/intellij/openapi/Disposable;", "pane", "<init>", "(Lcom/intellij/openapi/Disposable;Ljavax/swing/JComponent;)V", "getPane", "()Ljavax/swing/JComponent;", "sourceDecorator", "Lcom/intellij/toolWindow/InternalDecoratorImpl;", "sourceTopDecorator", "myInitialIndex", "", "curDropLocation", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation;", "myDraggingTab", "Lcom/intellij/openapi/wm/impl/content/ContentTabLabel;", "dragImageView", "Lcom/intellij/ui/drag/DragImageView;", "currentDropSide", "currentDropIndex", "highlighter", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "myInitialOffset", "Ljava/awt/Point;", "canStartDragging", "", "dragComponent", "dragComponentPoint", "getTab", "point", "Lcom/intellij/ui/awt/RelativePoint;", "canFinishDragging", "component", "processMousePressed", "", "event", "Ljava/awt/event/MouseEvent;", "getInitialIndex", "tabLabel", "getTabIndex", "doGetTabIndex", "tabContainer", "mouseReleased", "e", "processDragFinish", "willDragOutStart", "dropIntoToolWindow", "content", "Lcom/intellij/ui/content/Content;", "targetDecorator", "dropIntoEditor", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "cancelDragging", "stop", "processDrag", "dragToScreenPoint", "startScreenPoint", "stopDrag", "startDrag", "relocate", "updateCurDropLocation", "findToolWindowDecorator", "relativePoint", "findEditorWindow", "highlightToolWindowDropArea", "decorator", "highlightEditorDropArea", "window", "findTopDecorator", "Ljava/awt/Component;", "isSingleContentLayout", "getEditorSupport", "Lcom/intellij/openapi/wm/impl/content/ToolWindowInEditorSupport;", "DropLocation", "MyDialog", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowInnerDragHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowInnerDragHelper.kt\ncom/intellij/toolWindow/ToolWindowInnerDragHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n1#2:464\n4225#3,11:465\n1880#3,6:476\n1880#3,6:482\n1880#3,6:488\n528#4,7:494\n*S KotlinDebug\n*F\n+ 1 ToolWindowInnerDragHelper.kt\ncom/intellij/toolWindow/ToolWindowInnerDragHelper\n*L\n128#1:465,11\n144#1:476,6\n155#1:482,6\n162#1:488,6\n421#1:494,7\n*E\n"})
public final class ToolWindowInnerDragHelper
extends MouseDragHelper<JComponent> {
    @NotNull
    private final JComponent pane;
    @Nullable
    private InternalDecoratorImpl sourceDecorator;
    @Nullable
    private InternalDecoratorImpl sourceTopDecorator;
    private int myInitialIndex;
    @Nullable
    private DropLocation curDropLocation;
    @Nullable
    private ContentTabLabel myDraggingTab;
    @Nullable
    private DragImageView dragImageView;
    private int currentDropSide;
    private int currentDropIndex;
    @NotNull
    private final NonOpaquePanel highlighter;
    @NotNull
    private final Point myInitialOffset;

    public ToolWindowInnerDragHelper(@NotNull Disposable parent, @NotNull JComponent pane2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        super(parent, pane2);
        this.pane = pane2;
        this.sourceDecorator = null;
        this.myInitialIndex = -1;
        this.myDraggingTab = null;
        this.currentDropSide = -1;
        this.currentDropIndex = -1;
        this.highlighter = ToolWindowDragHelper.Companion.createDropTargetHighlightComponent$intellij_platform_ide_impl();
        this.myInitialOffset = new Point();
    }

    @NotNull
    public final JComponent getPane() {
        return this.pane;
    }

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
        Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
        return this.getTab(new RelativePoint((Component)dragComponent, dragComponentPoint)) != null;
    }

    @Nullable
    public final ContentTabLabel getTab(@NotNull RelativePoint point) {
        block5: {
            Component child;
            block6: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                Point $this$getTab_u24lambda_u240 = point.getPoint((Component)this.pane);
                boolean bl2 = false;
                child = SwingUtilities.getDeepestComponentAt(this.pane, $this$getTab_u24lambda_u240.x, $this$getTab_u24lambda_u240.y);
                InternalDecoratorImpl decorator = InternalDecoratorImpl.Companion.findTopLevelDecorator(child);
                ToolWindowInEditorSupport editorSupport = this.getEditorSupport(decorator);
                if (decorator == null || !ToolWindowContentUi.isTabsReorderingAllowed(decorator.toolWindow) || !(child instanceof ContentTabLabel) || !(((ContentTabLabel)child).getParent() instanceof ToolWindowContentUi.TabPanel) && (!Registry.Companion.is("debugger.new.tool.window.layout.dnd", false) || !(((ContentTabLabel)child).getParent() instanceof SingleContentLayout.TabAdapter))) break block5;
                ContentManager contentManager = decorator.toolWindow.getContentManager();
                Intrinsics.checkNotNull((Object)contentManager, (String)"null cannot be cast to non-null type com.intellij.ui.content.impl.ContentManagerImpl");
                if (((ContentManagerImpl)contentManager).getRecursiveContentCount() > 1) break block6;
                ToolWindowInEditorSupport toolWindowInEditorSupport = editorSupport;
                if (toolWindowInEditorSupport != null) {
                    Project project2 = decorator.toolWindow.getProject();
                    Content content2 = ((ContentTabLabel)child).getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                    bl = toolWindowInEditorSupport.canOpenInEditor(project2, content2);
                } else {
                    bl = false;
                }
                if (!bl) break block5;
            }
            return (ContentTabLabel)child;
        }
        return null;
    }

    protected boolean canFinishDragging(@NotNull JComponent component2, @NotNull RelativePoint point) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        DropLocation curLocation = this.curDropLocation;
        if (curLocation != null) {
            JComponent jComponent;
            DropLocation dropLocation = curLocation;
            if (dropLocation instanceof DropLocation.ToolWindow) {
                jComponent = (JComponent)((Object)((DropLocation.ToolWindow)curLocation).getDecorator());
            } else if (dropLocation instanceof DropLocation.Editor) {
                jComponent = ((DropLocation.Editor)curLocation).getWindow().getComponent$intellij_platform_ide_impl();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JComponent component3 = jComponent;
            bl = component3.contains(point.getPoint((Component)component3));
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void processMousePressed(@NotNull MouseEvent event) {
        DragImageView dragImageView;
        InternalDecoratorImpl internalDecoratorImpl;
        GlassPaneDragImageView it;
        ToolWindowInnerDragHelper toolWindowInnerDragHelper;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RelativePoint relativePoint = new RelativePoint(event);
        ContentTabLabel contentTabLabel = this.getTab(relativePoint);
        if (contentTabLabel == null) {
            this.sourceDecorator = null;
            this.sourceTopDecorator = null;
            this.myDraggingTab = null;
            return;
        }
        this.myInitialOffset.setLocation(relativePoint.getPoint((Component)contentTabLabel));
        this.myDraggingTab = contentTabLabel;
        this.sourceDecorator = InternalDecoratorImpl.Companion.findNearestDecorator(contentTabLabel);
        ToolWindowInnerDragHelper toolWindowInnerDragHelper2 = this;
        InternalDecoratorImpl internalDecoratorImpl2 = this.sourceDecorator;
        if (internalDecoratorImpl2 != null) {
            InternalDecoratorImpl internalDecoratorImpl3 = internalDecoratorImpl2;
            toolWindowInnerDragHelper = toolWindowInnerDragHelper2;
            boolean bl = false;
            internalDecoratorImpl = this.findTopDecorator((Component)((Object)it));
            toolWindowInnerDragHelper2 = toolWindowInnerDragHelper;
        } else {
            internalDecoratorImpl = null;
        }
        toolWindowInnerDragHelper2.sourceTopDecorator = internalDecoratorImpl;
        this.myInitialIndex = this.getInitialIndex(contentTabLabel);
        if (this.sourceDecorator != null) {
            InternalDecoratorImpl internalDecoratorImpl4 = this.sourceDecorator;
            Intrinsics.checkNotNull((Object)internalDecoratorImpl4);
            this.curDropLocation = new DropLocation.ToolWindow(internalDecoratorImpl4);
        }
        BufferedImage tabImage = ToolWindowDragHelper.Companion.createThumbnailDragImage$intellij_platform_ide_impl(contentTabLabel, -1);
        ToolWindowInnerDragHelper toolWindowInnerDragHelper3 = this;
        if (StartupUiUtil.isWaylandToolkit()) {
            void $this$processMousePressed_u24lambda_u241;
            GlassPaneDragImageView glassPaneDragImageView;
            IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this.pane);
            Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(...)");
            it = glassPaneDragImageView = new GlassPaneDragImageView(ideGlassPane);
            toolWindowInnerDragHelper = toolWindowInnerDragHelper3;
            boolean bl = false;
            $this$processMousePressed_u24lambda_u241.setImage(tabImage);
            toolWindowInnerDragHelper3 = toolWindowInnerDragHelper;
            dragImageView = glassPaneDragImageView;
        } else {
            dragImageView = new DialogDragImageView(new MyDialog(this.pane, this, tabImage));
        }
        toolWindowInnerDragHelper3.dragImageView = dragImageView;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int getInitialIndex(ContentTabLabel tabLabel) {
        int n;
        Content content2 = tabLabel.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
        Content content3 = content2;
        if (content3 instanceof SingleContentLayout.SubContent) {
            InternalDecoratorImpl internalDecoratorImpl = this.sourceDecorator;
            boolean bl = internalDecoratorImpl != null ? this.isSingleContentLayout(internalDecoratorImpl) : false;
            if (bl) {
                n = ((SingleContentLayout.SubContent)content3).getSupplier().getTabs().getIndexOf(((SingleContentLayout.SubContent)content3).getInfo());
                return n;
            }
        }
        ContentManager contentManager = content3.getManager();
        Intrinsics.checkNotNull((Object)contentManager);
        n = contentManager.getIndexOfContent(content3);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int getTabIndex(RelativePoint point) {
        void $this$filterIsInstanceTo$iv$iv;
        Point point2 = point.getPoint((Component)this.pane);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
        Point p = point2;
        Component componentBelowCursor = SwingUtilities.getDeepestComponentAt(this.pane, p.x, p.y);
        ToolWindowContentUi.TabPanel tabPanel = (ToolWindowContentUi.TabPanel)((Object)ComponentUtil.getParentOfType(ToolWindowContentUi.TabPanel.class, (Component)componentBelowCursor));
        if (tabPanel == null) {
            return -1;
        }
        Component[] componentArray = tabPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SingleContentLayout.TabAdapter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        SingleContentLayout.TabAdapter tabAdapter = (SingleContentLayout.TabAdapter)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        return tabAdapter != null && Registry.Companion.is("debugger.new.tool.window.layout.dnd", false) ? this.doGetTabIndex((JComponent)((Object)tabAdapter), point) : RangesKt.coerceAtLeast((int)this.doGetTabIndex((JComponent)((Object)tabPanel), point), (int)1);
    }

    /*
     * WARNING - void declaration
     */
    private final int doGetTabIndex(JComponent tabContainer, RelativePoint point) {
        int n;
        block14: {
            int n2;
            Object[] it;
            int index$iv;
            int n3;
            int $i$f$indexOfLast;
            Point p;
            block12: {
                Point point2 = point.getPoint((Component)tabContainer);
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
                p = point2;
                ContentTabLabel draggingTab = this.myDraggingTab;
                if (draggingTab != null) {
                    p.x += draggingTab.getWidth() / 2 - this.myInitialOffset.x;
                    p.y += draggingTab.getHeight() / 2 - this.myInitialOffset.y;
                }
                Component[] componentArray = tabContainer.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$indexOfLast$iv = componentArray;
                $i$f$indexOfLast = 0;
                n3 = $this$indexOfLast$iv.length + -1;
                if (0 <= n3) {
                    do {
                        index$iv = n3--;
                        it = (Object[])$this$indexOfLast$iv[index$iv];
                        boolean bl = false;
                        if (!(it instanceof JLabel && !(it instanceof BaseLabel))) continue;
                        n2 = index$iv;
                        break block12;
                    } while (0 <= n3);
                }
                n2 = -1;
            }
            int placeholderIndex = n2;
            $i$f$indexOfLast = tabContainer.getComponentCount();
            for (int i2 = 0; i2 < $i$f$indexOfLast; ++i2) {
                Component child = tabContainer.getComponents()[i2];
                if (!(child instanceof ContentTabLabel)) continue;
                int childCenterX = ((ContentTabLabel)child).getX() + ((ContentTabLabel)child).getWidth() / 2;
                if (placeholderIndex != -1) {
                    if (i2 < placeholderIndex && p.x < childCenterX) {
                        return i2;
                    }
                    if (i2 > placeholderIndex) {
                        if (p.x > childCenterX) {
                            int n4;
                            int n5;
                            block13: {
                                void $this$indexOfLast$iv;
                                Component[] componentArray = tabContainer.getComponents();
                                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                                it = componentArray;
                                n5 = i2;
                                boolean $i$f$indexOfLast2 = false;
                                int n6 = ((void)$this$indexOfLast$iv).length + -1;
                                if (0 <= n6) {
                                    do {
                                        int index$iv2 = n6--;
                                        Component it2 = (Component)$this$indexOfLast$iv[index$iv2];
                                        boolean bl = false;
                                        if (!(it2 instanceof JLabel)) continue;
                                        n4 = index$iv2;
                                        break block13;
                                    } while (0 <= n6);
                                }
                                n4 = -1;
                            }
                            int n7 = n4;
                            return RangesKt.coerceAtMost((int)n5, (int)n7);
                        }
                        return placeholderIndex;
                    }
                }
                if (!((ContentTabLabel)child).getBounds().contains(p)) continue;
                return i2;
            }
            Component[] componentArray = tabContainer.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$indexOfLast$iv = componentArray;
            $i$f$indexOfLast = 0;
            n3 = $this$indexOfLast$iv.length + -1;
            if (0 <= n3) {
                do {
                    index$iv = n3--;
                    it = (Component)$this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!(it instanceof JLabel)) continue;
                    n = index$iv;
                    break block14;
                } while (0 <= n3);
            }
            n = -1;
        }
        return RangesKt.coerceAtLeast((int)n, (int)0);
    }

    public void mouseReleased(@Nullable MouseEvent e) {
        super.mouseReleased(e);
        this.stopDrag();
    }

    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        ToolWindowImpl toolWindow2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InternalDecoratorImpl sourceDecorator = this.sourceDecorator;
        DropLocation curLocation = this.curDropLocation;
        if (sourceDecorator == null || curLocation == null) {
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
        Content content3 = content2;
        DropLocation dropLocation = curLocation;
        if (dropLocation instanceof DropLocation.ToolWindow) {
            this.dropIntoToolWindow(content3, sourceDecorator, ((DropLocation.ToolWindow)curLocation).getDecorator());
        } else if (dropLocation instanceof DropLocation.Editor) {
            this.dropIntoEditor(content3, sourceDecorator, ((DropLocation.Editor)curLocation).getWindow());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (sourceDecorator.getContentManager().isEmpty()) {
            sourceDecorator.unsplit(content3);
        }
        if ((toolWindow2 = sourceDecorator.toolWindow).getContentManager().getContentsRecursively().isEmpty()) {
            toolWindow2.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dropIntoToolWindow(Content content2, InternalDecoratorImpl sourceDecorator, InternalDecoratorImpl targetDecorator) {
        ContentManager contentManager = sourceDecorator.getContentManager();
        if (content2 instanceof SingleContentLayout.SubContent && this.isSingleContentLayout(targetDecorator)) {
            JBTabs tabs = ((SingleContentLayout.SubContent)content2).getSupplier().getTabs();
            TabInfo tabInfo = ((SingleContentLayout.SubContent)content2).getInfo();
            if (this.currentDropIndex != -1) {
                tabs.removeTab(tabInfo);
                tabInfo.setHidden(false);
                TabInfo tabInfo2 = tabs.addTab(tabInfo, this.currentDropIndex);
                Intrinsics.checkNotNull((Object)tabInfo2);
            } else if (this.currentDropSide == -1 || this.currentDropSide == 0) {
                tabInfo.setHidden(false);
            } else {
                targetDecorator.splitWithContent(content2, this.currentDropSide, -1);
            }
        } else {
            if (Intrinsics.areEqual((Object)sourceDecorator, (Object)targetDecorator)) {
                if (contentManager.getContentCount() > 0) {
                    ToolWindowInnerDragHelper.dropIntoToolWindow$splitWithContent(this, content2, sourceDecorator);
                } else {
                    contentManager.addContent(content2);
                }
                return;
            }
            content2.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)true);
            try {
                ToolWindowInnerDragHelper.dropIntoToolWindow$splitWithContent(this, content2, targetDecorator);
            }
            finally {
                content2.putUserData(Content.TEMPORARY_REMOVED_KEY, null);
            }
        }
    }

    private final void dropIntoEditor(Content content2, InternalDecoratorImpl sourceDecorator, EditorWindow editorWindow) {
        ToolWindowInEditorSupport toolWindowInEditorSupport = this.getEditorSupport(sourceDecorator);
        if (toolWindowInEditorSupport == null) {
            return;
        }
        ToolWindowInEditorSupport support = toolWindowInEditorSupport;
        support.openInEditor(content2, editorWindow);
    }

    /*
     * Unable to fully structure code
     */
    public boolean cancelDragging() {
        block2: {
            if (!super.cancelDragging()) break block2;
            v0 = this.myDraggingTab;
            Intrinsics.checkNotNull((Object)v0);
            v1 = v0.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getContent(...)");
            content = v1;
            if (!(content instanceof SingleContentLayout.SubContent)) ** GOTO lbl-1000
            v2 = this.sourceDecorator;
            Intrinsics.checkNotNull((Object)v2);
            if (this.isSingleContentLayout(v2)) {
                ((SingleContentLayout.SubContent)content).getInfo().setHidden(false);
            } else lbl-1000:
            // 2 sources

            {
                v3 = this.sourceDecorator;
                Intrinsics.checkNotNull((Object)v3);
                contentManager = v3.getContentManager();
                contentManager.addContent(content, RangesKt.coerceAtMost((int)this.myInitialIndex, (int)contentManager.getContentCount()));
            }
            this.stopDrag();
            return true;
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.stopDrag();
    }

    protected void processDrag(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (this.isDragJustStarted()) {
            this.startDrag();
        } else {
            this.relocate(event);
        }
    }

    private final void stopDrag() {
        if (this.myDraggingTab == null) {
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        Intrinsics.checkNotNull((Object)content2, (String)"null cannot be cast to non-null type com.intellij.ui.content.impl.ContentImpl");
        ((ContentImpl)content2).putUserData(Content.TEMPORARY_REMOVED_KEY, null);
        InternalDecoratorImpl internalDecoratorImpl = this.sourceDecorator;
        if (internalDecoratorImpl != null) {
            internalDecoratorImpl.setSplitUnsplitInProgress(false);
        }
        this.sourceDecorator = null;
        this.sourceTopDecorator = null;
        this.myDraggingTab = null;
        DropLocation curLocation = this.curDropLocation;
        if (curLocation instanceof DropLocation.ToolWindow) {
            ((DropLocation.ToolWindow)curLocation).getDecorator().setDropInfoIndex(-1, 0);
        }
        this.curDropLocation = null;
        Container parent = this.highlighter.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).remove((Component)this.highlighter);
            ((JComponent)parent).revalidate();
            ((JComponent)parent).repaint();
        }
        DragImageView dragImageView = this.dragImageView;
        if (dragImageView != null) {
            dragImageView.hide();
        }
        this.dragImageView = null;
    }

    private final void startDrag() {
        InternalDecoratorImpl sourceDecorator = this.sourceDecorator;
        if (sourceDecorator == null || sourceDecorator.getContentManager().getContentCount() == 0 || this.dragImageView == null) {
            return;
        }
        ContentTabLabel contentTabLabel = this.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        Content content2 = contentTabLabel.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
        Content content3 = content2;
        content3.putUserData(Content.TEMPORARY_REMOVED_KEY, (Object)true);
        if (content3 instanceof SingleContentLayout.SubContent && this.isSingleContentLayout(sourceDecorator)) {
            JBTabs tabs = ((SingleContentLayout.SubContent)content3).getSupplier().getTabs();
            TabInfo tabInfo = ((SingleContentLayout.SubContent)content3).getInfo();
            int index = tabs.getIndexOf(tabInfo);
            SwingUtilities.invokeLater(() -> ToolWindowInnerDragHelper.startDrag$lambda$0(tabInfo, sourceDecorator, index, this));
        } else {
            ContentManager manager2 = sourceDecorator.getContentManager();
            int index = manager2.getIndexOfContent(content3) + 1;
            SwingUtilities.invokeLater(() -> ToolWindowInnerDragHelper.startDrag$lambda$1(sourceDecorator, manager2, content3, index, this));
        }
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this.pane);
        Intrinsics.checkNotNull((Object)ideGlassPane, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent $this$startDrag_u24lambda_u242 = (JComponent)ideGlassPane;
        boolean bl = false;
        $this$startDrag_u24lambda_u242.add((Component)this.highlighter);
        $this$startDrag_u24lambda_u242.revalidate();
        $this$startDrag_u24lambda_u242.repaint();
    }

    private final void relocate(MouseEvent event) {
        DropLocation dropLocation;
        Point screenPoint = event.getLocationOnScreen();
        DragImageView dragImageView = this.dragImageView;
        Intrinsics.checkNotNull((Object)dragImageView);
        dragImageView.setLocation(new Point(screenPoint.x - this.myInitialOffset.x, screenPoint.y - this.myInitialOffset.y));
        DragImageView dragImageView2 = this.dragImageView;
        Intrinsics.checkNotNull((Object)dragImageView2);
        dragImageView2.show();
        RelativePoint relativePoint = new RelativePoint(event);
        this.updateCurDropLocation(relativePoint);
        DropLocation dropLocation2 = dropLocation = this.curDropLocation;
        if (dropLocation2 instanceof DropLocation.ToolWindow) {
            this.highlightToolWindowDropArea(((DropLocation.ToolWindow)dropLocation).getDecorator(), relativePoint);
        } else if (dropLocation2 instanceof DropLocation.Editor) {
            this.highlightEditorDropArea(((DropLocation.Editor)dropLocation).getWindow());
        } else {
            this.currentDropIndex = -1;
            this.highlighter.setBounds(new Rectangle());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void updateCurDropLocation(RelativePoint point) {
        block5: {
            block4: {
                decorator = this.findToolWindowDecorator(point);
                editorWindow = this.findEditorWindow(point);
                v0 = this.curDropLocation;
                if (v0 != null) {
                    dropLocation = v0;
                    $i$a$-let-ToolWindowInnerDragHelper$updateCurDropLocation$1 = false;
                    if (dropLocation instanceof DropLocation.ToolWindow && !Intrinsics.areEqual((Object)((DropLocation.ToolWindow)dropLocation).getDecorator(), (Object)decorator)) {
                        ((DropLocation.ToolWindow)dropLocation).getDecorator().setDropInfoIndex(-1, 0);
                    }
                }
                v1 = this.myDraggingTab;
                v2 /* !! */  = content = v1 != null ? v1.getContent() : null;
                if (decorator == null) break block4;
                v3 = new DropLocation.ToolWindow(decorator);
                break block5;
            }
            if (editorWindow == null || content == null) ** GOTO lbl-1000
            v4 = this.getEditorSupport(this.sourceDecorator);
            v5 = v4 != null ? v4.canOpenInEditor(editorWindow.getManager().getProject(), content) : false;
            if (v5) {
                v3 = new DropLocation.Editor(editorWindow);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
        }
        this.curDropLocation = v3;
    }

    private final InternalDecoratorImpl findToolWindowDecorator(RelativePoint relativePoint) {
        InternalDecoratorImpl internalDecoratorImpl = this.sourceTopDecorator;
        if (internalDecoratorImpl == null) {
            return null;
        }
        InternalDecoratorImpl topDecorator = internalDecoratorImpl;
        Point point = relativePoint.getPoint((Component)((Object)topDecorator));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Point point2 = point;
        Component component2 = SwingUtilities.getDeepestComponentAt((Component)((Object)topDecorator), point2.x, point2.y);
        return InternalDecoratorImpl.Companion.findNearestDecorator(component2);
    }

    private final EditorWindow findEditorWindow(RelativePoint point) {
        JRootPane jRootPane = UIUtil.getRootPane((Component)point.getComponent());
        Container rootComponent = jRootPane != null ? jRootPane.getContentPane() : null;
        Point point2 = point.getPoint((Component)rootComponent);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getPoint(...)");
        Point originalPoint = point2;
        Component component2 = SwingUtilities.getDeepestComponentAt(rootComponent, originalPoint.x, originalPoint.y);
        DataContext dataContext2 = DataManager.getInstance().getDataContext(component2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext dataContext3 = dataContext2;
        return (EditorWindow)dataContext3.getData(EditorWindow.DATA_KEY);
    }

    private final void highlightToolWindowDropArea(InternalDecoratorImpl decorator, RelativePoint point) {
        this.currentDropSide = TabsUtil.getDropSideFor((Point)point.getPoint((Component)((Object)decorator)), (JComponent)((JComponent)((Object)decorator)));
        Rectangle dropArea = new Rectangle(decorator.getSize());
        TabsUtil.updateBoundsWithDropSide((Rectangle)dropArea, (int)this.currentDropSide);
        dropArea.setBounds(SwingUtilities.convertRectangle((Component)((Object)decorator), dropArea, this.pane.getRootPane().getGlassPane()));
        this.currentDropIndex = this.getTabIndex(point);
        if (this.currentDropIndex != -1) {
            DragImageView dragImageView = this.dragImageView;
            Intrinsics.checkNotNull((Object)dragImageView);
            decorator.setDropInfoIndex(this.currentDropIndex, dragImageView.getSize().width);
            this.highlighter.setBounds(new Rectangle());
        } else {
            decorator.setDropInfoIndex(-1, 0);
            this.highlighter.setBounds(dropArea);
        }
    }

    private final void highlightEditorDropArea(EditorWindow window) {
        JComponent component2 = window.getComponent$intellij_platform_ide_impl();
        Rectangle dropArea = new Rectangle(component2.getSize());
        dropArea.setBounds(SwingUtilities.convertRectangle(component2, dropArea, this.pane.getRootPane().getGlassPane()));
        this.highlighter.setBounds(dropArea);
    }

    private final InternalDecoratorImpl findTopDecorator(Component component2) {
        JBIterable jBIterable = UIUtil.uiParents((Component)component2, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"uiParents(...)");
        Iterable $this$lastOrNull$iv = (Iterable)jBIterable;
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (!(it instanceof InternalDecoratorImpl)) continue;
            last$iv = element$iv;
        }
        Object var2_9 = last$iv;
        return var2_9 instanceof InternalDecoratorImpl ? (InternalDecoratorImpl)var2_9 : null;
    }

    private final boolean isSingleContentLayout(InternalDecoratorImpl $this$isSingleContentLayout) {
        Content[] contentArray = $this$isSingleContentLayout.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Content it = (Content)ArraysKt.singleOrNull((Object[])contentArray);
        boolean bl = false;
        return it != null && !(it instanceof SingleContentLayout.SubContent);
    }

    private final ToolWindowInEditorSupport getEditorSupport(InternalDecoratorImpl sourceDecorator) {
        return sourceDecorator != null ? ToolWindowContentUi.getToolWindowInEditorSupport(sourceDecorator.toolWindow) : null;
    }

    private static final void dropIntoToolWindow$splitWithContent(ToolWindowInnerDragHelper this$0, Content $content, InternalDecoratorImpl decorator) {
        int index = this$0.currentDropIndex != -1 ? RangesKt.coerceIn((int)(this$0.currentDropIndex - 1), (int)0, (int)decorator.getContentManager().getContentCount()) : -1;
        decorator.splitWithContent($content, this$0.currentDropSide, index);
    }

    private static final void startDrag$lambda$0(TabInfo $tabInfo, InternalDecoratorImpl $sourceDecorator, int $index, ToolWindowInnerDragHelper this$0) {
        $tabInfo.setHidden(true);
        ContentTabLabel contentTabLabel = this$0.myDraggingTab;
        Intrinsics.checkNotNull((Object)contentTabLabel);
        $sourceDecorator.setDropInfoIndex($index, contentTabLabel.getWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startDrag$lambda$1(InternalDecoratorImpl $sourceDecorator, ContentManager $manager, Content $content, int $index, ToolWindowInnerDragHelper this$0) {
        try {
            $sourceDecorator.setSplitUnsplitInProgress(true);
            $manager.removeContent($content, false);
            ContentTabLabel contentTabLabel = this$0.myDraggingTab;
            Intrinsics.checkNotNull((Object)contentTabLabel);
            $sourceDecorator.setDropInfoIndex($index, contentTabLabel.getWidth());
        }
        finally {
            $sourceDecorator.setSplitUnsplitInProgress(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation;", "", "ToolWindow", "Editor", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation$Editor;", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation$ToolWindow;", "intellij.platform.ide.impl"})
    private static sealed interface DropLocation {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation$Editor;", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "getWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
        public static final class Editor
        implements DropLocation {
            @NotNull
            private final EditorWindow window;

            public Editor(@NotNull EditorWindow window) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                this.window = window;
            }

            @NotNull
            public final EditorWindow getWindow() {
                return this.window;
            }

            @NotNull
            public final EditorWindow component1() {
                return this.window;
            }

            @NotNull
            public final Editor copy(@NotNull EditorWindow window) {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                return new Editor(window);
            }

            public static /* synthetic */ Editor copy$default(Editor editor2, EditorWindow editorWindow, int n, Object object) {
                if ((n & 1) != 0) {
                    editorWindow = editor2.window;
                }
                return editor2.copy(editorWindow);
            }

            @NotNull
            public String toString() {
                return "Editor(window=" + this.window + ")";
            }

            public int hashCode() {
                return this.window.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Editor)) {
                    return false;
                }
                Editor editor2 = (Editor)other;
                return Intrinsics.areEqual((Object)this.window, (Object)editor2.window);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation$ToolWindow;", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$DropLocation;", "decorator", "Lcom/intellij/toolWindow/InternalDecoratorImpl;", "<init>", "(Lcom/intellij/toolWindow/InternalDecoratorImpl;)V", "getDecorator", "()Lcom/intellij/toolWindow/InternalDecoratorImpl;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
        public static final class ToolWindow
        implements DropLocation {
            @NotNull
            private final InternalDecoratorImpl decorator;

            public ToolWindow(@NotNull InternalDecoratorImpl decorator) {
                Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
                this.decorator = decorator;
            }

            @NotNull
            public final InternalDecoratorImpl getDecorator() {
                return this.decorator;
            }

            @NotNull
            public final InternalDecoratorImpl component1() {
                return this.decorator;
            }

            @NotNull
            public final ToolWindow copy(@NotNull InternalDecoratorImpl decorator) {
                Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
                return new ToolWindow(decorator);
            }

            public static /* synthetic */ ToolWindow copy$default(ToolWindow toolWindow2, InternalDecoratorImpl internalDecoratorImpl, int n, Object object) {
                if ((n & 1) != 0) {
                    internalDecoratorImpl = toolWindow2.decorator;
                }
                return toolWindow2.copy(internalDecoratorImpl);
            }

            @NotNull
            public String toString() {
                return "ToolWindow(decorator=" + this.decorator + ")";
            }

            public int hashCode() {
                return this.decorator.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ToolWindow)) {
                    return false;
                }
                ToolWindow toolWindow2 = (ToolWindow)other;
                return Intrinsics.areEqual((Object)this.decorator, (Object)toolWindow2.decorator);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/toolWindow/ToolWindowInnerDragHelper$MyDialog;", "Ljavax/swing/JDialog;", "owner", "Ljavax/swing/JComponent;", "helper", "Lcom/intellij/toolWindow/ToolWindowInnerDragHelper;", "tabImage", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/toolWindow/ToolWindowInnerDragHelper;Ljava/awt/image/BufferedImage;)V", "getHelper", "()Lcom/intellij/toolWindow/ToolWindowInnerDragHelper;", "intellij.platform.ide.impl"})
    private static final class MyDialog
    extends JDialog {
        @NotNull
        private final ToolWindowInnerDragHelper helper;

        public MyDialog(@NotNull JComponent owner, @NotNull ToolWindowInnerDragHelper helper, @NotNull BufferedImage tabImage) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)((Object)helper), (String)"helper");
            Intrinsics.checkNotNullParameter((Object)tabImage, (String)"tabImage");
            super(ComponentUtil.getWindow((Component)owner), null, Dialog.ModalityType.MODELESS);
            this.helper = helper;
            this.setUndecorated(true);
            try {
                this.setOpacity(0.85f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAlwaysOnTop(true);
            this.setContentPane(new JLabel((Icon)IconUtil.createImageIcon((Image)tabImage)));
            this.getContentPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.getHelper().mouseReleased(e);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    ToolWindowInnerDragHelper toolWindowInnerDragHelper = this.getHelper();
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNull((Object)mouseEvent);
                    toolWindowInnerDragHelper.relocate(mouseEvent);
                }
            });
            this.pack();
        }

        @NotNull
        public final ToolWindowInnerDragHelper getHelper() {
            return this.helper;
        }
    }
}

