/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.Win7TaskBar;
import com.intellij.util.IconUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppIcon {
    private static final Logger LOG = Logger.getInstance(AppIcon.class);
    private static AppIcon ourIcon;

    @NotNull
    public static AppIcon getInstance() {
        if (ourIcon == null) {
            ourIcon = GraphicsEnvironment.isHeadless() || GraphicsUtil.isRemoteEnvironment() ? new EmptyIcon() : (SystemInfoRt.isMac ? new MacAppIcon() : (StartupUiUtil.isXToolkit() ? new XAppIcon() : (StartupUiUtil.isWaylandToolkit() ? new WLAppIcon() : (SystemInfoRt.isWindows && JnaLoader.isLoaded() ? new Win7AppIcon() : new EmptyIcon()))));
        }
        AppIcon appIcon = ourIcon;
        if (appIcon == null) {
            AppIcon.$$$reportNull$$$0(0);
        }
        return appIcon;
    }

    public abstract boolean setProgress(Project var1, @NonNls Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

    public abstract boolean hideProgress(Project var1, @NonNls Object var2);

    public abstract void setErrorBadge(Project var1, String var2);

    public abstract void setOkBadge(@Nullable Project var1, boolean var2);

    public abstract void requestAttention(@Nullable Project var1, boolean var2);

    public void requestFocus(IdeFrame frame) {
        this.requestFocus(frame == null ? null : SwingUtilities.getWindowAncestor(frame.getComponent()));
    }

    public void requestFocus(@Nullable Window window) {
    }

    public void requestFocus() {
    }

    private static boolean isProgressAppIconEnabled() {
        return SystemProperties.getBooleanProperty((String)"ide.appIcon.progress", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppIcon", "getInstance"));
    }

    private static final class EmptyIcon
    extends AppIcon {
        private EmptyIcon() {
        }

        @Override
        public boolean setProgress(Project project2, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            return false;
        }

        @Override
        public boolean hideProgress(Project project2, Object processId) {
            return false;
        }

        @Override
        public void setErrorBadge(Project project2, String text2) {
        }

        @Override
        public void setOkBadge(Project project2, boolean visible) {
        }

        @Override
        public void requestAttention(@Nullable Project project2, boolean critical) {
        }
    }

    static final class MacAppIcon
    extends BaseIcon {
        private BufferedImage myAppImage;
        private final Map<Object, Pair<BufferedImage, Graphics2D>> myProgressImagesCache = new HashMap<Object, Pair<BufferedImage, Graphics2D>>();
        private static final Color PROGRESS_BACKGROUND_COLOR = new Color(255, 255, 255, 217);
        private static final Color PROGRESS_OUTLINE_COLOR = new Color(140, 139, 140);

        MacAppIcon() {
        }

        private BufferedImage getAppImage() {
            EDT.assertIsEdt();
            try {
                if (this.myAppImage != null) {
                    return this.myAppImage;
                }
                if (!Taskbar.isTaskbarSupported()) {
                    return null;
                }
                Image appImage = Taskbar.getTaskbar().getIconImage();
                if (appImage == null) {
                    return null;
                }
                appImage = MultiResolutionImageProvider.getMaxSizeResolutionVariant((Image)appImage);
                this.myAppImage = ImageUtil.toBufferedImage((Image)appImage);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return this.myAppImage;
        }

        @Override
        public void _setTextBadge(@Nullable JFrame frame, String text2) {
            EDT.assertIsEdt();
            try {
                if (!Taskbar.isTaskbarSupported()) {
                    return;
                }
                Taskbar.getTaskbar().setIconBadge(text2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void requestFocus(@Nullable Window window) {
            EDT.assertIsEdt();
            if (window != null) {
                window.toFront();
                try {
                    Desktop.getDesktop().requestForeground(false);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                this.requestFocus();
            }
        }

        @Override
        public void requestFocus() {
            EDT.assertIsEdt();
            try {
                Desktop.getDesktop().requestForeground(true);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void _requestAttention(@Nullable JFrame frame, boolean critical) {
            EDT.assertIsEdt();
            try {
                if (!Taskbar.isTaskbarSupported()) {
                    return;
                }
                Taskbar.getTaskbar().requestUserAttention(true, critical);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public boolean _hideProgress(@Nullable JFrame frame, Object processId) {
            EDT.assertIsEdt();
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            BufferedImage appImage = this.getAppImage();
            if (appImage == null) {
                return false;
            }
            MacAppIcon.setDockIcon(appImage);
            this.myProgressImagesCache.remove(this.myCurrentProcessId);
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        @Override
        public void _setOkBadge(@Nullable JFrame frame, boolean visible) {
            EDT.assertIsEdt();
            BufferedImage appImage = this.getAppImage();
            if (appImage == null) {
                return;
            }
            Pair<BufferedImage, Graphics2D> img = MacAppIcon.createAppImage(appImage);
            if (visible) {
                Icon okIcon = AllIcons.Mac.AppIconOk512;
                int w = ((BufferedImage)img.first).getWidth();
                if (w != 128) {
                    okIcon = IconUtil.scale((Icon)okIcon, (Component)(frame != null ? frame.getRootPane() : null), (float)((float)w / 128.0f));
                }
                int x = w - okIcon.getIconWidth();
                int y = 0;
                okIcon.paintIcon(JOptionPane.getRootFrame(), (Graphics)img.second, x, y);
            }
            MacAppIcon.setDockIcon((BufferedImage)img.first);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _setProgress(@Nullable JFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            EDT.assertIsEdt();
            BufferedImage appImage = this.getAppImage();
            if (appImage == null) {
                return false;
            }
            this.myCurrentProcessId = processId;
            if (this.myLastValue > value) {
                return true;
            }
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                double progressHeight = (double)this.myAppImage.getHeight() * 0.13;
                double xInset = (double)this.myAppImage.getWidth() * 0.05;
                double yInset = (double)this.myAppImage.getHeight() * 0.15;
                double width = (double)this.myAppImage.getWidth() - xInset * 2.0;
                double y = (double)this.myAppImage.getHeight() - progressHeight - yInset;
                Area borderArea = new Area(new RoundRectangle2D.Double(xInset - 1.0, y - 1.0, width + 2.0, progressHeight + 2.0, progressHeight + 2.0, progressHeight + 2.0));
                Area backgroundArea = new Area(new Rectangle2D.Double(xInset, y, width, progressHeight));
                backgroundArea.intersect(borderArea);
                Area progressArea = new Area(new Rectangle2D.Double(xInset + 1.0, y + 1.0, (width - 2.0) * value, progressHeight - 1.0));
                progressArea.intersect(borderArea);
                Pair<BufferedImage, Graphics2D> appImg = this.myProgressImagesCache.get(this.myCurrentProcessId);
                if (appImg == null) {
                    appImg = MacAppIcon.createAppImage(appImage);
                    this.myProgressImagesCache.put(this.myCurrentProcessId, appImg);
                }
                Graphics2D g2d = (Graphics2D)appImg.second;
                g2d.setColor(PROGRESS_BACKGROUND_COLOR);
                g2d.fill(backgroundArea);
                g2d.setColor(isOk ? scheme.getOkColor() : scheme.getErrorColor());
                g2d.fill(progressArea);
                g2d.setColor(PROGRESS_OUTLINE_COLOR);
                g2d.draw(backgroundArea);
                g2d.draw(borderArea);
                MacAppIcon.setDockIcon((BufferedImage)appImg.first);
                this.myLastValue = value;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myCurrentProcessId = null;
            }
            return true;
        }

        private static Pair<BufferedImage, Graphics2D> createAppImage(BufferedImage appImage) {
            BufferedImage current = new BufferedImage(appImage.getWidth(), appImage.getHeight(), 2);
            Graphics2D g = current.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            StartupUiUtil.drawImage((Graphics)g, (Image)appImage, (int)0, (int)0, null);
            return new Pair((Object)current, (Object)g);
        }

        static void setDockIcon(BufferedImage image2) {
            try {
                if (!Taskbar.isTaskbarSupported()) {
                    return;
                }
                Taskbar.getTaskbar().setIconImage(image2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static final class XAppIcon
    extends BaseIcon {
        private XAppIcon() {
        }

        @Override
        public boolean _setProgress(@Nullable JFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            return false;
        }

        @Override
        public boolean _hideProgress(@Nullable JFrame frame, Object processId) {
            return false;
        }

        @Override
        public void _setTextBadge(@Nullable JFrame frame, String text2) {
        }

        @Override
        public void _setOkBadge(@Nullable JFrame frame, boolean visible) {
        }

        @Override
        public void _requestAttention(@Nullable JFrame frame, boolean critical) {
            if (frame != null) {
                X11UiUtil.requestAttention(frame);
            }
        }

        @Override
        public void requestFocus(Window window) {
            if (window != null) {
                X11UiUtil.activate(window);
            }
        }
    }

    private static final class WLAppIcon
    extends BaseIcon {
        private WLAppIcon() {
        }

        @Override
        public boolean _setProgress(@Nullable JFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            return false;
        }

        @Override
        public boolean _hideProgress(@Nullable JFrame frame, Object processId) {
            return false;
        }

        @Override
        public void _setTextBadge(@Nullable JFrame frame, String text2) {
        }

        @Override
        public void _setOkBadge(@Nullable JFrame frame, boolean visible) {
        }

        @Override
        public void _requestAttention(@Nullable JFrame frame, boolean critical) {
        }

        @Override
        public void requestFocus(Window window) {
            if (window != null) {
                window.toFront();
            }
        }
    }

    private static final class Win7AppIcon
    extends BaseIcon {
        private static final Color errorBadgeShadowColor = new Color(0, 0, 0, 102);
        private static final Color errorBadgeMainColor = new Color(255, 98, 89);
        private static final Color errorBadgeTextBackgroundColor = new Color(0, 0, 0, 39);
        private WinDef.HICON myOkIcon;

        private Win7AppIcon() {
        }

        @Override
        public boolean _setProgress(@Nullable JFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            EDT.assertIsEdt();
            this.myCurrentProcessId = processId;
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.setProgress(frame, value, isOk);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myLastValue = value;
            this.myCurrentProcessId = null;
            return true;
        }

        @Override
        public boolean _hideProgress(@Nullable JFrame frame, Object processId) {
            EDT.assertIsEdt();
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.hideProgress(frame);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        private static byte[] writeTransparentIco(BufferedImage src) throws IOException {
            LOG.assertTrue(2 == src.getType() || 6 == src.getType());
            int bitCount = 32;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                byte[] byArray;
                try (BinaryOutputStream bos = new BinaryOutputStream((OutputStream)os, ByteOrder.LITTLE_ENDIAN);){
                    int t_scan_line_size;
                    int scan_line_size = (bitCount * src.getWidth() + 7) / 8;
                    if (scan_line_size % 4 != 0) {
                        scan_line_size += 4 - scan_line_size % 4;
                    }
                    if ((t_scan_line_size = (src.getWidth() + 7) / 8) % 4 != 0) {
                        t_scan_line_size += 4 - t_scan_line_size % 4;
                    }
                    int imageSize = 40 + src.getHeight() * scan_line_size + src.getHeight() * t_scan_line_size;
                    bos.write2Bytes(0);
                    bos.write2Bytes(1);
                    bos.write2Bytes(1);
                    int iconDirEntryWidth = src.getWidth();
                    int iconDirEntryHeight = src.getHeight();
                    if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
                        iconDirEntryWidth = 0;
                        iconDirEntryHeight = 0;
                    }
                    bos.write(iconDirEntryWidth);
                    bos.write(iconDirEntryHeight);
                    bos.write(0);
                    bos.write(0);
                    bos.write2Bytes(1);
                    bos.write2Bytes(bitCount);
                    bos.write4Bytes(imageSize);
                    bos.write4Bytes(22);
                    bos.write4Bytes(40);
                    bos.write4Bytes(src.getWidth());
                    bos.write4Bytes(2 * src.getHeight());
                    bos.write2Bytes(1);
                    bos.write2Bytes(bitCount);
                    bos.write4Bytes(0);
                    bos.write4Bytes(0);
                    bos.write4Bytes(0);
                    bos.write4Bytes(0);
                    bos.write4Bytes(0);
                    bos.write4Bytes(0);
                    int bit_cache = 0;
                    int bits_in_cache = 0;
                    int row_padding = scan_line_size - (bitCount * src.getWidth() + 7) / 8;
                    for (int y = src.getHeight() - 1; y >= 0; --y) {
                        int x;
                        for (x = 0; x < src.getWidth(); ++x) {
                            int argb = src.getRGB(x, y);
                            bos.write(0xFF & argb);
                            bos.write(0xFF & argb >> 8);
                            bos.write(0xFF & argb >> 16);
                            bos.write(0xFF & argb >> 24);
                        }
                        for (x = 0; x < row_padding; ++x) {
                            bos.write(0);
                        }
                    }
                    int t_row_padding = t_scan_line_size - (src.getWidth() + 7) / 8;
                    for (int y = src.getHeight() - 1; y >= 0; --y) {
                        int x;
                        for (x = 0; x < src.getWidth(); ++x) {
                            int argb = src.getRGB(x, y);
                            int alpha = 0xFF & argb >> 24;
                            bit_cache <<= 1;
                            if (alpha == 0) {
                                bit_cache |= 1;
                            }
                            if (++bits_in_cache < 8) continue;
                            bos.write(0xFF & bit_cache);
                            bit_cache = 0;
                            bits_in_cache = 0;
                        }
                        if (bits_in_cache > 0) {
                            bos.write(0xFF & (bit_cache <<= 8 - bits_in_cache));
                            bit_cache = 0;
                            bits_in_cache = 0;
                        }
                        for (x = 0; x < t_row_padding; ++x) {
                            bos.write(0);
                        }
                    }
                    byArray = os.toByteArray();
                }
                return byArray;
            }
        }

        @Override
        public void _setTextBadge(@Nullable JFrame frame, String text2) {
            EDT.assertIsEdt();
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            WinDef.HICON icon2 = null;
            if (text2 != null) {
                try {
                    int size2 = 16;
                    BufferedImage image2 = UIUtil.createImage((Component)frame.getRootPane(), (int)size2, (int)size2, (int)2);
                    Graphics2D g = image2.createGraphics();
                    int shadowRadius = 16;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setPaint(errorBadgeShadowColor);
                    g.fillRoundRect(0, 0, shadowRadius, shadowRadius, size2, size2);
                    int mainRadius = 14;
                    g.setPaint(errorBadgeMainColor);
                    g.fillRoundRect(size2 / 2 - mainRadius / 2, size2 / 2 - mainRadius / 2, mainRadius, mainRadius, size2, size2);
                    Font font = g.getFont();
                    g.setFont(new Font(font.getName(), 1, 9));
                    FontMetrics fontMetrics = g.getFontMetrics();
                    int textWidth = fontMetrics.stringWidth(text2);
                    int textHeight = UIUtil.getHighestGlyphHeight((String)text2, (Font)font, (Graphics)g);
                    g.setPaint(errorBadgeTextBackgroundColor);
                    g.fillOval(size2 / 2 - textWidth / 2, size2 / 2 - textHeight / 2, textWidth, textHeight);
                    g.setColor(Color.white);
                    g.drawString(text2, size2 / 2 - textWidth / 2, size2 / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
                    byte[] bytes = Win7AppIcon.writeTransparentIco(image2);
                    icon2 = Win7TaskBar.createIcon(bytes);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon2, icon2 != null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void _setOkBadge(@Nullable JFrame frame, boolean visible) {
            EDT.assertIsEdt();
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            WinDef.HICON icon2 = null;
            if (visible) {
                Class<Win7AppIcon> clazz = Win7AppIcon.class;
                // MONITORENTER : com.intellij.ui.AppIcon$Win7AppIcon.class
                if (this.myOkIcon == null) {
                    try {
                        BufferedImage image2 = ImageIO.read(Objects.requireNonNull(AppIcon.class.getResourceAsStream("/mac/appIconOk512.png")));
                        byte[] bytes = Win7AppIcon.writeTransparentIco(image2);
                        this.myOkIcon = Win7TaskBar.createIcon(bytes);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        this.myOkIcon = null;
                    }
                }
                icon2 = this.myOkIcon;
                // MONITOREXIT : clazz
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon2, false);
                return;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void _requestAttention(@Nullable JFrame frame, boolean critical) {
            EDT.assertIsEdt();
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.attention(frame);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void requestFocus(@Nullable Window window) {
            if (window != null) {
                if (window instanceof Frame) {
                    ((Frame)window).setState(0);
                }
                try {
                    Thread.sleep(Registry.intValue((String)"win.request.focus.delay.ms"));
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                Win7TaskBar.setForegroundWindow(window);
            }
        }

        private static boolean isValid(@Nullable JFrame frame) {
            return frame != null && frame.isDisplayable();
        }
    }

    private static abstract class BaseIcon
    extends AppIcon {
        private ApplicationActivationListener myAppListener;
        protected Object myCurrentProcessId;
        protected double myLastValue;

        private BaseIcon() {
        }

        @Override
        public final boolean setProgress(Project project2, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            if (!this.isAppActive() && AppIcon.isProgressAppIconEnabled() && (this.myCurrentProcessId == null || this.myCurrentProcessId.equals(processId))) {
                return this._setProgress(BaseIcon.getIdeFrame(project2), processId, scheme, value, isOk);
            }
            return false;
        }

        @Override
        public final boolean hideProgress(Project project2, Object processId) {
            if (AppIcon.isProgressAppIconEnabled()) {
                return this._hideProgress(BaseIcon.getIdeFrame(project2), processId);
            }
            return false;
        }

        @Override
        public final void setErrorBadge(Project project2, String text2) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setOkBadge(BaseIcon.getIdeFrame(project2), false);
                this._setTextBadge(BaseIcon.getIdeFrame(project2), text2);
            }
        }

        @Override
        public final void setOkBadge(@Nullable Project project2, boolean visible) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setTextBadge(BaseIcon.getIdeFrame(project2), null);
                this._setOkBadge(BaseIcon.getIdeFrame(project2), visible);
            }
        }

        @Override
        public final void requestAttention(@Nullable Project project2, boolean critical) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.requestAttention")) {
                this._requestAttention(BaseIcon.getIdeFrame(project2), critical);
            }
        }

        public abstract boolean _setProgress(@Nullable JFrame var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

        public abstract boolean _hideProgress(@Nullable JFrame var1, Object var2);

        public abstract void _setTextBadge(@Nullable JFrame var1, String var2);

        public abstract void _setOkBadge(@Nullable JFrame var1, boolean var2);

        public abstract void _requestAttention(@Nullable JFrame var1, boolean var2);

        @Nullable
        private static JFrame getIdeFrame(@Nullable Project project2) {
            return WindowManager.getInstance().getFrame(project2);
        }

        private boolean isAppActive() {
            Application app = ApplicationManager.getApplication();
            if (app == null || this.myAppListener != null) {
                return app != null && app.isActive();
            }
            this.myAppListener = new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    JFrame frame = ideFrame instanceof JFrame ? (JFrame)ideFrame : ((ProjectFrameHelper)ideFrame).getFrame();
                    if (AppIcon.isProgressAppIconEnabled()) {
                        this._hideProgress(frame, myCurrentProcessId);
                    }
                    this._setOkBadge(frame, false);
                    this._setTextBadge(frame, null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ui/AppIcon$BaseIcon$1", "applicationActivated"));
                }
            };
            app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
            return app.isActive();
        }
    }
}

