/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextFieldRendererDocument;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorTextFieldCellRenderer
implements TableCellRenderer,
Disposable {
    private static final Key<SimpleRendererComponent> MY_PANEL_PROPERTY = Key.create((String)"EditorTextFieldCellRenderer.MyEditorPanel");
    private final Project myProject;
    private final Language myLanguage;
    private final boolean myInheritFontFromLaF;

    @Deprecated(forRemoval=true)
    protected EditorTextFieldCellRenderer(@Nullable Project project2, @Nullable FileType fileType2, @NotNull Disposable parent) {
        if (parent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(0);
        }
        this(project2, fileType2 == null ? null : LanguageUtil.getFileTypeLanguage((FileType)fileType2), true, parent);
    }

    protected EditorTextFieldCellRenderer(@Nullable Project project2, @Nullable Language language, @NotNull Disposable parent) {
        if (parent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(1);
        }
        this(project2, language, true, parent);
    }

    private EditorTextFieldCellRenderer(@Nullable Project project2, @Nullable Language language, boolean inheritFontFromLaF, @NotNull Disposable parent) {
        if (parent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myLanguage = language;
        this.myInheritFontFromLaF = inheritFontFromLaF;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    protected abstract String getText(JTable var1, Object var2, int var3, int var4);

    @Nullable
    protected TextAttributes getTextAttributes(JTable table2, Object value, int row2, int column) {
        return null;
    }

    @NotNull
    protected EditorColorsScheme getColorScheme(JTable table2) {
        EditorColorsScheme editorColorsScheme = this.getEditorPanel(table2).getEditor().getColorsScheme();
        if (editorColorsScheme == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(3);
        }
        return editorColorsScheme;
    }

    protected void customizeEditor(@NotNull EditorEx editor2, JTable table2, Object value, boolean selected, int row2, int column) {
        if (editor2 == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(4);
        }
        String text2 = this.getText(table2, value, row2, column);
        this.getEditorPanel(table2).setText(text2, this.getTextAttributes(table2, value, row2, column), selected);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean selected, boolean focused, int row2, int column) {
        RendererComponent panel2 = this.getEditorPanel(table2);
        EditorEx editor2 = panel2.getEditor();
        editor2.getColorsScheme().setEditorFontSize(table2.getFont().getSize());
        editor2.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, table2.getSelectionBackground());
        editor2.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, table2.getSelectionForeground());
        editor2.setBackgroundColor(selected ? table2.getSelectionBackground() : table2.getBackground());
        panel2.setSelected(!Comparing.equal((Object)editor2.getBackgroundColor(), (Object)table2.getBackground()));
        panel2.setBorder(null);
        this.customizeEditor(editor2, table2, value, selected, row2, column);
        return panel2;
    }

    @NotNull
    private RendererComponent getEditorPanel(JTable table2) {
        RendererComponent panel2 = (RendererComponent)((Object)ComponentUtil.getClientProperty((JComponent)table2, MY_PANEL_PROPERTY));
        if (panel2 != null) {
            DelegateColorScheme scheme = (DelegateColorScheme)panel2.getEditor().getColorsScheme();
            scheme.setDelegate(EditorColorsUtil.getGlobalOrDefaultColorScheme());
            RendererComponent rendererComponent = panel2;
            if (rendererComponent == null) {
                EditorTextFieldCellRenderer.$$$reportNull$$$0(5);
            }
            return rendererComponent;
        }
        panel2 = this.createRendererComponent(this.myProject, this.myLanguage, this.myInheritFontFromLaF);
        Disposer.register((Disposable)this, (Disposable)panel2);
        Disposer.register((Disposable)this, () -> ComponentUtil.putClientProperty((JComponent)table2, MY_PANEL_PROPERTY, null));
        table2.putClientProperty(MY_PANEL_PROPERTY, (Object)panel2);
        RendererComponent rendererComponent = panel2;
        if (rendererComponent == null) {
            EditorTextFieldCellRenderer.$$$reportNull$$$0(6);
        }
        return rendererComponent;
    }

    @NotNull
    protected RendererComponent createRendererComponent(@Nullable Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
        return new AbbreviatingRendererComponent(project2, language, inheritFontFromLaF);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorTextFieldCellRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorTextFieldCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static abstract class RendererComponent
    extends CellRendererPanel
    implements Disposable {
        private final EditorEx myEditor;
        TextAttributes myTextAttributes;
        private boolean mySelected;

        RendererComponent(@Nullable Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
            this.myEditor = RendererComponent.createEditor(project2, language, inheritFontFromLaF);
            this.addEditorToSelf(this.myEditor);
            if (!UIUtil.isAncestor((Component)((Object)this), (Component)this.myEditor.getContentComponent())) {
                throw new AssertionError((Object)"Editor component is not added in `addEditorToSelf`");
            }
        }

        public EditorEx getEditor() {
            return this.myEditor;
        }

        @NotNull
        private static EditorEx createEditor(Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
            Language adjustedLanguage = language != null ? language : PlainTextLanguage.INSTANCE;
            EditorTextFieldRendererDocument document2 = new EditorTextFieldRendererDocument();
            EditorEx editor2 = (EditorEx)EditorFactory.getInstance().createViewer((Document)document2, project2);
            editor2.putUserData(EditorTextField.SUPPLEMENTARY_KEY, true);
            EditorSettings settings = editor2.getSettings();
            EditorTextField.setupTextFieldEditor(editor2);
            editor2.setRendererMode(true);
            editor2.getScrollPane().setBorder(null);
            settings.setCaretRowShown(false);
            settings.setAnimatedScrolling(false);
            if (project2 != null) {
                EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
                LightVirtualFile virtualFile = new LightVirtualFile("_", adjustedLanguage, (CharSequence)"");
                EditorHighlighter highlighter = highlighterFactory.createEditorHighlighter(project2, (VirtualFile)virtualFile);
                editor2.setHighlighter(highlighter);
            }
            EditorColorsScheme colorsScheme = editor2.getColorsScheme();
            editor2.setBackgroundColor(StartupUiUtil.isUnderDarcula() ? UIUtil.getTextFieldBackground() : colorsScheme.getDefaultBackground());
            if (inheritFontFromLaF) {
                ((EditorImpl)editor2).setUseEditorAntialiasing(false);
                Font font = StartupUiUtil.getLabelFont();
                colorsScheme.setEditorFontName(font.getFontName());
                colorsScheme.setEditorFontSize(font.getSize());
            } else {
                UISettings uiSettings = UISettings.getInstance();
                if (uiSettings.getPresentationMode()) {
                    editor2.setFontSize(UISettingsUtils.with((UISettings)uiSettings).getPresentationModeFontSize());
                }
            }
            EditorEx editorEx = editor2;
            if (editorEx == null) {
                RendererComponent.$$$reportNull$$$0(0);
            }
            return editorEx;
        }

        public void setText(String text2, @Nullable TextAttributes textAttributes, boolean selected) {
            this.myTextAttributes = textAttributes;
            this.mySelected = selected;
            this.setText(text2);
        }

        public abstract void setText(String var1);

        public void setBackground(Color bg) {
            if (this.myEditor != null) {
                this.myEditor.setBackgroundColor(bg);
            }
            super.setBackground(bg);
        }

        public void dispose() {
            this.removeAll();
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }

        void addEditorToSelf(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                RendererComponent.$$$reportNull$$$0(1);
            }
            this.add(editor2.getContentComponent());
        }

        void setTextToEditor(String text2) {
            EditorImpl editor2 = (EditorImpl)this.myEditor;
            editor2.getMarkupModel().removeAllHighlighters();
            editor2.getDocument().setText((CharSequence)text2);
            editor2.resetSizes();
            editor2.getHighlighter().setText((CharSequence)text2);
            if (this.myTextAttributes != null) {
                editor2.getMarkupModel().addRangeHighlighter(0, editor2.getDocument().getTextLength(), 3000, this.myTextAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            editor2.setPaintSelection(this.mySelected);
            SelectionModelImpl selectionModel = editor2.getSelectionModel();
            selectionModel.setSelection(0, this.mySelected ? editor2.getDocument().getTextLength() : 0);
            editor2.getCaretModel().updateVisualPosition();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorTextFieldCellRenderer$RendererComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorTextFieldCellRenderer$RendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorToSelf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class AbbreviatingRendererComponent
    extends RendererComponent {
        private static final char ABBREVIATION_SUFFIX = '\u2026';
        private static final char RETURN_SYMBOL = '\u23ce';
        private final StringBuilder myDocumentTextBuilder = new StringBuilder();
        private boolean myAppendEllipsis;
        private final char myReturnSymbol;
        private boolean myForceSingleLine;
        private Dimension myPreferredSize;
        @NlsSafe
        private String myRawText;

        public AbbreviatingRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
            this(project2, language, inheritFontFromLaF, true);
        }

        public AbbreviatingRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF, boolean appendEllipsis) {
            this(project2, language, inheritFontFromLaF, appendEllipsis, false);
        }

        public AbbreviatingRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF, boolean appendEllipsis, boolean forceSingleLine) {
            this(project2, language, inheritFontFromLaF, appendEllipsis, forceSingleLine, '\u23ce');
        }

        public AbbreviatingRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF, boolean appendEllipsis, boolean forceSingleLine, char returnSymbol) {
            super(project2, language, inheritFontFromLaF);
            this.myAppendEllipsis = appendEllipsis;
            this.myReturnSymbol = returnSymbol;
            this.myForceSingleLine = forceSingleLine;
        }

        @Override
        public void setText(String text2) {
            this.myRawText = text2;
            this.myPreferredSize = null;
        }

        public void setForceSingleLine(boolean forceSingleLine) {
            this.myForceSingleLine = forceSingleLine;
            this.myPreferredSize = null;
        }

        public void setAppendEllipsis(boolean appendEllipsis) {
            this.myAppendEllipsis = appendEllipsis;
        }

        public Dimension getPreferredSize() {
            if (this.myPreferredSize == null) {
                int preferredWidth;
                int preferredHeight;
                int maxLineLength = 0;
                int linesCount = 0;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                while (!lt.atEnd()) {
                    maxLineLength = Math.max(maxLineLength, lt.getLength());
                    ++linesCount;
                    lt.advance();
                }
                FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
                if (this.myForceSingleLine) {
                    preferredHeight = this.getEditor().getLineHeight();
                    preferredWidth = fontMetrics.charWidth('m') * this.myRawText.length();
                } else {
                    preferredHeight = this.getEditor().getLineHeight() * Math.max(1, linesCount);
                    preferredWidth = fontMetrics.charWidth('m') * maxLineLength;
                }
                Insets insets = this.getInsets();
                if (insets != null) {
                    preferredHeight += insets.top + insets.bottom;
                    preferredWidth += insets.left + insets.right;
                }
                this.myPreferredSize = new Dimension(preferredWidth, preferredHeight);
            }
            return this.myPreferredSize;
        }

        protected void paintChildren(Graphics g) {
            ReadAction.run(() -> {
                this.updateText(g.getClipBounds());
                super.paintChildren(g);
            });
        }

        private void updateText(Rectangle clip) {
            boolean singleLineMode;
            FontMetrics fontMetrics = ((EditorImpl)this.getEditor()).getFontMetrics(this.myTextAttributes != null ? this.myTextAttributes.getFontType() : 0);
            Insets insets = this.getInsets();
            int maxLineWidth = this.getWidth() - (insets != null ? insets.left + insets.right : 0);
            this.myDocumentTextBuilder.setLength(0);
            boolean bl = singleLineMode = this.myForceSingleLine || (float)this.getHeight() / (float)this.getEditor().getLineHeight() < 1.5f;
            if (singleLineMode) {
                AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, 0, this.myRawText.length(), fontMetrics, maxLineWidth, true, this.myAppendEllipsis, this.myReturnSymbol);
            } else {
                int line;
                int lineHeight = this.getEditor().getLineHeight();
                int firstVisibleLine = clip.y / lineHeight;
                float visibleLinesCountFractional = (float)clip.height / (float)lineHeight;
                int linesToAppend = 1 + (int)visibleLinesCountFractional;
                LineTokenizer lt = new LineTokenizer((CharSequence)this.myRawText);
                for (line = 0; !lt.atEnd() && line < firstVisibleLine; ++line) {
                    this.myDocumentTextBuilder.append('\n');
                    lt.advance();
                }
                for (line = 0; !lt.atEnd() && line < linesToAppend; ++line) {
                    int start2 = lt.getOffset();
                    int end = start2 + lt.getLength();
                    AbbreviatingRendererComponent.appendAbbreviated(this.myDocumentTextBuilder, this.myRawText, start2, end, fontMetrics, maxLineWidth, false, this.myAppendEllipsis, this.myReturnSymbol);
                    if (lt.getLineSeparatorLength() > 0) {
                        this.myDocumentTextBuilder.append('\n');
                    }
                    lt.advance();
                }
            }
            this.setTextToEditor(this.myDocumentTextBuilder.toString());
        }

        private static void appendAbbreviated(StringBuilder to, String text2, int start2, int end, FontMetrics metrics, int maxWidth, boolean replaceLineTerminators, boolean appendEllipsis, char returnSymbol) {
            int abbreviationLength = AbbreviatingRendererComponent.abbreviationLength(text2, start2, end, metrics, maxWidth, replaceLineTerminators, appendEllipsis, returnSymbol);
            if (!replaceLineTerminators) {
                to.append(text2, start2, start2 + abbreviationLength);
            } else {
                CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text2, start2, start2 + abbreviationLength);
                LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
                while (!lt.atEnd()) {
                    to.append((CharSequence)subSeq, lt.getOffset(), lt.getOffset() + lt.getLength());
                    if (lt.getLineSeparatorLength() > 0) {
                        to.append(returnSymbol);
                    }
                    lt.advance();
                }
            }
            if (appendEllipsis && abbreviationLength != end - start2) {
                to.append('\u2026');
            }
        }

        private static int abbreviationLength(String text2, int start2, int end, FontMetrics metrics, int maxWidth, boolean replaceSeparators, boolean appendEllipsis, char returnSymbol) {
            if (metrics.charWidth('m') * (end - start2) <= maxWidth) {
                return end - start2;
            }
            int abbrWidth = appendEllipsis ? metrics.charWidth('\u2026') : 0;
            int abbrLength = 0;
            CharSequenceSubSequence subSeq = new CharSequenceSubSequence((CharSequence)text2, start2, end);
            LineTokenizer lt = new LineTokenizer((CharSequence)subSeq);
            while (!lt.atEnd()) {
                int i2 = 0;
                while (i2 < lt.getLength()) {
                    if ((abbrWidth += metrics.charWidth(subSeq.charAt(lt.getOffset() + i2))) >= maxWidth) {
                        return abbrLength;
                    }
                    ++i2;
                    ++abbrLength;
                }
                if (replaceSeparators && lt.getLineSeparatorLength() != 0) {
                    if ((abbrWidth += metrics.charWidth(returnSymbol)) >= maxWidth) {
                        return abbrLength;
                    }
                    abbrLength += lt.getLineSeparatorLength();
                }
                lt.advance();
            }
            return abbrLength;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleContextDelegate(super.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }

                    public String getAccessibleName() {
                        return myRawText;
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    public static class SimpleWithGutterRendererComponent
    extends SimpleRendererComponent {
        public SimpleWithGutterRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
            super(project2, language, inheritFontFromLaF);
        }

        @Override
        void addEditorToSelf(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                SimpleWithGutterRendererComponent.$$$reportNull$$$0(0);
            }
            this.add(editor2.getComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorTextFieldCellRenderer$SimpleWithGutterRendererComponent", "addEditorToSelf"));
        }
    }

    public static class SimpleRendererComponent
    extends RendererComponent {
        public SimpleRendererComponent(Project project2, @Nullable Language language, boolean inheritFontFromLaF) {
            super(project2, language, inheritFontFromLaF);
        }

        @Override
        public void setText(String text2) {
            this.setTextToEditor(text2);
        }
    }
}

