/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibNotifyWrapper
implements SystemNotificationsImpl.Notifier {
    private static LibNotifyWrapper ourInstance;
    private final LibNotify myLibNotify;
    private final String myIcon;
    private final Object myLock = new Object();
    private boolean myDisposed = false;

    @Nullable
    static synchronized LibNotifyWrapper getInstance() {
        if (ourInstance == null && JnaLoader.isLoaded()) {
            ourInstance = new LibNotifyWrapper();
        }
        return ourInstance;
    }

    private LibNotifyWrapper() {
        this.myLibNotify = (LibNotify)Native.load((String)"libnotify.so.4", LibNotify.class);
        String appName = ApplicationNamesInfo.getInstance().getProductName();
        if (this.myLibNotify.notify_init(appName) == 0) {
            throw new IllegalStateException("notify_init failed");
        }
        String icon2 = AppUIUtilKt.findAppIcon();
        this.myIcon = icon2 != null ? icon2 : "dialog-information";
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void appClosing() {
                Object object = LibNotifyWrapper.this.myLock;
                synchronized (object) {
                    LibNotifyWrapper.this.myDisposed = true;
                    LibNotifyWrapper.this.myLibNotify.notify_uninit();
                }
            }
        });
    }

    @Override
    public void notify(@NotNull String name2, @NotNull String title2, @NotNull String description) {
        if (name2 == null) {
            LibNotifyWrapper.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            LibNotifyWrapper.$$$reportNull$$$0(1);
        }
        if (description == null) {
            LibNotifyWrapper.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myDisposed) {
                    Pointer notification2 = this.myLibNotify.notify_notification_new(title2, description, this.myIcon);
                    this.myLibNotify.notify_notification_show(notification2, null);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/LibNotifyWrapper";
        objectArray[2] = "notify";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface LibNotify
    extends Library {
        public int notify_init(String var1);

        public void notify_uninit();

        public Pointer notify_notification_new(String var1, String var2, String var3);

        public int notify_notification_show(Pointer var1, Pointer var2);
    }
}

