/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.drag;

import com.intellij.ui.drag.DialogWithImage;
import com.intellij.ui.drag.DragImageView;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDialog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lcom/intellij/ui/drag/DialogDragImageView;", "Lcom/intellij/ui/drag/DragImageView;", "dialog", "Ljavax/swing/JDialog;", "<init>", "(Ljavax/swing/JDialog;)V", "value", "Ljava/awt/Point;", "location", "getLocation", "()Ljava/awt/Point;", "setLocation", "(Ljava/awt/Point;)V", "bounds", "Ljava/awt/Rectangle;", "getBounds", "()Ljava/awt/Rectangle;", "size", "Ljava/awt/Dimension;", "getSize", "()Ljava/awt/Dimension;", "preferredSize", "getPreferredSize", "Ljava/awt/Image;", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "show", "", "hide", "intellij.platform.ide.impl"})
public final class DialogDragImageView
implements DragImageView {
    @NotNull
    private final JDialog dialog;

    public DialogDragImageView(@NotNull JDialog dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialog2, (String)"dialog");
        this.dialog = dialog2;
    }

    @Override
    @NotNull
    public Point getLocation() {
        Point point = this.dialog.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
        return point;
    }

    @Override
    public void setLocation(@NotNull Point value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Dimension originalDialogSize = this.getPreferredSize();
        Rectangle newDialogScreenBounds = new Rectangle(value, originalDialogSize);
        this.dialog.setBounds(newDialogScreenBounds);
        if (!Intrinsics.areEqual((Object)this.dialog.getBounds(), (Object)newDialogScreenBounds)) {
            this.dialog.setSize(originalDialogSize);
        }
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        Rectangle rectangle = this.dialog.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        return rectangle;
    }

    @Override
    @NotNull
    public Dimension getSize() {
        Dimension dimension = this.dialog.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.dialog.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    @Nullable
    public Image getImage() {
        JDialog jDialog = this.dialog;
        DialogWithImage dialogWithImage = jDialog instanceof DialogWithImage ? (DialogWithImage)((Object)jDialog) : null;
        return dialogWithImage != null ? dialogWithImage.getImage() : null;
    }

    @Override
    public void setImage(@Nullable Image value) {
        block0: {
            JDialog jDialog = this.dialog;
            DialogWithImage dialogWithImage = jDialog instanceof DialogWithImage ? (DialogWithImage)((Object)jDialog) : null;
            if (dialogWithImage == null) break block0;
            dialogWithImage.setImage(value);
        }
    }

    @Override
    public void show() {
        this.dialog.setVisible(true);
    }

    @Override
    public void hide() {
        this.dialog.dispose();
    }
}

