/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.HyperlinkEventAction;
import com.intellij.ui.dsl.builder.IconsProvider;
import com.intellij.ui.dsl.builder.components.DslLabelKt;
import com.intellij.ui.dsl.builder.components.DslLabelType;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0014\u0010'\u001a\u00020 2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010)\u001a\u00020\u000fH\u0002J\b\u0010*\u001a\u00020 H\u0002J\u0012\u0010+\u001a\u00020\u001b2\b\b\u0001\u0010,\u001a\u00020\u001bH\u0003J\b\u0010-\u001a\u00020 H\u0002J\b\u0010.\u001a\u00020\u001bH\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u001bH\u0002R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00064"}, d2={"Lcom/intellij/ui/dsl/builder/components/DslLabel;", "Ljavax/swing/JEditorPane;", "type", "Lcom/intellij/ui/dsl/builder/components/DslLabelType;", "<init>", "(Lcom/intellij/ui/dsl/builder/components/DslLabelType;)V", "getType", "()Lcom/intellij/ui/dsl/builder/components/DslLabelType;", "action", "Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "getAction", "()Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;", "setAction", "(Lcom/intellij/ui/dsl/builder/HyperlinkEventAction;)V", "value", "", "maxLineLength", "getMaxLineLength", "()I", "setMaxLineLength", "(I)V", "limitPreferredSize", "", "getLimitPreferredSize", "()Z", "setLimitPreferredSize", "(Z)V", "", "userText", "getUserText", "()Ljava/lang/String;", "updateUI", "", "getBaseline", "width", "height", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "setText", "t", "getPreferredColumnsWordWrap", "updateEditorPaneText", "appendExternalLinkIcons", "text", "patchFont", "createCss", "getSupposedWidth", "charCount", "existingIconsProvider", "Ljavax/swing/Icon;", "key", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class DslLabel
extends JEditorPane {
    @ApiStatus.Internal
    @NotNull
    private final DslLabelType type;
    @Nullable
    private HyperlinkEventAction action;
    private int maxLineLength;
    private boolean limitPreferredSize;
    @ApiStatus.Internal
    @Nls
    @Nullable
    private String userText;

    public DslLabel(@NotNull DslLabelType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.maxLineLength = Integer.MAX_VALUE;
        this.setContentType("text/html");
        Function2[] function2Array = new Function2[]{ExtendableHTMLViewFactory.Extensions.WORD_WRAP, ExtendableHTMLViewFactory.Extensions.icons((Function1)((Function1)new Function1<String, Icon>((Object)this){

            public final Icon invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DslLabel)this.receiver).existingIconsProvider(p0);
            }
        }))};
        this.setEditorKit(new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).build());
        this.putClientProperty("caretWidth", 0);
        this.setForeground(switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> JBUI.CurrentTheme.ContextHelp.FOREGROUND;
            case 2 -> JBUI.CurrentTheme.Label.foreground();
            default -> throw new NoWhenBranchMatchedException();
        });
        this.addHyperlinkListener(arg_0 -> DslLabel._init_$lambda$0(this, arg_0));
        this.patchFont();
    }

    @NotNull
    public final DslLabelType getType() {
        return this.type;
    }

    @Nullable
    public final HyperlinkEventAction getAction() {
        return this.action;
    }

    public final void setAction(@Nullable HyperlinkEventAction hyperlinkEventAction) {
        this.action = hyperlinkEventAction;
    }

    public final int getMaxLineLength() {
        return this.maxLineLength;
    }

    public final void setMaxLineLength(int value) {
        this.maxLineLength = value;
        this.updateEditorPaneText();
    }

    public final boolean getLimitPreferredSize() {
        return this.limitPreferredSize;
    }

    public final void setLimitPreferredSize(boolean bl) {
        this.limitPreferredSize = bl;
    }

    @Nullable
    public final String getUserText() {
        return this.userText;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        this.setDisabledTextColor(JBUI.CurrentTheme.Label.disabledForeground());
        Caret caret = this.getCaret();
        Intrinsics.checkNotNull((Object)caret, (String)"null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        ((DefaultCaret)caret).setUpdatePolicy(1);
        this.patchFont();
        this.updateEditorPaneText();
    }

    @Override
    public int getBaseline(int width, int height) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.getAscent();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension result2 = super.getMinimumSize();
        if (this.maxLineLength == -1 && this.limitPreferredSize) {
            dimension = new Dimension(Math.min(this.getSupposedWidth(35), result2.width), result2.height);
        } else {
            Intrinsics.checkNotNull((Object)result2);
            dimension = result2;
        }
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension result2 = super.getPreferredSize();
        if (this.maxLineLength == -1 && this.limitPreferredSize) {
            dimension = new Dimension(Math.min(this.getSupposedWidth(this.getPreferredColumnsWordWrap()), result2.width), result2.height);
        } else {
            Intrinsics.checkNotNull((Object)result2);
            dimension = result2;
        }
        return dimension;
    }

    @Override
    public void setText(@Nls @Nullable String t) {
        this.userText = t;
        this.updateEditorPaneText();
    }

    private final int getPreferredColumnsWordWrap() {
        Integer n = (Integer)this.getClientProperty((Object)DslComponentPropertyInternal.PREFERRED_COLUMNS_LABEL_WORD_WRAP);
        return n != null ? n : 70;
    }

    private final void updateEditorPaneText() {
        String text2 = this.userText;
        if (text2 == null) {
            super.setText(null);
            return;
        }
        for (Map.Entry entry : DslLabelKt.access$getDENIED_TAGS$p().entrySet()) {
            Regex regex = (Regex)entry.getKey();
            String reason = (String)entry.getValue();
            if (regex.find((CharSequence)text2, 0) == null) continue;
            UiDslException.Companion.error("Invalid html: " + reason + ", text: " + text2);
        }
        String processedText = StringsKt.replace((String)text2, (String)"<a>", (String)"<a href=''>", (boolean)true);
        processedText = this.appendExternalLinkIcons(processedText);
        HtmlChunk.Element element = HtmlChunk.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        HtmlChunk.Element body = element;
        if (this.maxLineLength > 0 && this.maxLineLength != Integer.MAX_VALUE && text2.length() > this.maxLineLength) {
            HtmlChunk.Element element2 = body.attr("width", this.getSupposedWidth(this.maxLineLength));
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"attr(...)");
            body = element2;
        }
        String css = this.createCss();
        super.setText(new HtmlBuilder().append(HtmlChunk.raw((String)css)).append((HtmlChunk)HtmlChunk.raw((String)processedText).wrapWith(body)).wrapWith(HtmlChunk.html()).toString());
        this.setSize(new Dimension(0, 0));
    }

    @Nls
    private final String appendExternalLinkIcons(@Nls String text2) {
        Sequence matchers = Regex.findAll$default((Regex)DslLabelKt.access$getBROWSER_LINK_REGEX$p(), (CharSequence)text2, (int)0, (int)2, null);
        if (!SequencesKt.any((Sequence)matchers)) {
            return text2;
        }
        StringBuilder result2 = new StringBuilder();
        String string = DocumentationMarkup.EXTERNAL_LINK_ICON.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String externalLink = string;
        int i2 = 0;
        for (MatchResult matcher : matchers) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matcher.getGroups(), (String)"link");
            Intrinsics.checkNotNull((Object)matchGroup);
            int linkEnd = matchGroup.getRange().getLast();
            result2.append(StringsKt.substring((String)text2, (IntRange)new IntRange(i2, linkEnd)));
            result2.append(externalLink);
            i2 = linkEnd + 1;
        }
        String string2 = text2.substring(i2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        result2.append(string2);
        String string3 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private final void patchFont() {
        if (this.type == DslLabelType.COMMENT) {
            this.setFont(ComponentPanelBuilder.getCommentFont((Font)this.getFont()));
        }
    }

    private final String createCss() {
        Object[] objectArray = new String[]{"a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}", "a:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}", "a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}", "a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}"};
        List styles = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.maxLineLength == Integer.MAX_VALUE) {
            styles.add("body, p {white-space:nowrap;}");
        }
        return CollectionsKt.joinToString$default((Iterable)styles, (CharSequence)" ", (CharSequence)"<head><style type='text/css'>", (CharSequence)"</style></head>", (int)0, null, null, (int)56, null);
    }

    private final int getSupposedWidth(int charCount) {
        return this.getFontMetrics(this.getFont()).charWidth('0') * charCount;
    }

    private final Icon existingIconsProvider(String key) {
        IconsProvider iconsProvider;
        IconsProvider iconsProvider2 = iconsProvider = (IconsProvider)this.getClientProperty(DslComponentProperty.ICONS_PROVIDER);
        return iconsProvider2 != null ? iconsProvider2.getIcon(key) : null;
    }

    private static final void _init_$lambda$0(DslLabel this$0, HyperlinkEvent e) {
        block2: {
            HyperlinkEvent.EventType eventType;
            block3: {
                block1: {
                    HyperlinkEvent hyperlinkEvent = e;
                    HyperlinkEvent.EventType eventType2 = eventType = hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null;
                    if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ACTIVATED)) break block1;
                    HyperlinkEventAction hyperlinkEventAction = this$0.action;
                    if (hyperlinkEventAction == null) break block2;
                    hyperlinkEventAction.hyperlinkActivated(e);
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.ENTERED)) break block3;
                HyperlinkEventAction hyperlinkEventAction = this$0.action;
                if (hyperlinkEventAction == null) break block2;
                hyperlinkEventAction.hyperlinkEntered(e);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)eventType, (Object)HyperlinkEvent.EventType.EXITED)) break block2;
            HyperlinkEventAction hyperlinkEventAction = this$0.action;
            if (hyperlinkEventAction != null) {
                hyperlinkEventAction.hyperlinkExited(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DslLabelType.values().length];
            try {
                nArray[DslLabelType.COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DslLabelType.LABEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

