/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontOptionsModel;
import com.intellij.application.options.colors.ColorAndFontOptionsModelListener;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.FontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.application.options.colors.RainbowColorsInSchemeState;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.SchemesPanelFactory;
import com.intellij.application.options.colors.ScopeAttributesUtil;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.ide.actions.QuickChangeColorSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoKt;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.ConfigurablesListPanelKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyValidationManagerImpl;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontOptions
extends SearchableConfigurable.Parent.Abstract
implements EditorOptionsProvider,
SchemesModel<EditorColorsScheme>,
Configurable.WithEpDependencies,
Configurable.NoScroll,
Configurable.NoMargin {
    private static final Logger LOG = Logger.getInstance(ColorAndFontOptions.class);
    public static final String ID = "reference.settingsdialog.IDE.editor.colors";
    private final ColorAndFontOptionsModel myModel = ColorAndFontOptionsModel.getInstance();
    ColorAndFontOptionsModelListener modelListener = new ColorAndFontOptionsModelListener(){

        @Override
        public void onChanged() {
            if (ColorAndFontOptions.this.myInitResetCompleted) {
                ColorAndFontOptions.this.resetSchemesCombo(ColorAndFontOptions.this.myModel);
            }
        }
    };
    private boolean mySomeSchemesDeleted = false;
    private Map<ColorAndFontPanelFactory, InnerSearchableConfigurable> mySubPanelFactories;
    private SchemesPanelFactory mySchemesPanelFactory;
    private SchemesPanel myRootSchemesPanel;
    private boolean myInitResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertChangesCompleted = false;
    private boolean myApplyCompleted = false;
    private boolean myDisposeCompleted = false;
    private final Disposable myDisposable = Disposer.newDisposable();
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private MessageBusConnection myEditorColorSchemeConnection;
    private boolean myShouldChangeLafIfNecessary = true;
    private boolean myIsReset = false;

    public ColorAndFontOptions() {
        this.myModel.addListener(this.modelListener);
    }

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(0);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void stateChanged() {
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean listModified = this.isSchemeListModified();
        boolean schemeModified = this.isSomeSchemeModified();
        if (listModified || schemeModified) {
            this.myApplyCompleted = false;
        }
        return listModified;
    }

    private Iterable<MyColorScheme> getMySchemes() {
        return this.myModel.allSchemes().stream().filter(scheme -> scheme instanceof MyColorScheme).map(scheme -> (MyColorScheme)((Object)scheme)).toList();
    }

    @Nullable
    private MyColorScheme getMyScheme(@NotNull String name2) {
        EditorColorsScheme scheme;
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(1);
        }
        if ((scheme = this.myModel.getScheme(name2)) instanceof MyColorScheme) {
            return (MyColorScheme)scheme;
        }
        return null;
    }

    private MyColorScheme getMySelectedScheme() {
        EditorColorsScheme scheme = this.myModel.getSelectedScheme();
        if (scheme instanceof MyColorScheme) {
            return (MyColorScheme)scheme;
        }
        return null;
    }

    private boolean isSchemeListModified() {
        if (this.mySomeSchemesDeleted) {
            return true;
        }
        EditorColorsScheme selectedScheme = this.myModel.getSelectedScheme();
        if (selectedScheme == null || !selectedScheme.getName().equals(EditorColorsManager.getInstance().getGlobalScheme().getName())) {
            return true;
        }
        for (MyColorScheme scheme : this.getMySchemes()) {
            if (!scheme.isNew()) continue;
            return true;
        }
        return false;
    }

    private boolean isSomeSchemeModified() {
        for (MyColorScheme scheme : this.getMySchemes()) {
            if (!scheme.isModified()) continue;
            return true;
        }
        return false;
    }

    public EditorColorsScheme selectScheme(@NotNull String name2) {
        MyColorScheme schemeToSelect;
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(2);
        }
        if ((schemeToSelect = this.getMyScheme(name2)) != null) {
            this.myModel.setSelectedScheme((EditorColorsScheme)schemeToSelect, this);
        } else {
            LOG.warn("Scheme " + name2 + " can not be selected. Schemes: " + String.valueOf(this.myModel.schemesKeySet()));
        }
        return this.myModel.getSelectedScheme();
    }

    public EditorColorsScheme getSelectedScheme() {
        return this.myModel.getSelectedScheme();
    }

    public EditorSchemeAttributeDescriptor[] getCurrentDescriptions() {
        MyColorScheme selectedScheme = this.getMySelectedScheme();
        if (selectedScheme != null) {
            return selectedScheme.getDescriptors();
        }
        return new EditorSchemeAttributeDescriptor[0];
    }

    @Override
    public boolean canDuplicateScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(4);
        }
        AbstractColorsScheme originalScheme = scheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme).getOriginal() : null;
        return !ColorAndFontOptions.isReadOnly(scheme) && scheme.getName().startsWith("_@user_") && originalScheme != null && originalScheme.isReadOnly();
    }

    @Override
    public boolean canDeleteScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(5);
        }
        return !ColorAndFontOptions.isReadOnly(scheme) && ColorAndFontOptions.canBeDeleted(scheme);
    }

    @Override
    public boolean isProjectScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    public boolean canRenameScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(7);
        }
        return this.canDeleteScheme(scheme);
    }

    @Override
    public boolean containsScheme(@NotNull String name2, boolean projectScheme) {
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(8);
        }
        assert (!projectScheme);
        return this.myModel.getScheme(name2) != null || this.myModel.getScheme("_@user_" + name2) != null;
    }

    @Override
    public boolean differsFromDefault(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(9);
        }
        if (scheme.getName().startsWith("_@user_")) {
            String displayName = Scheme.getBaseName((String)scheme.getName());
            EditorColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getScheme(displayName);
            if (defaultScheme == null) {
                defaultScheme = EditorColorsManager.getInstance().getScheme(displayName);
            }
            if (defaultScheme != null && scheme instanceof AbstractColorsScheme) {
                return !((AbstractColorsScheme)scheme).settingsEqual((Object)defaultScheme, colorKey -> !colorKey.getExternalName().startsWith(FileStatusFactory.getFilestatusColorKeyPrefix()));
            }
        }
        return false;
    }

    @Override
    public boolean isDefaultScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(10);
        }
        return UIThemeLookAndFeelInfoKt.isDefaultForTheme((EditorColorsScheme)scheme, (UIThemeLookAndFeelInfo)LafManager.getInstance().getCurrentUIThemeLookAndFeel());
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<ExtensionPointName> list2 = List.of(ColorSettingsPage.EP_NAME, ColorAndFontPanelFactory.EP_NAME, ColorAndFontDescriptorsProvider.EP_NAME);
        if (list2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @ApiStatus.Internal
    public void setSchemesPanelFactory(SchemesPanelFactory schemesPanelFactory) {
        this.mySchemesPanelFactory = schemesPanelFactory;
    }

    @ApiStatus.Internal
    public void setShouldChangeLafIfNecessary(boolean shouldChangeLafIfNecessary) {
        this.myShouldChangeLafIfNecessary = shouldChangeLafIfNecessary;
    }

    public static boolean isReadOnly(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(12);
        }
        return scheme.isReadOnly();
    }

    public static boolean canBeDeleted(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(13);
        }
        return scheme instanceof MyColorScheme && ((MyColorScheme)scheme).canBeDeleted();
    }

    @NotNull
    public Groups<EditorColorsScheme> getOrderedSchemes() {
        Groups<EditorColorsScheme> groups = this.myModel.getOrderedSchemes();
        if (groups == null) {
            ColorAndFontOptions.$$$reportNull$$$0(14);
        }
        return groups;
    }

    @NotNull
    public Collection<EditorColorsScheme> getSchemes() {
        return new ArrayList<EditorColorsScheme>(this.myModel.allSchemes());
    }

    public boolean saveSchemeAs(@NotNull EditorColorsScheme editorScheme, @NotNull String name2) {
        if (editorScheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(16);
        }
        if (editorScheme instanceof MyColorScheme) {
            MyColorScheme scheme = (MyColorScheme)editorScheme;
            EditorColorsScheme clone = (EditorColorsScheme)scheme.getParentScheme().clone();
            scheme.apply(clone);
            if (clone instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)clone).setSaveNeeded(true);
            }
            clone.setName(name2);
            MyColorScheme newScheme = new MyColorScheme(clone);
            ColorAndFontOptions.initScheme(newScheme);
            newScheme.setIsNew();
            this.myModel.runBatchedUpdate(this, () -> {
                this.myModel.putScheme(name2, (EditorColorsScheme)newScheme, this);
                this.selectScheme(newScheme.getName());
            });
            this.resetSchemesCombo(null);
            return true;
        }
        return false;
    }

    public void addImportedScheme(@NotNull EditorColorsScheme imported) {
        if (imported == null) {
            ColorAndFontOptions.$$$reportNull$$$0(17);
        }
        if (imported instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)imported).setSaveNeeded(true);
        }
        MyColorScheme newScheme = new MyColorScheme(imported);
        ColorAndFontOptions.initScheme(newScheme);
        this.myModel.runBatchedUpdate(this, () -> {
            this.myModel.putScheme(imported.getName(), (EditorColorsScheme)newScheme, this);
            this.selectScheme(newScheme.getName());
        });
        this.resetSchemesCombo(null);
    }

    @Override
    public void removeScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(18);
        }
        String schemeName = scheme.getName();
        EditorColorsScheme selectedScheme = this.getSelectedScheme();
        if (selectedScheme != null && selectedScheme.getName().equals(schemeName)) {
            this.selectDefaultScheme();
        }
        boolean deletedNewlyCreated = false;
        MyColorScheme toDelete = this.getMyScheme(schemeName);
        if (toDelete != null) {
            deletedNewlyCreated = toDelete.isNew();
        }
        this.myModel.removeScheme(schemeName, this);
        this.resetSchemesCombo(null);
        this.mySomeSchemesDeleted = this.mySomeSchemesDeleted || !deletedNewlyCreated;
    }

    private void selectDefaultScheme() {
        DefaultColorsScheme defaultScheme = (DefaultColorsScheme)EditorColorsManager.getInstance().getDefaultScheme();
        this.selectScheme(defaultScheme.getEditableCopyName());
    }

    void resetSchemeToOriginal(@NotNull String name2) {
        MyColorScheme schemeToReset;
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(19);
        }
        if ((schemeToReset = this.getMyScheme(name2)) != null) {
            schemeToReset.resetToOriginal();
        }
        this.selectScheme(name2);
        this.resetSchemesCombo(null);
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (this.myApplyCompleted) {
            return;
        }
        try {
            EditorColorsManager editorColorManager = EditorColorsManager.getInstance();
            SchemeManager<EditorColorsScheme> schemeManager = ((EditorColorsManagerImpl)editorColorManager).getSchemeManager();
            EditorColorsScheme oldScheme = editorColorManager.getGlobalScheme();
            ArrayList<EditorColorsScheme> result2 = new ArrayList<EditorColorsScheme>(this.myModel.allSchemes().size());
            boolean activeSchemeModified = false;
            MyColorScheme selectedScheme = this.getMySelectedScheme();
            if (selectedScheme == null) {
                return;
            }
            EditorColorsScheme activeOriginalScheme = selectedScheme.getParentScheme();
            for (MyColorScheme scheme : this.getMySchemes()) {
                boolean isModified2 = scheme.apply();
                if (isModified2 && !activeSchemeModified && activeOriginalScheme == scheme.getParentScheme()) {
                    activeSchemeModified = true;
                }
                result2.add(scheme.getParentScheme());
            }
            boolean refreshEditors = activeSchemeModified && schemeManager.getActiveScheme() == activeOriginalScheme;
            schemeManager.setSchemes(ColorAndFontOptions.includingInvisible(result2, schemeManager), (Object)activeOriginalScheme);
            if (refreshEditors) {
                ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
            }
            if (this.myShouldChangeLafIfNecessary && !Objects.equals(oldScheme.getName(), editorColorManager.getGlobalScheme().getName())) {
                QuickChangeColorSchemeAction.changeLafIfNecessary(oldScheme, activeOriginalScheme, null);
            }
            this.reset();
        }
        finally {
            this.myApplyCompleted = true;
        }
    }

    private static List<EditorColorsScheme> includingInvisible(@NotNull List<EditorColorsScheme> schemeList, @NotNull SchemeManager<EditorColorsScheme> schemeManager) {
        if (schemeList == null) {
            ColorAndFontOptions.$$$reportNull$$$0(20);
        }
        if (schemeManager == null) {
            ColorAndFontOptions.$$$reportNull$$$0(21);
        }
        for (EditorColorsScheme scheme : schemeManager.getAllSchemes()) {
            if (AbstractColorsScheme.isVisible((EditorColorsScheme)scheme)) continue;
            schemeList.add(scheme);
        }
        return schemeList;
    }

    @ApiStatus.Internal
    public void preselectScheme(@NotNull String schemeName) {
        if (schemeName == null) {
            ColorAndFontOptions.$$$reportNull$$$0(22);
        }
        this.myModel.runBatchedUpdate(this, () -> {
            if (this.myModel.getScheme(schemeName) != null) {
                this.selectScheme(schemeName);
                if (this.myInitResetCompleted) {
                    this.resetSchemesCombo(this);
                }
            }
            if (!this.myInitResetCompleted) {
                this.myModel.setPreselectedSchemeName(schemeName, this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSchemesCombo(Object source) {
        this.myIsReset = true;
        try {
            this.myRootSchemesPanel.resetSchemesCombo(source);
            if (this.mySubPanelFactories != null) {
                for (NewColorAndFontPanel subPartialConfigurable : this.getPanels()) {
                    subPartialConfigurable.reset(source);
                }
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public JComponent createComponent() {
        return this.createComponent(false);
    }

    @ApiStatus.Internal
    public JComponent createComponent(boolean comboBoxOnly) {
        if (this.myRootSchemesPanel == null) {
            this.ensureSchemesPanel();
        }
        if (comboBoxOnly) {
            return this.myRootSchemesPanel;
        }
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.setBorder((Border)JBUI.Borders.empty((int)11, (int)16, (int)0, (int)16));
        container.add("North", this.myRootSchemesPanel);
        container.add("Center", this.createChildSectionLinkList());
        return container;
    }

    private JComponent createChildSectionLinkList() {
        JPanel content2 = new JPanel(new BorderLayout());
        content2.setBorder((Border)JBUI.Borders.emptyTop((int)11));
        content2.add("Center", (Component)ConfigurablesListPanelKt.createConfigurablesListPanel(ApplicationBundle.message((String)"description.colors.and.fonts", (Object[])new Object[0]), Arrays.asList(this.getConfigurables()), null));
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
        pane2.setHorizontalScrollBarPolicy(31);
        return pane2;
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public @NotNull Configurable @NotNull [] buildConfigurables() {
        this.myDisposeCompleted = false;
        this.initAll();
        List<ColorAndFontPanelFactory> panelFactories = this.createPanelFactories();
        this.mySubPanelFactories = new LinkedHashMap<ColorAndFontPanelFactory, InnerSearchableConfigurable>(panelFactories.size());
        for (ColorAndFontPanelFactory panelFactory : panelFactories) {
            this.mySubPanelFactories.put(panelFactory, new InnerSearchableConfigurable(panelFactory));
        }
        Configurable[] configurableArray = this.mySubPanelFactories.values().toArray(new Configurable[0]);
        if (configurableArray == null) {
            ColorAndFontOptions.$$$reportNull$$$0(23);
        }
        return configurableArray;
    }

    @NotNull
    private Set<NewColorAndFontPanel> getPanels() {
        if (this.mySubPanelFactories == null) {
            return new HashSet<NewColorAndFontPanel>();
        }
        HashSet<NewColorAndFontPanel> result2 = new HashSet<NewColorAndFontPanel>();
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            NewColorAndFontPanel panel2 = configurable.getSubPanelIfInitialized();
            if (panel2 == null) continue;
            result2.add(panel2);
        }
        HashSet<NewColorAndFontPanel> hashSet = result2;
        if (hashSet == null) {
            ColorAndFontOptions.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    protected List<ColorAndFontPanelFactory> createPanelFactories() {
        ColorSettingsPage[] pages;
        ArrayList<ColorAndFontPanelFactoryEx> extensions = new ArrayList<ColorAndFontPanelFactoryEx>();
        extensions.add(new FontConfigurableFactory());
        extensions.add(new ConsoleFontConfigurableFactory());
        for (final ColorSettingsPage page : pages = ColorSettingsPages.getInstance().getRegisteredPages()) {
            extensions.add(new ColorAndFontPanelFactoryEx(){

                @Override
                @NotNull
                public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options2) {
                    if (options2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    SimpleEditorPreview preview = new SimpleEditorPreview(options2, page);
                    NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create(preview, page.getDisplayName(), options2, null, page);
                    if (newColorAndFontPanel == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return newColorAndFontPanel;
                }

                @Override
                @NotNull
                public String getPanelDisplayName() {
                    String string = page.getDisplayName();
                    if (string == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public DisplayPriority getPriority() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getPriority();
                    }
                    return DisplayPriority.LANGUAGE_SETTINGS;
                }

                public int getWeight() {
                    if (page instanceof DisplayPrioritySortable) {
                        return ((DisplayPrioritySortable)page).getWeight();
                    }
                    return ColorAndFontPanelFactoryEx.super.getWeight();
                }

                @Override
                @NotNull
                public Class<?> getOriginalClass() {
                    Class clazz = page.getClass();
                    if (clazz == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return clazz;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "options";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createPanel";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPanelDisplayName";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getOriginalClass";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createPanel";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3 -> new IllegalStateException(string);
                    };
                }
            });
        }
        extensions.addAll(ColorAndFontPanelFactory.EP_NAME.getExtensionList());
        extensions.sort((f1, f2) -> DisplayPrioritySortable.compare((Object)f1, (Object)f2, factory -> factory.getPanelDisplayName()));
        return new ArrayList<ColorAndFontPanelFactory>(extensions);
    }

    @NlsContexts.ConfigurableName
    public static String getFontConfigurableName() {
        return ApplicationBundle.message((String)"title.colors.scheme.font", (Object[])new Object[0]);
    }

    private void initAll() {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myModel.runBatchedUpdate(this, () -> {
            this.myModel.dropSchemes(this);
            for (EditorColorsScheme allScheme : EditorColorsManager.getInstance().getAllSchemes()) {
                MyColorScheme schemeDelegate = new MyColorScheme(allScheme);
                ColorAndFontOptions.initScheme(schemeDelegate);
                this.myModel.putScheme(schemeDelegate.getName(), (EditorColorsScheme)schemeDelegate, this);
            }
            EditorColorsScheme schemeToSelect = null;
            String preselectedSchemeName = this.myModel.getPreselectedSchemeName();
            if (preselectedSchemeName != null) {
                schemeToSelect = this.myModel.getScheme(preselectedSchemeName);
                this.myModel.setPreselectedSchemeName(null, this);
            }
            if (schemeToSelect == null && EditorColorsManagerImpl.Companion.isTempScheme(schemeToSelect = globalScheme)) {
                MyTempColorScheme schemeDelegate = new MyTempColorScheme((AbstractColorsScheme)schemeToSelect);
                ColorAndFontOptions.initScheme(schemeDelegate);
                this.myModel.putScheme(schemeDelegate.getName(), (EditorColorsScheme)schemeDelegate, this);
            }
            this.myModel.setSelectedScheme(this.myModel.getScheme(schemeToSelect.getName()), this);
            assert (this.myModel.getSelectedScheme() != null) : schemeToSelect.getName() + "; mySchemes=" + String.valueOf(ContainerUtil.map(this.myModel.schemesKeySet(), key -> "(" + key + ": " + String.valueOf(this.myModel.getScheme((String)key)) + ")"));
        });
    }

    private static void initScheme(@NotNull MyColorScheme scheme) {
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(25);
        }
        ArrayList descriptions = new ArrayList();
        ColorAndFontOptions.initPluggedDescriptions(descriptions, scheme);
        ColorAndFontOptions.initScopesDescriptors(descriptions, scheme);
        scheme.setDescriptors(descriptions.toArray(new EditorSchemeAttributeDescriptor[0]));
    }

    private static void initPluggedDescriptions(@NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(26);
        }
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(27);
        }
        ColorSettingsPage[] pages = ColorSettingsPages.getInstance().getRegisteredPages();
        for (ColorSettingsPage page : pages) {
            try {
                ColorAndFontOptions.initDescriptions((ColorAndFontDescriptorsProvider)page, descriptions, scheme);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        for (ColorAndFontDescriptorsProvider provider : ColorAndFontDescriptorsProvider.EP_NAME.getExtensionList()) {
            try {
                ColorAndFontOptions.initDescriptions(provider, descriptions, scheme);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void initDescriptions(@NotNull ColorAndFontDescriptorsProvider provider, @NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        if (provider == null) {
            ColorAndFontOptions.$$$reportNull$$$0(28);
        }
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(29);
        }
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(30);
        }
        String className = provider.getClass().getName();
        String group2 = provider.getDisplayName();
        List<AttributesDescriptor> attributeDescriptors = ColorSettingsUtil.getAllAttributeDescriptors(provider);
        if (provider instanceof RainbowColorSettingsPage) {
            RainbowAttributeDescriptor d = new RainbowAttributeDescriptor(((RainbowColorSettingsPage)provider).getLanguage(), group2, ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]), (EditorColorsScheme)scheme, scheme.myRainbowState);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (AttributesDescriptor descriptor2 : attributeDescriptors) {
            if (descriptor2 == null) {
                LOG.warn("Null attribute descriptor in " + className);
                continue;
            }
            SchemeTextAttributesDescription d = new SchemeTextAttributesDescription(descriptor2.getDisplayName(), group2, descriptor2.getKey(), scheme, null, null);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
        for (ColorDescriptor descriptor3 : provider.getColorDescriptors()) {
            if (descriptor3 == null) {
                LOG.warn("Null color descriptor in " + className);
                continue;
            }
            EditorSettingColorDescription d = new EditorSettingColorDescription(descriptor3.getDisplayName(), group2, descriptor3.getKey(), descriptor3.getKind(), scheme);
            descriptions.add((EditorSchemeAttributeDescriptor)d);
        }
    }

    private static void initScopesDescriptors(@NotNull List<? super EditorSchemeAttributeDescriptor> descriptions, @NotNull MyColorScheme scheme) {
        Project[] projects;
        if (descriptions == null) {
            ColorAndFontOptions.$$$reportNull$$$0(31);
        }
        if (scheme == null) {
            ColorAndFontOptions.$$$reportNull$$$0(32);
        }
        Set namedScopes = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)new HashingStrategy<Pair<NamedScope, NamedScopesHolder>>(){

            public int hashCode(@Nullable Pair<NamedScope, NamedScopesHolder> object) {
                return object == null ? 0 : ((NamedScope)object.getFirst()).getScopeId().hashCode();
            }

            public boolean equals(@Nullable Pair<NamedScope, NamedScopesHolder> o1, @Nullable Pair<NamedScope, NamedScopesHolder> o2) {
                return o1 == o2 || o1 != null && o2 != null && ((NamedScope)o1.getFirst()).getScopeId().equals(((NamedScope)o2.getFirst()).getScopeId());
            }
        });
        for (Project project2 : projects = ProjectManager.getInstance().getOpenProjects()) {
            DependencyValidationManagerImpl validationManager = (DependencyValidationManagerImpl)DependencyValidationManager.getInstance((Project)project2);
            List cachedScopes = validationManager.getScopeBasedHighlightingCachedScopes();
            namedScopes.addAll(cachedScopes);
        }
        ArrayList list2 = new ArrayList(namedScopes);
        list2.sort((o1, o2) -> ((NamedScope)o1.getFirst()).getPresentableName().compareToIgnoreCase(((NamedScope)o2.getFirst()).getPresentableName()));
        for (Pair pair : list2) {
            NamedScope namedScope = (NamedScope)pair.getFirst();
            String name2 = namedScope.getScopeId();
            TextAttributesKey textAttributesKey = ScopeAttributesUtil.getScopeTextAttributeKey((String)name2);
            if (scheme.getAttributes(textAttributesKey) == null) {
                scheme.setAttributes(textAttributesKey, new TextAttributes());
            }
            NamedScopesHolder holder = (NamedScopesHolder)pair.getSecond();
            PackageSet value = namedScope.getValue();
            String toolTip = holder.getDisplayName() + (String)(value == null ? "" : ": " + value.getText());
            descriptions.add((EditorSchemeAttributeDescriptor)new SchemeTextAttributesDescription(namedScope.getPresentableName(), ColorAndFontOptions.getScopesGroup(), textAttributesKey, scheme, holder.getIcon(), toolTip));
        }
    }

    private void editorColorSchemeChanged(@Nullable EditorColorsScheme scheme) {
        if (this.myModel.getSelectedScheme() == null || scheme == null) {
            return;
        }
        if (this.myModel.getSelectedScheme().getName().equals(scheme.getName()) || Scheme.getBaseName((String)this.myModel.getSelectedScheme().getName()).equals(scheme.getName())) {
            return;
        }
        this.reset();
    }

    private void revertChanges() {
        if (this.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertChangesCompleted = false;
        }
        if (!this.myRevertChangesCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertChangesCompleted = true;
            }
        }
    }

    private void resetImpl() {
        this.mySomeSchemesDeleted = false;
        this.initAll();
        this.resetSchemesCombo(null);
        this.updateEnabledState();
    }

    boolean isSchemesPanelEnabled() {
        return !LafManager.getInstance().getAutodetect();
    }

    private void updateEnabledState() {
        if (this.myRootSchemesPanel != null) {
            boolean isEnabled = this.isSchemesPanelEnabled();
            this.myRootSchemesPanel.setEnabled(isEnabled);
            for (NewColorAndFontPanel subPanel : this.getPanels()) {
                subPanel.setSchemesPanelEnabled(isEnabled);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myInitResetCompleted) return;
                this.ensureSchemesPanel();
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myInitResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revertChanges();
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myInitResetCompleted) {
            this.ensureSchemesPanel();
            try {
                this.resetImpl();
            }
            finally {
                this.myInitResetCompleted = true;
            }
        }
    }

    private void ensureSchemesPanel() {
        if (this.myRootSchemesPanel == null) {
            this.myRootSchemesPanel = this.mySchemesPanelFactory == null ? new SchemesPanel(this, 0) : this.mySchemesPanelFactory.createSchemesPanel(this);
            this.myRootSchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

                @Override
                public void schemeChanged(@NotNull Object source) {
                    if (source == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (!ColorAndFontOptions.this.myIsReset) {
                        ColorAndFontOptions.this.resetSchemesCombo(source);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/application/options/colors/ColorAndFontOptions$4", "schemeChanged"));
                }
            });
            this.ensureSynchronizingWithGlobalScheme();
        }
    }

    private void ensureSynchronizingWithGlobalScheme() {
        if (this.myEditorColorSchemeConnection == null) {
            this.myEditorColorSchemeConnection = ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable);
            this.myEditorColorSchemeConnection.subscribe(EditorColorsManager.TOPIC, scheme -> this.editorColorSchemeChanged(scheme));
            this.myEditorColorSchemeConnection.subscribe(LafManagerListener.TOPIC, source -> this.updateEnabledState());
        }
    }

    public void disposeUIResources() {
        block6: {
            try {
                if (this.myDisposeCompleted) break block6;
                try {
                    super.disposeUIResources();
                    Disposer.dispose((Disposable)this.myDisposable);
                }
                finally {
                    this.myDisposeCompleted = true;
                }
            }
            finally {
                this.mySubPanelFactories = null;
                this.myInitResetCompleted = false;
                this.myInitResetInvoked = false;
                this.myRevertChangesCompleted = false;
                this.myApplyCompleted = false;
                this.myRootSchemesPanel = null;
                this.myModel.removeListener(this.modelListener);
            }
        }
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    public static void writeTempScheme(EditorColorsScheme colorsScheme) {
        Element scheme = new Element("scheme");
        ((AbstractColorsScheme)colorsScheme).writeExternal(scheme);
        ColorAndFontOptions.writeTempScheme(scheme, colorsScheme);
    }

    public static void writeTempScheme(Element scheme, EditorColorsScheme parentScheme) {
        Path path = EditorColorsManagerImpl.Companion.getTempSchemeOriginalFilePath(parentScheme);
        if (path != null) {
            try {
                Element originalFile = JDOMUtil.load((File)path.toFile());
                scheme.setName(originalFile.getName());
                for (Attribute attribute : originalFile.getAttributes()) {
                    scheme.setAttribute(attribute.getName(), attribute.getValue());
                }
                parentScheme.readExternal(scheme);
                scheme.removeChild("metaInfo");
                Element metaInfo = originalFile.getChild("metaInfo");
                if (metaInfo != null) {
                    metaInfo = JDOMUtil.load((CharSequence)JDOMUtil.writeElement((Element)metaInfo));
                    scheme.addContent(0, (Content)metaInfo);
                }
                JDOMUtil.write((Element)scheme, (Path)path);
                VirtualFileManager.getInstance().syncRefresh();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ColorAndFontOptions.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(@NotNull Class<?> pageClass) {
        if (pageClass == null) {
            ColorAndFontOptions.$$$reportNull$$$0(34);
        }
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (Map.Entry<ColorAndFontPanelFactory, InnerSearchableConfigurable> entry : this.mySubPanelFactories.entrySet()) {
            if (!pageClass.isInstance(entry.getValue().createPanel().getSettingsPage())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String pageName) {
        if (this.mySubPanelFactories == null) {
            this.getConfigurables();
        }
        for (InnerSearchableConfigurable configurable : this.mySubPanelFactories.values()) {
            if (!configurable.getDisplayName().equals(pageName)) continue;
            return configurable;
        }
        return null;
    }

    @Nullable
    public NewColorAndFontPanel findPage(String pageName) {
        InnerSearchableConfigurable child = (InnerSearchableConfigurable)this.findSubConfigurable(pageName);
        return child == null ? null : child.createPanel();
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search, @NotNull String name2) {
        if (context == null) {
            ColorAndFontOptions.$$$reportNull$$$0(35);
        }
        if (name2 == null) {
            ColorAndFontOptions.$$$reportNull$$$0(36);
        }
        return ColorAndFontOptions.selectOrEdit(context, search, options2 -> options2.findSubConfigurable(name2));
    }

    public static boolean selectOrEditColor(@NotNull DataContext context, @Nullable String search, @NotNull Class<?> type) {
        if (context == null) {
            ColorAndFontOptions.$$$reportNull$$$0(37);
        }
        if (type == null) {
            ColorAndFontOptions.$$$reportNull$$$0(38);
        }
        return ColorAndFontOptions.selectOrEdit(context, search, options2 -> options2.findSubConfigurable(type));
    }

    private static boolean selectOrEdit(DataContext context, String search, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        return ColorAndFontOptions.select(context, search, function) || ColorAndFontOptions.edit(context, search, function);
    }

    private static boolean select(DataContext context, String search, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        Settings settings = (Settings)Settings.KEY.getData(context);
        if (settings == null) {
            return false;
        }
        ColorAndFontOptions options2 = settings.find(ColorAndFontOptions.class);
        if (options2 == null) {
            return false;
        }
        SearchableConfigurable page = function.apply(options2);
        if (page == null) {
            return false;
        }
        settings.select((Configurable)page, search);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean edit(DataContext context, String search, Function<? super ColorAndFontOptions, ? extends SearchableConfigurable> function) {
        ColorAndFontOptions options2 = new ColorAndFontOptions();
        SearchableConfigurable page = function.apply(options2);
        Configurable[] configurables2 = options2.getConfigurables();
        try {
            if (page != null) {
                Runnable runnable2 = search == null ? null : page.enableSearch(search);
                Window window = ComponentUtil.getWindow((Component)((Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context)));
                if (window != null) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)window, (Configurable)page, runnable2);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Project)CommonDataKeys.PROJECT.getData(context), (Configurable)page, runnable2);
                }
            }
        }
        finally {
            for (Configurable configurable : configurables2) {
                configurable.disposeUIResources();
            }
            options2.disposeUIResources();
        }
        return page != null;
    }

    @NlsContexts.ConfigurableName
    public static String getScopesGroup() {
        return ApplicationBundle.message((String)"title.scope.based", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 14, 23, 24, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 16: 
            case 19: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 25: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 11: 
            case 14: 
            case 23: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorScheme";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageClass";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedSchemes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConfigurables";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanels";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMyScheme";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultScheme";
                break;
            }
            case 11: 
            case 14: 
            case 23: 
            case 24: 
            case 33: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canBeDeleted";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveSchemeAs";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addImportedScheme";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resetSchemeToOriginal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "includingInvisible";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "preselectScheme";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initScheme";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "initPluggedDescriptions";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "initDescriptions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "initScopesDescriptors";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findSubConfigurable";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "selectOrEditColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 14, 23, 24, 33 -> new IllegalStateException(string);
        };
    }

    private static class MyColorScheme
    extends EditorColorsSchemeImpl {
        private EditorSchemeAttributeDescriptor[] myDescriptors;
        private String myName;
        private boolean myIsNew;
        private final RainbowColorsInSchemeState myRainbowState;
        private static final Predicate<ColorKey> FILE_STATUS_COLORS = input -> input != null && input.getExternalName().startsWith(FileStatusFactory.getFilestatusColorKeyPrefix());

        private MyColorScheme(@NotNull EditorColorsScheme parentScheme) {
            if (parentScheme == null) {
                MyColorScheme.$$$reportNull$$$0(0);
            }
            super(parentScheme);
            this.myIsNew = false;
            if (parentScheme.isUseEditorFontPreferencesInConsole()) {
                this.setUseEditorFontPreferencesInConsole();
            } else {
                this.setConsoleFontPreferences(parentScheme.getConsoleFontPreferences());
            }
            if (parentScheme.isUseAppFontPreferencesInEditor()) {
                this.setUseAppFontPreferencesInEditor();
            } else {
                this.setFontPreferences(parentScheme.getFontPreferences());
            }
            this.myName = parentScheme.getName();
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)this, (SchemeMetaInfo)parentScheme);
            this.myRainbowState = new RainbowColorsInSchemeState((EditorColorsScheme)this, parentScheme);
            this.initFonts();
        }

        @Nullable
        public AbstractColorsScheme getOriginal() {
            return this.parentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.parentScheme).getOriginal() : null;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyColorScheme.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void setName(@NotNull String name2) {
            if (name2 == null) {
                MyColorScheme.$$$reportNull$$$0(2);
            }
            this.myName = name2;
        }

        public void setDescriptors(EditorSchemeAttributeDescriptor[] descriptors2) {
            this.myDescriptors = descriptors2;
        }

        public EditorSchemeAttributeDescriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        public boolean isReadOnly() {
            return this.parentScheme.isReadOnly();
        }

        public boolean isModified() {
            if (this.isFontModified() || this.isConsoleFontModified()) {
                return true;
            }
            for (EditorSchemeAttributeDescriptor descriptor2 : this.myDescriptors) {
                if (!descriptor2.isModified()) continue;
                return true;
            }
            return false;
        }

        public boolean canBeDeleted() {
            return this.parentScheme instanceof AbstractColorsScheme && ((AbstractColorsScheme)this.parentScheme).canBeDeleted();
        }

        private boolean isFontModified() {
            return !MyColorScheme.areDelegatingOrEqual((FontPreferences)this.getFontPreferences(), (FontPreferences)this.parentScheme.getFontPreferences());
        }

        private boolean isConsoleFontModified() {
            return !MyColorScheme.areDelegatingOrEqual((FontPreferences)this.getConsoleFontPreferences(), (FontPreferences)this.parentScheme.getConsoleFontPreferences());
        }

        protected boolean apply() {
            return !this.parentScheme.isReadOnly() && this.apply(this.parentScheme);
        }

        private boolean apply(@NotNull EditorColorsScheme scheme) {
            boolean isModified2;
            if (scheme == null) {
                MyColorScheme.$$$reportNull$$$0(3);
            }
            boolean bl = isModified2 = this.isFontModified() || this.isConsoleFontModified();
            if (this.isUseAppFontPreferencesInEditor()) {
                scheme.setUseAppFontPreferencesInEditor();
            } else {
                scheme.setFontPreferences(this.getFontPreferences());
            }
            if (this.isUseEditorFontPreferencesInConsole()) {
                scheme.setUseEditorFontPreferencesInConsole();
            } else {
                scheme.setConsoleFontPreferences(this.getConsoleFontPreferences());
            }
            for (EditorSchemeAttributeDescriptor descriptor2 : this.myDescriptors) {
                if (!descriptor2.isModified()) continue;
                isModified2 = true;
                descriptor2.apply(scheme);
            }
            if (isModified2 && scheme instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)scheme).setSaveNeeded(true);
            }
            return isModified2;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void setIsNew() {
            this.myIsNew = true;
        }

        public boolean isNew() {
            return this.myIsNew;
        }

        @NotNull
        public String toString() {
            String string = "temporary scheme for " + this.myName;
            if (string == null) {
                MyColorScheme.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isInherited(@NotNull TextAttributesKey key) {
            TextAttributesKey fallbackKey;
            if (key == null) {
                MyColorScheme.$$$reportNull$$$0(5);
            }
            if ((fallbackKey = key.getFallbackAttributeKey()) != null) {
                TextAttributes ownAttrs;
                if (this.parentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.parentScheme).getDirectlyDefinedAttributes(key)) != null) {
                    return ownAttrs == INHERITED_ATTRS_MARKER;
                }
                TextAttributes attributes = this.getAttributes(key);
                if (attributes != null) {
                    TextAttributes fallbackAttributes = this.getAttributes(fallbackKey);
                    return attributes == fallbackAttributes;
                }
            }
            return false;
        }

        public boolean isInherited(ColorKey key) {
            ColorKey fallbackKey = key.getFallbackColorKey();
            if (fallbackKey != null) {
                Color ownAttrs;
                if (this.parentScheme instanceof AbstractColorsScheme && (ownAttrs = ((AbstractColorsScheme)this.parentScheme).getDirectlyDefinedColor(key)) != null) {
                    return ownAttrs == INHERITED_COLOR_MARKER;
                }
                Color attributes = this.getColor(key);
                if (attributes != null) {
                    Color fallback = this.getColor(fallbackKey);
                    return attributes == fallback;
                }
            }
            return false;
        }

        public void resetToOriginal() {
            AbstractColorsScheme originalScheme;
            if (this.parentScheme instanceof AbstractColorsScheme && (originalScheme = ((AbstractColorsScheme)this.parentScheme).getOriginal()) != null) {
                MyColorScheme.copyPreservingFileStatusColors(originalScheme, (AbstractColorsScheme)this.parentScheme);
                MyColorScheme.copyPreservingFileStatusColors(originalScheme, (AbstractColorsScheme)this);
                ColorAndFontOptions.initScheme(this);
            }
        }

        private static void copyPreservingFileStatusColors(@NotNull AbstractColorsScheme source, @NotNull AbstractColorsScheme target) {
            if (source == null) {
                MyColorScheme.$$$reportNull$$$0(6);
            }
            if (target == null) {
                MyColorScheme.$$$reportNull$$$0(7);
            }
            Map fileStatusColors = target.getColorKeys().stream().filter(FILE_STATUS_COLORS).collect(Collectors.toMap(Function.identity(), arg_0 -> ((AbstractColorsScheme)target).getDirectlyDefinedColor(arg_0)));
            source.copyTo(target);
            for (ColorKey key : fileStatusColors.keySet()) {
                target.setColor(key, fileStatusColors.get(key));
            }
            target.setSaveNeeded(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentScheme";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$MyColorScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInherited";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "copyPreservingFileStatusColors";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4 -> new IllegalStateException(string);
            };
        }
    }

    private final class InnerSearchableConfigurable
    implements SearchableConfigurable,
    OptionsContainingConfigurable,
    Configurable.NoScroll,
    Configurable.InnerWithModifiableParent {
        private NewColorAndFontPanel mySubPanel;
        private boolean mySubInitInvoked;
        @NotNull
        private final ColorAndFontPanelFactory myFactory;

        private InnerSearchableConfigurable(ColorAndFontPanelFactory factory) {
            if (factory == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(0);
            }
            this.mySubInitInvoked = false;
            this.myFactory = factory;
        }

        @NlsContexts.ConfigurableName
        @NotNull
        public String getDisplayName() {
            String string = this.myFactory.getPanelDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public NewColorAndFontPanel getSubPanelIfInitialized() {
            return this.mySubPanel;
        }

        private NewColorAndFontPanel createPanel() {
            if (this.mySubPanel == null) {
                this.mySubPanel = this.myFactory.createPanel(ColorAndFontOptions.this);
                this.mySubPanel.reset(this);
                this.mySubPanel.addSchemesListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void schemeChanged(@NotNull Object source) {
                        if (source == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!ColorAndFontOptions.this.myIsReset) {
                            ColorAndFontOptions.this.resetSchemesCombo(source);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable$1", "schemeChanged"));
                    }
                });
                this.mySubPanel.addDescriptionListener(new ColorAndFontSettingsListener.Abstract(){

                    @Override
                    public void fontChanged() {
                        for (NewColorAndFontPanel panel2 : ColorAndFontOptions.this.getPanels()) {
                            panel2.updatePreview();
                            panel2.updateSchemesPanel();
                        }
                    }
                });
            }
            return this.mySubPanel;
        }

        public void focusOn(@Nls @NotNull String label2) {
            if (label2 == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(2);
            }
            this.createPanel().showOption(label2);
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.createPanel().getPanel();
        }

        public boolean isModified() {
            this.createPanel();
            for (MyColorScheme scheme : ColorAndFontOptions.this.getMySchemes()) {
                if (this.mySubPanel.containsFontOptions()) {
                    if (!scheme.isFontModified() && !scheme.isConsoleFontModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
                for (EditorSchemeAttributeDescriptor descriptor2 : scheme.getDescriptors()) {
                    if (!this.mySubPanel.contains(descriptor2) || !descriptor2.isModified()) continue;
                    ColorAndFontOptions.this.myRevertChangesCompleted = false;
                    return true;
                }
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            ColorAndFontOptions.this.apply();
        }

        public void reset() {
            if (!this.mySubInitInvoked) {
                if (!ColorAndFontOptions.this.myInitResetCompleted) {
                    ColorAndFontOptions.this.resetFromChild();
                }
                this.mySubInitInvoked = true;
            } else {
                ColorAndFontOptions.this.revertChanges();
            }
        }

        public void disposeUIResources() {
            if (this.mySubPanel != null) {
                this.mySubPanel.disposeUIResources();
                this.mySubPanel = null;
            }
        }

        @NotNull
        public String getId() {
            String string = ColorAndFontOptions.this.getId() + "." + this.getDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(3);
            }
            return string;
        }

        public Runnable enableSearch(String option2) {
            return this.createPanel().showOption(option2);
        }

        @Override
        @NotNull
        public Set<String> processListOptions() {
            Set<String> set = this.createPanel().processListOptions();
            if (set == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(4);
            }
            return set;
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class<?> clazz = this.myFactory.getOriginalClass();
            if (clazz == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(5);
            }
            return clazz;
        }

        @NotNull
        @NonNls
        public String toString() {
            String string = "Color And Fonts for " + this.getDisplayName();
            if (string == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public List<Configurable> getModifiableParents() {
            List<ColorAndFontOptions> list2 = List.of(ColorAndFontOptions.this);
            if (list2 == null) {
                InnerSearchableConfigurable.$$$reportNull$$$0(7);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$InnerSearchableConfigurable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processListOptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifiableParents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "focusOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private FontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options2) {
            if (options2 == null) {
                FontConfigurableFactory.$$$reportNull$$$0(0);
            }
            FontEditorPreview previewPanel = new FontEditorPreview(() -> options2.getSelectedScheme(), true);
            return new NewColorAndFontPanel(new SchemesPanel(options2, 0), new FontOptions(options2), previewPanel, ColorAndFontOptions.getFontConfigurableName(), null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            String string = ColorAndFontOptions.getFontConfigurableName();
            if (string == null) {
                FontConfigurableFactory.$$$reportNull$$$0(1);
            }
            return string;
        }

        public DisplayPriority getPriority() {
            return DisplayPriority.FONT_SETTINGS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$FontConfigurableFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanelDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPanel";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ConsoleFontConfigurableFactory
    implements ColorAndFontPanelFactoryEx {
        private ConsoleFontConfigurableFactory() {
        }

        @Override
        @NotNull
        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options2) {
            if (options2 == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(0);
            }
            FontEditorPreview previewPanel = new FontEditorPreview(this, () -> options2.getSelectedScheme(), true){

                @Override
                protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
                    return ConsoleViewUtil.updateConsoleColorScheme(selectedScheme);
                }
            };
            return new NewColorAndFontPanel(new SchemesPanel(options2, 0), new ConsoleFontOptions(options2), previewPanel, ApplicationBundle.message((String)"label.font.type", (Object[])new Object[0]), null, null){

                @Override
                public boolean containsFontOptions() {
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public String getPanelDisplayName() {
            String string = ApplicationBundle.message((String)"title.console.font", (Object[])new Object[0]);
            if (string == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public DisplayPriority getPriority() {
            DisplayPriority displayPriority = DisplayPriority.FONT_SETTINGS;
            if (displayPriority == null) {
                ConsoleFontConfigurableFactory.$$$reportNull$$$0(2);
            }
            return displayPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$ConsoleFontConfigurableFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPanelDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPanel";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class SchemeTextAttributesDescription
    extends TextAttributesDescription
    implements UiInspectorContextProvider {
        @NotNull
        private final TextAttributes myInitialAttributes;
        @NotNull
        private final TextAttributesKey key;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, AttributesDescriptor> myBaseAttributeDescriptor;
        private final boolean myIsInheritedInitial;

        private SchemeTextAttributesDescription(String name2, String group2, @NotNull TextAttributesKey key, @NotNull MyColorScheme scheme, Icon icon2, String toolTip) {
            if (key == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(0);
            }
            if (scheme == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(1);
            }
            super(name2, group2, SchemeTextAttributesDescription.getInitialAttributes(scheme, key).clone(), key, (EditorColorsScheme)scheme, icon2, toolTip);
            this.key = key;
            this.myInitialAttributes = SchemeTextAttributesDescription.getInitialAttributes(scheme, key);
            TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
            if (fallbackKey != null) {
                this.myFallbackAttributes = scheme.getAttributes(fallbackKey);
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getAttributeDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    this.myBaseAttributeDescriptor = new Pair(null, (Object)new AttributesDescriptor(fallbackKey.getExternalName(), fallbackKey));
                }
            }
            this.myIsInheritedInitial = scheme.isInherited(key);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial && this.myFallbackAttributes != null) {
                this.getTextAttributes().copyFrom(this.myFallbackAttributes);
            }
            this.initCheckedStatus();
        }

        @NotNull
        public List<PropertyBean> getUiInspectorContext() {
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Text Attributes Key", (Object)this.key.getExternalName(), true));
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        private static TextAttributes getInitialAttributes(@NotNull MyColorScheme scheme, @NotNull TextAttributesKey key) {
            TextAttributes attributes;
            if (scheme == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(3);
            }
            if (key == null) {
                SchemeTextAttributesDescription.$$$reportNull$$$0(4);
            }
            return (attributes = scheme.getAttributes(key)) != null ? attributes : new TextAttributes();
        }

        public void apply(EditorColorsScheme scheme) {
            boolean skip;
            if (scheme == null) {
                scheme = this.getScheme();
            }
            if (scheme == null) {
                return;
            }
            boolean bl = skip = scheme instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme.setAttributes(this.key, this.isInherited() ? AbstractColorsScheme.INHERITED_ATTRS_MARKER : this.getTextAttributes());
            }
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialAttributes, (Object)this.getTextAttributes()) || this.myIsInheritedInitial;
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }

        @Override
        public boolean isTransparencyEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$SchemeTextAttributesDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiInspectorContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getInitialAttributes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class EditorSettingColorDescription
    extends ColorAndFontDescription
    implements UiInspectorContextProvider {
        private final ColorKey myColorKey;
        @NotNull
        private final ColorDescriptor.Kind myKind;
        private final Color myInitialColor;
        private Color myColor;
        private TextAttributes myFallbackAttributes;
        private Pair<ColorAndFontDescriptorsProvider, ColorDescriptor> myBaseAttributeDescriptor;
        private final boolean myIsInheritedInitial;

        EditorSettingColorDescription(String name2, String group2, @NotNull ColorKey colorKey, @NotNull ColorDescriptor.Kind kind, @NotNull MyColorScheme scheme) {
            if (colorKey == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(1);
            }
            if (scheme == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(2);
            }
            super(name2, group2, colorKey.getExternalName(), (EditorColorsScheme)scheme, null, null);
            this.myColorKey = colorKey;
            this.myKind = kind;
            ColorKey fallbackKey = this.myColorKey.getFallbackColorKey();
            if (fallbackKey != null) {
                this.myBaseAttributeDescriptor = ColorSettingsPages.getInstance().getColorDescriptor(fallbackKey);
                if (this.myBaseAttributeDescriptor == null) {
                    @NlsSafe String fallbackKeyExternalName = fallbackKey.getExternalName();
                    this.myBaseAttributeDescriptor = Pair.create(null, (Object)new ColorDescriptor(fallbackKeyExternalName, fallbackKey, this.myKind));
                }
                Color fallbackColor = scheme.getColor(fallbackKey);
                this.myFallbackAttributes = new TextAttributes(this.myKind == ColorDescriptor.Kind.FOREGROUND ? fallbackColor : null, this.myKind == ColorDescriptor.Kind.BACKGROUND ? fallbackColor : null, null, null, 0);
            }
            this.myInitialColor = this.myColor = scheme.getColor(this.myColorKey);
            this.myIsInheritedInitial = scheme.isInherited(this.myColorKey);
            this.setInherited(this.myIsInheritedInitial);
            if (this.myIsInheritedInitial) {
                // empty if block
            }
            this.initCheckedStatus();
        }

        @NotNull
        public List<PropertyBean> getUiInspectorContext() {
            ArrayList<PropertyBean> result2 = new ArrayList<PropertyBean>();
            result2.add(new PropertyBean("Color Key", (Object)this.myColorKey.getExternalName(), true));
            ArrayList<PropertyBean> arrayList = result2;
            if (arrayList == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        public int getFontType() {
            return 0;
        }

        @Override
        public void setFontType(int type) {
        }

        @Override
        public Color getExternalEffectColor() {
            return null;
        }

        @Override
        public void setExternalEffectColor(Color color) {
        }

        @Override
        public void setExternalEffectType(EffectType type) {
        }

        @Override
        @NotNull
        public EffectType getExternalEffectType() {
            EffectType effectType = EffectType.LINE_UNDERSCORE;
            if (effectType == null) {
                EditorSettingColorDescription.$$$reportNull$$$0(4);
            }
            return effectType;
        }

        @Override
        public Color getExternalForeground() {
            return this.isForegroundEnabled() ? this.myColor : null;
        }

        @Override
        public void setExternalForeground(Color col) {
            if (!this.myKind.isForeground()) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalBackground() {
            return this.isBackgroundEnabled() ? this.myColor : null;
        }

        @Override
        public void setExternalBackground(Color col) {
            if (!this.myKind.isBackground()) {
                return;
            }
            if (this.myColor != null && this.myColor.equals(col)) {
                return;
            }
            this.myColor = col;
        }

        @Override
        public Color getExternalErrorStripe() {
            return null;
        }

        @Override
        public void setExternalErrorStripe(Color col) {
        }

        @Override
        public boolean isFontEnabled() {
            return false;
        }

        @Override
        public boolean isForegroundEnabled() {
            return this.myKind.isForeground();
        }

        @Override
        public boolean isBackgroundEnabled() {
            return this.myKind.isBackground();
        }

        @Override
        public boolean isTransparencyEnabled() {
            return this.myKind.isWithTransparency();
        }

        @Override
        public boolean isEffectsColorEnabled() {
            return false;
        }

        @Override
        public boolean isModified() {
            if (this.isInherited()) {
                return !this.myIsInheritedInitial;
            }
            return !Comparing.equal((Object)this.myInitialColor, (Object)this.myColor) || this.myIsInheritedInitial;
        }

        @Override
        @Nullable
        public TextAttributes getBaseAttributes() {
            return this.myFallbackAttributes;
        }

        public void apply(EditorColorsScheme scheme) {
            boolean skip;
            if (scheme == null) {
                scheme = this.getScheme();
            }
            if (scheme == null) {
                return;
            }
            boolean bl = skip = scheme instanceof EditorColorsSchemeImpl && this.isInherited() && this.myIsInheritedInitial;
            if (!skip) {
                scheme.setColor(this.myColorKey, this.isInherited() ? AbstractColorsScheme.INHERITED_COLOR_MARKER : this.myColor);
            }
        }

        @Override
        @Nullable
        public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
            return this.myBaseAttributeDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$EditorSettingColorDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiInspectorContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExternalEffectType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyTempColorScheme
    extends MyColorScheme {
        private MyTempColorScheme(@NotNull AbstractColorsScheme parentScheme) {
            if (parentScheme == null) {
                MyTempColorScheme.$$$reportNull$$$0(0);
            }
            super((EditorColorsScheme)parentScheme);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        protected boolean apply() {
            Element scheme = new Element("scheme");
            EditorColorsScheme parentScheme = this.getParentScheme();
            ((AbstractColorsScheme)parentScheme).writeExternal(scheme);
            Element changes = new Element("scheme");
            this.writeExternal(changes);
            MyTempColorScheme.deepMerge(scheme, changes);
            ColorAndFontOptions.writeTempScheme(scheme, parentScheme);
            return true;
        }

        private static void deepMerge(Element to, Element from) {
            List children2 = from.getChildren();
            Map<Pair<String, String>, Element> index = MyTempColorScheme.createNamedIndex(to);
            if (children2.isEmpty()) {
                Pair<String, String> key = MyTempColorScheme.indexKey(from);
                Element el = index.get(key);
                Parent parent = to.getParent();
                if (el == null && parent != null) {
                    if (!"".equals(from.getAttributeValue("value"))) {
                        parent.addContent((Content)from.clone());
                    }
                    parent.removeContent((Content)to);
                }
            } else {
                for (Element child : children2) {
                    Element el = index.get(MyTempColorScheme.indexKey(child));
                    if (el != null) {
                        MyTempColorScheme.deepMerge(el, child);
                        continue;
                    }
                    to.addContent(child.clone());
                }
            }
        }

        private static Map<Pair<String, String>, Element> createNamedIndex(Element e) {
            HashMap<Pair<String, String>, Element> index = new HashMap<Pair<String, String>, Element>();
            for (Element child : e.getChildren()) {
                index.put(MyTempColorScheme.indexKey(child), child);
            }
            return index;
        }

        @NotNull
        private static Pair<String, String> indexKey(Element e) {
            Pair pair = Pair.create((Object)e.getName(), (Object)e.getAttributeValue("name"));
            if (pair == null) {
                MyTempColorScheme.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentScheme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontOptions$MyTempColorScheme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontOptions$MyTempColorScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "indexKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

