/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.CustomizedSwitcherPanel;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;

public class NewColorAndFontPanel
extends JPanel {
    private final ColorSettingsPage mySettingsPage;
    private final SchemesPanel mySchemesPanel;
    private final OptionsPanel myOptionsPanel;
    private final PreviewPanel myPreviewPanel;
    private final String myCategory;
    private final Collection<String> myOptionList;

    public NewColorAndFontPanel(SchemesPanel schemesPanel, final OptionsPanel optionsPanel, final PreviewPanel previewPanel, String category, Collection<String> optionList, ColorSettingsPage page) {
        super(new BorderLayout(0, 10));
        this.mySchemesPanel = schemesPanel;
        this.myOptionsPanel = optionsPanel;
        this.myPreviewPanel = previewPanel;
        this.myCategory = category;
        this.myOptionList = optionList;
        this.mySettingsPage = page;
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.mySchemesPanel, "North");
        top.add((Component)this.myOptionsPanel.getPanel(), "Center");
        if (!(this.myPreviewPanel.getPanel() == null || page != null && StringUtil.isEmptyOrSpaces((String)page.getDemoText()))) {
            JSplitPane splitPane = new JSplitPane(0, top, this.myPreviewPanel.getPanel());
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            splitPane.setContinuousLayout(true);
            this.add(splitPane);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPane);
        } else {
            this.add((Component)top, "Center");
        }
        previewPanel.addListener(new ColorAndFontSettingsListener.Abstract(this){

            @Override
            public void selectionInPreviewChanged(@NotNull String typeToSelect) {
                if (typeToSelect == null) {
                    1.$$$reportNull$$$0(0);
                }
                optionsPanel.selectOption(typeToSelect);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToSelect", "com/intellij/application/options/colors/NewColorAndFontPanel$1", "selectionInPreviewChanged"));
            }
        });
        optionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                NewColorAndFontPanel.this.mySchemesPanel.updateOnCurrentSettingsChange();
                optionsPanel.applyChangesToScheme();
                previewPanel.updateView();
            }

            @Override
            public void selectedOptionChanged(@NotNull Object selected) {
                if (selected == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    NewColorAndFontPanel.this.myPreviewPanel.blinkSelectedHighlightType(selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/application/options/colors/NewColorAndFontPanel$2", "selectedOptionChanged"));
            }
        });
        this.mySchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(@NotNull Object source) {
                if (source == null) {
                    3.$$$reportNull$$$0(0);
                }
                NewColorAndFontPanel.this.myOptionsPanel.updateOptionsList();
                NewColorAndFontPanel.this.myPreviewPanel.updateView();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/application/options/colors/NewColorAndFontPanel$3", "schemeChanged"));
            }
        });
    }

    public static NewColorAndFontPanel create(PreviewPanel previewPanel, String category, ColorAndFontOptions options2, Collection<String> optionList, ColorSettingsPage page) {
        SchemesPanel schemesPanel = new SchemesPanel(options2);
        OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options2, schemesPanel, category, new CustomizedSwitcherPanel(previewPanel, page));
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, category, optionList, page);
    }

    public Runnable showOption(String option2) {
        return this.myOptionsPanel.showOption(option2);
    }

    public void selectOptionByType(String typeToSelect) {
        this.myOptionsPanel.selectOption(typeToSelect);
    }

    @NotNull
    public Set<String> processListOptions() {
        if (this.myOptionList == null) {
            Set<String> set = this.myOptionsPanel.processListOptions();
            if (set == null) {
                NewColorAndFontPanel.$$$reportNull$$$0(0);
            }
            return set;
        }
        return new HashSet<String>(this.myOptionList);
    }

    public String getDisplayName() {
        return this.myCategory;
    }

    public void reset(Object source) {
        this.resetSchemesCombo(source);
    }

    public void disposeUIResources() {
        this.myPreviewPanel.disposeUIResources();
    }

    public void addSchemesListener(ColorAndFontSettingsListener schemeListener) {
        this.mySchemesPanel.addListener(schemeListener);
    }

    private void resetSchemesCombo(Object source) {
        this.mySchemesPanel.resetSchemesCombo(source);
    }

    public boolean contains(EditorSchemeAttributeDescriptor descriptor2) {
        return descriptor2.getGroup().equals(this.myCategory);
    }

    public JComponent getPanel() {
        return this;
    }

    public void updatePreview() {
        this.myPreviewPanel.updateView();
    }

    public void updateSchemesPanel() {
        this.mySchemesPanel.updateOnCurrentSettingsChange();
    }

    public void addDescriptionListener(ColorAndFontSettingsListener listener2) {
        this.myOptionsPanel.addListener(listener2);
    }

    public boolean containsFontOptions() {
        return false;
    }

    public ColorSettingsPage getSettingsPage() {
        return this.mySettingsPage;
    }

    public void setEmptyText(@NlsContexts.StatusText @NotNull String text2, final @NlsContexts.PopupContent @NotNull String details) {
        if (text2 == null) {
            NewColorAndFontPanel.$$$reportNull$$$0(1);
        }
        if (details == null) {
            NewColorAndFontPanel.$$$reportNull$$$0(2);
        }
        this.myOptionsPanel.setEmptyText(text2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewColorAndFontPanel.this.notifyAtSchemePanel(details);
            }
        });
    }

    private void notifyAtSchemePanel(@NlsContexts.PopupContent @NotNull String message) {
        if (message == null) {
            NewColorAndFontPanel.$$$reportNull$$$0(3);
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        Balloon balloon2 = popupFactory.createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon();
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)balloon2);
        balloon2.show(new RelativePoint((Component)this.mySchemesPanel, new Point(this.mySchemesPanel.getWidth() / 10, this.mySchemesPanel.getHeight())), Balloon.Position.below);
    }

    void setSchemesPanelEnabled(boolean isEnabled) {
        this.mySchemesPanel.setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/NewColorAndFontPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/NewColorAndFontPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyAtSchemePanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

