/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PlatformMemoryUtil;
import com.intellij.diagnostic.PlatformMemoryUtilKt;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00060\u0007R\u00020\u0001H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/LinuxMemoryUtil;", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "<init>", "()V", "libc", "Lcom/intellij/diagnostic/LinuxMemoryUtil$LibC;", "newMemoryStatsProvider", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "getCurrentProcessMemoryStatsLinux", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "trimLinuxNativeHeap", "", "LinuxMemoryStats", "LibC", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPlatformMemoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformMemoryUtil.kt\ncom/intellij/diagnostic/LinuxMemoryUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,643:1\n1#2:644\n*E\n"})
final class LinuxMemoryUtil
extends PlatformMemoryUtil {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final LibC libc;
    @NotNull
    private static final List<String> INTERESTING_FIELDS;

    public LinuxMemoryUtil() {
        Library library = Native.load((String)"c", LibC.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        this.libc = (LibC)library;
    }

    @Override
    @NotNull
    public PlatformMemoryUtil.MemoryStatsProvider newMemoryStatsProvider() {
        return new PlatformMemoryUtil.MemoryStatsProvider(this){
            final /* synthetic */ LinuxMemoryUtil this$0;
            {
                this.this$0 = $receiver;
                super($receiver);
            }

            protected PlatformMemoryUtil.MemoryStats getCurrentProcessMemoryStatsInner() {
                return LinuxMemoryUtil.access$getCurrentProcessMemoryStatsLinux(this.this$0);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PlatformMemoryUtil.MemoryStats getCurrentProcessMemoryStatsLinux() {
        Object object;
        Path statusFile = Path.of("/proc/self/status", new String[0]);
        Intrinsics.checkNotNull((Object)statusFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(statusFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path path = statusFile;
        Closeable closeable = Files.newBufferedReader(path, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            object = (BufferedReader)closeable;
            Intrinsics.checkNotNull((Object)object);
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)object);
            boolean bl = false;
            object = MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)lines, LinuxMemoryUtil::getCurrentProcessMemoryStatsLinux$lambda$0$0));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object fields = object;
        Long l = (Long)fields.get("VmRSS");
        if (l == null) {
            return null;
        }
        long it = ((Number)l).longValue();
        boolean bl = false;
        long l2 = it * (long)1024;
        Long l3 = (Long)fields.get("RssAnon");
        if (l3 == null) {
            return null;
        }
        it = ((Number)l3).longValue();
        long l4 = l2;
        boolean bl2 = false;
        long l5 = it * (long)1024;
        Long l6 = (Long)fields.get("VmSwap");
        if (l6 == null) {
            return null;
        }
        it = ((Number)l6).longValue();
        boolean bl3 = false;
        long l7 = it * (long)1024;
        Long l8 = (Long)fields.get("RssFile");
        if (l8 == null) {
            return null;
        }
        it = ((Number)l8).longValue();
        boolean bl4 = false;
        long l9 = it * (long)1024;
        long l10 = l9;
        long l11 = l7;
        long l12 = l5;
        long l13 = l4;
        return new LinuxMemoryStats(l13, l12, l11, l10).toMemoryStats();
    }

    @Override
    public void trimLinuxNativeHeap() {
        try {
            this.libc.malloc_trim(0L);
        }
        catch (UnsatisfiedLinkError e) {
            PlatformMemoryUtilKt.access$getLOG$p().error("Failed to trim native heap", (Throwable)e);
        }
    }

    private static final Pair getCurrentProcessMemoryStatsLinux$lambda$0$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String name2 = StringsKt.substringBefore$default((String)line, (String)":", null, (int)2, null);
        if (!INTERESTING_FIELDS.contains(name2)) {
            return null;
        }
        Long l = StringsKt.toLongOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null), (String)"kB", null, (int)2, null))).toString());
        if (l == null) {
            return null;
        }
        long value = l;
        return TuplesKt.to((Object)name2, (Object)value);
    }

    public static final /* synthetic */ PlatformMemoryUtil.MemoryStats access$getCurrentProcessMemoryStatsLinux(LinuxMemoryUtil $this) {
        return $this.getCurrentProcessMemoryStatsLinux();
    }

    static {
        Object[] objectArray = new String[]{"VmRSS", "VmSwap", "RssAnon", "RssFile"};
        INTERESTING_FIELDS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/LinuxMemoryUtil$Companion;", "", "<init>", "()V", "INTERESTING_FIELDS", "", "", "getINTERESTING_FIELDS", "()Ljava/util/List;", "intellij.platform.ide.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getINTERESTING_FIELDS() {
            return INTERESTING_FIELDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diagnostic/LinuxMemoryUtil$LibC;", "Lcom/sun/jna/Library;", "malloc_trim", "", "pad", "", "intellij.platform.ide.impl"})
    public static interface LibC
    extends Library {
        public boolean malloc_trim(long var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diagnostic/LinuxMemoryUtil$LinuxMemoryStats;", "", "rss", "", "rssAnon", "swap", "rssFile", "<init>", "(JJJJ)V", "getRss", "()J", "getRssAnon", "getSwap", "getRssFile", "toMemoryStats", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStats;", "intellij.platform.ide.impl"})
    private static final class LinuxMemoryStats {
        private final long rss;
        private final long rssAnon;
        private final long swap;
        private final long rssFile;

        public LinuxMemoryStats(long rss, long rssAnon, long swap, long rssFile) {
            this.rss = rss;
            this.rssAnon = rssAnon;
            this.swap = swap;
            this.rssFile = rssFile;
        }

        public final long getRss() {
            return this.rss;
        }

        public final long getRssAnon() {
            return this.rssAnon;
        }

        public final long getSwap() {
            return this.swap;
        }

        public final long getRssFile() {
            return this.rssFile;
        }

        @NotNull
        public final PlatformMemoryUtil.MemoryStats toMemoryStats() {
            return new PlatformMemoryUtil.MemoryStats(this.rss, this.rssAnon, this.rssAnon + this.swap, this.rssFile);
        }
    }
}

