/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.EditorHyperlinkEffectSupplier;
import com.intellij.execution.impl.EditorHyperlinkEffectSupportKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0007J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0018\u00010\tR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0018\u00010\tR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/impl/EditorHyperlinkEffectSupport;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "effectSupplier", "Lcom/intellij/execution/impl/EditorHyperlinkEffectSupplier;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/execution/impl/EditorHyperlinkEffectSupplier;)V", "followedLinkWrapper", "Lcom/intellij/execution/impl/EditorHyperlinkEffectSupport$ChangedAttrsLinkWrapper;", "hoveredLinkWrapper", "followedLink", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getFollowedLink", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "linkFollowed", "", "link", "linkHovered", "ChangedAttrsLinkWrapper", "intellij.platform.ide.impl"})
public final class EditorHyperlinkEffectSupport {
    @NotNull
    private final Editor editor;
    @NotNull
    private final EditorHyperlinkEffectSupplier effectSupplier;
    @Nullable
    private ChangedAttrsLinkWrapper followedLinkWrapper;
    @Nullable
    private ChangedAttrsLinkWrapper hoveredLinkWrapper;

    public EditorHyperlinkEffectSupport(@NotNull Editor editor2, @NotNull EditorHyperlinkEffectSupplier effectSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)effectSupplier, (String)"effectSupplier");
        this.editor = editor2;
        this.effectSupplier = effectSupplier;
    }

    @RequiresEdt(generateAssertion=false)
    @Nullable
    public final RangeHighlighter getFollowedLink() {
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper = this.followedLinkWrapper;
        return (RangeHighlighter)(changedAttrsLinkWrapper != null ? changedAttrsLinkWrapper.getLinkRangeHighlighter() : null);
    }

    @RequiresEdt(generateAssertion=false)
    public final void linkFollowed(@NotNull RangeHighlighter link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper = this.followedLinkWrapper;
        boolean bl = changedAttrsLinkWrapper != null ? changedAttrsLinkWrapper.isSame(link) : false;
        if (bl) {
            return;
        }
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper2 = this.followedLinkWrapper;
        if (changedAttrsLinkWrapper2 != null) {
            changedAttrsLinkWrapper2.restoreOriginalAttrs();
        }
        this.followedLinkWrapper = null;
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper3 = this.hoveredLinkWrapper;
        if (changedAttrsLinkWrapper3 != null) {
            changedAttrsLinkWrapper3.restoreOriginalAttrs();
        }
        this.hoveredLinkWrapper = null;
        if (link instanceof RangeHighlighterEx) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)link;
            TextAttributes textAttributes = this.effectSupplier.getFollowedHyperlinkAttributes((RangeHighlighterEx)link);
            if (textAttributes == null) {
                textAttributes = EditorHyperlinkEffectSupportKt.access$defaultFollowedHyperlinkAttributes();
            }
            this.followedLinkWrapper = new ChangedAttrsLinkWrapper(rangeHighlighterEx, textAttributes);
        }
    }

    @RequiresEdt(generateAssertion=false)
    public final void linkHovered(@Nullable RangeHighlighter link) {
        TextAttributes hoveredLinkAttrs;
        ThreadingAssertions.assertEventDispatchThread();
        if (link == null) {
            ChangedAttrsLinkWrapper changedAttrsLinkWrapper = this.hoveredLinkWrapper;
            if (changedAttrsLinkWrapper != null) {
                changedAttrsLinkWrapper.restoreOriginalAttrs();
            }
            this.hoveredLinkWrapper = null;
            return;
        }
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper = this.hoveredLinkWrapper;
        boolean bl = changedAttrsLinkWrapper != null ? changedAttrsLinkWrapper.isSame(link) : false;
        if (bl) {
            return;
        }
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper2 = this.followedLinkWrapper;
        boolean bl2 = changedAttrsLinkWrapper2 != null ? changedAttrsLinkWrapper2.isSame(link) : false;
        if (bl2) {
            return;
        }
        ChangedAttrsLinkWrapper changedAttrsLinkWrapper3 = this.hoveredLinkWrapper;
        if (changedAttrsLinkWrapper3 != null) {
            changedAttrsLinkWrapper3.restoreOriginalAttrs();
        }
        this.hoveredLinkWrapper = null;
        if (link instanceof RangeHighlighterEx && (hoveredLinkAttrs = this.effectSupplier.getHoveredHyperlinkAttributes((RangeHighlighterEx)link)) != null) {
            this.hoveredLinkWrapper = new ChangedAttrsLinkWrapper((RangeHighlighterEx)link, hoveredLinkAttrs);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/impl/EditorHyperlinkEffectSupport$ChangedAttrsLinkWrapper;", "", "linkRangeHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "newTextAttrs", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "<init>", "(Lcom/intellij/execution/impl/EditorHyperlinkEffectSupport;Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;Lcom/intellij/openapi/editor/markup/TextAttributes;)V", "getLinkRangeHighlighter", "()Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "originalTextAttrs", "isSame", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "restoreOriginalAttrs", "", "intellij.platform.ide.impl"})
    private final class ChangedAttrsLinkWrapper {
        @NotNull
        private final RangeHighlighterEx linkRangeHighlighter;
        @Nullable
        private final TextAttributes originalTextAttrs;

        public ChangedAttrsLinkWrapper(@NotNull RangeHighlighterEx linkRangeHighlighter, TextAttributes newTextAttrs) {
            Intrinsics.checkNotNullParameter((Object)linkRangeHighlighter, (String)"linkRangeHighlighter");
            Intrinsics.checkNotNullParameter((Object)newTextAttrs, (String)"newTextAttrs");
            this.linkRangeHighlighter = linkRangeHighlighter;
            this.originalTextAttrs = this.linkRangeHighlighter.getTextAttributes(EditorHyperlinkEffectSupport.this.editor.getColorsScheme());
            this.linkRangeHighlighter.setTextAttributes(newTextAttrs);
        }

        @NotNull
        public final RangeHighlighterEx getLinkRangeHighlighter() {
            return this.linkRangeHighlighter;
        }

        public final boolean isSame(@NotNull RangeHighlighter linkRangeHighlighter) {
            Intrinsics.checkNotNullParameter((Object)linkRangeHighlighter, (String)"linkRangeHighlighter");
            return this.linkRangeHighlighter == linkRangeHighlighter;
        }

        public final void restoreOriginalAttrs() {
            if (this.linkRangeHighlighter.isValid()) {
                this.linkRangeHighlighter.setTextAttributes(this.originalTextAttrs);
            }
        }
    }
}

