/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.help.impl.HelpManagerImpl;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CreateLauncherScriptAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    private static final String TOPIC = "Working_with_the_IDE_Features_from_Command_Line";

    CreateLauncherScriptAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateLauncherScriptAction.$$$reportNull$$$0(1);
        }
        CreateLauncherScriptAction.showInstructions(event.getProject());
    }

    private static void showInstructions(@Nullable Project project2) {
        String message;
        if (ExternalUpdateManager.ACTUAL == ExternalUpdateManager.TOOLBOX) {
            message = ApplicationBundle.message((String)"cli.launcher.message.toolbox", (Object[])new Object[0]);
        } else if (ExternalUpdateManager.ACTUAL == ExternalUpdateManager.SNAP) {
            String name2 = ApplicationNamesInfo.getInstance().getScriptName();
            message = ApplicationBundle.message((String)"cli.launcher.message.snap", (Object[])new Object[]{name2});
        } else if (SystemInfo.isWindows) {
            Path dir = Path.of(PathManager.getBinPath(), new String[0]);
            String name1 = ApplicationNamesInfo.getInstance().getScriptName() + ".bat";
            String name2 = ApplicationNamesInfo.getInstance().getScriptName() + "64.exe";
            String url = HelpManagerImpl.getHelpUrl(TOPIC);
            message = ApplicationBundle.message((String)"cli.launcher.message.windows", (Object[])new Object[]{dir, name1, name2, url});
        } else if (SystemInfo.isMac) {
            Path dir = Path.of(PathManager.getHomePath(), new String[0]).resolve("MacOS");
            String name3 = ApplicationNamesInfo.getInstance().getScriptName();
            String url = HelpManagerImpl.getHelpUrl(TOPIC);
            message = ApplicationBundle.message((String)"cli.launcher.message.unix", (Object[])new Object[]{dir, name3, url});
        } else {
            Path dir = Path.of(PathManager.getBinPath(), new String[0]);
            String name4 = ApplicationNamesInfo.getInstance().getScriptName() + (Boolean.getBoolean("ide.native.launcher") ? "" : ".sh");
            String url = HelpManagerImpl.getHelpUrl(TOPIC);
            message = ApplicationBundle.message((String)"cli.launcher.message.unix", (Object[])new Object[]{dir, name4, url});
        }
        Messages.showInfoMessage((Project)project2, (String)message, (String)ApplicationBundle.message((String)"cli.launcher.message.title", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateLauncherScriptAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateLauncherScriptAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    static final class ObsoleteScriptLookupTask
    implements AppLifecycleListener {
        private static final String MARKER1 = "{0} [-l|--line line] [project_dir|--temp-project] [-w|--wait] file[:line]";
        private static final String MARKER2 = "def try_activate_instance(args):";

        ObsoleteScriptLookupTask() {
        }

        public void appStarted() {
            Application app = ApplicationManager.getApplication();
            if (!(app.isCommandLine() || app.isHeadlessEnvironment() || app.isUnitTestMode())) {
                ProcessIOExecutorService.INSTANCE.execute(() -> {
                    try {
                        String content2;
                        String launcherName;
                        String scriptName = switch (launcherName = ApplicationNamesInfo.getInstance().getScriptName()) {
                            case "phpstorm" -> "pstorm";
                            case "pycharm" -> "charm";
                            case "rubymine" -> "mine";
                            default -> launcherName;
                        };
                        File scriptFile = PathEnvironmentVariableUtil.findInPath((String)scriptName);
                        if (scriptFile != null && (content2 = Files.readString(scriptFile.toPath())).contains(MARKER1) && content2.contains(MARKER2) && !app.isDisposed()) {
                            String title2 = ApplicationBundle.message((String)"cli.launcher.obsolete.title", (Object[])new Object[0]);
                            String message = ApplicationBundle.message((String)"cli.launcher.obsolete.message", (Object[])new Object[]{scriptFile});
                            new Notification("IDE and Plugin Updates", title2, message, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimple((String)ApplicationBundle.message((String)"cli.launcher.obsolete.action", (Object[])new Object[0]), () -> CreateLauncherScriptAction.showInstructions(null))).notify(null);
                        }
                    }
                    catch (Exception e) {
                        Logger.getInstance(ObsoleteScriptLookupTask.class).info((Throwable)e);
                    }
                });
            }
        }
    }
}

