/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ToggleReadOnlyAttributeAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleReadOnlyAttributeAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(files2.length > 0);
        if (files2.length > 0) {
            int ro = 0;
            int rw = 0;
            int f = 0;
            int d = 0;
            for (VirtualFile file2 : files2) {
                if (file2.isWritable()) {
                    ++rw;
                } else {
                    ++ro;
                }
                if (file2.isDirectory()) {
                    ++d;
                    continue;
                }
                ++f;
            }
            int finalRo = ro;
            int finalRw = rw;
            int finalF = f;
            int finalD = d;
            if (ro > 0 && rw > 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer((String)"action.ToggleReadOnlyAttribute.text", (Object[])new Object[0]));
            } else if (f > 0 && d == 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer((String)"action.ToggleReadOnlyAttribute.files", (Object[])new Object[]{finalRo, finalRw, finalF, finalD}));
            } else if (f == 0 && d > 0) {
                e.getPresentation().setText(ActionsBundle.messagePointer((String)"action.ToggleReadOnlyAttribute.dirs", (Object[])new Object[]{finalRo, finalRw, finalF, finalD}));
            } else {
                e.getPresentation().setText(ActionsBundle.messagePointer((String)"action.ToggleReadOnlyAttribute.mixed", (Object[])new Object[]{finalRo, finalRw, finalF, finalD}));
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToggleReadOnlyAttributeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2;
        if (e == null) {
            ToggleReadOnlyAttributeAction.$$$reportNull$$$0(2);
        }
        if ((files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext())).length > 0) {
            WriteAction.run(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                try {
                    for (VirtualFile file2 : files2) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)file2.isWritable());
                    }
                }
                catch (IOException x) {
                    Notifications.Bus.notify((Notification)new Notification("System Messages", CommonBundle.getErrorTitle(), x.getMessage(), NotificationType.ERROR), (Project)e.getProject());
                }
            });
        }
    }

    private static VirtualFile[] getFiles(DataContext context) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        return files2 == null ? VirtualFile.EMPTY_ARRAY : (VirtualFile[])Stream.of(files2).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToggleReadOnlyAttributeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToggleReadOnlyAttributeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

