/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DropActionHandler;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.FileFlavorProvider;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DnDEventImpl
extends UserDataHolderBase
implements Transferable,
DnDEvent {
    private static final Logger LOG = Logger.getInstance(DnDEventImpl.class);
    public static final DataFlavor ourDataFlavor = FileCopyPasteUtil.createDataFlavor("application/x-java-jvm-local-objectref");
    private DnDTarget myDelegatedTarget;
    private DnDManagerImpl myManager;
    private DnDAction myAction;
    private Object myAttachedObject;
    private boolean myDropPossible;
    private @NlsContexts.PopupContent String myExpectedDropResult;
    private Point myPoint;
    private Point myOrgPoint;
    private int myHighlighting;
    private DropActionHandler myDropHandler;
    private Component myHandlerComponent;
    private boolean myShouldRemoveHighlighter = true;
    private Point myLocalPoint;
    private Cursor myCursor;

    public DnDEventImpl(DnDManagerImpl manager2, DnDAction action2, Object attachedObject, Point point) {
        this.myManager = manager2;
        this.myAction = action2;
        this.myAttachedObject = attachedObject;
        this.myPoint = point;
    }

    public DnDAction getAction() {
        return this.myAction;
    }

    public void updateAction(@NotNull DnDAction action2) {
        if (action2 == null) {
            DnDEventImpl.$$$reportNull$$$0(0);
        }
        this.myAction = action2;
    }

    public Object getAttachedObject() {
        return this.myAttachedObject;
    }

    public void setDropPossible(boolean possible, @NlsContexts.PopupContent @Nullable String aExpectedResult) {
        this.myDropPossible = possible;
        this.myExpectedDropResult = aExpectedResult;
        this.clearDropHandler();
    }

    public void setDropPossible(boolean possible) {
        this.setDropPossible(possible, null);
    }

    public void setDropPossible(@NlsContexts.PopupContent String aExpectedResult, DropActionHandler aHandler) {
        this.myDropPossible = true;
        this.myExpectedDropResult = aExpectedResult;
        this.myDropHandler = aHandler;
    }

    public String getExpectedDropResult() {
        return this.myExpectedDropResult;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.myAttachedObject instanceof Transferable) {
            return ((Transferable)this.myAttachedObject).getTransferDataFlavors();
        }
        if (this.myAttachedObject instanceof FileFlavorProvider) {
            return new DataFlavor[]{ourDataFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor};
        }
        if (this.myAttachedObject instanceof DnDNativeTarget.EventInfo) {
            return ((DnDNativeTarget.EventInfo)this.myAttachedObject).getFlavors();
        }
        if (this.myAttachedObject instanceof GutterIconRenderer) {
            return GutterDraggableObject.getFlavors();
        }
        return new DataFlavor[]{ourDataFlavor};
    }

    @Override
    @NotNull
    public Object getTransferData(DataFlavor flavor2) throws UnsupportedFlavorException, IOException {
        List<File> files2;
        if (this.myAttachedObject instanceof Transferable) {
            Object object = ((Transferable)this.myAttachedObject).getTransferData(flavor2);
            if (object == null) {
                DnDEventImpl.$$$reportNull$$$0(1);
            }
            return object;
        }
        if (this.myAttachedObject instanceof FileFlavorProvider && flavor2 == DataFlavor.javaFileListFlavor) {
            List<File> files3 = ((FileFlavorProvider)this.myAttachedObject).asFileList();
            if (files3 != null) {
                List<File> list2 = files3;
                if (list2 == null) {
                    DnDEventImpl.$$$reportNull$$$0(2);
                }
                return list2;
            }
        } else if (this.myAttachedObject instanceof FileFlavorProvider && flavor2 == LinuxDragAndDropSupport.uriListFlavor && (files2 = ((FileFlavorProvider)this.myAttachedObject).asFileList()) != null) {
            String string = LinuxDragAndDropSupport.toUriList(files2);
            if (string == null) {
                DnDEventImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        Object object = this.getAttachedObject();
        if (object == null) {
            DnDEventImpl.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor2) {
        Object[] flavors = this.getTransferDataFlavors();
        return ArrayUtil.find((Object[])flavors, (Object)flavor2) != -1;
    }

    public boolean isDropPossible() {
        return this.myDropPossible;
    }

    public Point getOrgPoint() {
        return this.myOrgPoint;
    }

    public void setOrgPoint(Point orgPoint) {
        this.myOrgPoint = orgPoint;
    }

    void setPoint(Point aPoint) {
        this.myPoint = aPoint;
    }

    public Point getPoint() {
        return this.myPoint;
    }

    public Point getPointOn(Component aComponent) {
        return SwingUtilities.convertPoint(this.myHandlerComponent, this.getPoint(), aComponent);
    }

    void clearDropHandler() {
        this.myDropHandler = null;
    }

    public boolean canHandleDrop() {
        LOG.debug("canHandleDrop:" + String.valueOf(this.myDropHandler));
        return this.myDropHandler != null;
    }

    void handleDrop() {
        this.myDropHandler.performDrop((DnDEvent)this);
    }

    void setHandlerComponent(Component aOverComponent) {
        this.myHandlerComponent = aOverComponent;
    }

    public Component getHandlerComponent() {
        return this.myHandlerComponent;
    }

    public Component getCurrentOverComponent() {
        return this.getHandlerComponent().getComponentAt(this.getPoint());
    }

    public void setHighlighting(Component aComponent, int aType) {
        this.myManager.showHighlighter(aComponent, aType, (DnDEvent)this);
        this.myHighlighting = aType;
    }

    public void setHighlighting(RelativeRectangle rectangle, int aType) {
        this.myManager.showHighlighter(rectangle, aType, (DnDEvent)this);
        this.myHighlighting = aType;
    }

    public void setHighlighting(JLayeredPane layeredPane2, RelativeRectangle rectangle, int aType) {
        this.myManager.showHighlighter(layeredPane2, rectangle, aType, this);
    }

    boolean shouldRemoveHighlighting() {
        return this.myShouldRemoveHighlighter;
    }

    public void setAutoHideHighlighterInDrop(boolean aValue) {
        this.myShouldRemoveHighlighter = aValue;
    }

    public void hideHighlighter() {
        this.myManager.hideCurrentHighlighter();
        this.myHighlighting = 0;
    }

    public void setLocalPoint(Point localPoint) {
        this.myLocalPoint = localPoint;
    }

    public Point getLocalPoint() {
        return this.myLocalPoint;
    }

    public RelativePoint getRelativePoint() {
        return new RelativePoint(this.getCurrentOverComponent(), this.getPoint());
    }

    public void clearDelegatedTarget() {
        this.myDelegatedTarget = null;
    }

    public boolean wasDelegated() {
        return this.myDelegatedTarget != null;
    }

    public DnDTarget getDelegatedTarget() {
        return this.myDelegatedTarget;
    }

    public boolean delegateUpdateTo(DnDTarget target) {
        this.myDelegatedTarget = target;
        return this.myDelegatedTarget.update((DnDEvent)this);
    }

    public void delegateDropTo(DnDTarget target) {
        this.myDelegatedTarget = target;
        target.drop((DnDEvent)this);
    }

    protected Object clone() {
        DnDEventImpl result2 = new DnDEventImpl(this.myManager, this.myAction, this.myAttachedObject, this.myPoint);
        result2.myDropHandler = this.myDropHandler;
        result2.myDropPossible = this.myDropPossible;
        result2.myExpectedDropResult = this.myExpectedDropResult;
        result2.myHighlighting = this.myHighlighting;
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnDEventImpl)) {
            return false;
        }
        DnDEventImpl event = (DnDEventImpl)o;
        if (this.myDropPossible != event.myDropPossible) {
            return false;
        }
        if (this.myHighlighting != event.myHighlighting) {
            return false;
        }
        if (this.myAttachedObject != null ? !this.myAttachedObject.equals(event.myAttachedObject) : event.myAttachedObject != null) {
            return false;
        }
        return !(this.myExpectedDropResult != null ? !this.myExpectedDropResult.equals(event.myExpectedDropResult) : event.myExpectedDropResult != null);
    }

    public int hashCode() {
        int result2 = this.myAttachedObject != null ? this.myAttachedObject.hashCode() : 0;
        result2 = 29 * result2 + (this.myDropPossible ? 1 : 0);
        result2 = 29 * result2 + (this.myExpectedDropResult != null ? this.myExpectedDropResult.hashCode() : 0);
        result2 = 29 * result2 + this.myHighlighting;
        return result2;
    }

    public Cursor getCursor() {
        return this.myCursor;
    }

    @NonNls
    public String toString() {
        return "DnDEvent[attachedObject: " + String.valueOf(this.myAttachedObject) + ", delegatedTarget: " + String.valueOf(this.myDelegatedTarget) + ", dropHandler: " + String.valueOf(this.myDropHandler) + "]";
    }

    public void setCursor(Cursor cursor) {
        this.myCursor = cursor;
    }

    public void cleanUp() {
        this.myAttachedObject = null;
        this.myDelegatedTarget = null;
        this.myDropHandler = null;
        this.myHandlerComponent = null;
        this.myManager = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/DnDEventImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/DnDEventImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

