/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.InstallationSourceEnum;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginInstallOperation {
    private static final Logger LOG = Logger.getInstance(PluginInstallOperation.class);
    private static final Cache<@NotNull String, Optional<PluginId>> ourModuleResolutionCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    @NotNull
    private final List<PluginUiModel> myPluginsToInstall;
    @NotNull
    private final Collection<PluginUiModel> myCustomReposPlugins;
    @NotNull
    private final PluginEnabler myPluginEnabler;
    @NotNull
    private final ProgressIndicator myIndicator;
    private boolean mySuccess;
    private final Set<PluginInstallCallbackData> myDependant;
    private boolean myAllowInstallWithoutRestart;
    private final List<PendingDynamicPluginInstall> myPendingDynamicPluginInstalls;
    private boolean myRestartRequired;
    private boolean myShownErrors;
    private static final Map<PluginId, ActionCallback> ourInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
    private final Map<PluginId, ActionCallback> myLocalInstallCallbacks;
    private final Map<PluginId, ActionCallback> myLocalWaitInstallCallbacks;
    private static final Object ourInstallLock = new Object();

    public PluginInstallOperation(@NotNull List<PluginNode> pluginsToInstall, @NotNull Collection<PluginNode> customReposPlugins, @NotNull PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator2) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(0);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(1);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(2);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(3);
        }
        this(ContainerUtil.map(pluginsToInstall, PluginUiModelAdapter::new), ContainerUtil.map(customReposPlugins, PluginUiModelAdapter::new), indicator2, pluginEnabler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginInstallOperation(@NotNull List<PluginUiModel> pluginsToInstall, @NotNull Collection<PluginUiModel> customReposPlugins, @NotNull ProgressIndicator indicator2, @NotNull PluginEnabler pluginEnabler) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(4);
        }
        if (customReposPlugins == null) {
            PluginInstallOperation.$$$reportNull$$$0(5);
        }
        if (indicator2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(6);
        }
        if (pluginEnabler == null) {
            PluginInstallOperation.$$$reportNull$$$0(7);
        }
        this.mySuccess = true;
        this.myDependant = new HashSet<PluginInstallCallbackData>();
        this.myAllowInstallWithoutRestart = false;
        this.myPendingDynamicPluginInstalls = new ArrayList<PendingDynamicPluginInstall>();
        this.myRestartRequired = false;
        this.myLocalInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myLocalWaitInstallCallbacks = new IdentityHashMap<PluginId, ActionCallback>();
        this.myPluginsToInstall = pluginsToInstall;
        this.myCustomReposPlugins = customReposPlugins;
        this.myPluginEnabler = pluginEnabler;
        this.myIndicator = indicator2;
        Object object = ourInstallLock;
        synchronized (object) {
            for (PluginUiModel node : pluginsToInstall) {
                PluginId id2 = node.getPluginId();
                ActionCallback callback = ourInstallCallbacks.get(id2);
                if (callback == null) {
                    this.createInstallCallback(id2);
                    continue;
                }
                this.myLocalWaitInstallCallbacks.put(id2, callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstallCallback(@NotNull PluginId id2, @NotNull ActionCallback callback, boolean isDone) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            PluginInstallOperation.$$$reportNull$$$0(9);
        }
        Object object = ourInstallLock;
        synchronized (object) {
            ActionCallback oldValue = ourInstallCallbacks.get(id2);
            if (oldValue == callback) {
                ourInstallCallbacks.remove(id2);
            }
        }
        if (isDone) {
            callback.setDone();
        } else {
            callback.setRejected();
        }
    }

    private void createInstallCallback(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginInstallOperation.$$$reportNull$$$0(10);
        }
        ActionCallback callback = new ActionCallback();
        ourInstallCallbacks.put(id2, callback);
        this.myLocalInstallCallbacks.put(id2, callback);
    }

    public void setAllowInstallWithoutRestart(boolean allowInstallWithoutRestart) {
        this.myAllowInstallWithoutRestart = allowInstallWithoutRestart;
    }

    public List<PendingDynamicPluginInstall> getPendingDynamicPluginInstalls() {
        return this.myPendingDynamicPluginInstalls;
    }

    public boolean isRestartRequired() {
        return this.myRestartRequired;
    }

    public void run() {
        this.updateUrls();
        this.mySuccess = this.prepareToInstall(this.myPluginsToInstall);
    }

    public boolean isSuccess() {
        return this.mySuccess;
    }

    public Set<PluginInstallCallbackData> getInstalledDependentPlugins() {
        return this.myDependant;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    private void updateUrls() {
        boolean unknownNodes = false;
        for (PluginUiModel node : this.myPluginsToInstall) {
            if (!Strings.areSameInstance((String)node.getRepositoryName(), (String)"__unknown_repository__")) continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        HashMap<PluginId, PluginUiModel> allPlugins = new HashMap<PluginId, PluginUiModel>();
        for (String host : RepositoryHelper.getCustomPluginRepositoryHosts()) {
            try {
                for (PluginUiModel descriptor2 : RepositoryHelper.loadPluginModels(host, null, this.myIndicator)) {
                    allPlugins.put(descriptor2.getPluginId(), descriptor2);
                }
            }
            catch (IOException iOException) {
            }
        }
        for (PluginUiModel node : this.myPluginsToInstall) {
            if (!Strings.areSameInstance((String)node.getRepositoryName(), (String)"__unknown_repository__")) continue;
            PluginUiModel descriptor3 = (PluginUiModel)allPlugins.get(node.getPluginId());
            node.setRepositoryName(descriptor3 != null ? descriptor3.getRepositoryName() : null);
            String oldUrl = node.getDownloadUrl();
            if (descriptor3 != null) {
                node.setDownloadUrl(descriptor3.getDownloadUrl());
            }
            LOG.info("updateUrls for node: " + String.valueOf(node.getPluginId()) + " | " + node.getVersion() + " | " + oldUrl + " to: " + node.getRepositoryName() + " | " + node.getDownloadUrl());
        }
    }

    private boolean prepareToInstall(@NotNull List<PluginUiModel> pluginsToInstall) {
        if (pluginsToInstall == null) {
            PluginInstallOperation.$$$reportNull$$$0(11);
        }
        SmartList pluginIdsBeingInstalled = new SmartList();
        for (PluginUiModel pluginNode : pluginsToInstall) {
            pluginIdsBeingInstalled.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginUiModel pluginNode : pluginsToInstall) {
            this.myIndicator.setText(pluginNode.getName());
            try {
                result2 |= this.prepareToInstallWithCallback(pluginNode, (List<PluginId>)pluginIdsBeingInstalled);
            }
            catch (IOException e) {
                String title2 = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                LOG.warn((Throwable)e);
                NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup("Plugin Error");
                Notifications.Bus.notify((Notification)group2.createNotification(title2, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    private boolean prepareToInstallWithCallback(@NotNull PluginUiModel pluginNode, @NotNull List<PluginId> pluginIdsBeingInstalled) throws IOException {
        PluginId id2;
        ActionCallback localCallback;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(12);
        }
        if (pluginIdsBeingInstalled == null) {
            PluginInstallOperation.$$$reportNull$$$0(13);
        }
        if ((localCallback = this.myLocalInstallCallbacks.remove(id2 = pluginNode.getPluginId())) == null) {
            ActionCallback callback = this.myLocalWaitInstallCallbacks.remove(id2);
            if (callback == null) {
                return this.prepareToInstall(pluginNode, pluginIdsBeingInstalled);
            }
            return callback.waitFor(-1L) && callback.isDone();
        }
        try {
            boolean result2 = this.prepareToInstall(pluginNode, pluginIdsBeingInstalled);
            PluginInstallOperation.removeInstallCallback(id2, localCallback, result2);
            return result2;
        }
        catch (IOException | RuntimeException e) {
            PluginInstallOperation.removeInstallCallback(id2, localCallback, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private boolean prepareToInstall(@NotNull PluginUiModel pluginNode, @NotNull List<PluginId> pluginIdsBeingInstalled) throws IOException {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(14);
        }
        if (pluginIdsBeingInstalled == null) {
            PluginInstallOperation.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!PluginManagementPolicy.getInstance().canInstallPlugin(pluginNode.getDescriptor())) {
            LOG.warn("The plugin " + String.valueOf(pluginNode.getPluginId()) + " is not allowed to install for the organization");
            return false;
        }
        IdeaPluginDescriptor toDisable = this.checkDependenciesAndReplacements(pluginNode.getDescriptor());
        this.myShownErrors = false;
        PluginDownloader downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null);
        IdeaPluginDescriptor previousDescriptor = PluginManagerCore.getPlugin((PluginId)pluginNode.getPluginId());
        String previousVersion = previousDescriptor == null ? null : previousDescriptor.getVersion();
        PluginManagerUsageCollector.pluginInstallationStarted(pluginNode.getDescriptor(), downloader.isFromMarketplace() ? InstallationSourceEnum.MARKETPLACE : InstallationSourceEnum.CUSTOM_REPOSITORY, previousVersion);
        boolean prepared = downloader.prepareToInstall(this.myIndicator);
        if (prepared) {
            boolean allowNoRestart;
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)downloader.getDescriptor();
            if (!this.checkMissingDependencies((IdeaPluginDescriptor)descriptor2, pluginIdsBeingInstalled)) {
                return false;
            }
            boolean bl = allowNoRestart = this.myAllowInstallWithoutRestart && DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2, null, ContainerUtil.map(this.myPendingDynamicPluginInstalls, pluginInstall -> pluginInstall.getPluginDescriptor()));
            if (allowNoRestart) {
                this.myPendingDynamicPluginInstalls.add(new PendingDynamicPluginInstall(downloader.getFilePath(), descriptor2));
                state = InstalledPluginsState.getInstanceIfLoaded();
                if (state != null) {
                    ((InstalledPluginsState)state).onPluginInstall(downloader.getDescriptor(), false, false);
                }
            } else {
                this.myRestartRequired = true;
                state = PluginInstaller.ourLock;
                synchronized (state) {
                    downloader.install();
                }
            }
            this.myDependant.add(new PluginInstallCallbackData(downloader.getFilePath(), (IdeaPluginDescriptor)descriptor2, !allowNoRestart));
            IdeaPluginDescriptor ideaPluginDescriptor = pluginNode.getDescriptor();
            if (ideaPluginDescriptor instanceof PluginNode) {
                PluginNode node = (PluginNode)ideaPluginDescriptor;
                node.setStatus(PluginNode.Status.DOWNLOADED);
            }
            if (toDisable != null) {
                this.myPluginEnabler.disable(Set.of(toDisable));
            }
            return true;
        }
        this.myShownErrors = downloader.isShownErrors();
        return false;
    }

    @Nullable
    IdeaPluginDescriptor checkDependenciesAndReplacements(@NotNull IdeaPluginDescriptor pluginNode) {
        PluginReplacement pluginReplacement;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(16);
        }
        if ((pluginReplacement = (PluginReplacement)ContainerUtil.find((Object[])((PluginReplacement[])PluginReplacement.EP_NAME.getExtensions()), r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()))) == null) {
            return null;
        }
        PluginId oldPluginId = pluginReplacement.getOldPluginDescriptor().getPluginId();
        IdeaPluginDescriptor oldPlugin = PluginManagerCore.getPlugin((PluginId)oldPluginId);
        if (oldPlugin == null) {
            LOG.warn("Plugin with id '" + String.valueOf(oldPluginId) + "' not found");
            return null;
        }
        if (this.myPluginEnabler.isDisabled(oldPlugin.getPluginId())) {
            return null;
        }
        AtomicBoolean toDisable = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            boolean choice = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)pluginReplacement.getReplacementMessage(oldPlugin, pluginNode), (String)IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0])).yesText(IdeBundle.message((String)"plugins.configurable.disable", (Object[])new Object[0]))).noText(Messages.getNoButton())).icon(Messages.getWarningIcon())).guessWindowAndAsk();
            toDisable.set(choice);
        }, ModalityState.any());
        return toDisable.get() ? oldPlugin : null;
    }

    boolean checkMissingDependencies(@NotNull IdeaPluginDescriptor pluginNode, @Nullable List<PluginId> pluginIdsBeingInstalled) {
        PluginSet pluginSet;
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(17);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking missing dependencies for " + String.valueOf(pluginNode) + ". Plugins being installed: " + String.valueOf(pluginIdsBeingInstalled));
        }
        Set existingPluginIds = (pluginSet = PluginManagerCore.getPluginSetOrNull()) != null ? pluginSet.buildPluginIdMap().keySet() : Collections.emptySet();
        Set existingContentModuleIds = pluginSet != null ? pluginSet.buildContentModuleIdMap().keySet() : Collections.emptySet();
        HashSet<PluginId> addedPluginIdsAfterInstallation = new HashSet<PluginId>();
        HashSet<PluginModuleId> addedContentModuleIdsAfterInstallation = new HashSet<PluginModuleId>();
        addedPluginIdsAfterInstallation.add(pluginNode.getPluginId());
        if (pluginIdsBeingInstalled != null) {
            addedPluginIdsAfterInstallation.addAll(pluginIdsBeingInstalled);
        }
        if (pluginNode instanceof PluginMainDescriptor) {
            PluginMainDescriptor pluginDescriptor = (PluginMainDescriptor)pluginNode;
            addedPluginIdsAfterInstallation.addAll(pluginDescriptor.getPluginAliases());
            for (ContentModuleDescriptor module2 : pluginDescriptor.getContentModules()) {
                addedPluginIdsAfterInstallation.addAll(module2.getPluginAliases());
                addedContentModuleIdsAfterInstallation.add(module2.getModuleId());
            }
        }
        HashMap missingRequiredPlugins = new HashMap();
        HashMap<PluginId, PluginUiModel> missingOptionalPlugins = new HashMap<PluginId, PluginUiModel>();
        for (IdeaPluginDependency dependency : pluginNode.getDependencies()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing depends dependency: " + String.valueOf(dependency.getPluginId()) + " optional=" + dependency.isOptional());
            }
            PluginId dependencyId = dependency.getPluginId();
            HashMap<Object, PluginUiModel> targetCollector = dependency.isOptional() ? missingOptionalPlugins : missingRequiredPlugins;
            Function<PluginId, Boolean> shouldSkip = pluginId -> {
                PluginModuleId pluginIdAsModuleId = PluginModuleId.getId((String)pluginId.getIdString(), (String)"jetbrains");
                return existingPluginIds.contains(pluginId) || existingContentModuleIds.contains(pluginIdAsModuleId) || addedPluginIdsAfterInstallation.contains(pluginId) || addedContentModuleIdsAfterInstallation.contains(pluginIdAsModuleId) || InstalledPluginsState.getInstance().wasInstalled((PluginId)pluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart((PluginId)pluginId) || targetCollector.containsKey(pluginId);
            };
            if (shouldSkip.apply(dependencyId).booleanValue()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Dependency is already satisfied");
                continue;
            }
            PluginId resolvedDependencyId = PluginInstallOperation.resolveModuleInMarketplaceWithCache(dependencyId.getIdString());
            if (resolvedDependencyId == null) {
                resolvedDependencyId = dependencyId;
            }
            if (LOG.isDebugEnabled() && !resolvedDependencyId.equals((Object)dependencyId)) {
                LOG.debug("Dependency is resolved into " + String.valueOf(resolvedDependencyId));
            }
            if (shouldSkip.apply(resolvedDependencyId).booleanValue()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Dependency is already satisfied");
                continue;
            }
            PluginUiModel depPluginDescriptor = this.findPluginInRepo(resolvedDependencyId);
            if (depPluginDescriptor != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + String.valueOf(resolvedDependencyId) + " to missing dependencies (optional=" + dependency.isOptional() + ")");
                }
                targetCollector.put(resolvedDependencyId, depPluginDescriptor);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Plugin " + String.valueOf(resolvedDependencyId) + " is not found in the repository");
        }
        if (pluginNode instanceof PluginMainDescriptor) {
            PluginMainDescriptor pluginDescriptor = (PluginMainDescriptor)pluginNode;
            Function<PluginModuleDescriptor, Void> processRequiredModuleDependencies = module -> {
                ContentModuleDescriptor contentModule;
                for (PluginId dependencyPluginId : module.getModuleDependencies().getPlugins()) {
                    Function<PluginId, Boolean> shouldSkip;
                    if (LOG.isDebugEnabled()) {
                        Object object;
                        String string = dependencyPluginId.getIdString();
                        if (module instanceof ContentModuleDescriptor) {
                            contentModule = (ContentModuleDescriptor)module;
                            object = "content module " + contentModule.getModuleNameString();
                        } else {
                            object = "main descriptor";
                        }
                        LOG.debug("Processing v2 plugin dependency: " + string + " in " + (String)object);
                    }
                    if ((shouldSkip = pluginId -> existingPluginIds.contains(pluginId) || addedPluginIdsAfterInstallation.contains(pluginId) || InstalledPluginsState.getInstance().wasInstalled((PluginId)pluginId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart((PluginId)pluginId) || missingRequiredPlugins.containsKey(pluginId)).apply(dependencyPluginId).booleanValue()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Dependency is already satisfied");
                        continue;
                    }
                    PluginId resolvedDependencyId = PluginInstallOperation.resolveModuleInMarketplaceWithCache(dependencyPluginId.getIdString());
                    if (resolvedDependencyId == null) {
                        resolvedDependencyId = dependencyPluginId;
                    }
                    if (LOG.isDebugEnabled() && !resolvedDependencyId.equals((Object)dependencyPluginId)) {
                        LOG.debug("Dependency is resolved into " + String.valueOf(resolvedDependencyId));
                    }
                    if (shouldSkip.apply(resolvedDependencyId).booleanValue()) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Dependency is already satisfied");
                        continue;
                    }
                    PluginUiModel depPluginDescriptor = this.findPluginInRepo(resolvedDependencyId);
                    if (depPluginDescriptor != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding " + String.valueOf(resolvedDependencyId) + " to missing dependencies");
                        }
                        missingRequiredPlugins.put(resolvedDependencyId, depPluginDescriptor);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Plugin " + String.valueOf(resolvedDependencyId) + " is not found in the repository");
                }
                for (PluginModuleId dependencyModuleId : module.getModuleDependencies().getModules()) {
                    if (LOG.isDebugEnabled()) {
                        Object object;
                        String string = dependencyModuleId.getName();
                        if (module instanceof ContentModuleDescriptor) {
                            contentModule = (ContentModuleDescriptor)module;
                            object = "content module " + contentModule.getModuleNameString();
                        } else {
                            object = "main descriptor";
                        }
                        LOG.debug("Processing v2 module dependency: " + string + " in " + (String)object);
                    }
                    if (existingContentModuleIds.contains(dependencyModuleId) || addedContentModuleIdsAfterInstallation.contains(dependencyModuleId)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Dependency is already satisfied");
                        continue;
                    }
                    PluginId resolvedDependencyId = PluginInstallOperation.resolveModuleInMarketplaceWithCache(dependencyModuleId.getName());
                    if (resolvedDependencyId == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Dependency is not resolved");
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dependency is resolved into " + String.valueOf(resolvedDependencyId));
                    }
                    if (existingPluginIds.contains(resolvedDependencyId) || addedPluginIdsAfterInstallation.contains(resolvedDependencyId) || InstalledPluginsState.getInstance().wasInstalled(resolvedDependencyId) || InstalledPluginsState.getInstance().wasInstalledWithoutRestart(resolvedDependencyId) || missingRequiredPlugins.containsKey(resolvedDependencyId)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Dependency is already satisfied");
                        continue;
                    }
                    PluginUiModel depPluginDescriptor = this.findPluginInRepo(resolvedDependencyId);
                    if (depPluginDescriptor != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding " + String.valueOf(resolvedDependencyId) + " to missing dependencies");
                        }
                        missingRequiredPlugins.put(resolvedDependencyId, depPluginDescriptor);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Plugin " + String.valueOf(resolvedDependencyId) + " is not found in the repository");
                }
                return null;
            };
            processRequiredModuleDependencies.apply((PluginModuleDescriptor)pluginDescriptor);
            for (ContentModuleDescriptor module3 : pluginDescriptor.getContentModules()) {
                if (!module3.getModuleLoadingRule().getRequired()) continue;
                processRequiredModuleDependencies.apply((PluginModuleDescriptor)module3);
            }
        }
        if (!this.prepareDependencies(pluginNode, missingRequiredPlugins.values().stream().toList(), "plugin.manager.dependencies.detected.title", "plugin.manager.dependencies.detected.message", false)) {
            return false;
        }
        return !Registry.is((String)"ide.plugins.suggest.install.optional.dependencies") || this.prepareDependencies(pluginNode, missingOptionalPlugins.values().stream().toList(), "plugin.manager.optional.dependencies.detected.title", "plugin.manager.optional.dependencies.detected.message", true);
    }

    private boolean prepareDependencies(@NotNull IdeaPluginDescriptor pluginNode, @NotNull List<PluginUiModel> dependencies, @NotNull @NonNls String titleKey, @NotNull @NonNls String messageKey, boolean askConfirmation) {
        if (pluginNode == null) {
            PluginInstallOperation.$$$reportNull$$$0(18);
        }
        if (dependencies == null) {
            PluginInstallOperation.$$$reportNull$$$0(19);
        }
        if (titleKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(20);
        }
        if (messageKey == null) {
            PluginInstallOperation.$$$reportNull$$$0(21);
        }
        if (dependencies.isEmpty()) {
            return true;
        }
        try {
            Ref result2 = new Ref((Object)false);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                Object object = ourInstallLock;
                synchronized (object) {
                    InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                    LinkedHashSet<PluginId> dependenciesToShow = new LinkedHashSet<PluginId>();
                    Iterator iterator = dependencies.iterator();
                    while (iterator.hasNext()) {
                        PluginId pluginId = ((PluginUiModel)iterator.next()).getPluginId();
                        ActionCallback callback = ourInstallCallbacks.get(pluginId);
                        if (callback == null || callback.isRejected()) {
                            if (pluginsState.wasInstalled(pluginId) || pluginsState.wasInstalledWithoutRestart(pluginId)) {
                                iterator.remove();
                                continue;
                            }
                            dependenciesToShow.add(pluginId);
                            continue;
                        }
                        this.myLocalWaitInstallCallbacks.put(pluginId, callback);
                    }
                    if (dependenciesToShow.isEmpty()) {
                        result2.set((Object)true);
                        return;
                    }
                    if (!askConfirmation) {
                        for (PluginId dependency : dependenciesToShow) {
                            this.createInstallCallback(dependency);
                        }
                        result2.set((Object)true);
                    } else {
                        String deps = PluginInstallOperation.getPluginsText(dependencies);
                        int dialogResult = Messages.showYesNoDialog((String)IdeBundle.message((String)messageKey, (Object[])new Object[]{pluginNode.getName(), deps}), (String)IdeBundle.message((String)titleKey, (Object[])new Object[0]), (String)IdeBundle.message((String)"plugins.configurable.install", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
                        result2.set((Object)(dialogResult == 0 ? 1 : 0));
                        if (((Boolean)result2.get()).booleanValue()) {
                            for (PluginId dependency : dependenciesToShow) {
                                this.createInstallCallback(dependency);
                            }
                        }
                    }
                }
            }, ModalityState.any());
            return dependencies.isEmpty() || (Boolean)result2.get() != false && this.prepareToInstall(dependencies);
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    @Nls
    private static String getPluginsText(@NotNull List<PluginUiModel> nodes) {
        List pluginNames;
        int size2;
        if (nodes == null) {
            PluginInstallOperation.$$$reportNull$$$0(22);
        }
        if ((size2 = (pluginNames = ContainerUtil.map(nodes, node -> StringUtil.wrapWithDoubleQuote((String)node.getName()))).size()) == 1) {
            String string = (String)pluginNames.get(0);
            if (string == null) {
                PluginInstallOperation.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = NlsMessages.formatAndList((Collection)pluginNames);
        if (string == null) {
            PluginInstallOperation.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    private PluginUiModel findPluginInRepo(@NotNull PluginId depPluginId) {
        if (depPluginId == null) {
            PluginInstallOperation.$$$reportNull$$$0(25);
        }
        PluginUiModel pluginFromCustomRepos = ((Stream)this.myCustomReposPlugins.stream().parallel()).filter(p -> p.getPluginId().equals((Object)depPluginId)).findAny().orElse(null);
        PluginUiModel pluginFromMarketplace = MarketplaceRequests.getInstance().getLastCompatiblePluginUpdateModel(depPluginId);
        boolean fromCustomRepos = pluginFromMarketplace == null || pluginFromCustomRepos != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(pluginFromCustomRepos.getVersion(), pluginFromMarketplace.getDescriptor()) > 0;
        return fromCustomRepos ? pluginFromCustomRepos : pluginFromMarketplace;
    }

    @Nullable
    private static PluginId resolveModuleInMarketplaceWithCache(@NotNull String moduleId) {
        Optional cachedResult;
        if (moduleId == null) {
            PluginInstallOperation.$$$reportNull$$$0(26);
        }
        if ((cachedResult = (Optional)ourModuleResolutionCache.getIfPresent((Object)moduleId)) != null) {
            return cachedResult.orElse(null);
        }
        LOG.debug("Resolving module " + moduleId + " in Marketplace");
        PluginId result2 = MarketplaceRequests.getInstance().getCompatibleUpdateByModule(moduleId);
        ourModuleResolutionCache.put((Object)moduleId, Optional.ofNullable(result2));
        LOG.debug("Resolved module " + moduleId + " in Marketplace: " + String.valueOf(result2));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customReposPlugins";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginNode";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdsBeingInstalled";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depPluginId";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginInstallOperation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeInstallCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInstallCallback";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstallWithCallback";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkDependenciesAndReplacements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkMissingDependencies";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsText";
                break;
            }
            case 23: 
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findPluginInRepo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInMarketplaceWithCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24 -> new IllegalStateException(string);
        };
    }
}

