/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Graphics;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginTable
extends JBTable {
    public PluginTable(PluginTableModel model2) {
        super((TableModel)model2);
        this.getColumnModel().setColumnMargin(0);
        for (int i2 = 0; i2 < model2.getColumnCount(); ++i2) {
            TableColumn column = this.getColumnModel().getColumn(i2);
            ColumnInfo columnInfo = model2.getColumnInfos()[i2];
            column.setCellEditor(columnInfo.getEditor(null));
            if (columnInfo.getColumnClass() != Boolean.class) continue;
            TableUtil.setupCheckboxColumn((TableColumn)column, (int)JBUIScale.scale((int)16));
        }
        this.setSelectionMode(2);
        this.setShowGrid(false);
        this.setTableHeader(null);
        this.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                Object[] selectedValues = PluginTable.this.getSelectedObjects();
                if (selectedValues == null) {
                    return null;
                }
                String text2 = StringUtil.join((Object[])selectedValues, descriptor2 -> descriptor2.getName(), (String)", ");
                String htmlText = "<body>\n<ul>\n" + StringUtil.join((Object[])selectedValues, descriptor2 -> descriptor2.getName(), (String)"</li>\n<li>") + "</ul>\n</body>\n";
                return new TextTransferable(XmlStringUtil.wrapInHtml((CharSequence)htmlText), text2);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
    }

    public void paint(@NotNull Graphics g) {
        if (g == null) {
            PluginTable.$$$reportNull$$$0(0);
        }
        super.paint(g);
        UIUtil.fixOSXEditorBackground((JTable)((Object)this));
    }

    public void setColumnWidth(int columnIndex, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    protected boolean isSortOnUpdates() {
        return false;
    }

    public void setValueAt(Object aValue, int row2, int column) {
        super.setValueAt(aValue, row2, column);
        this.repaint();
    }

    public TableCellRenderer getCellRenderer(int row2, int column) {
        ColumnInfo columnInfo = ((PluginTableModel)this.getModel()).getColumnInfos()[column];
        return columnInfo.getRenderer((Object)this.getObjectAt(row2));
    }

    public Object[] getElements() {
        return ((PluginTableModel)this.getModel()).view.toArray();
    }

    public IdeaPluginDescriptor getObjectAt(int row2) {
        return ((PluginTableModel)this.getModel()).getObjectAt(this.convertRowIndexToModel(row2));
    }

    public void select(IdeaPluginDescriptor ... descriptors2) {
        PluginTableModel tableModel2 = (PluginTableModel)this.getModel();
        this.getSelectionModel().clearSelection();
        for (int i2 = 0; i2 < tableModel2.getRowCount(); ++i2) {
            IdeaPluginDescriptor descriptorAt = tableModel2.getObjectAt(i2);
            if (ArrayUtil.find((Object[])descriptors2, (Object)descriptorAt) == -1) continue;
            int row2 = this.convertRowIndexToView(i2);
            this.getSelectionModel().addSelectionInterval(row2, row2);
        }
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    public IdeaPluginDescriptor getSelectedObject() {
        IdeaPluginDescriptor selected = null;
        if (this.getSelectedRowCount() > 0) {
            selected = this.getObjectAt(this.getSelectedRow());
        }
        return selected;
    }

    public IdeaPluginDescriptor[] getSelectedObjects() {
        IdeaPluginDescriptor[] selection = null;
        if (this.getSelectedRowCount() > 0) {
            int[] poses = this.getSelectedRows();
            selection = new IdeaPluginDescriptor[poses.length];
            for (int i2 = 0; i2 < poses.length; ++i2) {
                selection[i2] = this.getObjectAt(poses[i2]);
            }
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/plugins/PluginTable", "paint"));
    }
}

