/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.marketplace.utils.MarketplaceCustomizationService;
import com.intellij.ide.plugins.newui.PluginNodeModelBuilderFactory;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUiModelBuilderFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsProvider;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String CUSTOM_BUILT_IN_PLUGIN_REPOSITORY_PROPERTY = "intellij.plugins.custom.built.in.repository.url";
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String MARKETPLACE_PLUGIN_ID = "com.intellij.marketplace";
    private static final String ULTIMATE_MODULE = "com.intellij.modules.ultimate";

    @NotNull
    public static @NotNull List<@NotNull String> getCustomPluginRepositoryHosts() {
        ArrayList<String> hosts = new ArrayList<String>(UpdateSettings.getInstance().getStoredPluginHosts());
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        hosts.addAll(UpdateSettingsProvider.getRepositoriesFromProviders());
        String pluginsUrl = ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl();
        if (pluginsUrl != null && !"__BUILTIN_PLUGINS_URL__".equals(pluginsUrl)) {
            hosts.add(pluginsUrl);
        }
        if ((pluginsUrl = System.getProperty(CUSTOM_BUILT_IN_PLUGIN_REPOSITORY_PROPERTY)) != null) {
            hosts.add(pluginsUrl);
        }
        ContainerUtil.removeDuplicates(hosts);
        ArrayList<String> arrayList = hosts;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static @NotNull List<@Nullable String> getPluginHosts() {
        List<@Nullable String> hosts = RepositoryHelper.getCustomPluginRepositoryHosts();
        hosts.add(null);
        List<String> list2 = hosts;
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator2) throws IOException {
        return new ArrayList<IdeaPluginDescriptor>(RepositoryHelper.loadPlugins(repositoryUrl, null, indicator2));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<PluginNode> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator2) throws IOException {
        List list2 = ContainerUtil.map(RepositoryHelper.loadPluginModels(repositoryUrl, build2, indicator2, PluginNodeModelBuilderFactory.INSTANCE), it -> (PluginNode)it.getDescriptor());
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static List<PluginNode> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator2, @NotNull PluginUiModelBuilderFactory factory) throws IOException {
        if (factory == null) {
            RepositoryHelper.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.map(RepositoryHelper.loadPluginModels(repositoryUrl, build2, indicator2, factory), it -> (PluginNode)it.getDescriptor());
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<PluginUiModel> loadPluginModels(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator2) throws IOException {
        return RepositoryHelper.loadPluginModels(repositoryUrl, build2, indicator2, PluginUiModelBuilderFactory.getInstance());
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PluginUiModel> loadPluginModels(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator2, @NotNull PluginUiModelBuilderFactory factory) throws IOException {
        Path pluginListFile;
        Url url;
        if (factory == null) {
            RepositoryHelper.$$$reportNull$$$0(5);
        }
        if (repositoryUrl == null) {
            if (ApplicationInfoImpl.getShadowInstance().usesJetBrainsPluginRepository()) {
                LOG.error("Using deprecated API for getting plugins from Marketplace");
            }
            String base = MarketplaceCustomizationService.getInstance().getPluginsListUrl();
            url = Urls.newFromEncoded((String)base).addParameters(Map.of("uuid", PluginDownloader.getMarketplaceDownloadsUUID()));
            pluginListFile = Paths.get(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        } else {
            url = Urls.newFromEncoded((String)repositoryUrl);
            pluginListFile = null;
        }
        if (!"file".equals(url.getScheme())) {
            url = url.addParameters(Map.of("build", ApplicationInfoImpl.orFromPluginCompatibleBuild((BuildNumber)build2)));
        }
        if (indicator2 != null) {
            indicator2.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{url.getAuthority()}));
        }
        String message = IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{url.getAuthority()});
        List descriptors2 = (List)MarketplaceRequests.readOrUpdateFile(pluginListFile, url.toExternalForm(), indicator2, message, input -> MarketplaceRequests.parsePluginList(input, factory));
        List<PluginUiModel> list2 = RepositoryHelper.process(descriptors2, build2 != null ? build2 : PluginManagerCore.getBuildNumber(), repositoryUrl);
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static List<PluginUiModel> process(List<PluginUiModel> uiModels, BuildNumber build2, @Nullable String repositoryUrl) {
        LinkedHashMap<PluginId, PluginUiModel> result2 = new LinkedHashMap<PluginId, PluginUiModel>(uiModels.size());
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        for (PluginUiModel model2 : uiModels) {
            PluginUiModel previous;
            PluginId pluginId = model2.getPluginId();
            if (repositoryUrl != null && model2.getDownloadUrl() == null) {
                LOG.debug("Malformed plugin record (id:" + String.valueOf(pluginId) + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (BrokenPluginFileKt.isBrokenPlugin((PluginId)model2.getPluginId(), (String)model2.getVersion()) || PluginManagerCore.isIncompatible((IdeaPluginDescriptor)model2.getDescriptor(), (BuildNumber)build2)) {
                LOG.debug("An incompatible plugin (id:" + String.valueOf(pluginId) + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (repositoryUrl != null) {
                model2.setRepositoryName(repositoryUrl);
            }
            if (model2.getName() == null) {
                String url = model2.getDownloadUrl();
                model2.setName(FileUtilRt.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1)));
            }
            if ((previous = (PluginUiModel)result2.get(pluginId)) == null || VersionComparatorUtil.compare((String)model2.getVersion(), (String)previous.getVersion()) > 0) {
                result2.put(pluginId, model2);
            }
            RepositoryHelper.addMarketplacePluginDependencyIfRequired(model2, isPaidPluginsRequireMarketplacePlugin);
        }
        return List.copyOf(result2.values());
    }

    @ApiStatus.Internal
    public static void addMarketplacePluginDependencyIfRequired(@NotNull PluginUiModel model2) {
        if (model2 == null) {
            RepositoryHelper.$$$reportNull$$$0(7);
        }
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        RepositoryHelper.addMarketplacePluginDependencyIfRequired(model2, isPaidPluginsRequireMarketplacePlugin);
    }

    private static boolean isPaidPluginsRequireMarketplacePlugin() {
        IdeaPluginDescriptorImpl core = PluginManagerCore.findPlugin((PluginId)PluginManagerCore.CORE_ID);
        return core == null || !core.getPluginAliases().contains(PluginId.getId((String)ULTIMATE_MODULE)) || !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains();
    }

    private static void addMarketplacePluginDependencyIfRequired(PluginUiModel node, boolean isPaidPluginsRequireMarketplacePlugin) {
        if (isPaidPluginsRequireMarketplacePlugin && node.getProductCode() != null) {
            node.addDependency(PluginId.getId((String)MARKETPLACE_PLUGIN_ID), false);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static Collection<PluginNode> mergePluginsFromRepositories(@NotNull List<PluginNode> marketplacePlugins, @NotNull List<PluginNode> customPlugins2, boolean addMissing) {
        if (marketplacePlugins == null) {
            RepositoryHelper.$$$reportNull$$$0(8);
        }
        if (customPlugins2 == null) {
            RepositoryHelper.$$$reportNull$$$0(9);
        }
        List marketplaceModels = ContainerUtil.map(marketplacePlugins, PluginUiModelAdapter::new);
        List customPluginsModels = ContainerUtil.map(customPlugins2, PluginUiModelAdapter::new);
        Collection<PluginUiModel> mergedPluginModels = RepositoryHelper.mergePluginModelsFromRepositories(marketplaceModels, customPluginsModels, addMissing);
        List list2 = ContainerUtil.map(mergedPluginModels, model2 -> (PluginNode)model2.getDescriptor());
        if (list2 == null) {
            RepositoryHelper.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Collection<PluginUiModel> mergePluginModelsFromRepositories(@NotNull List<PluginUiModel> marketplacePlugins, @NotNull List<PluginUiModel> customPlugins2, boolean addMissing) {
        if (marketplacePlugins == null) {
            RepositoryHelper.$$$reportNull$$$0(11);
        }
        if (customPlugins2 == null) {
            RepositoryHelper.$$$reportNull$$$0(12);
        }
        LinkedHashMap<PluginId, PluginUiModel> compatiblePluginMap = new LinkedHashMap<PluginId, PluginUiModel>(marketplacePlugins.size());
        for (PluginUiModel marketplacePlugin : marketplacePlugins) {
            compatiblePluginMap.put(marketplacePlugin.getPluginId(), marketplacePlugin);
        }
        for (PluginUiModel customPlugin : customPlugins2) {
            PluginId pluginId = customPlugin.getPluginId();
            PluginUiModel plugin = (PluginUiModel)compatiblePluginMap.get(pluginId);
            if ((plugin != null || !addMissing) && (plugin == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(customPlugin.getVersion(), plugin.getDescriptor()) <= 0)) continue;
            compatiblePluginMap.put(pluginId, customPlugin);
        }
        Collection<PluginUiModel> collection = compatiblePluginMap.values();
        if (collection == null) {
            RepositoryHelper.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PluginNode> loadPluginsFromCustomRepositories(@Nullable ProgressIndicator indicator2) {
        return RepositoryHelper.loadPluginsFromCustomRepositories(indicator2, PluginUiModelBuilderFactory.getInstance());
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PluginNode> loadPluginsFromCustomRepositories(@Nullable ProgressIndicator indicator2, @NotNull PluginUiModelBuilderFactory factory) {
        if (factory == null) {
            RepositoryHelper.$$$reportNull$$$0(14);
        }
        HashSet<PluginId> ids = new HashSet<PluginId>();
        ArrayList<PluginNode> result2 = new ArrayList<PluginNode>();
        for (String host : RepositoryHelper.getCustomPluginRepositoryHosts()) {
            try {
                List<PluginNode> plugins2 = RepositoryHelper.loadPlugins(host, null, indicator2, factory);
                for (PluginNode plugin : plugins2) {
                    if (!ids.add(plugin.getPluginId())) continue;
                    result2.add(plugin);
                }
            }
            catch (IOException e) {
                LOG.info("Couldn't load plugins from " + host + ": " + String.valueOf(e));
                LOG.debug((Throwable)e);
            }
        }
        ArrayList<PluginNode> arrayList = result2;
        if (arrayList == null) {
            RepositoryHelper.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PluginNode> loadPlugins(@NotNull Set<PluginId> pluginIds) {
        if (pluginIds == null) {
            RepositoryHelper.$$$reportNull$$$0(16);
        }
        List<PluginNode> mpPlugins = MarketplaceRequests.loadLastCompatiblePluginDescriptors(pluginIds);
        List<PluginNode> customPlugins2 = RepositoryHelper.loadPluginsFromCustomRepositories(null).stream().filter(p -> pluginIds.contains(p.getPluginId())).toList();
        return RepositoryHelper.mergePluginsFromRepositories(mpPlugins, customPlugins2, true);
    }

    @ApiStatus.Internal
    public static void updatePluginHostsFromConfigDir(@NotNull Path oldConfigDir, @NotNull Logger logger) {
        if (oldConfigDir == null) {
            RepositoryHelper.$$$reportNull$$$0(17);
        }
        if (logger == null) {
            RepositoryHelper.$$$reportNull$$$0(18);
        }
        logger.info("reading plugin repositories from " + String.valueOf(oldConfigDir));
        try {
            List<String> hosts;
            String text2 = ComponentStorageUtil.loadTextContent((Path)oldConfigDir.resolve("options/updates.xml"));
            Map components = ComponentStorageUtil.loadComponents((Element)JDOMUtil.load((CharSequence)text2), null);
            Element element = (Element)components.get("UpdatesConfigurable");
            if (element != null && !(hosts = ((UpdateOptions)((Object)XmlSerializer.deserialize((Element)element, UpdateOptions.class))).getPluginHosts()).isEmpty()) {
                RepositoryHelper.amendPluginHostsProperty(hosts);
                logger.info("plugin hosts: " + System.getProperty("idea.plugin.hosts"));
            }
        }
        catch (IOException | InvalidPathException | JDOMException e) {
            logger.error("... failed: " + e.getMessage());
        }
    }

    @ApiStatus.Internal
    public static void amendPluginHostsProperty(@NotNull Collection<String> repositoryUrls) {
        if (repositoryUrls == null) {
            RepositoryHelper.$$$reportNull$$$0(19);
        }
        String hosts = System.getProperty("idea.plugin.hosts");
        Object newHosts = String.join((CharSequence)";", repositoryUrls);
        if (hosts != null && !hosts.isBlank()) {
            newHosts = hosts + ";" + (String)newHosts;
        }
        System.setProperty("idea.plugin.hosts", (String)newHosts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 7, 8, 9, 11, 12, 14, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marketplacePlugins";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPluginRepositoryHosts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPlugins";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/RepositoryHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginModels";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePluginsFromRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePluginModelsFromRepositories";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginsFromCustomRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadPluginModels";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMarketplacePluginDependencyIfRequired";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergePluginsFromRepositories";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergePluginModelsFromRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPluginsFromCustomRepositories";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updatePluginHostsFromConfigDir";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "amendPluginHostsProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 7, 8, 9, 11, 12, 14, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

