/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.certificates.PluginCertificateStore;
import com.intellij.ide.plugins.marketplace.statistics.PluginManagerUsageCollector;
import com.intellij.ide.plugins.marketplace.statistics.enums.DialogAcceptanceResultEnum;
import com.intellij.ide.plugins.marketplace.statistics.enums.SignatureVerificationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.util.io.HttpRequests;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0007J&\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J&\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001bH\u0002J.\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J-\u0010#\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001bH\u0002J\u0015\u0010&\u001a\u00070\b\u00a2\u0006\u0002\b$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010'\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010(\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/intellij/ide/plugins/marketplace/PluginSignatureChecker;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "jetBrainsCertificateRevokedCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/util/Optional;", "", "jetbrainsCertificate", "Ljava/security/cert/Certificate;", "getJetbrainsCertificate", "()Ljava/security/cert/Certificate;", "jetbrainsCertificate$delegate", "Lkotlin/Lazy;", "verifyIfRequired", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginFile", "Ljava/nio/file/Path;", "isMarketplace", "showAcceptDialog", "isSignedInBackground", "certificates", "", "isSignedInWithAcceptDialog", "isJetBrainsCertificateRevoked", "getRevocationLists", "Ljava/security/cert/X509CRL;", "certs", "Ljava/security/cert/X509Certificate;", "isSignedBy", "verifyPluginAndGetErrorMessage", "Lorg/jetbrains/annotations/Nls;", "file", "getSignatureWarningMessage", "processSignatureCheckerVerdict", "message", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPluginSignatureChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginSignatureChecker.kt\ncom/intellij/ide/plugins/marketplace/PluginSignatureChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n1#2:192\n1#2:203\n1617#3,9:193\n1869#3:202\n1870#3:204\n1626#3:205\n1761#3,3:206\n13#4:209\n*S KotlinDebug\n*F\n+ 1 PluginSignatureChecker.kt\ncom/intellij/ide/plugins/marketplace/PluginSignatureChecker\n*L\n106#1:203\n106#1:193,9\n106#1:202\n106#1:204\n106#1:205\n149#1:206,3\n32#1:209\n*E\n"})
public final class PluginSignatureChecker {
    @NotNull
    public static final PluginSignatureChecker INSTANCE = new PluginSignatureChecker();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Cache<String, Optional<Boolean>> jetBrainsCertificateRevokedCache;
    @NotNull
    private static final Lazy jetbrainsCertificate$delegate;

    private PluginSignatureChecker() {
    }

    private final Certificate getJetbrainsCertificate() {
        Lazy lazy = jetbrainsCertificate$delegate;
        return (Certificate)lazy.getValue();
    }

    @JvmStatic
    public static final boolean verifyIfRequired(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Path pluginFile, boolean isMarketplace, boolean showAcceptDialog) {
        String key;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        String string = key = isMarketplace ? "marketplace.certificate.signature.check" : "custom-repository.certificate.signature.check";
        if (!RegistryManager.Companion.getInstance().is(key)) {
            return true;
        }
        List list2 = PluginCertificateStore.INSTANCE.getCustomTrustManager().getCertificates();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCertificates(...)");
        List certificates = CollectionsKt.plus((Collection)list2, (Iterable)PluginCertificateStore.INSTANCE.getManagedTrustedCertificates());
        return showAcceptDialog ? INSTANCE.isSignedInWithAcceptDialog(descriptor2, pluginFile, certificates) : INSTANCE.isSignedInBackground(descriptor2, pluginFile, certificates);
    }

    private final boolean isSignedInBackground(IdeaPluginDescriptor descriptor2, Path pluginFile, List<? extends Certificate> certificates) {
        Object object;
        Certificate certificate = this.getJetbrainsCertificate();
        if (certificate == null) {
            return false;
        }
        Certificate jbCert = certificate;
        Object object2 = this;
        try {
            PluginSignatureChecker $this$isSignedInBackground_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$isSignedInBackground_u24lambda_u240.isJetBrainsCertificateRevoked());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Boolean bl = (Boolean)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (bl == null) {
            return false;
        }
        boolean isRevoked = bl;
        if (isRevoked) {
            LOG.info("Plugin " + pluginFile.getFileName() + " has revoked JetBrains certificate");
            return false;
        }
        List allCerts = CollectionsKt.plus((Collection)certificates, (Object)jbCert);
        return this.isSignedBy(descriptor2, pluginFile, false, allCerts);
    }

    private final boolean isSignedInWithAcceptDialog(IdeaPluginDescriptor descriptor2, Path pluginFile, List<? extends Certificate> certificates) {
        boolean bl;
        Certificate certificate = this.getJetbrainsCertificate();
        if (certificate == null) {
            String string = IdeBundle.message((String)"jetbrains.certificate.not.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.processSignatureCheckerVerdict(descriptor2, string);
        }
        Certificate jbCert = certificate;
        try {
            bl = this.isJetBrainsCertificateRevoked();
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                String string2 = IdeBundle.message((String)"jetbrains.certificate.invalid", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            String message = string;
            return this.processSignatureCheckerVerdict(descriptor2, message);
        }
        boolean isRevoked = bl;
        if (isRevoked) {
            LOG.info("Plugin " + pluginFile.getFileName() + " has revoked JetBrains certificate");
            Object[] objectArray = new Object[]{descriptor2.getName()};
            String string = IdeBundle.message((String)"plugin.signature.checker.revoked.cert", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            return this.processSignatureCheckerVerdict(descriptor2, message);
        }
        List allCerts = CollectionsKt.plus((Collection)certificates, (Object)jbCert);
        return this.isSignedBy(descriptor2, pluginFile, true, allCerts);
    }

    private final boolean isJetBrainsCertificateRevoked() {
        Boolean isRevokedCached;
        Optional optional = (Optional)jetBrainsCertificateRevokedCache.getIfPresent((Object)this.getClass().getName());
        Boolean bl = isRevokedCached = optional != null ? (Boolean)optional.get() : null;
        if (bl != null) {
            return bl;
        }
        Certificate certificate = this.getJetbrainsCertificate();
        List cert509Lists = CollectionsKt.listOfNotNull((Object)(certificate instanceof X509Certificate ? (X509Certificate)certificate : null));
        List<X509CRL> lists = this.getRevocationLists(cert509Lists);
        X509Certificate revokedCertificates = CertificateUtils.findRevokedCertificate((List)cert509Lists, lists);
        boolean isRevoked = revokedCertificates != null;
        jetBrainsCertificateRevokedCache.put((Object)this.getClass().getName(), Optional.of(isRevoked));
        return isRevoked;
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509CRL> getRevocationLists(List<? extends X509Certificate> certs) {
        void $this$mapNotNullTo$iv$iv;
        List<? extends X509Certificate> certsExceptCA = certs.subList(0, certs.size() - 1);
        Iterable $this$mapNotNull$iv = certsExceptCA;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            X509CRL it$iv$iv;
            InputStream inputStream;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            X509Certificate certificate = (X509Certificate)element$iv$iv;
            boolean bl2 = false;
            List crlUris = CertificateUtils.getCrlUris((X509Certificate)certificate);
            if (crlUris.isEmpty()) {
                LOG.error("CRL not found for certificate");
                throw new IllegalArgumentException("CRL not found for certificate");
            }
            if (crlUris.size() > 1) {
                LOG.error("Multiple CRL URI found in certificate");
                throw new IllegalArgumentException("Multiple CRL URI found in certificate");
            }
            URI crlURI = (URI)CollectionsKt.first((List)crlUris);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CRL cRL = certificateFactory.generateCRL(inputStream = (InputStream)HttpRequests.request((String)crlURI.toURL().toExternalForm()).throwStatusCodeException(false).productNameAsUserAgent().connect(PluginSignatureChecker::getRevocationLists$lambda$0$0));
            if ((cRL instanceof X509CRL ? (X509CRL)cRL : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isSignedBy(IdeaPluginDescriptor descriptor2, Path pluginFile, boolean showAcceptDialog, List<? extends Certificate> certificates) {
        String errorMessage = this.verifyPluginAndGetErrorMessage(descriptor2, pluginFile, certificates);
        if (errorMessage != null && showAcceptDialog) {
            return this.processSignatureCheckerVerdict(descriptor2, errorMessage);
        }
        return errorMessage == null;
    }

    private final String verifyPluginAndGetErrorMessage(IdeaPluginDescriptor descriptor2, Path file2, List<? extends Certificate> certificates) {
        String string;
        ZipVerificationResult verificationResult = ZipVerifier.verify((Path)file2);
        if (verificationResult instanceof InvalidSignatureResult) {
            PluginManagerUsageCollector.INSTANCE.signatureCheckResult(descriptor2, SignatureVerificationResult.INVALID_SIGNATURE);
            Object[] objectArray = new Object[]{descriptor2.getName(), ((InvalidSignatureResult)verificationResult).getErrorMessage()};
            string = IdeBundle.message((String)"plugin.invalid.signature.result", (Object[])objectArray);
        } else if (verificationResult instanceof MissingSignatureResult) {
            PluginManagerUsageCollector.INSTANCE.signatureCheckResult(descriptor2, SignatureVerificationResult.MISSING_SIGNATURE);
            string = this.getSignatureWarningMessage(descriptor2);
        } else if (verificationResult instanceof SuccessfulVerificationResult) {
            boolean isSigned;
            block11: {
                Iterable $this$any$iv = certificates;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Certificate certificate = (Certificate)element$iv;
                        boolean bl = false;
                        if (!(certificate instanceof X509Certificate && ((SuccessfulVerificationResult)verificationResult).isSignedBy((X509Certificate)certificate))) continue;
                        v1 = true;
                        break block11;
                    }
                    v1 = isSigned = false;
                }
            }
            if (!isSigned) {
                PluginManagerUsageCollector.INSTANCE.signatureCheckResult(descriptor2, SignatureVerificationResult.WRONG_SIGNATURE);
                string = this.getSignatureWarningMessage(descriptor2);
            } else {
                PluginManagerUsageCollector.INSTANCE.signatureCheckResult(descriptor2, SignatureVerificationResult.SUCCESSFUL);
                string = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getSignatureWarningMessage(IdeaPluginDescriptor descriptor2) {
        String string;
        CharSequence charSequence = descriptor2.getOrganization();
        String vendor = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? descriptor2.getVendor() : descriptor2.getOrganization();
        Object[] objectArray = (Object[])vendor;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            string = vendor;
        } else {
            objectArray = new Object[]{vendor};
            string = IdeBundle.message((String)"jetbrains.certificate.vendor", (Object[])objectArray);
        }
        String vendorMessage = string;
        Object[] objectArray2 = new Object[]{descriptor2.getName(), descriptor2.getPluginId().getIdString(), descriptor2.getVersion(), vendorMessage};
        String string2 = IdeBundle.message((String)"plugin.signature.not.signed", (Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final boolean processSignatureCheckerVerdict(IdeaPluginDescriptor descriptor2, @Nls String message) {
        String string = IdeBundle.message((String)"plugin.signature.checker.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title2 = string;
        String string2 = IdeBundle.message((String)"plugin.signature.checker.yes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String yesText = string2;
        String string3 = IdeBundle.message((String)"plugin.signature.checker.no", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String noText = string3;
        Ref.IntRef result2 = new Ref.IntRef();
        result2.element = -1;
        ApplicationManager.getApplication().invokeAndWait(() -> PluginSignatureChecker.processSignatureCheckerVerdict$lambda$0(result2, message, title2, yesText, noText), ModalityState.any());
        PluginManagerUsageCollector.INSTANCE.signatureWarningShown(descriptor2, result2.element == 0 ? DialogAcceptanceResultEnum.ACCEPTED : DialogAcceptanceResultEnum.DECLINED);
        return result2.element == 0;
    }

    private static final Certificate jetbrainsCertificate_delegate$lambda$0() {
        Certificate certificate;
        InputStream cert = INSTANCE.getClass().getClassLoader().getResourceAsStream("ca.crt");
        if (cert == null) {
            LOG.warn(IdeBundle.message((String)"jetbrains.certificate.not.found", (Object[])new Object[0]));
            certificate = null;
        } else {
            certificate = CertificateFactory.getInstance("X.509").generateCertificate(cert);
        }
        return certificate;
    }

    private static final InputStream getRevocationLists$lambda$0$0(HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getInputStream();
    }

    private static final void processSignatureCheckerVerdict$lambda$0(Ref.IntRef $result, String $message, String $title, String $yesText, String $noText) {
        $result.element = Messages.showYesNoDialog((String)$message, (String)$title, (String)$yesText, (String)$noText, (Icon)Messages.getWarningIcon());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PluginSignatureChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Cache cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        jetBrainsCertificateRevokedCache = cache;
        jetbrainsCertificate$delegate = LazyKt.lazy(PluginSignatureChecker::jetbrainsCertificate_delegate$lambda$0);
    }
}

