/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.ide.plugins.newui.DefaultUiPluginManagerController;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.NotABooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PluginBooleanOptionDescriptor
extends BooleanOptionDescription
implements BooleanOptionDescription.RequiresRebuild,
NotABooleanOptionDescription {
    private static final AtomicReference<Notification> ourPreviousNotification = new AtomicReference();
    private final IdeaPluginDescriptor myDescriptor;

    PluginBooleanOptionDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(0);
        }
        super(IdeBundle.message((String)"search.everywhere.command.plugins", (Object[])new Object[]{descriptor2.getName()}), "preferences.pluginManager");
        this.myDescriptor = descriptor2;
    }

    public boolean isOptionEnabled() {
        return !PluginEnabler.HEADLESS.isDisabled(this.myDescriptor.getPluginId());
    }

    public void setOptionState(boolean enable2) {
        PluginBooleanOptionDescriptor.togglePluginState(List.of(this.myDescriptor), enable2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void togglePluginState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, boolean enable2) {
        boolean appliedWithoutRestart;
        if (descriptors2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(1);
        }
        if (descriptors2.isEmpty()) {
            return;
        }
        Map pluginIdMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        @NotNull @NotNull Map contentModuleIdMap = PluginManagerCore.getPluginSet().buildContentModuleIdMap();
        Collection<? extends IdeaPluginDescriptor> autoSwitchedDescriptors = enable2 ? PluginBooleanOptionDescriptor.getDependenciesToEnable(descriptors2, pluginIdMap, contentModuleIdMap) : PluginBooleanOptionDescriptor.getDependentsToDisable(descriptors2, pluginIdMap, contentModuleIdMap);
        PluginEnabler pluginEnabler = PluginEnabler.getInstance();
        boolean bl = appliedWithoutRestart = enable2 ? pluginEnabler.enable(autoSwitchedDescriptors) : pluginEnabler.disable(autoSwitchedDescriptors);
        if (autoSwitchedDescriptors.size() > descriptors2.size()) {
            String content2 = IdeBundle.message((String)(enable2 ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content"), (Object[])new Object[]{MyPluginModel.joinPluginNamesOrIds(MyPluginModel.getPluginNames(descriptors2)), MyPluginModel.joinPluginNamesOrIds(MyPluginModel.getPluginNames(autoSwitchedDescriptors))});
            PluginBooleanOptionDescriptor.showAutoSwitchNotification(autoSwitchedDescriptors, pluginEnabler, content2, enable2);
        }
        PluginBooleanOptionDescriptor.notifyIfRestartRequired(!appliedWithoutRestart);
    }

    private static void showAutoSwitchNotification(final @NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, final @NotNull PluginEnabler pluginEnabler, @NotNull @Nls String content2, final boolean enabled2) {
        if (descriptors2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(2);
        }
        if (pluginEnabler == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(4);
        }
        String title2 = IdeBundle.message((String)(enabled2 ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title"), (Object[])new Object[0]);
        final Notification switchNotification = ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForPluginUpdateResults().createNotification(content2, NotificationType.INFORMATION).setDisplayId("plugin.auto.switch").setTitle(title2).addAction((AnAction)new NotificationAction(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean appliedWithoutRestart = enabled2 ? pluginEnabler.disable(descriptors2) : pluginEnabler.enable(descriptors2);
                notification2.expire();
                PluginBooleanOptionDescriptor.notifyIfRestartRequired(!appliedWithoutRestart);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        final Set pluginIds = PluginUtils.toPluginIdSet(descriptors2);
        DisabledPluginsState.Companion.addDisablePluginListener(new Runnable(){

            @Override
            public void run() {
                Balloon balloon2;
                boolean notificationValid;
                Condition condition = arg_0 -> ((PluginEnabler)pluginEnabler).isDisabled(arg_0);
                boolean bl = enabled2 ? !ContainerUtil.exists((Iterable)pluginIds, (Condition)condition) : (notificationValid = ContainerUtil.and((Iterable)pluginIds, (Condition)condition));
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon2 = switchNotification.getBalloon()) == null || balloon2.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> DisabledPluginsState.Companion.removeDisablePluginListener((Runnable)this));
                }
            }
        });
        switchNotification.notify(null);
    }

    @NotNull
    private static Collection<? extends IdeaPluginDescriptor> getDependenciesToEnable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap) {
        if (descriptors2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(5);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(6);
        }
        if (contentModuleIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(7);
        }
        LinkedHashSet<IdeaPluginDescriptor> result2 = new LinkedHashSet<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            result2.add(ideaPluginDescriptor);
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            PluginManagerCore.INSTANCE.processAllNonOptionalDependencies((IdeaPluginDescriptorImpl)ideaPluginDescriptor, pluginIdMap, contentModuleIdMap, dependency -> PluginManagerCore.CORE_ID.equals((Object)dependency.getPluginId()) || PluginManagerCore.ULTIMATE_PLUGIN_ID.equals((Object)dependency.getPluginId()) && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID) || dependency.isEnabled() || !result2.add((IdeaPluginDescriptor)dependency) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE);
        }
        Set set = Collections.unmodifiableSet(result2);
        if (set == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Collection<? extends IdeaPluginDescriptor> getDependentsToDisable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Map<PluginModuleId, ContentModuleDescriptor> contentModuleIdMap) {
        if (descriptors2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(9);
        }
        if (pluginIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(10);
        }
        if (contentModuleIdMap == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(11);
        }
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors2) {
            result2.add(ideaPluginDescriptor);
            result2.addAll(DefaultUiPluginManagerController.INSTANCE.getDependents(ideaPluginDescriptor.getPluginId(), applicationInfo, pluginIdMap, contentModuleIdMap));
        }
        Set set = Collections.unmodifiableSet(result2);
        if (set == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static void notifyIfRestartRequired(boolean restartRequired) {
        Balloon balloon2;
        if (!restartRequired) {
            return;
        }
        Notification notification2 = ourPreviousNotification.get();
        if (notification2 != null && (balloon2 = notification2.getBalloon()) != null && !balloon2.isDisposed()) {
            return;
        }
        Notification newNotification2 = ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForIdeUpdateResults().createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0])).setDisplayId("plugins.updated.restart.required").addAction((AnAction)new DumbAwareAction(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/PluginBooleanOptionDescriptor$3", "actionPerformed"));
            }
        });
        if (ourPreviousNotification.compareAndSet(notification2, newNotification2)) {
            newNotification2.notify(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginEnabler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentModuleIdMap";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesToEnable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentsToDisable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "togglePluginState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showAutoSwitchNotification";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependenciesToEnable";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDependentsToDisable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 12 -> new IllegalStateException(string);
        };
    }
}

