/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionManagerImplKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChameleonAction
extends AnAction {
    @NotNull
    private final String myActionId;
    private final Map<ProjectType, AnAction> myActions;

    public ChameleonAction(@NotNull String actionId, @NotNull AnAction first, @Nullable ProjectType projectType, @NotNull Function1<? super String, ? extends AnAction> actionSupplier) {
        if (actionId == null) {
            ChameleonAction.$$$reportNull$$$0(0);
        }
        if (first == null) {
            ChameleonAction.$$$reportNull$$$0(1);
        }
        if (actionSupplier == null) {
            ChameleonAction.$$$reportNull$$$0(2);
        }
        this.myActions = new HashMap<ProjectType, AnAction>();
        this.myActionId = actionId;
        this.addAction(first, projectType, actionSupplier);
        this.copyFrom(this.myActions.values().iterator().next());
    }

    boolean addAction(@NotNull AnAction action2, @Nullable ProjectType projectType, @NotNull Function1<? super String, ? extends AnAction> actionSupplier) {
        if (action2 == null) {
            ChameleonAction.$$$reportNull$$$0(3);
        }
        if (actionSupplier == null) {
            ChameleonAction.$$$reportNull$$$0(4);
        }
        if (action2 instanceof ActionStub) {
            ActionStub actionStub = (ActionStub)action2;
            if ((action2 = ActionManagerImplKt.convertStub(actionStub, actionSupplier)) == null) {
                return true;
            }
            projectType = actionStub.getProjectType();
        }
        return this.myActions.putIfAbsent(projectType, action2) == null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChameleonAction.$$$reportNull$$$0(5);
        }
        AnAction action2 = this.getAction(e);
        assert (action2 != null);
        action2.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        AnAction action2;
        if (e == null) {
            ChameleonAction.$$$reportNull$$$0(6);
        }
        boolean visible = (action2 = this.getAction(e)) != null;
        e.getPresentation().setVisible(visible);
        if (visible) {
            action2.update(e);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        AnAction action2 = this.myActions.get(null);
        if (action2 == null) {
            action2 = this.myActions.values().iterator().next();
        }
        ActionUpdateThread actionUpdateThread = action2 == null ? ActionUpdateThread.BGT : action2.getActionUpdateThread();
        if (actionUpdateThread == null) {
            ChameleonAction.$$$reportNull$$$0(7);
        }
        return actionUpdateThread;
    }

    @Nullable
    private AnAction getAction(@NotNull AnActionEvent e) {
        Project project2;
        ProjectType projectType;
        AnAction action2;
        if (e == null) {
            ChameleonAction.$$$reportNull$$$0(8);
        }
        return (action2 = this.myActions.get(projectType = ProjectTypeService.getProjectType((Project)(project2 = e.getProject())))) != null ? action2 : this.myActions.get(null);
    }

    public Map<ProjectType, AnAction> getActions() {
        return this.myActions;
    }

    @NotNull
    public String getActionId() {
        String string = this.myActionId;
        if (string == null) {
            ChameleonAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ChameleonAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ChameleonAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }
}

