/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.idea.AppMode;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/application/InitialConfigImportState;", "", "<init>", "()V", "FIRST_SESSION_KEY", "", "CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY", "CUSTOM_MARKER_FILE_NAME", "FRONTEND_PLUGINS_TO_MIGRATE_DIR_NAME", "MIGRATION_INSTALLED_PLUGINS_TXT", "OPTIONS", "", "[Ljava/lang/String;", "isFirstSession", "", "isConfigImported", "isNewUser", "isConfigDirectory", "candidate", "Ljava/nio/file/Path;", "isStartupWizardEnabled", "writeOptionsForRestart", "", "newConfigDir", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInitialConfigImportState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitialConfigImportState.kt\ncom/intellij/openapi/application/InitialConfigImportState\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n12970#2,2:67\n*S KotlinDebug\n*F\n+ 1 InitialConfigImportState.kt\ncom/intellij/openapi/application/InitialConfigImportState\n*L\n48#1:67,2\n*E\n"})
public final class InitialConfigImportState {
    @NotNull
    public static final InitialConfigImportState INSTANCE = new InitialConfigImportState();
    @NotNull
    public static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    @NotNull
    public static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    @NotNull
    public static final String CUSTOM_MARKER_FILE_NAME = "migrate.config";
    @NotNull
    public static final String FRONTEND_PLUGINS_TO_MIGRATE_DIR_NAME = "frontend-to-migrate";
    @NotNull
    public static final String MIGRATION_INSTALLED_PLUGINS_TXT = "migration_installed_plugins.txt";
    @NotNull
    private static final String[] OPTIONS;

    private InitialConfigImportState() {
    }

    @JvmStatic
    public static final boolean isFirstSession() {
        return Boolean.parseBoolean(System.getProperty(FIRST_SESSION_KEY));
    }

    @JvmStatic
    public static final boolean isConfigImported() {
        return Boolean.parseBoolean(System.getProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY));
    }

    @JvmStatic
    public static final boolean isNewUser() {
        return InitialConfigImportState.isFirstSession() && !InitialConfigImportState.isConfigImported();
    }

    @Deprecated(message="Use `ConfigImportHelper.isConfigDirectory()` instead")
    public final boolean isConfigDirectory(@NotNull Path candidate) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
            String[] $this$any$iv = OPTIONS;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!Files.exists(candidate.resolve(it), new LinkOption[0])) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isStartupWizardEnabled() {
        return !AppMode.isRemoteDevHost() && Boolean.parseBoolean(System.getProperty("intellij.startup.wizard", ApplicationManagerEx.isInIntegrationTest() ? "false" : "true"));
    }

    @JvmStatic
    public static final void writeOptionsForRestart(@NotNull Path newConfigDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newConfigDir, (String)"newConfigDir");
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FIRST_SESSION_KEY);
        if (InitialConfigImportState.isConfigImported()) {
            properties.add(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
        }
        new CustomConfigMigrationOption.SetProperties((List<String>)properties).writeConfigMarkerFile(newConfigDir);
    }

    static {
        String[] stringArray = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
        OPTIONS = stringArray;
    }
}

