/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SubmissionTracker {
    private static final Logger LOG = Logger.getInstance(SubmissionTracker.class);
    private static final String TOO_MANY_NON_BLOCKING_READ_ACTIONS_SUBMITTED_AT_ONCE = "Too many non-blocking read actions submitted at once";
    private static final String SUGGESTIONS = "Please use coalesceBy, BoundedTaskExecutor or another way of limiting the number of concurrently running threads.";
    private static final String TOO_MANY_SUBMISSIONS = "Too many non-blocking read actions submitted at once. Please use coalesceBy, BoundedTaskExecutor or another way of limiting the number of concurrently running threads.";
    @VisibleForTesting
    public static final String ARE_CURRENTLY_ACTIVE = " with similar stack traces are currently active";
    private final AtomicInteger myCount = new AtomicInteger();
    @Nullable
    private volatile Map<String, Integer> myTraces;
    private volatile boolean myStoppedTracing;

    @Nullable
    String preventTooManySubmissions() {
        int currentCount = this.myCount.incrementAndGet();
        if (this.myStoppedTracing) {
            return null;
        }
        Map<String, Integer> traces = this.myTraces;
        if (currentCount > 100) {
            if (traces == null) {
                this.myTraces = new ConcurrentHashMap<String, Integer>();
            } else {
                Integer count = traces.get(this.callerTrace());
                if (count != null && count > 10) {
                    this.stopTracing();
                    LOG.error("Too many non-blocking read actions submitted at once. Please use coalesceBy, BoundedTaskExecutor or another way of limiting the number of concurrently running threads.: " + count + ARE_CURRENTLY_ACTIVE);
                } else if (currentCount % 127 == 0) {
                    this.stopTracing();
                    SubmissionTracker.reportTooManyUnidentifiedSubmissions(traces);
                }
            }
        }
        if (traces != null) {
            String trace = this.callerTrace();
            traces.merge(trace, 1, Integer::sum);
            return trace;
        }
        return null;
    }

    private void stopTracing() {
        this.myStoppedTracing = true;
        this.myTraces = null;
    }

    private String callerTrace() {
        return ((StreamEx)((StreamEx)StreamEx.of((Object[])new Throwable().getStackTrace()).dropWhile(ste -> ste.getClassName().contains("NonBlockingReadAction") || ste.getClassName().equals(this.getClass().getName()))).limit(10L)).joining((CharSequence)"\n");
    }

    void unregisterSubmission(@Nullable String startTrace) {
        this.myCount.decrementAndGet();
        Map<String, Integer> traces = this.myTraces;
        if (startTrace != null && traces != null) {
            traces.compute(startTrace, (__, i2) -> i2 == null || i2 == 1 ? null : Integer.valueOf(i2 - 1));
        }
    }

    private static void reportTooManyUnidentifiedSubmissions(Map<String, Integer> traces) {
        String mostFrequentTraces = ((StreamEx)((EntryStream)EntryStream.of(traces).sortedByInt(e -> -((Integer)e.getValue()).intValue())).map(e -> String.valueOf(e.getValue()) + " occurrences of " + (String)e.getKey()).limit(10L)).joining((CharSequence)"\n\n");
        if (LOG.isDebugEnabled()) {
            LOG.debug(mostFrequentTraces);
        }
        Attachment attachment = new Attachment("diagnostic.txt", mostFrequentTraces);
        attachment.setIncluded(true);
        LOG.error(TOO_MANY_SUBMISSIONS, new Attachment[]{attachment});
    }
}

