/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.AiInternalUiComponentMarker;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainerDragOutDelegate;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainerKt;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainerTransferHandler;
import com.intellij.openapi.fileEditor.impl.EditorTabs;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.TabMouseListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabInfoIconHolder;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.TimedDeadzone;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0015\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J\u0017\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,Jd\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0013\u001a\u00020\u00142\r\u00103\u001a\t\u0018\u000104\u00a2\u0006\u0002\b52\u0006\u00106\u001a\u00020\r2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020=0<H\u0000\u00a2\u0006\u0002\b>J\u001b\u0010?\u001a\u00020\u00182\f\u0010@\u001a\b\u0012\u0004\u0012\u00020.0AH\u0000\u00a2\u0006\u0002\bBR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010@\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;", "", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lkotlinx/coroutines/CoroutineScope;)V", "editorTabs", "Lcom/intellij/ui/tabs/impl/JBEditorTabs;", "dragOutDelegate", "Lcom/intellij/ui/tabs/TabInfo$DragOutDelegate;", "tabCount", "", "getTabCount", "()I", "setSelectedIndex", "Lcom/intellij/openapi/util/ActionCallback;", "indexToSelect", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "removeTabAt", "", "componentIndex", "selectedIndex", "getSelectedIndex", "setForegroundAt", "index", "color", "Ljava/awt/Color;", "setTextAttributes", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "setTabLayoutPolicy", "policy", "setTabLayoutPolicy$intellij_platform_ide_impl", "setTabPlacement", "tabPlacement", "setTabPlacement$intellij_platform_ide_impl", "getSelectedComponent", "ignorePopup", "", "getSelectedComponent$intellij_platform_ide_impl", "insertTab", "Lcom/intellij/ui/tabs/TabInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "tooltip", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "indexToInsert", "selectedEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "holderCreator", "Lkotlin/Function1;", "Lcom/intellij/ui/tabs/TabInfoIconHolder;", "insertTab$intellij_platform_ide_impl", "setTabs", "tabs", "", "setTabs$intellij_platform_ide_impl", "Lcom/intellij/ui/tabs/JBTabs;", "getTabs", "()Lcom/intellij/ui/tabs/JBTabs;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabbedContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabbedContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,763:1\n1#2:764\n*E\n"})
public final class EditorTabbedContainer {
    @NotNull
    private final EditorWindow window;
    @NotNull
    private final CoroutineScope coroutineScope;
    @JvmField
    @NotNull
    public final JBEditorTabs editorTabs;
    @NotNull
    private final TabInfo.DragOutDelegate dragOutDelegate;

    public EditorTabbedContainer(@NotNull EditorWindow window, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.window = window;
        this.coroutineScope = coroutineScope;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> EditorTabbedContainer._init_$lambda$0(disposable2, arg_0));
        this.editorTabs = new EditorTabs(this.coroutineScope, disposable2, this.window);
        this.dragOutDelegate = new EditorTabbedContainerDragOutDelegate(this.window, (JBTabsImpl)this.editorTabs);
        Project project2 = this.window.getManager().getProject();
        SimpleMessageBusConnection simpleMessageBusConnection = project2.getMessageBus().connect(this.coroutineScope);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        simpleMessageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(FileEditorManager source, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((EditorTabs)editorTabs).updateActive();
            }

            public void fileClosed(FileEditorManager source, VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                ((EditorTabs)editorTabs).updateActive();
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ((EditorTabs)editorTabs).updateActive();
            }
        });
        ((EditorTabs)this.editorTabs).getComponent().setFocusable(false);
        ((EditorTabs)this.editorTabs).getComponent().setTransferHandler(new EditorTabbedContainerTransferHandler(this.window));
        JBTabsPresentation jBTabsPresentation = this.editorTabs.setPopupGroup(EditorTabbedContainer::_init_$lambda$1, "EditorTabPopup", false).addTabMouseListener((MouseListener)new TabMouseListener(this.window, (JBTabsImpl)this.editorTabs)).getPresentation();
        TimedDeadzone.Length length = TimedDeadzone.NULL;
        Intrinsics.checkNotNullExpressionValue((Object)length, (String)"NULL");
        jBTabsPresentation.setTabLabelActionsMouseDeadzone(length).setTabLabelActionsAutoHide(false);
        this.editorTabs.setSelectionChangeHandler((arg_0, arg_1, arg_2) -> EditorTabbedContainer._init_$lambda$2(this, project2, arg_0, arg_1, arg_2));
        ((EditorTabs)this.editorTabs).getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (editorTabs.findInfo(e) != null || window.getOwner().isFloating()) {
                    return;
                }
                if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    EditorTabbedContainerKt.access$doProcessDoubleClick(e, (JBTabsImpl)editorTabs, window);
                }
            }
        });
    }

    public final int getTabCount() {
        return this.editorTabs.getTabCount();
    }

    @NotNull
    public final ActionCallback setSelectedIndex(int indexToSelect) {
        if (indexToSelect >= this.editorTabs.getTabCount()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"REJECTED");
            return actionCallback;
        }
        return this.editorTabs.select(this.editorTabs.getTabAt(indexToSelect), true);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.editorTabs.getComponent();
    }

    public final void removeTabAt(int componentIndex, int indexToSelect) {
        TabInfo info = this.editorTabs.getTabAt(componentIndex);
        if (info.isHidden() || !this.window.getManager().getProject().isOpen() || this.window.isDisposed()) {
            this.editorTabs.removeTabWithoutChangingSelection(info);
        } else {
            TabInfo toSelect = indexToSelect >= 0 && indexToSelect < this.editorTabs.getTabCount() ? this.editorTabs.getTabAt(indexToSelect) : null;
            JBTabsImpl.removeTab$default((JBTabsImpl)((JBTabsImpl)this.editorTabs), (TabInfo)info, (TabInfo)toSelect, (boolean)false, (int)4, null);
        }
    }

    public final int getSelectedIndex() {
        int n;
        TabInfo tabInfo = this.editorTabs.getSelectedInfo();
        if (tabInfo != null) {
            TabInfo it = tabInfo;
            boolean bl = false;
            n = this.editorTabs.getIndexOf(it);
        } else {
            n = -1;
        }
        return n;
    }

    public final void setForegroundAt(int index, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.editorTabs.getTabAt(index).setDefaultForeground(color);
    }

    public final void setTextAttributes(int index, @Nullable TextAttributes attributes) {
        this.editorTabs.getTabAt(index).setDefaultAttributes(attributes);
    }

    public final void setTabLayoutPolicy$intellij_platform_ide_impl(int policy) {
        switch (policy) {
            case 1: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setSingleRow(true);
                break;
            }
            case 0: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    public final void setTabPlacement$intellij_platform_ide_impl(int tabPlacement) {
        switch (tabPlacement) {
            case 1: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                JBTabsPresentation jBTabsPresentation = this.editorTabs.setTabsPosition(JBTabsPosition.right);
                break;
            }
            case 0: {
                this.editorTabs.setHideTabs(true);
                JBTabsPresentation jBTabsPresentation = Unit.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tab placement code=" + tabPlacement);
            }
        }
    }

    @Nullable
    public final Object getSelectedComponent$intellij_platform_ide_impl(boolean ignorePopup) {
        TabInfo tabInfo = ignorePopup ? this.editorTabs.getSelectedInfo() : this.editorTabs.getTargetInfo();
        return tabInfo != null ? tabInfo.getComponent() : null;
    }

    @NotNull
    public final TabInfo insertTab$intellij_platform_ide_impl(@NotNull VirtualFile file2, @Nullable Icon icon2, @NotNull JComponent component2, @Nullable String tooltip, int indexToInsert, @Nullable FileEditor selectedEditor, @NotNull Disposable parentDisposable, @NotNull Function1<? super TabInfo, ? extends TabInfoIconHolder> holderCreator) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(holderCreator, (String)"holderCreator");
        TabInfo tabInfo = this.editorTabs.findInfo((Object)file2);
        if (tabInfo != null) {
            TabInfo it = tabInfo;
            boolean bl = false;
            return it;
        }
        AnAction anAction = ActionManager.getInstance().getAction("EditorTabActionGroup");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getAction(...)");
        TabInfo tab = EditorTabbedContainerKt.createTabInfo(component2, file2, parentDisposable, this.window, anAction, (Function1<? super TabInfo, Unit>)((Function1)arg_0 -> EditorTabbedContainer.insertTab$lambda$1(file2, tooltip, holderCreator, icon2, arg_0)));
        FileEditor fileEditor = selectedEditor;
        if (fileEditor != null && (fileEditor = fileEditor.getTabActions()) != null) {
            FileEditor it = fileEditor;
            boolean bl = false;
            tab.setTabPaneActions((ActionGroup)it);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file2, tab, null){
            Object L$0;
            int label;
            final /* synthetic */ EditorTabbedContainer this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ TabInfo $tab;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$tab = $tab;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EditorTabPresentationUtil.INSTANCE.getCustomEditorTabTitleAsync(EditorTabbedContainer.access$getWindow$p(this.this$0).getManager().getProject(), this.$file, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (String)v0;
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        title = v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)title);
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUiWithModelAccess((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$tab, title, null){
                            int label;
                            final /* synthetic */ TabInfo $tab;
                            final /* synthetic */ String $title;
                            {
                                this.$tab = $tab;
                                this.$title = $title;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$tab.setText(this.$title);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        title = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Project project2 = this.window.getManager().getProject();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, file2, tab, null){
            Object L$0;
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ TabInfo $tab;
            {
                this.$project = $project;
                this.$file = $file;
                this.$tab = $tab;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.project.Project com.intellij.openapi.vfs.VirtualFile ), ()Ljava/awt/Color;)((Project)this.$project, (VirtualFile)this.$file), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        color = (Color)v0;
                        v1 = CoroutinesKt.getUiWithModelAccess((Dispatchers)Dispatchers.INSTANCE);
                        v2 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)color);
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$tab, color, null){
                            int label;
                            final /* synthetic */ TabInfo $tab;
                            final /* synthetic */ Color $color;
                            {
                                this.$tab = $tab;
                                this.$color = $color;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$tab.setTabColor(this.$color);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        color = (Color)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Color invokeSuspend$lambda$0(Project $project, VirtualFile $file) {
                return EditorTabPresentationUtil.getEditorTabBackgroundColor((Project)$project, (VirtualFile)$file);
            }
        }), (int)3, null);
        tab.setDragOutDelegate(this.dragOutDelegate);
        this.editorTabs.addTabSilently(tab, indexToInsert);
        return tab;
    }

    public final void setTabs$intellij_platform_ide_impl(@NotNull List<TabInfo> tabs) {
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        this.editorTabs.setTabs(tabs);
        for (TabInfo tab : tabs) {
            tab.setDragOutDelegate(this.dragOutDelegate);
        }
    }

    @NotNull
    public final JBTabs getTabs() {
        return (JBTabs)this.editorTabs;
    }

    private static final Unit _init_$lambda$0(Disposable $disposable, Throwable it) {
        Disposer.dispose((Disposable)$disposable);
        return Unit.INSTANCE;
    }

    private static final ActionGroup _init_$lambda$1() {
        AnAction anAction = CustomActionsSchema.Companion.getInstance().getCorrectedAction("EditorTabPopupMenu");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        return (ActionGroup)anAction;
    }

    private static final ActionCallback _init_$lambda$2(EditorTabbedContainer this$0, Project $project, TabInfo tabInfo, boolean bl, ActiveRunnable doChangeSelection) {
        Intrinsics.checkNotNullParameter((Object)doChangeSelection, (String)"doChangeSelection");
        if (this$0.window.isDisposed()) {
            return ActionCallback.DONE;
        }
        ActionCallback result2 = new ActionCallback();
        IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance($project);
        CommandProcessor.getInstance().executeCommand($project, () -> EditorTabbedContainer.lambda$2$0(ideDocumentHistory, result2, doChangeSelection), "EditorChange", null);
        return result2;
    }

    private static final void lambda$2$0(IdeDocumentHistory $ideDocumentHistory, ActionCallback $result, ActiveRunnable $doChangeSelection) {
        $ideDocumentHistory.onSelectionChanged();
        $result.notify($doChangeSelection.run());
    }

    private static final Unit insertTab$lambda$1(VirtualFile $file, String $tooltip, Function1 $holderCreator, Icon $icon, TabInfo it) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = $file.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            it.setText(string);
            it.setTooltipText($tooltip);
            if (UISettings.Companion.getInstance().getShowFileIconInTabs()) {
                it.setIconHolder((TabInfoIconHolder)$holderCreator.invoke((Object)it)).setIcon($icon);
            }
            if ((object = InternalUICustomization.Companion.getInstance()) == null || (object = ((InternalUICustomization)object).getAiComponentMarker()) == null) break block1;
            ((AiInternalUiComponentMarker)object).markAiComponent(it.getComponent(), (UserDataHolder)$file);
        }
        return Unit.INSTANCE;
    }
}

