/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditor;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditorKt;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditorResourceHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0089\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u001c\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\b\u00100\u001a\u00020\u001fH\u0016J\b\u00101\u001a\u000202H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u00063"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLFileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "request", "Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/testFramework/LightVirtualFile;Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Request;)V", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "contentPanel", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "timeoutJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/Job;", "initial", "Ljava/util/concurrent/atomic/AtomicBoolean;", "navigating", "htmlTabScope", "Lkotlinx/coroutines/CoroutineScope;", "jsRouter", "Lorg/cef/browser/CefMessageRouter;", "requestHandler", "Lorg/cef/handler/CefRequestHandler;", "multiPanel", "com/intellij/openapi/fileEditor/impl/HTMLFileEditor$multiPanel$1", "Lcom/intellij/openapi/fileEditor/impl/HTMLFileEditor$multiPanel$1;", "browse", "", "url", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHTMLFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HTMLFileEditor.kt\ncom/intellij/openapi/fileEditor/impl/HTMLFileEditor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,320:1\n42#2,3:321\n*S KotlinDebug\n*F\n+ 1 HTMLFileEditor.kt\ncom/intellij/openapi/fileEditor/impl/HTMLFileEditor\n*L\n70#1:321,3\n*E\n"})
public final class HTMLFileEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final LightVirtualFile file;
    @NotNull
    private final HTMLEditorProvider.Request request;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final JCEFHtmlPanel contentPanel;
    @NotNull
    private final AtomicReference<Job> timeoutJob;
    @NotNull
    private final AtomicBoolean initial;
    @NotNull
    private final AtomicBoolean navigating;
    @NotNull
    private final CoroutineScope htmlTabScope;
    @Nullable
    private CefMessageRouter jsRouter;
    @Nullable
    private CefRequestHandler requestHandler;
    @NotNull
    private final multiPanel.1 multiPanel;

    public HTMLFileEditor(@NotNull Project project2, @NotNull LightVirtualFile file2, @NotNull HTMLEditorProvider.Request request) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project2;
        this.file = file2;
        this.request = request;
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0, 4, null);
        this.contentPanel = new JCEFHtmlPanel(true, null, null);
        this.timeoutJob = new AtomicReference();
        this.initial = new AtomicBoolean(true);
        this.navigating = new AtomicBoolean(false);
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.htmlTabScope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, (String)("HTMLFileEditor[" + this.file.getName() + "]"), null, (boolean)false, (int)6, null);
        this.multiPanel = new MultiPanel(this){
            final /* synthetic */ HTMLFileEditor this$0;
            {
                this.this$0 = $receiver;
            }

            protected JComponent create(int key) {
                JComponent jComponent;
                switch (key) {
                    case 1: {
                        jComponent = (JComponent)HTMLFileEditor.access$getLoadingPanel$p(this.this$0);
                        break;
                    }
                    case 0: {
                        JComponent jComponent2 = HTMLFileEditor.access$getContentPanel$p(this.this$0).getComponent();
                        jComponent = jComponent2;
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown key: " + key);
                    }
                }
                return jComponent;
            }

            public ActionCallback select(int key, boolean now) {
                ActionCallback callback = super.select(key, now);
                if (key == 0) {
                    UIUtil.invokeLaterIfNeeded(() -> multiPanel.1.select$lambda$0(this.this$0));
                }
                Intrinsics.checkNotNull((Object)callback);
                return callback;
            }

            private static final void select$lambda$0(HTMLFileEditor this$0) {
                HTMLFileEditor.access$getContentPanel$p(this$0).getComponent().requestFocusInWindow();
            }
        };
        this.loadingPanel.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.contentPanel));
        this.contentPanel.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                if (initial.get()) {
                    if (isLoading) {
                        EdtInvocationManager.getInstance().invokeLater(() -> 1.onLoadingStateChange$lambda$0(this));
                    } else {
                        Job job2 = timeoutJob.getAndSet(null);
                        if (job2 != null) {
                            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                        }
                        initial.set(false);
                        EdtInvocationManager.getInstance().invokeLater(() -> 1.onLoadingStateChange$lambda$1(this));
                    }
                }
            }

            private static final void onLoadingStateChange$lambda$0(HTMLFileEditor this$0) {
                this$0.loadingPanel.startLoading();
                this$0.multiPanel.select(1, true);
            }

            private static final void onLoadingStateChange$lambda$1(HTMLFileEditor this$0) {
                this$0.loadingPanel.stopLoading();
                this$0.multiPanel.select(0, true);
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.getJBCefClient().addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean userGesture, boolean isRedirect) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if (userGesture) {
                    navigating.set(true);
                    String string = request.getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
                    this.browse(string);
                    return true;
                }
                return false;
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.getJBCefClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String targetUrl, String targetFrameName) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
                this.browse(targetUrl);
                return true;
            }
        }, this.contentPanel.getCefBrowser());
        final HTMLEditorProvider.JsQueryHandler queryHandler = this.request.getQueryHandler$intellij_platform_ide_impl();
        if (queryHandler != null) {
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig("jbCefQuery", "jbCefQueryCancel");
            CefMessageRouter cefMessageRouter = this.jsRouter = JBCefApp.getInstance().createMessageRouter(config);
            Intrinsics.checkNotNull((Object)cefMessageRouter);
            cefMessageRouter.addHandler((CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

                public boolean onQuery(CefBrowser browser, CefFrame frame, long id2, String request, boolean persistent, CefQueryCallback callback) {
                    Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                    Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                    Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                    BuildersKt.launch$default((CoroutineScope)htmlTabScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(queryHandler, id2, request, callback, null){
                        Object L$1;
                        int I$0;
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ HTMLEditorProvider.JsQueryHandler $queryHandler;
                        final /* synthetic */ long $id;
                        final /* synthetic */ String $request;
                        final /* synthetic */ CefQueryCallback $callback;
                        {
                            this.$queryHandler = $queryHandler;
                            this.$id = $id;
                            this.$request = $request;
                            this.$callback = $callback;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = (CoroutineScope)this.L$0;
                            var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var3_4 = $this$launch;
                                    var4_5 = this.$queryHandler;
                                    var5_6 = this.$id;
                                    var7_9 = this.$request;
                                    $this$invokeSuspend_u24lambda_u240 = var3_4;
                                    $i$a$-runCatching-HTMLFileEditor$4$onQuery$1$1 = 0;
                                    v0 = var7_9;
                                    if (v0 == null) {
                                        v0 = "";
                                    }
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                                    this.I$0 = $i$a$-runCatching-HTMLFileEditor$4$onQuery$1$1;
                                    this.label = 1;
                                    v1 = var4_5.query(var5_6, v0, (Continuation<? super String>)this);
                                    ** if (v1 != var10_3) goto lbl25
lbl24:
                                    // 1 sources

                                    return var10_3;
lbl25:
                                    // 1 sources

                                    ** GOTO lbl33
                                }
                                case 1: {
                                    $i$a$-runCatching-HTMLFileEditor$4$onQuery$1$1 = this.I$0;
                                    $this$invokeSuspend_u24lambda_u240 = (CoroutineScope)this.L$1;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl33:
                                        // 2 sources

                                        var8_11 = Result.constructor-impl((Object)((String)v1));
                                    }
                                    catch (Throwable var9_14) {
                                        var8_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_14));
                                    }
                                    var3_4 = var8_11;
                                    var4_5 = this.$callback;
                                    if (Result.isSuccess-impl((Object)var3_4)) {
                                        it = (String)var3_4;
                                        $i$a$-onSuccess-HTMLFileEditor$4$onQuery$1$2 = false;
                                        var4_5.success(it);
                                    }
                                    var4_5 = this.$callback;
                                    v2 = Result.exceptionOrNull-impl((Object)var3_4);
                                    if (v2 != null) {
                                        it = var5_8 = v2;
                                        $i$a$-onFailure-HTMLFileEditor$4$onQuery$1$3 = false;
                                        var4_5.failure(-1, it.getClass() + ": " + it.getMessage());
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    return true;
                }
            }, true);
            this.contentPanel.getJBCefClient().getCefClient().addMessageRouter(this.jsRouter);
        }
        HTMLEditorProvider.ResourceHandler resourceHandler = this.request.getRequestHandler$intellij_platform_ide_impl();
        if (resourceHandler != null) {
            HTMLEditorProvider.ResourceHandler handler = resourceHandler;
            boolean bl = false;
            CoroutineScope coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.htmlTabScope, (String)"HTMLFileEditorResourceHandler", (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (boolean)false, (int)4, null);
            this.requestHandler = (CefRequestHandler)new CefRequestHandlerAdapter(handler, coroutineScope){
                private final 5.REQUEST_HANDLER.1 REQUEST_HANDLER;
                final /* synthetic */ HTMLEditorProvider.ResourceHandler $handler;
                {
                    this.$handler = $handler;
                    this.REQUEST_HANDLER = new CefResourceRequestHandlerAdapter($handler, $coroutineScope){
                        final /* synthetic */ HTMLEditorProvider.ResourceHandler $handler;
                        final /* synthetic */ CoroutineScope $coroutineScope;
                        {
                            this.$handler = $handler;
                            this.$coroutineScope = $coroutineScope;
                        }

                        public CefResourceHandler getResourceHandler(CefBrowser browser, CefFrame frame, CefRequest request) {
                            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            return (CefResourceHandler)new HTMLFileEditorResourceHandler(this.$handler, this.$coroutineScope);
                        }
                    };
                }

                public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                    Object object = request;
                    if (object == null || (object = object.getURL()) == null || (object = HTMLFileEditorKt.access$toURIOrNull((String)object)) == null) {
                        return null;
                    }
                    Object uri = object;
                    if (!this.$handler.shouldInterceptRequest(new HTMLEditorProvider.ResourceHandler.ResourceRequest((URI)uri))) {
                        return null;
                    }
                    return (CefResourceRequestHandler)this.REQUEST_HANDLER;
                }
            };
            JBCefClient jBCefClient = this.contentPanel.getJBCefClient();
            CefRequestHandler cefRequestHandler = this.requestHandler;
            Intrinsics.checkNotNull((Object)cefRequestHandler);
            jBCefClient.addRequestHandler(cefRequestHandler, this.contentPanel.getCefBrowser());
        }
        this.contentPanel.getJBCefClient().addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onStatusMessage(CefBrowser browser, String text2) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                StatusBar.Info.set$default((String)text2, (Project)project, null, (int)4, null);
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.setErrorPage((arg_0, arg_1, arg_2) -> HTMLFileEditor._init_$lambda$1(this, arg_0, arg_1, arg_2));
        this.multiPanel.select(0, true);
        if (this.request.html != null) {
            String string = this.request.html;
            String string2 = this.request.url;
            if (string2 == null) {
                string2 = "about:blank";
            }
            this.contentPanel.loadHTML(string, string2);
        } else {
            String string = this.request.getTimeoutHtml$intellij_platform_ide_impl();
            if (string == null) {
                String string3 = EditorBundle.message((String)"message.html.editor.timeout", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            String timeoutText = string;
            this.timeoutJob.set(BuildersKt.launch$default((CoroutineScope)this.htmlTabScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutText, null){
                int label;
                final /* synthetic */ HTMLFileEditor this$0;
                final /* synthetic */ String $timeoutText;
                {
                    this.this$0 = $receiver;
                    this.$timeoutText = $timeoutText;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)Registry.Companion.intValue("html.editor.timeout", 10000), (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$timeoutText, null){
                                int label;
                                final /* synthetic */ HTMLFileEditor this$0;
                                final /* synthetic */ String $timeoutText;
                                {
                                    this.this$0 = $receiver;
                                    this.$timeoutText = $timeoutText;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.this$0.contentPanel.loadHTML(this.$timeoutText);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
            String string4 = this.request.url;
            Intrinsics.checkNotNull((Object)string4);
            this.contentPanel.loadURL(string4);
        }
    }

    private final void browse(String url) {
        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url));
    }

    @NotNull
    public JComponent getComponent() {
        return this.multiPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.multiPanel;
    }

    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"tab.title.html.preview", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void dispose() {
        block1: {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.htmlTabScope, null, (int)1, null);
            CefMessageRouter cefMessageRouter = this.jsRouter;
            if (cefMessageRouter != null) {
                CefMessageRouter router = cefMessageRouter;
                boolean bl = false;
                this.contentPanel.getJBCefClient().getCefClient().removeMessageRouter(router);
                router.dispose();
            }
            CefRequestHandler cefRequestHandler = this.requestHandler;
            if (cefRequestHandler == null) break block1;
            CefRequestHandler handler = cefRequestHandler;
            boolean bl = false;
            this.contentPanel.getJBCefClient().removeRequestHandler(handler, this.contentPanel.getCefBrowser());
        }
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    private static final String _init_$lambda$1(HTMLFileEditor this$0, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        Intrinsics.checkNotNullParameter((Object)failedUrl, (String)"failedUrl");
        return errorCode == CefLoadHandler.ErrorCode.ERR_ABORTED && this$0.navigating.getAndSet(false) ? null : JBCefBrowserBase.ErrorPage.DEFAULT.create(errorCode, errorText, failedUrl);
    }
}

