/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EntryData;
import com.intellij.openapi.fileEditor.impl.HistoryEntryKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0005R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HistoryEntry;", "", "filePointer", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "selectedProvider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "isPreview", "", "isPersisted", "providerToState", "", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;Lcom/intellij/openapi/fileEditor/FileEditorProvider;ZZLjava/util/Map;Lcom/intellij/openapi/Disposable;)V", "()Z", "providers", "", "getProviders", "()Ljava/util/List;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getState", "provider", "putState", "", "state", "destroy", "writeExternal", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "onProviderRemoval", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHistoryEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryEntry.kt\ncom/intellij/openapi/fileEditor/impl/HistoryEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class HistoryEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final VirtualFilePointer filePointer;
    @JvmField
    @Nullable
    public FileEditorProvider selectedProvider;
    @JvmField
    public boolean isPreview;
    private final boolean isPersisted;
    @NotNull
    private Map<FileEditorProvider, ? extends FileEditorState> providerToState;
    @Nullable
    private final Disposable disposable;
    @NotNull
    public static final String TAG = "entry";
    @NotNull
    public static final String FILE_ATTRIBUTE = "file";
    @NotNull
    public static final String FILE_ID_ATTRIBUTE = "file-id";
    @NotNull
    public static final String MANAGING_FS_ATTRIBUTE = "managing-fs";
    @NotNull
    public static final String PROTOCOL_ATTRIBUTE = "protocol";

    public HistoryEntry(@NotNull VirtualFilePointer filePointer, @Nullable FileEditorProvider selectedProvider, boolean isPreview, boolean isPersisted, @NotNull Map<FileEditorProvider, ? extends FileEditorState> providerToState, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)filePointer, (String)"filePointer");
        Intrinsics.checkNotNullParameter(providerToState, (String)"providerToState");
        this.filePointer = filePointer;
        this.selectedProvider = selectedProvider;
        this.isPreview = isPreview;
        this.isPersisted = isPersisted;
        this.providerToState = providerToState;
        this.disposable = disposable;
    }

    public final boolean isPersisted() {
        return this.isPersisted;
    }

    @NotNull
    public final List<FileEditorProvider> getProviders() {
        List<FileEditorProvider> list2 = List.copyOf((Collection)this.providerToState.keySet());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"copyOf(...)");
        return list2;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.filePointer.getFile();
    }

    @Nullable
    public final FileEditorState getState(@NotNull FileEditorProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return this.providerToState.get(provider);
    }

    public final void putState(@NotNull FileEditorProvider provider, @NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.providerToState = (Map)ExtensionsKt.toPersistentMap(this.providerToState).put((Object)provider, (Object)state2);
    }

    public final void destroy() {
        block0: {
            Disposable disposable = this.disposable;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    @NotNull
    public final Element writeExternal(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Element element = new Element(TAG);
        element.setAttribute(FILE_ATTRIBUTE, this.filePointer.getUrl());
        for (Map.Entry<FileEditorProvider, ? extends FileEditorState> entry : this.providerToState.entrySet()) {
            FileEditorProvider provider = entry.getKey();
            FileEditorState value = entry.getValue();
            Element providerElement = new Element("provider");
            if (Intrinsics.areEqual((Object)provider, (Object)this.selectedProvider)) {
                providerElement.setAttribute("selected", "true");
            }
            providerElement.setAttribute("editor-type-id", provider.getEditorTypeId());
            Element stateElement = new Element("state");
            provider.writeState(value, project2, stateElement);
            if (!stateElement.isEmpty()) {
                providerElement.addContent(stateElement);
            }
            element.addContent(providerElement);
        }
        if (this.isPreview) {
            element.setAttribute("preview", "true");
        }
        return element;
    }

    public final void onProviderRemoval(@NotNull FileEditorProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (this.selectedProvider == provider) {
            this.selectedProvider = null;
        }
        this.providerToState = (Map)ExtensionsKt.toPersistentMap(this.providerToState).remove((Object)provider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HistoryEntry$Companion;", "", "<init>", "()V", "TAG", "", "Lorg/jetbrains/annotations/NonNls;", "FILE_ATTRIBUTE", "FILE_ID_ATTRIBUTE", "MANAGING_FS_ATTRIBUTE", "PROTOCOL_ATTRIBUTE", "createHeavy", "Lcom/intellij/openapi/fileEditor/impl/HistoryEntry;", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lorg/jdom/Element;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nHistoryEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HistoryEntry.kt\ncom/intellij/openapi/fileEditor/impl/HistoryEntry$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n23#2:177\n*S KotlinDebug\n*F\n+ 1 HistoryEntry.kt\ncom/intellij/openapi/fileEditor/impl/HistoryEntry$Companion\n*L\n56#1:177\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HistoryEntry createHeavy(@NotNull Project project2, @NotNull Element e) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileEditorProviderManager fileEditorProviderManager = FileEditorProviderManager.Companion.getInstance();
            EntryData entryData = HistoryEntryKt.access$parseEntry(project2, e, fileEditorProviderManager);
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            try {
                object = VirtualFilePointerManager.getInstance().create(entryData.url, disposable2, null);
            }
            catch (Throwable throwable) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(throwable);
                return null;
            }
            VirtualFilePointer virtualFilePointer = object;
            Intrinsics.checkNotNull((Object)virtualFilePointer);
            VirtualFilePointer pointer = virtualFilePointer;
            LinkedHashMap<Object, Object> stateMap = new LinkedHashMap<Object, Object>();
            for (Pair pair : entryData.providerStates) {
                stateMap.put(pair.getFirst(), pair.getSecond());
            }
            object = entryData.selectedProvider;
            boolean bl = entryData.preview;
            return new HistoryEntry(pointer, (FileEditorProvider)object, bl, true, (Map<FileEditorProvider, ? extends FileEditorState>)stateMap, disposable2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

