/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.FileEditorDropHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J#\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/fileEditor/impl/MyTransferHandler;", "Ljavax/swing/TransferHandler;", "splitters", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;)V", "fileDropHandler", "Lcom/intellij/openapi/fileEditor/impl/text/FileEditorDropHandler;", "importData", "", "comp", "Ljavax/swing/JComponent;", "t", "Ljava/awt/datatransfer/Transferable;", "canImport", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "(Ljavax/swing/JComponent;[Ljava/awt/datatransfer/DataFlavor;)Z", "intellij.platform.ide.impl"})
final class MyTransferHandler
extends TransferHandler {
    @NotNull
    private final EditorsSplitters splitters;
    @NotNull
    private final FileEditorDropHandler fileDropHandler;

    public MyTransferHandler(@NotNull EditorsSplitters splitters2) {
        Intrinsics.checkNotNullParameter((Object)splitters2, (String)"splitters");
        this.splitters = splitters2;
        this.fileDropHandler = new FileEditorDropHandler(null);
    }

    @Override
    public boolean importData(@NotNull JComponent comp, @NotNull Transferable t) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
        if (this.fileDropHandler.canHandleDrop(dataFlavorArray)) {
            this.fileDropHandler.handleDrop(t, this.splitters.getManager().getProject(), this.splitters.getCurrentWindow());
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(@NotNull JComponent comp, @NotNull DataFlavor[] transferFlavors) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
        return this.fileDropHandler.canHandleDrop(transferFlavors);
    }
}

