/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.copy1;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTableUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@ApiStatus.Internal
public final class IgnoredPatternSet {
    private final Set<String> masks;
    private final FileTypeAssocTable<Boolean> ignorePatterns;

    public IgnoredPatternSet(@NotNull List<String> initialMasks) {
        if (initialMasks == null) {
            IgnoredPatternSet.$$$reportNull$$$0(0);
        }
        this.ignorePatterns = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
        FileNameMatcherFactory fileNameMatcherFactory = null;
        this.masks = new LinkedHashSet<String>(initialMasks.size());
        for (String ignoredFile : initialMasks) {
            if (this.ignorePatterns.findAssociatedFileType((CharSequence)ignoredFile) != null) continue;
            this.masks.add(ignoredFile);
            if (fileNameMatcherFactory == null) {
                fileNameMatcherFactory = FileNameMatcherFactory.getInstance();
            }
            this.ignorePatterns.addAssociation(fileNameMatcherFactory.createMatcher(ignoredFile), (Object)Boolean.TRUE);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Set<String> getIgnoreMasks() {
        Set<String> set = Collections.unmodifiableSet(this.masks);
        if (set == null) {
            IgnoredPatternSet.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void setIgnoreMasks(@NotNull String list2) {
        if (list2 == null) {
            IgnoredPatternSet.$$$reportNull$$$0(2);
        }
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            this.addIgnoreMask(tokenizer.nextToken());
        }
    }

    @ApiStatus.Internal
    public void addIgnoreMask(@NotNull String ignoredFile) {
        if (ignoredFile == null) {
            IgnoredPatternSet.$$$reportNull$$$0(3);
        }
        if (this.ignorePatterns.findAssociatedFileType((CharSequence)ignoredFile) == null) {
            this.masks.add(ignoredFile);
            this.ignorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), (Object)Boolean.TRUE);
        }
    }

    public boolean isIgnored(@NotNull CharSequence fileName) {
        if (fileName == null) {
            IgnoredPatternSet.$$$reportNull$$$0(4);
        }
        if (this.ignorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return StringUtilRt.endsWith((CharSequence)fileName, (CharSequence)".__del__");
    }

    @ApiStatus.Internal
    public void clearPatterns() {
        this.masks.clear();
        this.ignorePatterns.removeAllAssociations((Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialMasks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/copy1/IgnoredPatternSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/copy1/IgnoredPatternSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoreMasks";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoreMask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

