/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.CopySettingsPathActionKt;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ui.TextTransferable;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/options/newEditor/CopySettingsPathAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "Companion", "intellij.platform.ide.impl"})
public final class CopySettingsPathAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CopySettingsPathAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Component component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        SettingsEditor editor2 = (SettingsEditor)ComponentUtil.getParentOfType(SettingsEditor.class, (Component)component2);
        event.getPresentation().setText(CopySettingsPathAction.Companion.getActionText());
        event.getPresentation().setEnabledAndVisible(editor2 != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        SettingsTreeView settingsTreeView;
        Component component2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (component2 instanceof JTree && (settingsTreeView = (SettingsTreeView)ComponentUtil.getParentOfType(SettingsTreeView.class, (Component)component2)) != null) {
            SettingsTreeView settingsTreeView2 = settingsTreeView;
            boolean bl = false;
            Transferable transferable = settingsTreeView2.createTransferable(event.getInputEvent());
            if (transferable != null) {
                Transferable it = transferable;
                boolean bl2 = false;
                CopyPasteManager.getInstance().setContents(it);
            }
            return;
        }
        Object object = (SettingsEditor)ComponentUtil.getParentOfType(SettingsEditor.class, (Component)component2);
        if (object == null || (object = ((SettingsEditor)object).getPathNames()) == null) {
            return;
        }
        Object names = object;
        if (names.isEmpty()) {
            return;
        }
        ConfigurableEditor inner = (ConfigurableEditor)ComponentUtil.getParentOfType(ConfigurableEditor.class, (Component)component2);
        if (inner != null) {
            String label2 = CopySettingsPathActionKt.access$getTextLabel(component2);
            ArrayDeque<String> path = new ArrayDeque<String>();
            for (component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT); component2 != null && component2 != inner; component2 = (Component)component2.getParent()) {
                String title2;
                CharSequence charSequence;
                Border border;
                if (component2 instanceof JBTabs) {
                    if (((JBTabs)component2).getSelectedInfo() != null) {
                        TabInfo it;
                        boolean bl = false;
                        path.addFirst(it.getText());
                    }
                }
                if (component2 instanceof JTabbedPane) {
                    path.addFirst(((JTabbedPane)component2).getTitleAt(((JTabbedPane)component2).getSelectedIndex()));
                }
                if (!(component2 instanceof JComponent) || !((border = ((JComponent)component2).getBorder()) instanceof TitledBorder) || (charSequence = (CharSequence)(title2 = ((TitledBorder)border).getTitle())) == null || charSequence.length() == 0) continue;
                path.addFirst(title2);
            }
            names.addAll((Collection)path);
            if (label2 != null) {
                names.add(label2);
            }
        }
        CopySettingsPathActionKt.access$copy((Collection)names);
    }

    @JvmStatic
    @NotNull
    public static final List<Action> createSwingActions(@NotNull Supplier<Collection<String>> supplier) {
        return Companion.createSwingActions(supplier);
    }

    @JvmStatic
    @Nullable
    public static final Transferable createTransferable(@NotNull Collection<String> names) {
        return Companion.createTransferable(names);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0007J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u001a\u0010\u000e\u001a\u0014 \u0010*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000f0\n\u00a2\u0006\u0002\b\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/options/newEditor/CopySettingsPathAction$Companion;", "", "<init>", "()V", "createSwingActions", "", "Ljavax/swing/Action;", "supplier", "Ljava/util/function/Supplier;", "", "", "createTransferable", "Ljava/awt/datatransfer/Transferable;", "names", "getActionText", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCopySettingsPathAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopySettingsPathAction.kt\ncom/intellij/openapi/options/newEditor/CopySettingsPathAction$Companion\n+ 2 CopySettingsPathAction.kt\ncom/intellij/openapi/options/newEditor/CopySettingsPathActionKt\n*L\n1#1,191:1\n159#2,12:192\n159#2,12:204\n*S KotlinDebug\n*F\n+ 1 CopySettingsPathAction.kt\ncom/intellij/openapi/options/newEditor/CopySettingsPathAction$Companion\n*L\n37#1:192,12\n42#1:204,12\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Action> createSwingActions(@NotNull Supplier<Collection<String>> supplier) {
            Object id$iv;
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            Object[] objectArray = new Action[2];
            String string = "CopySettingsPath";
            String string2 = this.getActionText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getActionText(...)");
            String name$iv = string2;
            boolean $i$f$createSwingAction22 = false;
            AbstractAction action$iv = new AbstractAction(name$iv, supplier){
                final /* synthetic */ Supplier $supplier$inlined;
                {
                    this.$supplier$inlined = supplier;
                    super($name);
                }

                public void actionPerformed(ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    boolean bl = false;
                    T t = this.$supplier$inlined.get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                    CopySettingsPathActionKt.access$copy((Collection)t);
                }
            };
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut((String)id$iv);
            if (keyboardShortcut != null) {
                KeyboardShortcut it$iv = keyboardShortcut;
                boolean bl = false;
                action$iv.putValue("AcceleratorKey", it$iv.getFirstKeyStroke());
            }
            objectArray[0] = action$iv;
            id$iv = null;
            Object[] $i$f$createSwingAction22 = new Object[]{CommonBundle.settingsTitle()};
            String string3 = IdeBundle.message((String)"action.copy.link.text", (Object[])$i$f$createSwingAction22);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            name$iv = string3;
            boolean $i$f$createSwingAction = false;
            action$iv = new AbstractAction(name$iv, supplier){
                final /* synthetic */ Supplier $supplier$inlined;
                {
                    this.$supplier$inlined = supplier;
                    super($name);
                }

                public void actionPerformed(ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    boolean bl = false;
                    CopySettingsPathActionKt.access$copyLink(this.$supplier$inlined, false);
                }
            };
            objectArray[1] = action$iv;
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @JvmStatic
        @Nullable
        public final Transferable createTransferable(@NotNull Collection<String> names) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            if (names.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder(CommonBundle.settingsActionPath());
            for (String name2 : names) {
                sb.append(" | ").append(name2);
            }
            return new TextTransferable(sb);
        }

        private final String getActionText() {
            Object[] objectArray = new Object[]{CommonBundle.settingsTitle()};
            return ActionsBundle.message((String)"action.CopySettingsPath.text.template", (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

