/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.util.ApplicationKt;
import com.intellij.util.CoroutinesKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/project/InitialVfsRefreshService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "job", "Lkotlinx/coroutines/CompletableDeferred;", "", "scheduleInitialVfsRefresh", "runInitialVfsRefresh", "isInitialVfsRefreshFinished", "", "awaitInitialVfsRefreshFinished", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInitialVfsRefreshService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitialVfsRefreshService.kt\ncom/intellij/openapi/project/InitialVfsRefreshService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n13#2:97\n60#2,5:98\n13#2:103\n60#2,5:104\n*S KotlinDebug\n*F\n+ 1 InitialVfsRefreshService.kt\ncom/intellij/openapi/project/InitialVfsRefreshService\n*L\n34#1:97\n36#1:98,5\n66#1:103\n68#1:104,5\n*E\n"})
public final class InitialVfsRefreshService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicBoolean started;
    @NotNull
    private final CompletableDeferred<Unit> job;

    public InitialVfsRefreshService(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.started = new AtomicBoolean(false);
        this.job = CompletableDeferredKt.CompletableDeferred((Job)JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()));
    }

    public final void scheduleInitialVfsRefresh() {
        if (this.started.getAndSet(true)) {
            return;
        }
        String string = this.project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        String projectId = string;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InitialVfsRefreshService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        if (Boolean.parseBoolean(System.getProperty("ij.indexes.skip.initial.refresh")) || ApplicationKt.getApplication().isUnitTestMode()) {
            Logger $this$debug_u24default$iv = logger2;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger3 = $this$debug_u24default$iv;
                boolean bl = false;
                logger3.debug(projectId + ": initial VFS refresh skipped", e$iv);
            }
            this.job.complete((Object)Unit.INSTANCE);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(logger2, projectId, this, null){
            Object L$0;
            long J$0;
            int label;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $projectId;
            final /* synthetic */ InitialVfsRefreshService this$0;
            {
                this.$logger = $logger;
                this.$projectId = $projectId;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$logger.info(this.$projectId + ": marking roots for initial VFS refresh");
                        v0 = ProjectRootManagerEx.getInstanceEx((Project)InitialVfsRefreshService.access$getProject$p(this.this$0)).markRootsForRefresh();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"markRootsForRefresh(...)");
                        roots = v0;
                        this.$logger.info(this.$projectId + ": starting initial VFS refresh of " + roots.size() + " roots");
                        t = System.nanoTime();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)roots);
                        this.J$0 = t;
                        this.label = 1;
                        v1 = RefreshQueue.Companion.getInstance().refresh(true, roots, (Continuation)this);
                        ** if (v1 != var7_2) goto lbl19
lbl18:
                        // 1 sources

                        return var7_2;
lbl19:
                        // 1 sources

                        ** GOTO lbl27
                    }
                    case 1: {
                        t = this.J$0;
                        roots = (List)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl27:
                            // 2 sources

                            duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
                            this.$logger.info(this.$projectId + ": initial VFS refresh finished in " + duration + " ms");
                            VfsUsageCollector.logInitialRefresh(InitialVfsRefreshService.access$getProject$p(this.this$0), duration);
                        }
                        catch (Throwable var2_5) {
                            throw var2_5;
                        }
                        finally {
                            InitialVfsRefreshService.access$getJob$p(this.this$0).complete((Object)Unit.INSTANCE);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInitialVfsRefresh() {
        if (this.started.getAndSet(true)) {
            return;
        }
        String string = this.project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        String projectId = string;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InitialVfsRefreshService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        if (Boolean.parseBoolean(System.getProperty("ij.indexes.skip.initial.refresh")) || ApplicationKt.getApplication().isUnitTestMode()) {
            Logger $this$debug_u24default$iv = logger2;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger3 = $this$debug_u24default$iv;
                boolean bl = false;
                logger3.debug(projectId + ": initial VFS refresh skipped", e$iv);
            }
            this.job.complete((Object)Unit.INSTANCE);
            return;
        }
        try {
            logger2.info(projectId + ": marking roots for initial VFS refresh");
            List list2 = ProjectRootManagerEx.getInstanceEx((Project)this.project).markRootsForRefresh();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"markRootsForRefresh(...)");
            List roots = list2;
            logger2.info(projectId + ": starting initial VFS refresh of " + roots.size() + " roots");
            RefreshSession session = RefreshQueue.Companion.getInstance().createSession(false, true, null);
            CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.coroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, null){
                int label;
                final /* synthetic */ RefreshSession $session;
                {
                    this.$session = $session;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$session.cancel();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            session.addAllFiles((Collection)roots);
            long t = System.nanoTime();
            session.launch();
            long duration2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            logger2.info(projectId + ": initial VFS refresh finished in " + duration2 + " ms");
            VfsUsageCollector.logInitialRefresh(this.project, duration2);
        }
        finally {
            this.job.complete((Object)Unit.INSTANCE);
        }
    }

    public final boolean isInitialVfsRefreshFinished() {
        return this.job.isCompleted();
    }

    @Nullable
    public final Object awaitInitialVfsRefreshFinished(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.job.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(InitialVfsRefreshService $this) {
        return $this.project;
    }

    public static final /* synthetic */ CompletableDeferred access$getJob$p(InitialVfsRefreshService $this) {
        return $this.job;
    }
}

