/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.FilePartNodeRoot;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectionListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerManagerImpl.class);
    private static final boolean IS_UNDER_UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private static final boolean IS_INTERNAL = ApplicationManager.getApplication().isInternal();
    private static final Key<Boolean> DISABLE_VFS_CONSISTENCY_CHECK_IN_TEST = Key.create((String)"DISABLE_VFS_CONSISTENCY_CHECK_IN_TEST");
    private final FilePartNodeRoot myLocalRoot = FilePartNodeRoot.createFakeRoot((NewVirtualFileSystem)LocalFileSystem.getInstance());
    private final FilePartNodeRoot myTempRoot = FilePartNodeRoot.createFakeRoot((NewVirtualFileSystem)TempFileSystem.getInstance());
    private final Set<VirtualFilePointerContainerImpl> myContainers = new ReferenceOpenHashSet();
    @NotNull
    private final VirtualFilePointerListener myPublisher;
    private int myPointerSetModCount;
    private volatile CollectedEvents myCollectedEvents;
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity = CollectionFactory.createSmallMemoryFootprintMap();

    static boolean shouldCheckConsistency() {
        return IS_UNDER_UNIT_TEST && !ApplicationManagerEx.isInStressTest() && !TestModeFlags.is(DISABLE_VFS_CONSISTENCY_CHECK_IN_TEST);
    }

    @TestOnly
    public static void disableConsistencyChecksInTestsTemporarily(@NotNull Disposable testDisposable) {
        if (testDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(0);
        }
        TestModeFlags.set(DISABLE_VFS_CONSISTENCY_CHECK_IN_TEST, (Object)true, (Disposable)testDisposable);
    }

    public VirtualFilePointerManagerImpl() {
        this.myPublisher = (VirtualFilePointerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFilePointerListener.TOPIC);
    }

    public void dispose() {
        this.assertAllPointersDisposed();
    }

    @TestOnly
    @NotNull
    public synchronized Collection<? extends VirtualFilePointer> getPointersUnder(@NotNull VirtualFileSystemEntry parent, @NotNull String childName) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(1);
        }
        if (childName == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(2);
        }
        assert (!StringUtil.isEmptyOrSpaces((String)childName));
        @NotNull MultiMap nodes = MultiMap.create();
        this.addRelevantPointers(null, parent, VirtualFilePointerManagerImpl.toNameId(childName), (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)nodes, new ArrayList(), true, parent.getFileSystem(), (VFileEvent)new VFileDeleteEvent((Object)this, (VirtualFile)parent));
        Collection collection = nodes.values();
        if (collection == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private void addRelevantPointers(@Nullable VirtualFile file2, @NotNull VirtualFileSystemEntry parent, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, @NotNull List<? super NodeToUpdate> toUpdateNodes, boolean addSubdirectoryPointers, @NotNull NewVirtualFileSystem fs, @NotNull VFileEvent event) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(4);
        }
        if (toFirePointers == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(5);
        }
        if (toUpdateNodes == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(6);
        }
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(7);
        }
        if (event == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(8);
        }
        this.addRelevantPointers(parent, file2, childNameId, toFirePointers, toUpdateNodes, addSubdirectoryPointers, fs, true, event);
    }

    private void addRelevantPointers(@NotNull VirtualFileSystemEntry parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, @NotNull List<? super NodeToUpdate> toUpdateNodes, boolean addSubdirectoryPointers, @NotNull NewVirtualFileSystem fs, boolean addRecursiveDirectoryPointers, @NotNull VFileEvent event) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(9);
        }
        if (toFirePointers == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(10);
        }
        if (toUpdateNodes == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(11);
        }
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(12);
        }
        if (event == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(13);
        }
        this.getRoot(fs).addRelevantPointersFrom(parent, file2, childNameId, toFirePointers, toUpdateNodes, addSubdirectoryPointers, fs, addRecursiveDirectoryPointers, event);
    }

    @NotNull
    private FilePartNodeRoot getRoot(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(14);
        }
        FilePartNodeRoot filePartNodeRoot = fs instanceof TempFileSystem ? this.myTempRoot : this.myLocalRoot;
        if (filePartNodeRoot == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(15);
        }
        return filePartNodeRoot;
    }

    @NotNull
    public VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(17);
        }
        return this.create(null, url, parent, listener2, false);
    }

    @NotNull
    public VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (file2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(19);
        }
        return this.create(file2, null, parent, listener2, false);
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") @Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file2, @Nullable(value="null means url has to be computed from the (not-null) file path") @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2, boolean recursive) {
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
                path = url;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
                path = url.substring(protocolEnd + "://".length());
            }
            if (fileSystem == null) {
                if (IS_UNDER_UNIT_TEST || IS_INTERNAL) {
                    throw new IllegalArgumentException("Unknown filesystem: '" + protocol + "' in url: '" + url + "'");
                }
                return new LightFilePointer(url);
            }
        } else {
            fileSystem = file2.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = null;
            url = null;
        }
        if (fileSystem instanceof TempFileSystem && listener2 == null) {
            VirtualFile found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            return found == null ? new LightFilePointer(url) : new LightFilePointer(found);
        }
        if (!(fileSystem instanceof VirtualFilePointerCapableFileSystem) || file2 != null && !(file2 instanceof VirtualFileSystemEntry)) {
            VirtualFile found;
            VirtualFile virtualFile = found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            if (url == null) {
                url = file2.getUrl();
            }
            return this.getOrCreateIdentity(url, found, recursive, parentDisposable, listener2);
        }
        if (file2 == null) {
            String cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path);
            if (!Strings.areSameInstance((String)cleanPath, (String)path)) {
                url = VirtualFileManager.constructUrl((String)protocol, (String)cleanPath);
                path = cleanPath;
            }
            if (url.contains("..")) {
                file2 = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file2 != null) {
                    url = file2.getUrl();
                    path = file2.getPath();
                } else {
                    path = FileUtil.toCanonicalPath((String)path);
                    url = VirtualFileManager.constructUrl((String)protocol, (String)path);
                }
            }
            if (file2 == null && StringUtil.isEmptyOrSpaces((String)path)) {
                return this.getOrCreateIdentity(url, VirtualFileManager.getInstance().findFileByUrl(url), recursive, parentDisposable, listener2);
            }
        }
        return this.getOrCreate((VirtualFileSystemEntry)file2, path, url, recursive, parentDisposable, listener2, (NewVirtualFileSystem)fileSystem);
    }

    @NotNull
    private synchronized IdentityVirtualFilePointer getOrCreateIdentity(@NotNull String url, @Nullable VirtualFile found, boolean recursive, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        IdentityVirtualFilePointer pointer;
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(21);
        }
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(22);
        }
        if ((pointer = this.myUrlToIdentity.get(url)) == null) {
            pointer = new IdentityVirtualFilePointer(found, url, this.myUrlToIdentity, this, listener2);
            this.myUrlToIdentity.put(url, pointer);
            DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        }
        pointer.incrementUsageCount(1);
        pointer.recursive = recursive;
        IdentityVirtualFilePointer identityVirtualFilePointer = pointer;
        if (identityVirtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(23);
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path) {
        int slash;
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(24);
        }
        path = FileUtilRt.toSystemIndependentName((String)path);
        path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path);
        int i2 = 0;
        while (i2 < path.length() && (slash = path.indexOf(47, i2)) != -1 && slash != path.length() - 1) {
            char next = path.charAt(slash + 1);
            if (next == '/' && i2 != 0 || next == '/' && !SystemInfo.isWindows || next == '/' && slash == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path) || next == '.' && (slash == path.length() - 2 || path.charAt(slash + 2) == '/')) {
                return VirtualFilePointerManagerImpl.cleanupTail(path, slash);
            }
            i2 = slash + 1;
        }
        String string = path;
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String cleanupTail(@NotNull String path, int slashIndex) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(26);
        }
        StringBuilder s = new StringBuilder(path.length());
        s.append(path, 0, slashIndex);
        for (int i2 = slashIndex; i2 < path.length(); ++i2) {
            char c = path.charAt(i2);
            if (c == '/') {
                char nextC;
                char c2 = nextC = i2 == path.length() - 1 ? (char)'\u0000' : path.charAt(i2 + 1);
                if (nextC == '.') {
                    if (i2 == path.length() - 2) break;
                    char nextNextC = path.charAt(i2 + 2);
                    if (nextNextC == '/') {
                        ++i2;
                        continue;
                    }
                } else if (nextC == '/') continue;
            }
            s.append(c);
        }
        String string = s.toString();
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String trimTrailingSeparators(@NotNull String path) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(28);
        }
        path = StringUtil.trimEnd((String)path, (String)"!/");
        String string = path = UriUtil.trimTrailingSlashes((String)path);
        if (string == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    private synchronized VirtualFilePointerImpl getOrCreate(VirtualFileSystemEntry file2, String path, String url, boolean recursive, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2, @NotNull NewVirtualFileSystem fs) {
        VirtualFilePointerImpl pointer;
        NodeToUpdate toUpdate;
        NewVirtualFileSystem fsFromFile;
        if (parentDisposable == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(30);
        }
        if (fs == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(31);
        }
        Object object = fsFromFile = file2 == null ? VirtualFileManager.getInstance().getFileSystem(VirtualFileManager.extractProtocol((String)url)) : file2.getFileSystem();
        assert (fs == fsFromFile) : "fs=" + String.valueOf(fs) + "; file.fs=" + String.valueOf(fsFromFile) + "; url='" + url + "'; file=" + String.valueOf((Object)file2);
        FilePartNodeRoot root = this.getRoot(fs);
        if (file2 == null) {
            Object normPath = path;
            if (fs instanceof ArchiveFileSystem) {
                int index = -1;
                while ((index = path.indexOf("!/", index + 1)) > 0 && path.charAt(index - 1) == '/') {
                }
                if (index == -1 && !VirtualFilePointerManagerImpl.isArchiveInTheWindowsDiskRoot(path)) {
                    normPath = path + "!/";
                }
            }
            toUpdate = root.findOrCreateByPath((String)normPath, fs);
        } else {
            toUpdate = root.findOrCreateByFile((VirtualFile)file2);
        }
        FilePartNode node = toUpdate.node;
        if (fs != node.fs) {
            if (url != null && (IS_UNDER_UNIT_TEST || IS_INTERNAL)) {
                throw new IllegalArgumentException("Invalid url: '" + url + "'. Its protocol '" + VirtualFileManager.extractProtocol((String)url) + "' is from " + String.valueOf(fsFromFile) + " but the path part points to " + String.valueOf(node.fs));
            }
            LOG.error("fs=" + String.valueOf(fs) + "; node.myFS=" + String.valueOf(node.fs) + "; url=" + url + "; file=" + String.valueOf((Object)file2) + "; node=" + String.valueOf(node));
        }
        if ((pointer = node.getPointer(listener2)) == null) {
            pointer = new VirtualFilePointerImpl(listener2);
            node.addLeaf(pointer);
        }
        pointer.incrementUsageCount(1);
        if (!pointer.recursive) {
            pointer.recursive = recursive;
        }
        root.checkConsistency();
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        ++this.myPointerSetModCount;
        VirtualFilePointerImpl virtualFilePointerImpl = pointer;
        if (virtualFilePointerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(32);
        }
        return virtualFilePointerImpl;
    }

    private static boolean isArchiveInTheWindowsDiskRoot(@NotNull String path) {
        if (path == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(33);
        }
        return OSAgnosticPathUtil.startsWithWindowsDrive((String)path) && path.length() >= 4 && (path.charAt(2) == '!' && path.charAt(3) == '/' || path.length() >= 5 && path.charAt(2) == '/' && path.charAt(3) == '!' && path.charAt(4) == '/');
    }

    @NotNull
    public VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        VirtualFile file2;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(34);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(35);
        }
        VirtualFilePointer virtualFilePointer = (file2 = pointer.getFile()) == null ? this.create(pointer.getUrl(), parent, listener2) : this.create(file2, parent, listener2);
        if (virtualFilePointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(36);
        }
        return virtualFilePointer;
    }

    synchronized void resolveUrlBasedPointers() {
        VirtualFilePointerManagerImpl.resolveUrlBasedPointers(this.myLocalRoot);
        VirtualFilePointerManagerImpl.resolveUrlBasedPointers(this.myTempRoot);
    }

    private static void resolveUrlBasedPointers(@NotNull FilePartNodeRoot root) {
        if (root == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(37);
        }
        for (FilePartNode child : root.children) {
            VirtualFile resolvedChild;
            if (child.isUrlBased() && (resolvedChild = VirtualFileManager.getInstance().findFileByUrl(FilePartNode.urlOf(child.fileOrUrl))) != null) {
                child = child.replaceWithFPPN(resolvedChild, root);
            }
            VirtualFilePointerManagerImpl.resolveUrlBasedPointers(child, root, root);
        }
    }

    private static void resolveUrlBasedPointers(@NotNull FilePartNode node, @NotNull FilePartNode parent, @NotNull FilePartNodeRoot root) {
        if (node == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(38);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(39);
        }
        if (root == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(40);
        }
        node.update(parent, root, "VFPMI invalidated VFP during FS connection", null);
        for (FilePartNode child : node.children) {
            VirtualFilePointerManagerImpl.resolveUrlBasedPointers(child, node, root);
        }
    }

    synchronized void switchToUrlBasedPointers() {
        this.myLocalRoot.replaceChildrenWithUPN();
        this.myTempRoot.replaceChildrenWithUPN();
    }

    public synchronized void assertUrlBasedPointers() {
        VirtualFilePointerManagerImpl.assertUrlBasedPointers(this.myLocalRoot);
        VirtualFilePointerManagerImpl.assertUrlBasedPointers(this.myTempRoot);
    }

    private static void assertUrlBasedPointers(@NotNull FilePartNode node) {
        if (node == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(41);
        }
        if (node.isUrlBased()) {
            for (FilePartNode child : node.children) {
                VirtualFilePointerManagerImpl.assertUrlBasedPointers(child);
            }
        } else {
            throw new IllegalStateException("Node for " + String.valueOf(node.fileOrUrl) + " is not a url-based");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        ArrayList<VirtualFilePointer> leaked = new ArrayList<VirtualFilePointer>(this.dumpAllPointers());
        leaked.sort(Comparator.comparing(VirtualFilePointer::getUrl));
        for (VirtualFilePointer pointer : leaked) {
            try {
                ((VirtualFilePointerImpl)pointer).throwDisposalError("Not disposed pointer: " + String.valueOf(pointer));
            }
            finally {
                ((VirtualFilePointerImpl)pointer).dispose();
            }
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                container.throwDisposalError("Not disposed container");
            }
        }
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(42);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(43);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(44);
        }
        return this.registerContainer(parent, new VirtualFilePointerContainerImpl((VirtualFilePointerManager)this, parent, listener2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl container) {
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(45);
        }
        if (container == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(46);
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            this.myContainers.add(container);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)container);
                Set<VirtualFilePointerContainerImpl> set = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove(container);
                }
                if (!IS_UNDER_UNIT_TEST) assert (removed);
            }

            public String toString() {
                return "Disposing container " + String.valueOf(container);
            }
        });
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = container;
        if (virtualFilePointerContainerImpl == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(47);
        }
        return virtualFilePointerContainerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CollectedEvents collectEvents(@NotNull List<? extends VFileEvent> events) {
        ArrayList allPointersToFire;
        ArrayList<EventDescriptor> eventList;
        long startModCount;
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(48);
        }
        if (!this.hasAnyPointers()) {
            return new CollectedEvents((MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl>)new MultiMap(), List.of(), List.of(), 0L, 0L);
        }
        long start2 = System.currentTimeMillis();
        MultiMap toFirePointers = MultiMap.create();
        ArrayList<NodeToUpdate> toUpdateNodes = new ArrayList<NodeToUpdate>();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            startModCount = this.myPointerSetModCount;
            for (VFileEvent vFileEvent : events) {
                VirtualFileSystemEntry parent;
                VFilePropertyChangeEvent change;
                VirtualFileSystemEntry eventFile;
                ProgressManager.checkCanceled();
                VirtualFileSystem vfs = vFileEvent.getFileSystem();
                if (!(vfs instanceof VirtualFilePointerCapableFileSystem) || !(vfs instanceof NewVirtualFileSystem)) continue;
                NewVirtualFileSystem fs = (NewVirtualFileSystem)vfs;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    VirtualFileSystemEntry file2 = (VirtualFileSystemEntry)deleteEvent.getFile();
                    VirtualFileSystemEntry parent2 = (VirtualFileSystemEntry)FilePartNode.getParentThroughJar((VirtualFile)file2, file2.getFileSystem());
                    if (parent2 == null) continue;
                    this.addRelevantPointers((VirtualFile)file2, parent2, FilePartNode.getNameId((VirtualFile)file2), (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    boolean fireSubdirectoryPointers;
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    if (createEvent.isDirectory()) {
                        fireSubdirectoryPointers = !createEvent.isEmptyDirectory();
                    } else {
                        String createdFileName = createEvent.getChildName();
                        FileType fileType2 = FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)createdFileName));
                        fireSubdirectoryPointers = fileType2 instanceof ArchiveFileType;
                    }
                    this.addRelevantPointers(null, (VirtualFileSystemEntry)createEvent.getParent(), createEvent.getChildNameId(), (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, fireSubdirectoryPointers, fs, vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addRelevantPointers(null, (VirtualFileSystemEntry)copyEvent.getNewParent(), VirtualFilePointerManagerImpl.toNameId(copyEvent.getNewChildName()), (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = (VirtualFileSystemEntry)moveEvent.getFile();
                    int newNameId = FilePartNode.getNameId((VirtualFile)eventFile);
                    this.addRelevantPointers(null, (VirtualFileSystemEntry)moveEvent.getNewParent(), newNameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, vFileEvent);
                    VirtualFileSystemEntry parent3 = (VirtualFileSystemEntry)FilePartNode.getParentThroughJar((VirtualFile)eventFile, eventFile.getFileSystem());
                    if (parent3 == null) continue;
                    this.addRelevantPointers((VirtualFile)eventFile, parent3, newNameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || Comparing.equal((Object)change.getOldValue(), (Object)change.getNewValue()) || (parent = (VirtualFileSystemEntry)FilePartNode.getParentThroughJar((VirtualFile)(eventFile = (VirtualFileSystemEntry)change.getFile()), eventFile.getFileSystem())) == null) continue;
                int newNameId = VirtualFilePointerManagerImpl.toNameId(change.getNewValue().toString());
                this.addRelevantPointers((VirtualFile)eventFile, parent, newNameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, vFileEvent);
                this.addRelevantPointers(parent, (VirtualFile)eventFile, FilePartNode.getNameId((VirtualFile)eventFile), (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, true, fs, false, vFileEvent);
            }
            eventList = new ArrayList<EventDescriptor>();
            allPointersToFire = new ArrayList();
            VirtualFilePointerManagerImpl.groupPointersToFire((MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl>)toFirePointers, eventList, allPointersToFire);
        }
        if (!allPointersToFire.isEmpty()) {
            VirtualFilePointer[] allPointers = allPointersToFire.toArray(VirtualFilePointer.EMPTY_ARRAY);
            eventList.add(new EventDescriptor(this.myPublisher, allPointers));
        }
        long prepareElapsedMs = System.currentTimeMillis() - start2;
        return new CollectedEvents((MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl>)toFirePointers, toUpdateNodes, eventList, startModCount, prepareElapsedMs);
    }

    private boolean hasAnyPointers() {
        return this.myLocalRoot.children.length != 0 || this.myTempRoot.children.length != 0;
    }

    private static void groupPointersToFire(@NotNull MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> toFirePointers, @NotNull List<? super EventDescriptor> eventList, @NotNull List<? super VirtualFilePointer> allPointersToFire) {
        if (toFirePointers == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(49);
        }
        if (eventList == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(50);
        }
        if (allPointersToFire == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(51);
        }
        for (Map.Entry entry : toFirePointers.entrySet()) {
            Collection values;
            Object[] array;
            VirtualFilePointerListener listener2 = (VirtualFilePointerListener)entry.getKey();
            if (listener2 == null || (array = (values = (Collection)entry.getValue()).toArray(new VirtualFilePointerImpl[0])).length == 0) continue;
            eventList.add(new EventDescriptor(listener2, (VirtualFilePointer[])array));
            ContainerUtil.addAll(allPointersToFire, (Object[])array);
        }
    }

    @VisibleForTesting
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(52);
        }
        this.myCollectedEvents = this.collectEvents(events);
        return new AsyncFileListener.ChangeApplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeVfsChange() {
                CollectedEvents collected;
                VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                synchronized (virtualFilePointerManagerImpl) {
                    collected = VirtualFilePointerManagerImpl.this.myCollectedEvents;
                    if (collected.startModCount == (long)VirtualFilePointerManagerImpl.this.myPointerSetModCount) {
                        VirtualFilePointerManagerImpl.this.incModificationCount();
                    } else {
                        VirtualFilePointerManagerImpl.this.myCollectedEvents = collected = VirtualFilePointerManagerImpl.this.collectEvents(events);
                    }
                }
                for (EventDescriptor descriptor2 : collected.eventList) {
                    descriptor2.fireBefore();
                }
                VirtualFilePointerManagerImpl.this.assertConsistency();
            }
        };
    }

    private static int toNameId(@NotNull String name2) {
        if (name2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(53);
        }
        return FSRecords.getInstance().getNameId(name2);
    }

    @VisibleForTesting
    public synchronized void assertConsistency() {
        if (IS_UNDER_UNIT_TEST && !ApplicationManagerEx.isInStressTest()) {
            this.myLocalRoot.checkConsistency();
            this.myTempRoot.checkConsistency();
        }
    }

    public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(54);
        }
        if (this.myCollectedEvents == null) {
            this.myCollectedEvents = this.collectEvents(events);
        }
    }

    public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
        if (events == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(55);
        }
        this.after(events.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void after(int eventsSize) {
        CollectedEvents collectedEvents = this.myCollectedEvents;
        if (collectedEvents == null) {
            return;
        }
        this.myCollectedEvents = null;
        long start2 = System.currentTimeMillis();
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        this.incModificationCount();
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            for (NodeToUpdate toUpdate : collectedEvents.toUpdateNodes) {
                FilePartNode parent = toUpdate.parent;
                FilePartNode node = toUpdate.node;
                node.update(parent, this.getRoot(node.fs), "VFPMI invalidated VFP during update", toUpdate.myEvent);
            }
        }
        for (EventDescriptor event : collectedEvents.eventList) {
            event.fireAfter();
        }
        this.assertConsistency();
        long afterElapsedMs = System.currentTimeMillis() - start2;
        if (afterElapsedMs > 1000L || collectedEvents.prepareElapsedMs > 1000L) {
            LOG.warn("VirtualFilePointerManagerImpl.prepareChange(" + eventsSize + " events): " + collectedEvents.prepareElapsedMs + "ms.; total pointers: " + this.numberOfPointers() + "; afterElapsedMs: " + afterElapsedMs + "ms.; eventList.size(): " + collectedEvents.eventList.size() + "; toFirePointers.size(): " + collectedEvents.toFirePointers.size() + "; toUpdateNodes.size(): " + collectedEvents.toUpdateNodes.size() + "; eventList: " + String.valueOf(ContainerUtil.getFirstItems(collectedEvents.eventList, (int)100)));
        }
    }

    synchronized boolean decrementUsageCount(@NotNull VirtualFilePointerImpl pointer) {
        boolean shouldKill;
        if (pointer == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(56);
        }
        boolean bl = shouldKill = pointer.incrementUsageCount(-1) == 0;
        if (!shouldKill) {
            return false;
        }
        this.getRoot(pointer.myNode.fs).removePointer(pointer);
        pointer.myNode = null;
        this.assertConsistency();
        ++this.myPointerSetModCount;
        return true;
    }

    public long getModificationCount() {
        return super.getModificationCount() + (long)PersistentFS.getInstance().getStructureModificationCount();
    }

    @NotNull
    public VirtualFilePointer createDirectoryPointer(@NotNull String url, boolean recursively, @NotNull Disposable parent, @NotNull VirtualFilePointerListener listener2) {
        if (url == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(57);
        }
        if (parent == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(58);
        }
        if (listener2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(59);
        }
        return this.create(null, url, parent, listener2, true);
    }

    @TestOnly
    public synchronized int numberOfPointers() {
        return this.dumpAllPointers().size();
    }

    @TestOnly
    public synchronized int numberOfListeners() {
        return ContainerUtil.count(this.dumpAllPointers(), pointer -> ((VirtualFilePointerImpl)pointer).myListener != null);
    }

    @TestOnly
    public synchronized int numberOfCachedUrlToIdentity() {
        return this.myUrlToIdentity.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void shelveAllPointersIn(@NotNull Runnable runnable2) {
        FilePartNode[] oldChildren;
        if (runnable2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(60);
        }
        FilePartNodeRoot localRoot = this.myLocalRoot;
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            oldChildren = localRoot.children;
            localRoot.children = FilePartNode.EMPTY_ARRAY;
        }
        try {
            runnable2.run();
        }
        finally {
            virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                localRoot.children = oldChildren;
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public synchronized Collection<VirtualFilePointer> dumpAllPointers() {
        ArrayList<VirtualFilePointer> result2 = new ArrayList<VirtualFilePointer>();
        VirtualFilePointerManagerImpl.dumpPointersRecursivelyTo(this.myLocalRoot, result2);
        VirtualFilePointerManagerImpl.dumpPointersRecursivelyTo(this.myTempRoot, result2);
        ArrayList<VirtualFilePointer> arrayList = result2;
        if (arrayList == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    private static void dumpPointersRecursivelyTo(@NotNull FilePartNode node, @NotNull Collection<? super VirtualFilePointer> result2) {
        if (node == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(62);
        }
        if (result2 == null) {
            VirtualFilePointerManagerImpl.$$$reportNull$$$0(63);
        }
        node.addAllPointersTo(result2);
        for (FilePartNode child : node.children) {
            VirtualFilePointerManagerImpl.dumpPointersRecursivelyTo(child, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15, 23, 25, 27, 29, 32, 36, 43, 47, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDisposable";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 17: 
            case 19: 
            case 35: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 3: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 43: 
            case 47: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 5: 
            case 10: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFirePointers";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdateNodes";
                break;
            }
            case 7: 
            case 12: 
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 16: 
            case 21: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 34: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 38: 
            case 41: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 48: 
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventList";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPointersToFire";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointersUnder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIdentity";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupTail";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingSeparators";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "registerContainer";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpAllPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disableConsistencyChecksInTestsTemporarily";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPointersUnder";
                break;
            }
            case 3: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 36: 
            case 43: 
            case 47: 
            case 61: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRelevantPointers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateIdentity";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cleanupPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "cleanupTail";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailingSeparators";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isArchiveInTheWindowsDiskRoot";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveUrlBasedPointers";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "assertUrlBasedPointers";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "registerContainer";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "collectEvents";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "groupPointersToFire";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "prepareChange";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "toNameId";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "before";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "decrementUsageCount";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryPointer";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "shelveAllPointersIn";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "dumpPointersRecursivelyTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15, 23, 25, 27, 29, 32, 36, 43, 47, 61 -> new IllegalStateException(string);
        };
    }

    private static final class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        private final Reference2IntOpenHashMap<VirtualFilePointerImpl> myCounts;
        private final Disposable myParent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DelegatingDisposable(@NotNull Disposable parent, @NotNull VirtualFilePointerImpl firstPointer) {
            if (parent == null) {
                DelegatingDisposable.$$$reportNull$$$0(0);
            }
            if (firstPointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(1);
            }
            this.myCounts = new Reference2IntOpenHashMap();
            this.myParent = parent;
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.put((Object)firstPointer, 1);
            }
        }

        private static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            DelegatingDisposable result2;
            if (parentDisposable == null) {
                DelegatingDisposable.$$$reportNull$$$0(2);
            }
            if (pointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(3);
            }
            if ((result2 = (DelegatingDisposable)ourInstances.get(parentDisposable)) == null && (result2 = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable, pointer)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result2);
                return;
            }
            result2.increment(pointer);
        }

        synchronized void increment(@NotNull VirtualFilePointerImpl pointer) {
            if (pointer == null) {
                DelegatingDisposable.$$$reportNull$$$0(4);
            }
            this.myCounts.addTo((Object)pointer, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                ObjectIterator iterator = this.myCounts.reference2IntEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    int after;
                    boolean isDisposed;
                    Reference2IntMap.Entry entry = (Reference2IntMap.Entry)iterator.next();
                    VirtualFilePointerImpl pointer = (VirtualFilePointerImpl)((Object)entry.getKey());
                    int disposeCount = entry.getIntValue();
                    boolean bl = isDisposed = !(pointer instanceof IdentityVirtualFilePointer) && pointer.myNode == null;
                    if (isDisposed) {
                        pointer.throwDisposalError("Already disposed:\n" + pointer.getStackTrace());
                    }
                    LOG.assertTrue((after = pointer.incrementUsageCount(-(disposeCount - 1))) > 0, (Object)after);
                    pointer.dispose();
                }
                this.myCounts.clear();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstPointer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerDisposable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "increment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class NodeToUpdate {
        private final FilePartNode parent;
        final FilePartNode node;
        VFileEvent myEvent;

        NodeToUpdate(@NotNull FilePartNode parent, @NotNull FilePartNode node) {
            if (parent == null) {
                NodeToUpdate.$$$reportNull$$$0(0);
            }
            if (node == null) {
                NodeToUpdate.$$$reportNull$$$0(1);
            }
            this.parent = parent;
            this.node = node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$NodeToUpdate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record CollectedEvents(@NotNull MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> toFirePointers, @NotNull List<NodeToUpdate> toUpdateNodes, @NotNull List<EventDescriptor> eventList, long startModCount, long prepareElapsedMs) {
        @NotNull
        private final MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> toFirePointers;
        @NotNull
        private final List<NodeToUpdate> toUpdateNodes;
        @NotNull
        private final List<EventDescriptor> eventList;

        /*
         * WARNING - void declaration
         */
        private CollectedEvents(@NotNull MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> toFirePointers, @NotNull List<NodeToUpdate> toUpdateNodes, @NotNull List<EventDescriptor> eventList, long startModCount, long l) {
            void prepareElapsedMs;
            if (toFirePointers == null) {
                CollectedEvents.$$$reportNull$$$0(0);
            }
            if (toUpdateNodes == null) {
                CollectedEvents.$$$reportNull$$$0(1);
            }
            if (eventList == null) {
                CollectedEvents.$$$reportNull$$$0(2);
            }
            this.toFirePointers = toFirePointers;
            this.toUpdateNodes = toUpdateNodes;
            this.eventList = eventList;
            this.startModCount = startModCount;
            this.prepareElapsedMs = prepareElapsedMs;
        }

        @NotNull
        public MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> toFirePointers() {
            MultiMap<VirtualFilePointerListener, VirtualFilePointerImpl> multiMap = this.toFirePointers;
            if (multiMap == null) {
                CollectedEvents.$$$reportNull$$$0(3);
            }
            return multiMap;
        }

        @NotNull
        public List<NodeToUpdate> toUpdateNodes() {
            List<NodeToUpdate> list2 = this.toUpdateNodes;
            if (list2 == null) {
                CollectedEvents.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public List<EventDescriptor> eventList() {
            List<EventDescriptor> list2 = this.eventList;
            if (list2 == null) {
                CollectedEvents.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toFirePointers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toUpdateNodes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventList";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$CollectedEvents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$CollectedEvents";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFirePointers";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toUpdateNodes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "eventList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        private final VirtualFilePointer @NotNull [] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener2, VirtualFilePointer @NotNull [] pointers) {
            if (listener2 == null) {
                EventDescriptor.$$$reportNull$$$0(0);
            }
            if (pointers == null) {
                EventDescriptor.$$$reportNull$$$0(1);
            }
            this.myListener = listener2;
            this.myPointers = pointers;
            if (pointers.length == 0) {
                throw new IllegalArgumentException();
            }
        }

        private void fireBefore() {
            this.myListener.beforeValidityChanged(this.myPointers);
        }

        private void fireAfter() {
            this.myListener.validityChanged(this.myPointers);
        }

        public String toString() {
            return String.valueOf(this.myListener) + " -> " + Arrays.toString(this.myPointers);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyPersistentFsConnectionListener
    implements PersistentFsConnectionListener {
        MyPersistentFsConnectionListener() {
        }

        public void connectionOpen() {
            VirtualFilePointerManager service = (VirtualFilePointerManager)ApplicationManager.getApplication().getServiceIfCreated(VirtualFilePointerManager.class);
            if (service != null) {
                ((VirtualFilePointerManagerImpl)service).resolveUrlBasedPointers();
            }
        }

        public void beforeConnectionClosed() {
            VirtualFilePointerManager service;
            Application app = ApplicationManager.getApplication();
            VirtualFilePointerManager virtualFilePointerManager = service = app == null ? null : (VirtualFilePointerManager)app.getServiceIfCreated(VirtualFilePointerManager.class);
            if (service != null) {
                ((VirtualFilePointerManagerImpl)service).switchToUrlBasedPointers();
            }
        }
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        MyAsyncFileListener() {
        }

        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyAsyncFileListener.$$$reportNull$$$0(0);
            }
            return ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).prepareChange(events);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$MyAsyncFileListener", "prepareChange"));
        }
    }
}

