/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class FileWatcher
implements AppLifecycleListener {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    private final ManagingFS myManagingFS;
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final ExecutorService myFileWatcherExecutor;
    private final AtomicReference<Future<?>> myLastTask;
    private volatile boolean myShuttingDown;
    private volatile CanonicalPathMap myPathMap;
    private volatile Map<Object, Set<String>> myManualWatchRoots;
    public static final String RESET = "(reset)";
    public static final String OTHER = "(other)";
    private volatile Consumer<? super String> myTestNotifier;

    FileWatcher(@NotNull ManagingFS managingFS, @NotNull Runnable postInitCallback) {
        if (managingFS == null) {
            FileWatcher.$$$reportNull$$$0(0);
        }
        if (postInitCallback == null) {
            FileWatcher.$$$reportNull$$$0(1);
        }
        this.myFileWatcherExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"File Watcher", (int)1);
        this.myLastTask = new AtomicReference<Object>(null);
        this.myShuttingDown = false;
        this.myPathMap = CanonicalPathMap.empty();
        this.myManualWatchRoots = Collections.emptyMap();
        this.myManagingFS = managingFS;
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TOPIC, (Object)this);
        this.myFileWatcherExecutor.execute(() -> {
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.initialize((FileWatcherNotificationSink)this.myNotificationSink));
            if (this.isOperational()) {
                postInitCallback.run();
            }
        });
    }

    public void appWillBeClosed(boolean isRestart) {
        this.myShuttingDown = true;
    }

    public void dispose() {
        this.myFileWatcherExecutor.shutdown();
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null) {
            lastTask.cancel(false);
        }
        try {
            this.myFileWatcherExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.dispose());
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (watcher == null || !watcher.isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean isSettingRoots() {
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null && !lastTask.isDone()) {
            return true;
        }
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (watcher == null || !watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    DirtyPaths getDirtyPaths() {
        DirtyPaths dirtyPaths = this.myNotificationSink.getDirtyPaths();
        if (dirtyPaths == null) {
            FileWatcher.$$$reportNull$$$0(2);
        }
        return dirtyPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public @NotNull Collection<@NotNull String> getManualWatchRoots() {
        Collection<String> result2 = null;
        Iterator<Set<String>> iterator = this.myManualWatchRoots.values().iterator();
        while (iterator.hasNext()) {
            Set<String> rootSet;
            Set<String> set = rootSet = iterator.next();
            synchronized (set) {
                if (result2 == null) {
                    result2 = new HashSet<String>(rootSet);
                } else {
                    result2.retainAll(rootSet);
                }
            }
        }
        Collection<String> collection = result2 != null ? result2 : Collections.emptyList();
        if (collection == null) {
            FileWatcher.$$$reportNull$$$0(3);
        }
        return collection;
    }

    void setWatchRoots(@NotNull Supplier<CanonicalPathMap> pathMapSupplier) {
        Future<?> prevTask;
        if (pathMapSupplier == null) {
            FileWatcher.$$$reportNull$$$0(4);
        }
        if ((prevTask = this.myLastTask.getAndSet(this.myFileWatcherExecutor.submit(() -> {
            try {
                CanonicalPathMap pathMap;
                CanonicalPathMap canonicalPathMap = pathMap = this.myShuttingDown ? CanonicalPathMap.empty() : (CanonicalPathMap)pathMapSupplier.get();
                if (pathMap == null) {
                    return;
                }
                this.myPathMap = pathMap;
                this.myManualWatchRoots = new ConcurrentHashMap<Object, Set<String>>();
                Pair<List<String>, List<String>> roots = pathMap.getCanonicalWatchRoots();
                PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> {
                    if (watcher.isOperational()) {
                        watcher.setWatchRoots((List)roots.first, (List)roots.second, this.myShuttingDown);
                    }
                });
            }
            catch (Error | RuntimeException e) {
                LOG.error(e);
            }
        }))) != null) {
            prevTask.cancel(false);
        }
    }

    public void notifyOnFailure(@NlsContexts.NotificationContent @NotNull String cause, @Nullable NotificationListener listener2) {
        if (cause == null) {
            FileWatcher.$$$reportNull$$$0(5);
        }
        LOG.warn(cause);
        String title2 = IdeCoreBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
        Notification notification2 = new Notification("File Watcher Messages", title2, cause, NotificationType.WARNING).setSuggestionType(true);
        if (listener2 != null) {
            notification2.setListener(listener2);
        }
        notification2.notify(null);
    }

    boolean belongsToWatchRoots(@NotNull String reportedPath, boolean isFile) {
        if (reportedPath == null) {
            FileWatcher.$$$reportNull$$$0(6);
        }
        return this.myPathMap.belongsToWatchRoots(reportedPath, isFile);
    }

    @NotNull
    @NotNull Collection<@NotNull String> mapToAllSymlinks(@NotNull String reportedPath) {
        Collection<String> result2;
        if (reportedPath == null) {
            FileWatcher.$$$reportNull$$$0(7);
        }
        if (!(result2 = this.myPathMap.mapToOriginalWatchRoots(reportedPath, true)).isEmpty()) {
            result2.remove(reportedPath);
        }
        Collection<String> collection = result2;
        if (collection == null) {
            FileWatcher.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private void notifyOnEvent(String path) {
        Consumer<? super String> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(path);
        }
    }

    @TestOnly
    public void startup(@Nullable Consumer<? super String> notifier) throws Exception {
        this.myTestNotifier = notifier;
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                if (watcher == null) continue;
                watcher.startup();
            }
            return null;
        }).get();
    }

    @TestOnly
    public void shutdown() throws Exception {
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                if (watcher == null) continue;
                watcher.shutdown();
            }
            this.myTestNotifier = null;
            return null;
        }).get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postInitCallback";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapSupplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualWatchRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToAllSymlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setWatchRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnFailure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "belongsToWatchRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mapToAllSymlinks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8 -> new IllegalStateException(string);
        };
    }

    private final class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
            }
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.resetChangedPaths());
            DirtyPaths dirtyPaths2 = dirtyPaths;
            if (dirtyPaths2 == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(0);
            }
            return dirtyPaths2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyManualWatchRoots(@NotNull PluggableFileWatcher watcher, @NotNull Collection<String> roots) {
            Set rootSet;
            if (watcher == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(1);
            }
            if (roots == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(2);
            }
            Set set = rootSet = FileWatcher.this.myManualWatchRoots.computeIfAbsent(watcher, k -> new HashSet());
            synchronized (set) {
                rootSet.addAll(roots);
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        public void notifyMapping(@NotNull Collection<? extends Pair<String, String>> mapping) {
            if (mapping == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(3);
            }
            if (!mapping.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping);
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(4);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String eachPath : paths) {
                        this.myDirtyPaths.addDirtyPath(eachPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(5);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.addDirtyPath(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(6);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(7);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String each : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(each);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyReset(@Nullable String path) {
            if (path != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.addDirtyPathRecursive(path);
                }
            }
            VirtualFile[] roots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = this.myLock;
            synchronized (object) {
                for (VirtualFile root : roots) {
                    this.myDirtyPaths.addDirtyPathRecursive(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.RESET);
        }

        public void notifyUserOnFailure(@NlsContexts.NotificationContent @NotNull String cause, @Nullable NotificationListener listener2) {
            if (cause == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(8);
            }
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/FileWatcher$MyFileWatcherNotificationSink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "watcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirtyPaths";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher$MyFileWatcherNotificationSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyManualWatchRoots";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyMapping";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyPath";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyPathCreatedOrDeleted";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyDirectory";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyPathRecursive";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyUserOnFailure";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class DirtyPaths {
        final Set<String> dirtyPaths = new HashSet<String>();
        final Set<String> dirtyPathsRecursive = new HashSet<String>();
        final Set<String> dirtyDirectories = new HashSet<String>();
        static final DirtyPaths EMPTY = new DirtyPaths();

        DirtyPaths() {
        }

        boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }

        void addDirtyPath(String path) {
            if (!this.dirtyPathsRecursive.contains(path)) {
                this.dirtyPaths.add(path);
            }
        }

        void addDirtyPathRecursive(String path) {
            this.dirtyPaths.remove(path);
            this.dirtyPathsRecursive.add(path);
        }
    }
}

