/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SystemProperties;
import kotlin.Metadata;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthCheckerConstants;", "", "<init>", "()V", "HEALTH_CHECKING_ENABLED", "", "getHEALTH_CHECKING_ENABLED", "()Z", "HEALTH_CHECKING_PERIOD_MS", "", "getHEALTH_CHECKING_PERIOD_MS", "()I", "HEALTH_CHECKING_START_DELAY_MS", "getHEALTH_CHECKING_START_DELAY_MS", "WRAP_HEALTH_CHECK_IN_READ_ACTION", "getWRAP_HEALTH_CHECK_IN_READ_ACTION", "CHECK_ORPHAN_RECORDS", "getCHECK_ORPHAN_RECORDS", "MAX_CHILDREN_TO_LOG", "getMAX_CHILDREN_TO_LOG", "MAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE", "getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE", "intellij.platform.ide.impl"})
final class VFSHealthCheckerConstants {
    @NotNull
    public static final VFSHealthCheckerConstants INSTANCE = new VFSHealthCheckerConstants();
    private static final boolean HEALTH_CHECKING_ENABLED = SystemProperties.getBooleanProperty((String)"vfs.health-check.enabled", (!ApplicationManager.getApplication().isUnitTestMode() ? 1 : 0) != 0);
    private static final int HEALTH_CHECKING_PERIOD_MS = SystemProperties.getIntProperty((String)"vfs.health-check.checking-period-ms", (int)((int)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS))));
    private static final int HEALTH_CHECKING_START_DELAY_MS = SystemProperties.getIntProperty((String)"vfs.health-check.checking-start-delay-ms", (int)((int)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES))));
    private static final boolean WRAP_HEALTH_CHECK_IN_READ_ACTION = SystemProperties.getBooleanProperty((String)"vfs.health-check.wrap-in-read-action", (boolean)true);
    private static final boolean CHECK_ORPHAN_RECORDS = SystemProperties.getBooleanProperty((String)"vfs.health-check.check-orphan-records", (boolean)false);
    private static final int MAX_CHILDREN_TO_LOG = SystemProperties.getIntProperty((String)"vfs.health-check.max-children-to-log", (int)16);
    private static final int MAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE = SystemProperties.getIntProperty((String)"vfs.health-check.max-single-error-logs", (int)128);

    private VFSHealthCheckerConstants() {
    }

    public final boolean getHEALTH_CHECKING_ENABLED() {
        return HEALTH_CHECKING_ENABLED;
    }

    public final int getHEALTH_CHECKING_PERIOD_MS() {
        return HEALTH_CHECKING_PERIOD_MS;
    }

    public final int getHEALTH_CHECKING_START_DELAY_MS() {
        return HEALTH_CHECKING_START_DELAY_MS;
    }

    public final boolean getWRAP_HEALTH_CHECK_IN_READ_ACTION() {
        return WRAP_HEALTH_CHECK_IN_READ_ACTION;
    }

    public final boolean getCHECK_ORPHAN_RECORDS() {
        return CHECK_ORPHAN_RECORDS;
    }

    public final int getMAX_CHILDREN_TO_LOG() {
        return MAX_CHILDREN_TO_LOG;
    }

    public final int getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE() {
        return MAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE;
    }
}

