/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecoratorBoundsHelperKt;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper;", "", "decorator", "Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecorator;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecorator;)V", "isUpdatingBounds", "", "value", "Ljava/awt/Rectangle;", "bounds", "getBounds", "()Ljava/awt/Rectangle;", "setBounds", "(Ljava/awt/Rectangle;)V", "shownAt", "", "Ljava/lang/Long;", "listener", "Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper$MyWindowListener;", "checkBounds", "", "sinceShown", "()Ljava/lang/Long;", "MyWindowListener", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowExternalDecoratorBoundsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowExternalDecoratorBoundsHelper.kt\ncom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n60#2,5:109\n60#2,5:114\n1#3:119\n*S KotlinDebug\n*F\n+ 1 ToolWindowExternalDecoratorBoundsHelper.kt\ncom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper\n*L\n73#1:109,5\n95#1:114,5\n*E\n"})
public final class ToolWindowExternalDecoratorBoundsHelper {
    @NotNull
    private final ToolWindowExternalDecorator decorator;
    private boolean isUpdatingBounds;
    @NotNull
    private Rectangle bounds;
    @Nullable
    private Long shownAt;
    @NotNull
    private final MyWindowListener listener;

    public ToolWindowExternalDecoratorBoundsHelper(@NotNull ToolWindowExternalDecorator decorator) {
        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
        this.decorator = decorator;
        this.bounds = this.decorator.getVisibleWindowBounds();
        this.listener = new MyWindowListener();
        this.decorator.getWindow().addComponentListener(this.listener);
    }

    @NotNull
    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull Rectangle value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.isUpdatingBounds) {
            this.bounds = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkBounds() {
        Long l = this.sinceShown();
        if (l == null) {
            return;
        }
        long sinceShown = l;
        int maxDelay = Registry.Companion.intValue("ide.tool.window.prevent.move.resize.timeout", 100);
        if (maxDelay < 0) {
            return;
        }
        if (sinceShown > (long)maxDelay) {
            this.decorator.getWindow().removeComponentListener(this.listener);
            return;
        }
        Rectangle storedBounds = this.bounds;
        Rectangle actualBounds = this.decorator.getVisibleWindowBounds();
        if (!Intrinsics.areEqual((Object)storedBounds, (Object)actualBounds)) {
            if (ToolWindowExternalDecoratorBoundsHelperKt.access$isMaximized(this.decorator)) {
                Logger $this$debug_u24default$iv = this.decorator.log();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("The tool window " + this.decorator.getId() + " external (" + this.decorator.getToolWindowType() + ") decorator is shown with the bounds " + actualBounds + ", the expected bounds are " + storedBounds + ", " + sinceShown + " ms after showing, NOT re-applying because the frame is currently maximized", e$iv);
                }
                return;
            }
            this.decorator.log().warn("The tool window " + this.decorator.getId() + " external (" + this.decorator.getToolWindowType() + ") decorator is shown with the bounds " + actualBounds + ", but the expected bounds are " + storedBounds + ", " + sinceShown + " ms after showing, re-applying");
            try {
                this.isUpdatingBounds = true;
                this.decorator.setVisibleWindowBounds(storedBounds);
            }
            finally {
                this.isUpdatingBounds = false;
            }
        } else {
            Logger $this$debug_u24default$iv = this.decorator.log();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("The tool window " + this.decorator.getId() + " external (" + this.decorator.getToolWindowType() + ") decorator is shown with the bounds " + actualBounds + ", " + sinceShown + " ms after showing, matching the expected bounds", e$iv);
            }
        }
    }

    private final Long sinceShown() {
        Long l;
        Long l2 = this.shownAt;
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = System.currentTimeMillis() - it;
        } else {
            l = null;
        }
        return l;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper$MyWindowListener;", "Ljava/awt/event/ComponentAdapter;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper;)V", "componentMoved", "", "e", "Ljava/awt/event/ComponentEvent;", "componentResized", "componentShown", "intellij.platform.ide.impl"})
    public final class MyWindowListener
    extends ComponentAdapter {
        @Override
        public void componentMoved(@Nullable ComponentEvent e) {
            ToolWindowExternalDecoratorBoundsHelper.this.checkBounds();
        }

        @Override
        public void componentResized(@Nullable ComponentEvent e) {
            ToolWindowExternalDecoratorBoundsHelper.this.checkBounds();
        }

        @Override
        public void componentShown(@Nullable ComponentEvent e) {
            ToolWindowExternalDecoratorBoundsHelper.this.shownAt = System.currentTimeMillis();
            ToolWindowExternalDecoratorBoundsHelper.this.checkBounds();
        }
    }
}

