/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.headertoolbar;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.ListenableToolbarComboButton;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import com.intellij.openapi.wm.impl.ToolbarComboButtonModel;
import com.intellij.openapi.wm.impl.headertoolbar.FilenameToolbarWidgetActionKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/wm/impl/headertoolbar/FilenameToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updatePresentationFromFile", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "isDarkToolbar", "", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "createToolbarComboButton", "Lcom/intellij/openapi/wm/impl/ToolbarComboButton;", "model", "Lcom/intellij/openapi/wm/impl/ToolbarComboButtonModel;", "updateCustomComponent", "component", "Ljavax/swing/JComponent;", "FilenameToolbarWidget", "RecentFilesListPopupStep", "intellij.platform.ide.impl"})
public final class FilenameToolbarWidgetAction
extends ExpandableComboAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        UISettings uiSettings = UISettings.Companion.getInstance();
        if (uiSettings.getEditorTabPlacement() != 0 && !uiSettings.getFullPathsInWindowHeader()) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project3).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        this.updatePresentationFromFile(project3, file2, presentation2);
    }

    private final void updatePresentationFromFile(Project project2, VirtualFile file2, Presentation presentation2) {
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project2).getStatus(file2);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        FileStatus status2 = fileStatus;
        Color fg = null;
        Icon icon2 = IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)project2);
        if (JBColor.isBright() && this.isDarkToolbar()) {
            icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme("Dark");
            fg = editorColorsScheme != null ? editorColorsScheme.getColor(status2.getColorKey()) : null;
        } else {
            fg = status2.getColor();
        }
        if (fg == null) {
            fg = (Color)JBColor.namedColor((String)"MainToolbar.Dropdown.foreground", (Color)JBColor.foreground());
        }
        String string = VfsPresentationUtil.getUniquePresentableNameForUI(project2, file2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniquePresentableNameForUI(...)");
        String filename = string;
        String path = FrameTitleBuilder.Companion.getInstance().getFileTitle(project2, file2);
        presentation2.setEnabledAndVisible(true);
        presentation2.putClientProperty(FilenameToolbarWidgetActionKt.access$getFILE_COLOR$p(), (Object)fg);
        presentation2.putClientProperty(FilenameToolbarWidgetActionKt.access$getFILE_FULL_PATH$p(), UISettings.Companion.getInstance().getFullPathsInWindowHeader() && !Intrinsics.areEqual((Object)path, (Object)filename) ? path : null);
        presentation2.setText(StringUtil.shortenTextWithEllipsis((String)filename, (int)60, (int)30));
        presentation2.setDescription(path);
        presentation2.setIcon(icon2);
    }

    private final boolean isDarkToolbar() {
        return ColorUtil.isDark((Color)((Color)JBColor.namedColor((String)"MainToolbar.background", (Color)Color.WHITE)));
    }

    @Override
    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project2 = event.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        List recentFiles = CollectionsKt.asReversed(EditorHistoryManager.Companion.getInstance(project3).getFileList());
        if (recentFiles.size() > 1) {
            List files2 = recentFiles.subList(1, CollectionsKt.getLastIndex((List)recentFiles) + 1);
            return (JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new RecentFilesListPopupStep(project3, files2));
        }
        return null;
    }

    @Override
    @NotNull
    protected ToolbarComboButton createToolbarComboButton(@NotNull ToolbarComboButtonModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return new FilenameToolbarWidget(model2);
    }

    @Override
    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        ((FilenameToolbarWidget)component2).update(presentation2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/wm/impl/headertoolbar/FilenameToolbarWidgetAction$FilenameToolbarWidget;", "Lcom/intellij/openapi/wm/impl/ListenableToolbarComboButton;", "model", "Lcom/intellij/openapi/wm/impl/ToolbarComboButtonModel;", "<init>", "(Lcom/intellij/openapi/wm/impl/headertoolbar/FilenameToolbarWidgetAction;Lcom/intellij/openapi/wm/impl/ToolbarComboButtonModel;)V", "processMouseEvent", "", "e", "Ljava/awt/event/MouseEvent;", "update", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "installListeners", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.ide.impl"})
    private final class FilenameToolbarWidget
    extends ListenableToolbarComboButton {
        public FilenameToolbarWidget(ToolbarComboButtonModel model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            super(model2);
            this.setOpaque(false);
            this.setHoverBackground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.foreground()));
            this.setAccessibleNamePrefix(UIBundle.message((String)"filename.widget.accessible.name.prefix", (Object[])new Object[0]));
        }

        @Override
        protected void processMouseEvent(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getID() == 502 && UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                e.consume();
                Project project2 = ProjectUtil.getProjectForComponent(this);
                if (project2 != null) {
                    VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project2).getSelectedFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
                    VirtualFile[] files2 = virtualFileArray;
                    if (!(files2.length == 0)) {
                        FileEditorManager.getInstance((Project)project2).closeFile(files2[0]);
                    }
                }
                return;
            }
            super.processMouseEvent(e);
        }

        public final void update(@NotNull Presentation presentation2) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            this.setOpaque(false);
            if (!Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(this.getLeftIcons()), (Object)presentation2.getIcon())) {
                Icon icon2 = presentation2.getIcon();
                Intrinsics.checkNotNull((Object)icon2);
                this.setLeftIcons(CollectionsKt.listOf((Object)icon2));
            }
            this.setForeground((Color)presentation2.getClientProperty(FilenameToolbarWidgetActionKt.access$getFILE_COLOR$p()));
            this.setToolTipText(presentation2.getDescription());
            String path = (String)presentation2.getClientProperty(FilenameToolbarWidgetActionKt.access$getFILE_FULL_PATH$p());
            this.setText((String)(path != null ? presentation2.getTextWithMnemonic() + " [" + path + "]" : presentation2.getTextWithMnemonic()));
            CharSequence charSequence = this.getText();
            if (charSequence == null || charSequence.length() == 0) {
                this.setVisible(false);
            }
        }

        @Override
        protected void installListeners(@Nullable Project project2, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            if (project2 == null) {
                return;
            }
            FileEditorManagerListener editorListener2 = new FileEditorManagerListener(this){
                final /* synthetic */ FilenameToolbarWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public void selectionChanged(FileEditorManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.updateWidgetAction();
                }
            };
            MessageBusConnection messageBusConnection = project2.getMessageBus().connect(disposable);
            Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
            messageBusConnection.subscribe(topic, (Object)editorListener2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0017\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/headertoolbar/FilenameToolbarWidgetAction$RecentFilesListPopupStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getIconFor", "Ljavax/swing/Icon;", "value", "getForegroundFor", "Ljava/awt/Color;", "getTextFor", "", "Lcom/intellij/openapi/util/NlsSafe;", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "", "intellij.platform.ide.impl"})
    public static final class RecentFilesListPopupStep
    extends BaseListPopupStep<VirtualFile> {
        @NotNull
        private final Project project;

        public RecentFilesListPopupStep(@NotNull Project project2, @NotNull List<? extends VirtualFile> files2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            super(null, files2);
            this.project = project2;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public Icon getIconFor(@Nullable VirtualFile value) {
            if (value == null) {
                return null;
            }
            return IconUtil.getIcon((VirtualFile)value, (int)2, (Project)this.project);
        }

        @Nullable
        public Color getForegroundFor(@Nullable VirtualFile value) {
            if (value == null) {
                return null;
            }
            return FileStatusManager.getInstance((Project)this.project).getStatus(value).getColor();
        }

        @NotNull
        public String getTextFor(@Nullable VirtualFile value) {
            Object object = value;
            if (object == null || (object = object.getPresentableName()) == null) {
                object = "";
            }
            return object;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue != null && finalChoice) {
                FileEditorManager.getInstance((Project)this.project).openFile(selectedValue, true);
            }
            return null;
        }
    }
}

