/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/wm/impl/status/StatusBarUtil;", "", "<init>", "()V", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "component", "Ljava/awt/Component;", "getStatusBar$intellij_platform_ide_impl", "getCurrentTextEditor", "Lcom/intellij/openapi/editor/Editor;", "statusBar", "getCurrentFileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "setStatusBarInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "ensureValidEditorFile", "", "editor", "fileEditor", "intellij.platform.ide.impl"})
public final class StatusBarUtil {
    @NotNull
    public static final StatusBarUtil INSTANCE = new StatusBarUtil();

    private StatusBarUtil() {
    }

    @Nullable
    public final StatusBar getStatusBar$intellij_platform_ide_impl(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        for (Component parent = component2; parent != null; parent = (Component)parent.getParent()) {
            if (!(parent instanceof IdeFrame)) continue;
            return ((IdeFrame)parent).getStatusBar();
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Editor getCurrentTextEditor(@Nullable StatusBar statusBar) {
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(statusBar);
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        if (textEditor == null) {
            return null;
        }
        TextEditor fileEditor2 = textEditor;
        Editor editor2 = fileEditor2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        return INSTANCE.ensureValidEditorFile(editor3, (FileEditor)fileEditor2) && UIUtil.isShowing((Component)editor3.getComponent()) ? editor3 : null;
    }

    @JvmStatic
    @Nullable
    public static final FileEditor getCurrentFileEditor(@Nullable StatusBar statusBar) {
        StatusBar statusBar2 = statusBar;
        return statusBar2 != null && (statusBar2 = statusBar2.getCurrentEditor()) != null ? (FileEditor)statusBar2.invoke() : null;
    }

    @JvmStatic
    public static final void setStatusBarInfo(@NotNull Project project2, @NotNull String message) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            if (statusBar == null) break block0;
            statusBar.setInfo(message);
        }
    }

    private final boolean ensureValidEditorFile(Editor editor2, FileEditor fileEditor) {
        Project project2;
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document3);
        if (file2 == null || file2.isValid()) {
            return true;
        }
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
        Project project3 = project2 = editor2.getProject();
        Boolean fileIsOpen = project3 == null ? null : Boolean.valueOf(FileEditorManager.getInstance((Project)project3).isFileOpen(file2));
        FileEditor fileEditor2 = fileEditor;
        Logger.getInstance(StatusBar.class).error("Returned editor for invalid file: " + editor2 + "; disposed=" + editor2.isDisposed() + (String)(fileEditor2 == null ? "" : "; fileEditor=" + fileEditor2 + "; fileEditor.valid=" + fileEditor.isValid()) + "; file " + file2.getClass() + "; cached document exists: " + (cachedDocument != null) + "; same as document: " + (cachedDocument == document3) + "; file is open: " + fileIsOpen);
        return false;
    }
}

