/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AboutDialog;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StartPagePromoter;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NotificationEventAction;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeSeparateBalloonLayoutImpl;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeScreenComponentFactory {
    private static final BadgeIconSupplier NOTIFICATION_ICON = new BadgeIconSupplier(AllIcons.Toolwindows.Notifications);

    @NotNull
    static JComponent createSmallLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String welcomeScreenLogoUrl = appInfo.getApplicationSvgIconUrl();
        Icon icon2 = IconLoader.getIcon((String)welcomeScreenLogoUrl, (ClassLoader)WelcomeScreenComponentFactory.class.getClassLoader());
        final ActionLink copyAbout = new ActionLink("", EmptyIcon.ICON_16, WelcomeScreenComponentFactory.createCopyAboutAction());
        copyAbout.setHoveringIcon(AllIcons.Actions.Copy);
        copyAbout.setToolTipText(IdeBundle.message((String)"welcome.screen.copy.about.action.text", (Object[])new Object[0]));
        JComponent panel2 = WelcomeScreenComponentFactory.createSmallLogo(icon2, (Component)copyAbout);
        panel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                copyAbout.setIcon(AllIcons.Actions.Copy);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                copyAbout.setIcon(EmptyIcon.ICON_16);
            }
        });
        JComponent jComponent = panel2;
        if (jComponent == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @ApiStatus.Internal
    @NotNull
    public static JComponent createSmallLogo(final Icon icon2, Component actionComponent) {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JLabel logo = new JLabel(){

            @Override
            public void updateUI() {
                super.updateUI();
                float scale = JBUIScale.scale((float)28.0f) / (float)icon2.getIconWidth();
                Icon smallLogoIcon = IconUtil.scale((Icon)icon2, null, (float)scale);
                this.setIcon(smallLogoIcon);
            }
        };
        logo.setBorder((Border)JBUI.Borders.empty((int)29, (int)0, (int)27, (int)0));
        logo.setHorizontalAlignment(0);
        panel2.add((Component)logo, (Object)"West");
        String applicationName = WelcomeScreenComponentFactory.getAppName();
        JLabel appName = new JLabel(applicationName);
        appName.setForeground(JBColor.foreground());
        appName.setFont((Font)JBFont.create((Font)appName.getFont().deriveFont(0), (boolean)false));
        Object appVersion = appInfo.getFullVersion();
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = (String)appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version = new JLabel((String)appVersion);
        version.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        version.setForeground(ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.ContextHelp.FOREGROUND : Gray._128);
        NonOpaquePanel textPanel = new NonOpaquePanel();
        textPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0));
        textPanel.setBorder((Border)JBUI.Borders.empty((int)28, (int)10, (int)25, (int)10));
        BorderLayoutPanel namePanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((Component)appName).andTransparent()).addToRight(actionComponent);
        textPanel.add((Component)namePanel);
        textPanel.add((Component)version);
        panel2.add((Component)textPanel, (Object)"Center");
        panel2.setToolTipText(IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild()}));
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(1);
        }
        return nonOpaquePanel;
    }

    @NotNull
    static JComponent createLogo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JLabel logo = new JLabel(IconLoader.getIcon((String)appInfo.getApplicationSvgIconUrl(), (ClassLoader)WelcomeScreenComponentFactory.class.getClassLoader()));
        logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
        logo.setHorizontalAlignment(0);
        panel2.add((Component)logo, (Object)"North");
        JLabel appName = new JLabel(WelcomeScreenComponentFactory.getAppName());
        appName.setForeground(JBColor.foreground());
        appName.setFont(WelcomeScreenUIManager.getProductFont(36).deriveFont(0));
        appName.setHorizontalAlignment(0);
        Object appVersion = IdeBundle.message((String)"welcome.screen.logo.version.label", (Object[])new Object[]{appInfo.getFullVersion()});
        if (appInfo.isEAP() && !appInfo.getBuild().isSnapshot()) {
            appVersion = (String)appVersion + " (" + appInfo.getBuild().asStringWithoutProductCode() + ")";
        }
        JLabel version = new JLabel((String)appVersion);
        version.setFont(WelcomeScreenUIManager.getProductFont(16));
        version.setHorizontalAlignment(0);
        version.setForeground((Color)Gray._128);
        panel2.add((Component)appName);
        panel2.add((Component)version, (Object)"South");
        panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(2);
        }
        return nonOpaquePanel;
    }

    private static AnAction createCopyAboutAction() {
        return DumbAwareAction.create(e -> CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(new AboutDialog(null).getExtendedAboutText())));
    }

    static JComponent createRecentProjects(Disposable parentDisposable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new NewRecentProjectPanel(parentDisposable), "Center");
        panel2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        panel2.setBorder((Border)new CustomLineBorder((Color)WelcomeScreenUIManager.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
        return panel2;
    }

    static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.LinkDropTriangle);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link, (int)e.getX(), (int)e.getY());
                link.doClick((InputEvent)newEvent);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$3", "onClick"));
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    @NotNull
    public static AnAction createShowPopupAction(final @NonNls @NotNull String groupId) {
        if (groupId == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(3);
        }
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Component component2 = Objects.requireNonNull(Objects.requireNonNull(e.getInputEvent()).getComponent());
                ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId);
                PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, null, configureGroup, e.getDataContext(), "WelcomeScreen", new MenuItemPresentationFactory(true), ActionPopupOptions.empty(), null);
                popup2.showUnderneathOf(component2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$4", "actionPerformed"));
            }
        };
    }

    static JComponent createActionLink(@NotNull Container parentContainer, @Nls String text2, String groupId, Icon icon2, @Nullable Component focusOnLeft) {
        if (parentContainer == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(4);
        }
        AnAction action2 = WelcomeScreenComponentFactory.createShowPopupAction(groupId);
        JComponent panel2 = WelcomeScreenComponentFactory.wrapActionLink(new ActionLink(text2, icon2, action2));
        WelcomeScreenFocusManager.installFocusable(parentContainer, panel2, action2, 40, 38, focusOnLeft);
        return panel2;
    }

    public static JComponent wrapActionLink(@NotNull ActionLink link) {
        if (link == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(5);
        }
        JActionLinkPanel panel2 = WelcomeScreenComponentFactory.wrapActionLinkWithoutArrow(link);
        if (!StringUtil.isEmptyOrSpaces((String)link.getText())) {
            panel2.add((Component)WelcomeScreenComponentFactory.createArrow(link), "East");
        }
        return panel2;
    }

    public static JActionLinkPanel wrapActionLinkWithoutArrow(@NotNull ActionLink link) {
        if (link == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(6);
        }
        link.setFocusable(false);
        link.setPaintUnderline(false);
        link.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
        JActionLinkPanel panel2 = new JActionLinkPanel(link);
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        return panel2;
    }

    public static JComponent createErrorsLink(@NotNull Disposable parent) {
        if (parent == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(7);
        }
        IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
        panel2.getComponent().setBorder((Border)JBUI.Borders.emptyRight((int)13));
        Disposer.register((Disposable)parent, (Disposable)panel2);
        return panel2.getComponent();
    }

    @Deprecated
    @NotNull
    public static JComponent createEventLink(@NotNull @Nls String linkText, @NotNull SimpleMessageBusConnection busConnection) {
        if (linkText == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(8);
        }
        if (busConnection == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(9);
        }
        final SelectablePanel selectablePanel = new SelectablePanel();
        ActionLink actionLink = new ActionLink(linkText, WelcomeScreenComponentFactory.getNotificationIcon(Collections.emptyList(), null), (AnAction)new DumbAwareAction(){
            private boolean hideListenerInstalled = false;

            public void actionPerformed(@NotNull AnActionEvent e) {
                BalloonLayout balloonLayout;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((balloonLayout = WelcomeFrame.getInstance().getBalloonLayout()) instanceof WelcomeBalloonLayoutImpl) {
                    WelcomeBalloonLayoutImpl welcomeBalloonLayout = (WelcomeBalloonLayoutImpl)balloonLayout;
                    if (!this.hideListenerInstalled) {
                        welcomeBalloonLayout.setHideListener(() -> selectablePanel.setSelectionColor(null));
                        this.hideListenerInstalled = true;
                    }
                    selectablePanel.setSelectionColor(JBUI.CurrentTheme.ActionButton.pressedBackground());
                    welcomeBalloonLayout.showPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$5", "actionPerformed"));
            }
        });
        JComponent panel2 = WelcomeScreenComponentFactory.wrapActionLink(actionLink);
        selectablePanel.setLayout((LayoutManager)new BorderLayout());
        selectablePanel.add((Component)panel2);
        selectablePanel.setOpaque(false);
        selectablePanel.setBorder(panel2.getBorder());
        selectablePanel.setSelectionArc(JBUIScale.scale((int)6));
        panel2.setBorder(null);
        selectablePanel.setVisible(false);
        busConnection.subscribe(WelcomeBalloonLayoutImpl.BALLOON_NOTIFICATION_TOPIC, types -> {
            WelcomeBalloonLayoutImpl welcomeBalloonLayout;
            BalloonLayout balloonLayout = WelcomeFrame.getInstance().getBalloonLayout();
            if (balloonLayout instanceof WelcomeBalloonLayoutImpl && (welcomeBalloonLayout = (WelcomeBalloonLayoutImpl)balloonLayout).getLocationComponent() == null) {
                welcomeBalloonLayout.setLocationComponent((Component)actionLink);
            }
            if (!types.isEmpty()) {
                actionLink.setIcon(WelcomeScreenComponentFactory.getNotificationIcon(types, (JComponent)selectablePanel));
            }
            selectablePanel.setVisible(!types.isEmpty());
        });
        SelectablePanel selectablePanel2 = selectablePanel;
        if (selectablePanel2 == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(10);
        }
        return selectablePanel2;
    }

    static Icon getNotificationIcon(List<NotificationType> notificationTypes, JComponent panel2) {
        if (ExperimentalUI.isNewUI()) {
            return IconUtil.resizeSquared((Icon)NOTIFICATION_ICON.getInfoIcon(!notificationTypes.isEmpty()), (int)JBUIScale.scale((int)16));
        }
        if (notificationTypes.isEmpty()) {
            return AllIcons.Ide.Notification.NoEvents;
        }
        NotificationType type = Collections.max(notificationTypes);
        return type == NotificationType.IDE_UPDATE ? AllIcons.Ide.Notification.IdeUpdate : IdeNotificationArea.createIconWithNotificationCount(panel2, type, notificationTypes.size(), false);
    }

    @Nls
    public static String getApplicationTitle() {
        String suffix;
        Object title2 = IdeBundle.message((String)"label.welcome.to.0", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        if (Boolean.getBoolean("ide.ui.version.in.title")) {
            title2 = (String)title2 + " " + ApplicationInfo.getInstance().getFullVersion();
        }
        if ((suffix = ProjectFrameHelper.Companion.getSuperUserSuffix()) != null) {
            title2 = (String)title2 + " (" + suffix + ")";
        }
        return title2;
    }

    @NotNull
    public static JComponent createNotificationToolbar(final @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(11);
        }
        int horizontalGap = 4;
        IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
        Disposer.register((Disposable)parentDisposable, (Disposable)panel2);
        DefaultActionGroup group2 = new DefaultActionGroup(new AnAction[]{panel2.getAction(), new NotificationEventAction(parentDisposable)});
        final ActionToolbarImpl toolbar2 = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("WelcomeScreen.NotificationPanel", (ActionGroup)group2, true);
        toolbar2.setMinimumButtonSize((Dimension)new JBDimension(26, 26));
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setActionButtonBorder(horizontalGap, 1);
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(WelcomeBalloonLayoutImpl.BALLOON_NOTIFICATION_TOPIC, (Object)new WelcomeBalloonLayoutImpl.BalloonNotificationListener(){

            @Override
            public void notificationsChanged(List<NotificationType> types) {
            }

            @Override
            public void newNotifications() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    final Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable);
                    toolbar2.addListener(new ActionToolbarListener(){

                        public void actionsUpdated() {
                            Disposer.dispose((Disposable)disposable);
                            BalloonLayout balloonLayout = WelcomeFrame.getInstance().getBalloonLayout();
                            if (balloonLayout instanceof WelcomeSeparateBalloonLayoutImpl) {
                                WelcomeSeparateBalloonLayoutImpl layout2 = (WelcomeSeparateBalloonLayoutImpl)balloonLayout;
                                layout2.autoPopup();
                            }
                        }
                    }, disposable);
                    if (toolbar2.getParent() != null) {
                        toolbar2.updateActionsAsync();
                    }
                });
            }
        });
        JComponent result2 = toolbar2.getComponent();
        toolbar2.setTargetComponent(result2);
        result2.setOpaque(false);
        if (ExperimentalUI.isNewUI()) {
            result2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)15, (int)(24 - horizontalGap)));
        } else {
            result2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)5, (int)8));
        }
        JComponent jComponent = result2;
        if (jComponent == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    @Deprecated
    @NotNull
    public static JPanel createNotificationPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(13);
        }
        JComponent errorsLink = WelcomeScreenComponentFactory.createErrorsLink(parentDisposable);
        JComponent eventLink = WelcomeScreenComponentFactory.createEventLink("", (SimpleMessageBusConnection)ApplicationManager.getApplication().getMessageBus().connect(parentDisposable));
        NonOpaquePanel panel2 = new NonOpaquePanel();
        if (ExperimentalUI.isNewUI()) {
            panel2.setLayout(new FlowLayout(2, 0, 0));
            panel2.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)16, (int)24));
            errorsLink.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)13));
            eventLink.setBorder(JBUI.Borders.empty((int)5));
        } else {
            panel2.setLayout(new FlowLayout(2));
            panel2.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)0, (int)3));
        }
        panel2.add(errorsLink);
        panel2.add(eventLink);
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            WelcomeScreenComponentFactory.$$$reportNull$$$0(14);
        }
        return nonOpaquePanel;
    }

    @Nullable
    static JComponent getSinglePromotion(boolean isEmptyState) {
        if (PlatformUtils.isMPS()) {
            return null;
        }
        StartPagePromoter[] extensions = (StartPagePromoter[])StartPagePromoter.START_PAGE_PROMOTER_EP.getExtensions();
        ArrayList<StartPagePromoter> promoters = new ArrayList<StartPagePromoter>();
        int maxPriorityLevel = Integer.MIN_VALUE;
        for (StartPagePromoter promoter : extensions) {
            int priorityLevel = promoter.getPriorityLevel();
            if (priorityLevel < maxPriorityLevel || !promoter.canCreatePromo(isEmptyState)) continue;
            if (priorityLevel > maxPriorityLevel) {
                maxPriorityLevel = priorityLevel;
                promoters.clear();
            }
            promoters.add(promoter);
        }
        if (promoters.isEmpty()) {
            return null;
        }
        StartPagePromoter selectedPromoter = (StartPagePromoter)promoters.get(new Random().nextInt(promoters.size()));
        return selectedPromoter.getPromotion(isEmptyState);
    }

    @NlsSafe
    public static String getAppName() {
        return Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 11, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busConnection";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmallLogo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventLink";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationToolbar";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createShowPopupAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionLink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapActionLinkWithoutArrow";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createErrorsLink";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEventLink";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationToolbar";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 11, 13 -> new IllegalArgumentException(string);
        };
    }

    protected static final class JActionLinkPanel
    extends JPanel {
        @NotNull
        private final ActionLink myActionLink;

        public JActionLinkPanel(@NotNull ActionLink actionLink) {
            if (actionLink == null) {
                JActionLinkPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myActionLink = actionLink;
            this.add((Component)this.myActionLink);
            this.setOpaque(false);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLink", "com/intellij/openapi/wm/impl/welcomeScreen/WelcomeScreenComponentFactory$JActionLinkPanel", "<init>"));
        }

        protected final class AccessibleJActionLinkPanel
        extends AccessibleContextDelegate {
            private final JComponent.AccessibleJComponent myAccessibleHelper;

            AccessibleJActionLinkPanel(AccessibleContext context) {
                super(context);
                this.myAccessibleHelper = new JComponent.AccessibleJComponent(){};
            }

            public Container getDelegateParent() {
                return JActionLinkPanel.this.getParent();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }

            public int getAccessibleChildrenCount() {
                return this.myAccessibleHelper.getAccessibleChildrenCount();
            }

            public Accessible getAccessibleChild(int i2) {
                return this.myAccessibleHelper.getAccessibleChild(i2);
            }
        }
    }
}

