/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ThreadContextElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J?\u0010\u0018\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u0002H\u00192\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u0002H\u0019\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJO\u0010\u001f\u001a\u00020\f\"\b\b\u0000\u0010\u0019*\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u0002H\u00192$\u0010\u001c\u001a \b\u0001\u0012\u0004\u0012\u0002H\u0019\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0!\u0012\u0006\u0012\u0004\u0018\u00010\u000b0 H\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ui/IconDeferrerImpl;", "Lcom/intellij/ui/IconDeferrer;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "preConfiguredCacheSize", "", "maxCacheSize", "iconCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Ljavax/swing/Icon;", "mightBePopulated", "", "lastClearTimestamp", "Ljava/util/concurrent/atomic/LongAdder;", "deferrerCacheClearingCheckPeriod", "", "recomputeMaxCacheSize", "", "neededSize", "scheduleCacheClearingTask", "clearCache", "defer", "T", "base", "param", "evaluator", "Lkotlin/Function1;", "(Ljavax/swing/Icon;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljavax/swing/Icon;", "deferAsync", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Ljavax/swing/Icon;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljavax/swing/Icon;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIconDeferrerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconDeferrerImpl.kt\ncom/intellij/ui/IconDeferrerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n13#2:172\n*S KotlinDebug\n*F\n+ 1 IconDeferrerImpl.kt\ncom/intellij/ui/IconDeferrerImpl\n*L\n46#1:172\n*E\n"})
public final class IconDeferrerImpl
extends IconDeferrer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int preConfiguredCacheSize;
    private volatile int maxCacheSize;
    @NotNull
    private final ConcurrentMap<Object, Icon> iconCache;
    private volatile boolean mightBePopulated;
    @NotNull
    private final LongAdder lastClearTimestamp;
    private final long deferrerCacheClearingCheckPeriod;
    private static final ThreadLocal<Boolean> isEvaluationInProgress = ThreadLocal.withInitial(IconDeferrerImpl::isEvaluationInProgress$lambda$0);
    @NotNull
    private static final Logger log;

    public IconDeferrerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.maxCacheSize = this.preConfiguredCacheSize = SystemProperties.getIntProperty((String)"ide.icons.deferrerCacheSize", (int)1000);
        this.iconCache = new ConcurrentHashMap(Math.min(1000, this.preConfiguredCacheSize));
        this.lastClearTimestamp = new LongAdder();
        this.deferrerCacheClearingCheckPeriod = SystemProperties.getLongProperty((String)"ide.icons.deferrerCacheClearingCheckPeriod.ms", (long)Duration.toLong-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        Topic topic = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, () -> IconDeferrerImpl._init_$lambda$0(this));
        Topic topic2 = VirtualFileManager.VFS_CHANGES_BG;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES_BG");
        connection.subscribe(topic2, (Object)new BulkFileListenerBackgroundable(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                log.trace("clearing icon deferrer cache after vfs events");
                this.clearCache();
                this.recomputeMaxCacheSize(events.size());
            }
        });
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                log.trace("clearing icon deferrer cache after project closing");
                this.clearCache();
            }
        });
        Topic topic3 = VirtualFileAppearanceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        connection.subscribe(topic3, arg_0 -> IconDeferrerImpl._init_$lambda$1(this, arg_0));
        LowMemoryWatcher lowMemoryWatcher = LowMemoryWatcher.register(() -> IconDeferrerImpl._init_$lambda$2(this));
        this.scheduleCacheClearingTask(coroutineScope);
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> IconDeferrerImpl._init_$lambda$3(connection, lowMemoryWatcher, arg_0));
    }

    private final void recomputeMaxCacheSize(int neededSize) {
        if (this.maxCacheSize < neededSize) {
            this.maxCacheSize = Math.max(this.preConfiguredCacheSize, Math.min(10000, neededSize));
        }
    }

    private final void scheduleCacheClearingTask(CoroutineScope coroutineScope) {
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IconDeferrerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 4 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)IconDeferrerImpl.access$getDeferrerCacheClearingCheckPeriod$p(this.this$0), (Continuation)((Continuation)this));
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        currentCacheSize = IconDeferrerImpl.access$getIconCache$p(this.this$0).size();
                        IconDeferrerImpl.access$recomputeMaxCacheSize(this.this$0, currentCacheSize);
                        if (currentCacheSize <= IconDeferrerImpl.access$getMaxCacheSize$p(this.this$0)) ** GOTO lbl28
                        var3_4 = IconDeferrerImpl.access$getLog$cp();
                        var4_5 = this.this$0;
                        $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            var7_9 = $this$trace$iv;
                            $i$a$-trace-IconDeferrerImpl$scheduleCacheClearingTask$1$1 = false;
                            var7_9.trace("Clearing icon deferrer cache because it's too big: " + currentCacheSize + " > " + IconDeferrerImpl.access$getMaxCacheSize$p(var4_5));
                        }
                        this.this$0.clearCache();
                        ** GOTO lbl6
lbl28:
                        // 1 sources

                        $this$trace$iv = IconDeferrerImpl.access$getLog$cp();
                        $i$f$trace = false;
                        if (!$this$trace$iv.isTraceEnabled()) ** GOTO lbl6
                        var7_9 = $this$trace$iv;
                        $i$a$-trace-IconDeferrerImpl$scheduleCacheClearingTask$1$2 = false;
                        var7_9.trace("icon cache size " + currentCacheSize);
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void clearCache() {
        this.lastClearTimestamp.increment();
        if (this.mightBePopulated) {
            this.mightBePopulated = false;
            this.iconCache.clear();
        }
    }

    @NotNull
    public <T> Icon defer(@Nullable Icon base, @NotNull T param, @NotNull Function1<? super T, ? extends Icon> evaluator) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        Intrinsics.checkNotNullParameter(evaluator, (String)"evaluator");
        if (isEvaluationInProgress.get().booleanValue()) {
            Icon icon2 = (Icon)evaluator.invoke(param);
            if (icon2 == null) {
                icon2 = DeferredIconImpl.Companion.getEMPTY_ICON$intellij_platform_ide_impl();
            }
            return icon2;
        }
        Icon result2 = this.iconCache.computeIfAbsent(param, arg_0 -> IconDeferrerImpl.defer$lambda$0(this, base, param, evaluator, arg_0));
        this.mightBePopulated = true;
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @NotNull
    public <T> Icon deferAsync(@Nullable Icon base, @NotNull T param, @NotNull Function2<? super T, ? super Continuation<? super Icon>, ? extends Object> evaluator) {
        Intrinsics.checkNotNullParameter(param, (String)"param");
        Intrinsics.checkNotNullParameter(evaluator, (String)"evaluator");
        Icon result2 = this.iconCache.computeIfAbsent(param, arg_0 -> IconDeferrerImpl.deferAsync$lambda$0(base, param, evaluator, this, arg_0));
        this.mightBePopulated = true;
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    private static final void _init_$lambda$0(IconDeferrerImpl this$0) {
        log.trace("clearing icon deferrer cache after psi modification");
        this$0.clearCache();
    }

    private static final void _init_$lambda$1(IconDeferrerImpl this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        log.trace("clearing icon deferrer cache after VirtualFileAppearanceListener event");
        this$0.clearCache();
    }

    private static final void _init_$lambda$2(IconDeferrerImpl this$0) {
        log.trace("Clearing icon deferrer cache because after low memory signal");
        this$0.clearCache();
    }

    private static final Unit _init_$lambda$3(SimpleMessageBusConnection $connection, LowMemoryWatcher $lowMemoryWatcher, Throwable it) {
        $connection.disconnect();
        $lowMemoryWatcher.stop();
        return Unit.INSTANCE;
    }

    private static final Icon defer$lambda$0(IconDeferrerImpl this$0, Icon $base, Object $param, Function1 $evaluator, Object it) {
        long started = this$0.lastClearTimestamp.sum();
        return (Icon)((Object)new DeferredIconImpl<Object>($base, $param, true, $evaluator, (arg_0, arg_1) -> IconDeferrerImpl.defer$lambda$0$0(started, this$0, arg_0, arg_1)));
    }

    private static final Unit defer$lambda$0$0(long $started, IconDeferrerImpl this$0, DeferredIconImpl source, Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        if ($started == this$0.lastClearTimestamp.sum()) {
            this$0.iconCache.replace(source.param, (Icon)((Object)source), icon2);
        }
        return Unit.INSTANCE;
    }

    private static final Icon deferAsync$lambda$0(Icon $base, Object $param, Function2 $evaluator, IconDeferrerImpl this$0, Object it) {
        return (Icon)((Object)new DeferredIconImpl<Object>($base, $param, (Function2)new Function2<T, Continuation<? super Icon>, Object>($evaluator, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Function2<T, Continuation<? super Icon>, Object> $evaluator;
            {
                this.$evaluator = $evaluator;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.label = 1;
                        v0 = this.$evaluator.invoke((Object)it, (Object)this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if ((v1 = (Icon)v0) == null) {
                            v1 = DeferredIconImpl.Companion.getEMPTY_ICON$intellij_platform_ide_impl();
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(T p1, Continuation<? super Icon> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (arg_0, arg_1) -> IconDeferrerImpl.deferAsync$lambda$0$0(this$0, arg_0, arg_1)));
    }

    private static final Unit deferAsync$lambda$0$0(IconDeferrerImpl this$0, DeferredIconImpl source, Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        this$0.iconCache.replace(source.param, (Icon)((Object)source), icon2);
        return Unit.INSTANCE;
    }

    private static final Boolean isEvaluationInProgress$lambda$0() {
        return false;
    }

    public static final /* synthetic */ long access$getDeferrerCacheClearingCheckPeriod$p(IconDeferrerImpl $this) {
        return $this.deferrerCacheClearingCheckPeriod;
    }

    public static final /* synthetic */ ConcurrentMap access$getIconCache$p(IconDeferrerImpl $this) {
        return $this.iconCache;
    }

    public static final /* synthetic */ int access$getMaxCacheSize$p(IconDeferrerImpl $this) {
        return $this.maxCacheSize;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IconDeferrerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u001e\b\u0004\u0010\n\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0086H\u00a2\u0006\u0002\u0010\rR2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/IconDeferrerImpl$Companion;", "", "<init>", "()V", "isEvaluationInProgress", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "evaluateDeferred", "T", "runnable", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final <T> Object evaluateDeferred(@NotNull Function1<? super Continuation<? super T>, ? extends Object> runnable, @NotNull Continuation<? super T> $completion) {
            if (!($completion instanceof evaluateDeferred.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.evaluateDeferred(null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$f$evaluateDeferred = 0;
                    IconDeferrerImpl.access$isEvaluationInProgress$cp().set(Boxing.boxBoolean((boolean)true));
                    v0 = IconDeferrerImpl.access$isEvaluationInProgress$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"access$isEvaluationInProgress$cp(...)");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)runnable);
                    $continuation.I$0 = $i$f$evaluateDeferred;
                    $continuation.label = 1;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)ThreadContextElementKt.asContextElement$default((ThreadLocal)v0, null, (int)1, null)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(runnable, null){
                        int label;
                        final /* synthetic */ Function1<Continuation<? super T>, Object> $runnable;
                        {
                            this.$runnable = $runnable;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.$runnable.invoke((Object)((Object)this));
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Object invokeSuspend$$forInline(Object $result) {
                            return this.$runnable.invoke((Object)((Object)this));
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), $continuation);
                    ** if (v1 != var8_5) goto lbl24
lbl23:
                    // 1 sources

                    return var8_5;
lbl24:
                    // 1 sources

                    ** GOTO lbl32
                }
                case 1: {
                    $i$f$evaluateDeferred = $continuation.I$0;
                    runnable = (Function1)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        var4_7 = v1;
                        return var4_7;
                    }
                    catch (Throwable var5_8) {
                        throw var5_8;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        IconDeferrerImpl.access$isEvaluationInProgress$cp().set(Boxing.boxBoolean((boolean)false));
                        InlineMarker.finallyEnd((int)1);
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> Object evaluateDeferred$$forInline(Function1<? super Continuation<? super T>, ? extends Object> runnable2, Continuation<? super T> $completion) {
            boolean $i$f$evaluateDeferred = false;
            try {
                isEvaluationInProgress.set(true);
                Object object = isEvaluationInProgress;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"access$isEvaluationInProgress$cp(...)");
                CoroutineContext coroutineContext = (CoroutineContext)ThreadContextElementKt.asContextElement$default((ThreadLocal)object, null, (int)1, null);
                Function2 function2 = new /* invalid duplicate definition of identical inner class */;
                InlineMarker.mark((int)0);
                Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext, (Function2)function2, $completion);
                InlineMarker.mark((int)1);
                object = object2;
                return object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                isEvaluationInProgress.set(false);
                InlineMarker.finallyEnd((int)1);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

