/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatusPanel
extends JBPanel {
    private final ReentrantLock myLock = new ReentrantLock();
    @Nullable
    @Nls
    private String myError;
    @Nullable
    private Action myCurrentAction;

    public StatusPanel() {
        super((LayoutManager)new BorderLayout());
        this.setVisible(false);
    }

    public void resetState() {
        this.myLock.lock();
        try {
            this.cancelCurrentAction();
            this.clearUI();
        }
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    public Action progress(@NotNull @Nls String message) {
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(0);
        }
        Action action2 = this.progress(message, true);
        if (action2 == null) {
            StatusPanel.$$$reportNull$$$0(1);
        }
        return action2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Action progress(@NotNull @Nls String message, boolean addProgressIconBelow) {
        Action action2;
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(2);
        }
        this.myLock.lock();
        this.cancelCurrentAction();
        this.myCurrentAction = action2 = new Action();
        this.invokeLater(() -> {
            this.clearUI();
            if (addProgressIconBelow) {
                AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon(message);
                this.add((Component)asyncProcessIcon, "Center");
                this.setVisible(true);
                asyncProcessIcon.resume();
            }
            this.refreshUI();
        });
        Action action3 = action2;
        Action action4 = action3;
        if (action4 == null) {
            StatusPanel.$$$reportNull$$$0(3);
        }
        return action4;
        finally {
            this.myLock.unlock();
        }
    }

    private void cancelCurrentAction() {
        if (this.myCurrentAction != null) {
            this.myCurrentAction.cancel();
            this.myCurrentAction = null;
        }
    }

    private void clearUI() {
        this.myError = null;
        this.removeAll();
        this.setVisible(false);
        this.refreshUI();
    }

    private void refreshUI() {
        this.revalidate();
        this.repaint();
    }

    private void showMessage(@NlsContexts.DialogMessage @NotNull String message, @NotNull JBColor color, @Nullable Icon statusIcon) {
        if (message == null) {
            StatusPanel.$$$reportNull$$$0(4);
        }
        if (color == null) {
            StatusPanel.$$$reportNull$$$0(5);
        }
        this.removeAll();
        this.setVisible(true);
        JBLabel label2 = new JBLabel(message);
        label2.setText(HtmlChunk.tag((String)"font").attr("color", "#" + ColorUtil.toHex((Color)color)).child((HtmlChunk)HtmlChunk.tag((String)"left").addRaw(message)).wrapWith("html").toString());
        label2.setIcon(statusIcon);
        label2.setBorder((Border)new EmptyBorder(4, 10, 0, 2));
        this.add((Component)label2, "Center");
        this.refreshUI();
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StatusPanel.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.stateForComponent((Component)((Object)this)));
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getError() {
        return this.myError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/StatusPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/StatusPanel";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "progress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "progress";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public final class Action {
        private volatile boolean myCancelled = false;
        private final AtomicBoolean myCompleted = new AtomicBoolean(false);

        private boolean checkIsInProgressAndComplete() {
            return this.myCompleted.compareAndSet(false, true) && !this.myCancelled;
        }

        private void cancel() {
            this.myCancelled = true;
        }

        public void done() {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            StatusPanel.this.clearUI();
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }

        public void doneWithResult(@NlsContexts.DialogMessage @NotNull String message) {
            if (message == null) {
                Action.$$$reportNull$$$0(0);
            }
            this.showMessageOnce(message, false);
        }

        public void failed(@NlsContexts.DialogMessage @Nullable String message) {
            this.showMessageOnce(message, true);
        }

        private void showMessageOnce(@NlsContexts.DialogMessage @Nullable String message, boolean isError) {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            JBColor color = isError ? JBColor.RED : JBColor.DARK_GRAY;
                            Icon statusIcon = isError ? AllIcons.Actions.Lightning : AllIcons.General.InspectionsOK;
                            StatusPanel.this.myError = isError ? message : null;
                            StatusPanel.this.showMessage(StringUtil.notNullize((String)message), color, statusIcon);
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ui/StatusPanel$Action", "doneWithResult"));
        }
    }
}

