/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithAutoCompletionListProvider<T>
extends DefaultTextCompletionValueDescriptor<T>
implements TextCompletionProvider,
PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(TextFieldWithAutoCompletionListProvider.class);
    @NotNull
    protected Collection<T> myVariants;
    private @NlsContexts.PopupAdvertisement @Nullable String myCompletionAdvertisement;

    protected TextFieldWithAutoCompletionListProvider(@Nullable Collection<T> variants) {
        this.setItems(variants);
        this.myCompletionAdvertisement = null;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(0);
        }
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text2, offset);
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        PrefixMatcher prefixMatcher;
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(2);
        }
        if ((prefixMatcher = this.createPrefixMatcher(prefix)) != null) {
            CompletionResultSet completionResultSet = result2.withPrefixMatcher(prefixMatcher);
            if (completionResultSet == null) {
                TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(3);
            }
            return completionResultSet;
        }
        CompletionResultSet completionResultSet = result2;
        if (completionResultSet == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(4);
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(7);
        }
        this.addCachedItems(parameters, prefix, result2);
        this.addNonCachedItems(parameters, prefix, result2);
    }

    private void addCachedItems(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(10);
        }
        Collection<T> items2 = this.getItems(prefix, true, parameters);
        TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, items2, -10000);
    }

    private void addNonCachedItems(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        ProgressManager progressManager;
        ProgressIndicator mainIndicator;
        if (parameters == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(13);
        }
        SensitiveProgressWrapper indicator2 = (mainIndicator = (progressManager = ProgressManager.getInstance()).getProgressIndicator()) != null ? new SensitiveProgressWrapper(mainIndicator) : new EmptyProgressIndicator();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$addNonCachedItems$1(progressManager, prefix, parameters, (ProgressIndicator)indicator2));
        try {
            Collection tasks = (Collection)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)future, (ProgressIndicator)indicator2);
            if (tasks != null) {
                TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, tasks, 0);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected static <T> void addCompletionElements(CompletionResultSet result2, TextCompletionValueDescriptor<T> descriptor2, Collection<? extends T> items2, int index) {
        AutoCompletionPolicy completionPolicy = ApplicationManager.getApplication().isUnitTestMode() ? AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE : AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        int grouping = index;
        for (T item : items2) {
            if (item == null) {
                LOG.error("Null item from " + String.valueOf(descriptor2));
                continue;
            }
            LookupElementBuilder builder = descriptor2.createLookupBuilder(item);
            result2.addElement(PrioritizedLookupElement.withGrouping((LookupElement)builder.withAutoCompletionPolicy(completionPolicy), (int)grouping--));
        }
    }

    public void setItems(@Nullable Collection<T> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    @NotNull
    public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        if (prefix == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(14);
            }
            return list2;
        }
        ArrayList<T> items2 = new ArrayList<T>(this.myVariants);
        items2.sort(this);
        ArrayList<T> arrayList = items2;
        if (arrayList == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    @NlsContexts.PopupAdvertisement
    @Nullable
    public String getAdvertisement() {
        if (this.myCompletionAdvertisement != null) {
            return this.myCompletionAdvertisement;
        }
        String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickJavaDoc");
        String advertisementTail = this.getQuickDocHotKeyAdvertisementTail(shortcut);
        if (advertisementTail == null) {
            return null;
        }
        return LangBundle.message((String)"textfield.autocompletion.advertisement", (Object[])new Object[]{shortcut, advertisementTail});
    }

    @Nullable
    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(16);
        }
        return null;
    }

    public void setAdvertisement(@NlsContexts.PopupAdvertisement @Nullable String completionAdvertisement) {
        this.myCompletionAdvertisement = completionAdvertisement;
    }

    @Nullable
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(17);
        }
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    public static String getCompletionPrefix(CompletionParameters parameters) {
        String text2 = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text2, offset);
    }

    @NotNull
    private static String getCompletionPrefix(String text2, int offset) {
        int i2 = text2.lastIndexOf(32, offset - 1) + 1;
        int j = text2.lastIndexOf(10, offset - 1) + 1;
        String string = text2.substring(Math.max(i2, j), offset);
        if (string == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    private /* synthetic */ Collection lambda$addNonCachedItems$1(ProgressManager progressManager, String prefix, CompletionParameters parameters, ProgressIndicator indicator2) throws Exception {
        return (Collection)progressManager.runProcess(() -> this.getItems(prefix, false, parameters), indicator2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 14, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TextFieldWithAutoCompletionListProvider";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TextFieldWithAutoCompletionListProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPrefixMatcher";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyPrefixMatcher";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addCachedItems";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNonCachedItems";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocHotKeyAdvertisementTail";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixMatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 14, 15, 18 -> new IllegalStateException(string);
        };
    }
}

