/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.colorpicker.AlphaSliderComponentKt;
import com.intellij.ui.colorpicker.SliderComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0015\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J0\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "Lcom/intellij/ui/colorpicker/SliderComponent;", "", "<init>", "()V", "sliderBackgroundColor", "Ljava/awt/Color;", "getSliderBackgroundColor", "()Ljava/awt/Color;", "setSliderBackgroundColor", "(Ljava/awt/Color;)V", "knobPositionToValue", "knobPosition", "(I)Ljava/lang/Integer;", "valueToKnobPosition", "value", "slide", "shift", "paintSlider", "", "g2d", "Ljava/awt/Graphics2D;", "paintCheckeredBackground", "g", "Ljava/awt/Graphics;", "backgroundColor", "checkeredColor", "clip", "Ljava/awt/Shape;", "cellSize", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AlphaSliderComponent
extends SliderComponent<Integer> {
    @NotNull
    private Color sliderBackgroundColor;

    public AlphaSliderComponent() {
        super(0);
        Color color = AlphaSliderComponentKt.access$getDEFAULT_SLIDER_BACKGROUND$p();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"access$getDEFAULT_SLIDER_BACKGROUND$p(...)");
        this.sliderBackgroundColor = color;
    }

    @NotNull
    public final Color getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public final void setSliderBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.sliderBackgroundColor = color;
    }

    @Override
    @NotNull
    protected Integer knobPositionToValue(int knobPosition) {
        return this.getSliderWidth() > 0 ? Math.round((float)knobPosition * 255.0f / (float)this.getSliderWidth()) : 0;
    }

    @Override
    protected int valueToKnobPosition(int value) {
        return Math.round((float)(value * this.getSliderWidth()) / 255.0f);
    }

    @Override
    @NotNull
    protected Integer slide(int shift) {
        return Math.max(0, Math.min(((Number)this.getValue()).intValue() + shift, 255));
    }

    @Override
    protected void paintSlider(@NotNull Graphics2D g2d) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Color color = ColorUtil.toAlpha((Color)Color.WHITE, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"toAlpha(...)");
        Color transparent = color;
        Rectangle clip = new Rectangle(this.getLeftPadding(), this.getTopPadding(), this.getWidth() - this.getLeftPadding() - this.getRightPadding(), this.getHeight() - this.getTopPadding() - this.getBottomPadding());
        Graphics graphics = g2d;
        Color color2 = Color.LIGHT_GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"LIGHT_GRAY");
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"GRAY");
        this.paintCheckeredBackground(graphics, color2, color3, clip, 6);
        Color sliderBackgroundWithoutAlpha = new Color(this.sliderBackgroundColor.getRGB() & 0xFFFFFF);
        g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)transparent, (float)this.getWidth(), (float)0.0f, (Color)sliderBackgroundWithoutAlpha));
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
    }

    private final void paintCheckeredBackground(Graphics g, Color backgroundColor, Color checkeredColor, Shape clip, int cellSize) {
        Shape savedClip = g.getClip();
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        ((Graphics2D)g).clip(clip);
        Rectangle rect = clip.getBounds();
        g.setColor(backgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(checkeredColor);
        int dy = 0;
        while (dy * cellSize < rect.height) {
            int dx = dy % 2;
            while (dx * cellSize < rect.width) {
                g.fillRect(rect.x + dx * cellSize, rect.y + dy * cellSize, cellSize, cellSize);
                dx += 2;
            }
            ++dy;
        }
        g.setClip(savedClip);
    }
}

