/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.processHandshake;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.processHandshake.ProcessHandshakeLauncherKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/io/processHandshake/LoggingProcessListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "<init>", "()V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "intellij.platform.ide.impl"})
final class LoggingProcessListener
extends ProcessAdapter {
    @NotNull
    public static final LoggingProcessListener INSTANCE = new LoggingProcessListener();

    private LoggingProcessListener() {
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        Logger logger = ProcessHandshakeLauncherKt.access$getLOG$p();
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        logger.info("Process [" + outputType + "]: " + StringsKt.removeSuffix((String)string, (CharSequence)"\n"));
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = ProcessTerminatedListener.stringifyExitCode((int)event.getExitCode());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringifyExitCode(...)");
        String exitCodeString = string;
        ProcessHandshakeLauncherKt.access$getLOG$p().info("Process terminated with exit code " + exitCodeString);
    }
}

