/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.SmartList;
import com.intellij.xml.breadcrumbs.BreadcrumbsConfigurableUI;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class BreadcrumbsConfigurable
extends CompositeConfigurable<BreadcrumbsProviderConfigurable>
implements SearchableConfigurable {
    private DialogPanel panel;

    BreadcrumbsConfigurable() {
    }

    @NotNull
    public String getId() {
        return "editor.breadcrumbs";
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"configurable.breadcrumbs", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.editor.general.breadcrumbs";
    }

    public JComponent createComponent() {
        if (this.panel == null) {
            this.panel = new BreadcrumbsConfigurableUI(this.getConfigurables()).panel;
        }
        return this.panel;
    }

    @Override
    public void reset() {
        this.panel.reset();
    }

    @Override
    public boolean isModified() {
        return this.panel.isModified();
    }

    @Override
    @NotNull
    protected List<BreadcrumbsProviderConfigurable> createConfigurables() {
        SmartList configurables2 = new SmartList();
        for (BreadcrumbsProvider provider : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
            for (Language language : provider.getLanguages()) {
                configurables2.add(new BreadcrumbsProviderConfigurable(provider, language));
            }
        }
        SmartList smartList = configurables2;
        if (smartList == null) {
            BreadcrumbsConfigurable.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    @Override
    public void apply() {
        boolean modified = this.panel.isModified();
        this.panel.apply();
        if (modified) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable", "createConfigurables"));
    }

    static final class BreadcrumbsProviderConfigurable
    implements SearchableConfigurable {
        private final BreadcrumbsProvider myProvider;
        private final Language myLanguage;

        private BreadcrumbsProviderConfigurable(@NotNull BreadcrumbsProvider provider, @NotNull Language language) {
            if (provider == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(0);
            }
            if (language == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myLanguage = language;
        }

        @NotNull
        public JCheckBox createComponent() {
            return new JCheckBox(this.myLanguage.getDisplayName());
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        @NotNull
        public String getId() {
            String string = this.myLanguage.getID();
            if (string == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myLanguage.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class clazz = this.myProvider.getClass();
            if (clazz == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

