// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.ide.actions

import com.intellij.openapi.actionSystem.AnActionEvent
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification
import com.intellij.openapi.wm.ToolWindow
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase
import com.intellij.ui.content.Content
import javax.swing.SwingConstants

internal abstract class ToolWindowSplitAndMoveActionBase(
  private val isRight: Boolean,
) : ToolWindowContextMenuActionBase(), ActionRemoteBehaviorSpecification.Frontend {
  override fun actionPerformed(e: AnActionEvent, toolWindow: ToolWindow, content: Content?) {
    if (content == null) return
    val decorator = findNearestDecorator(e) ?: return
    decorator.splitWithContent(content, if (isRight) SwingConstants.RIGHT else SwingConstants.BOTTOM, -1)
  }

  override fun update(e: AnActionEvent, toolWindow: ToolWindow, content: Content?) {
    val contentManager = content?.manager
    e.presentation.isEnabledAndVisible = toolWindow.canSplitTabs() &&
                                         contentManager != null && contentManager.contentCount > 1
  }
}

internal class ToolWindowSplitAndMoveRightAction : ToolWindowSplitAndMoveActionBase(isRight = true)

internal class ToolWindowSplitAndMoveDownAction : ToolWindowSplitAndMoveActionBase(isRight = false)